#include <iostream>
#include <list>

#include "ldastoolsal/mutexlock.hh"

namespace LDASTools
{
  namespace AL
  {
    /// \brief  Class to coordinate writing of streams.
    ///
    /// This class allows multithreaded applications to share a stream
    /// when threads cooperate.
    class IOLock
    {
    public:
      typedef MutexLock::baton_type baton_type;

      /// \brief  Obtain the lock for a stream.
      static baton_type	GetKey( const std::ostream& Stream );

    private:
      struct lock_set {
	const void*	key;
	baton_type	lock;
      };
      typedef std::list< lock_set* >	keys_ostream_type;

      static baton_type			m_key_ostream;

      static keys_ostream_type		m_keys_ostream;
    }; // class - IOLock
  } // namespace - AL
} // namespace - LDASTools
