# -*- mode: RPM-SPEC; indent-tabs-mode: nil -*-
%define _docdir %{_datadir}/doc/ldas-tools-al-%{version}

Summary: LDAS tools abstraction toolkit
Name: ldas-tools-al
Version: 2.5.0
Release: 1%{?dist}
License: ?
URL: http://www.ligo.caltech.edu
Group: Application/Scientific
BuildRoot: %{buildroot}
Source0: http://software.ligo.org/lscsoft/source/ldas-tools-al-%{version}.tar.gz
Obsoletes: ldas-tools-general
Requires: openssl
Requires: zlib
Buildrequires: autoconf
Buildrequires: automake
Buildrequires: bison
Buildrequires: doxygen
Buildrequires: flex
Buildrequires: libtool
Buildrequires: openssl-devel
Buildrequires: pkgconfig
Buildrequires: python-devel
Buildrequires: swig
Buildrequires: zlib-devel


%description
This provides the runtime libraries for the abstaction library.

%package devel
Obsoletes: ldas-tools-general-devel
Group: Development/Scientific
Summary: LDAS tools abstraction toolkit development files
%description devel
This provides the develpement files the abstraction library.
Requires: ldas-tools-al
%prep

%setup -q

%build

%configure --with-optimization=high --disable-tcl --enable-python --docdir=%{_docdir}
make V=1 %{?_smp_mflags}
make V=1 check

%install
rm -rf %{buildroot}
#--------------------------------------------------------------
# install lscsoft specific files
#--------------------------------------------------------------
make V=1 install DESTDIR=%{buildroot}
#--------------------------------------------------------------
# Removed unwanted libtool files
#--------------------------------------------------------------
find %{buildroot} -name \*.la -exec rm -f {} \;

%post
ldconfig
%postun
ldconfig

%clean
rm -rf %{buildroot}

%files
%defattr(-,root,root,-)
%{_libdir}/libexception*.so.*
%{_libdir}/libldastoolsal*.so.*

%files devel
%defattr(-,root,root)
%{_includedir}/ldastoolsal
%{_libdir}/libexception.a
%{_libdir}/libexception*.so
%{_libdir}/libldastoolsal.a
%{_libdir}/libldastoolsal*.so
%{_libdir}/pkgconfig/ldastoolsal.pc
%{_docdir}/ldastoolsal

%changelog
* Wed Mar 23 2016 Edward Maros <ed.maros@ligo.org> - 2.4.99.4-1
- Made build be verbose

* Fri Mar 11 2016 Edward Maros <ed.maros@ligo.org> - 2.4.99.1-1
- Corrections for RPM build

* Thu Mar 03 2016 Edward Maros <ed.maros@ligo.org> - 2.4.99.0-1
- Breakout into separate source package

* Tue Oct 11 2011 Edward Maros <emaros@ligo.caltech.edu> - 1.19.13-1
- Initial build.
