/*
 * Decompiled with CFR 0.152.
 */
package net.sf.launch4j.config;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import com.thoughtworks.xstream.security.NoTypePermission;
import com.thoughtworks.xstream.security.NullPermission;
import com.thoughtworks.xstream.security.PrimitiveTypePermission;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.sf.launch4j.binding.Validator;
import net.sf.launch4j.config.ClassPath;
import net.sf.launch4j.config.Config;
import net.sf.launch4j.config.ConfigPersisterException;
import net.sf.launch4j.config.Jre;
import net.sf.launch4j.config.Splash;
import net.sf.launch4j.config.VersionInfo;
import org.w3c.dom.Document;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;

public class ConfigPersister {
    private static final ConfigPersister _instance = new ConfigPersister();
    private final XStream _xstream = new XStream((HierarchicalStreamDriver)new DomDriver());
    private Config _config;
    private File _configPath;

    private ConfigPersister() {
        this._xstream.addPermission(NoTypePermission.NONE);
        this._xstream.addPermission(NullPermission.NULL);
        this._xstream.addPermission(PrimitiveTypePermission.PRIMITIVES);
        this._xstream.allowTypeHierarchy(Collection.class);
        this._xstream.allowTypesByWildcard(new String[]{"net.sf.launch4j.config.*"});
        this._xstream.alias("launch4jConfig", Config.class);
        this._xstream.alias("classPath", ClassPath.class);
        this._xstream.alias("jre", Jre.class);
        this._xstream.alias("splash", Splash.class);
        this._xstream.alias("versionInfo", VersionInfo.class);
        this._xstream.addImplicitCollection(Config.class, "headerObjects", "obj", String.class);
        this._xstream.addImplicitCollection(Config.class, "libs", "lib", String.class);
        this._xstream.addImplicitCollection(Config.class, "variables", "var", String.class);
        this._xstream.addImplicitCollection(ClassPath.class, "paths", "cp", String.class);
        this._xstream.addImplicitCollection(Jre.class, "options", "opt", String.class);
    }

    public static ConfigPersister getInstance() {
        return _instance;
    }

    public Config getConfig() {
        return this._config;
    }

    public File getConfigPath() {
        return this._configPath;
    }

    public File getOutputPath() throws IOException {
        if (this._config.getOutfile().isAbsolute()) {
            return this._config.getOutfile().getParentFile();
        }
        File parent = this._config.getOutfile().getParentFile();
        return parent != null ? new File(this._configPath, parent.getPath()) : this._configPath;
    }

    public File getOutputFile() throws IOException {
        return this._config.getOutfile().isAbsolute() ? this._config.getOutfile() : new File(this.getOutputPath(), this._config.getOutfile().getName());
    }

    public void createBlank() {
        this._config = new Config();
        this._config.setJre(new Jre());
        this._configPath = null;
    }

    public void setAntConfig(Config c, File basedir) {
        this._config = c;
        this._configPath = basedir;
    }

    public void load(File f) throws ConfigPersisterException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(f);
            DOMImplementationLS domImplementation = (DOMImplementationLS)((Object)doc.getImplementation());
            LSSerializer lsSerializer = domImplementation.createLSSerializer();
            String configString = lsSerializer.writeToString(doc);
            this._config = this.convertToCurrent(configString);
            this.setConfigPath(f);
        }
        catch (Exception e) {
            throw new ConfigPersisterException(e);
        }
    }

    public void save(File f) throws ConfigPersisterException {
        try {
            BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), "UTF-8"));
            w.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            this._xstream.toXML((Object)this._config, (Writer)w);
            w.close();
            this.setConfigPath(f);
        }
        catch (Exception e) {
            throw new ConfigPersisterException(e);
        }
    }

    private Config convertToCurrent(String configString) {
        boolean requires64Bit = configString.contains("<bundledJre64Bit>true</bundledJre64Bit>") || configString.contains("<runtimeBits>64</runtimeBits>");
        String updatedConfigString = configString.replaceAll("<headerType>0<", "<headerType>gui<").replaceAll("<headerType>1<", "<headerType>console<").replaceAll("jarArgs>", "cmdLine>").replaceAll("<jarArgs[ ]*/>", "<cmdLine/>").replaceAll("args>", "opt>").replaceAll("<args[ ]*/>", "<opt/>").replaceAll("<jdkPreference>jdkOnly</jdkPreference>", "<requiresJdk>true</requiresJdk>").replaceAll("<initialHeapSize>0</initialHeapSize>", "").replaceAll("<maxHeapSize>0</maxHeapSize>", "").replaceAll("<customProcName>.*</customProcName>", "").replaceAll("<bundledJre64Bit>.*</bundledJre64Bit>", "").replaceAll("<bundledJreAsFallback>.*</bundledJreAsFallback>", "").replaceAll("<jdkPreference>.*</jdkPreference>", "").replaceAll("<runtimeBits>.*</runtimeBits>", "");
        Config config = (Config)this._xstream.fromXML(updatedConfigString);
        if (Validator.isEmpty(config.getJre().getPath())) {
            config.getJre().setPath("%JAVA_HOME%;%PATH%");
        }
        if (requires64Bit) {
            config.getJre().setRequires64Bit(true);
        }
        return config;
    }

    private void setConfigPath(File configFile) {
        this._configPath = configFile.getAbsoluteFile().getParentFile();
    }
}

