/*
 * Decompiled with CFR 0.152.
 */
package net.sf.launch4j;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import net.sf.launch4j.KanjiEscapeOutputStream;
import net.sf.launch4j.Util;
import net.sf.launch4j.config.CharsetID;
import net.sf.launch4j.config.Config;
import net.sf.launch4j.config.ConfigPersister;
import net.sf.launch4j.config.Jre;
import net.sf.launch4j.config.Msg;
import net.sf.launch4j.config.Splash;
import net.sf.launch4j.config.VersionInfo;

public class RcBuilder {
    public static final int LANG_NEUTRAL = 0;
    public static final int SUBLANG_NEUTRAL = 0;
    public static final int SUBLANG_DEFAULT = 1;
    public static final int SUBLANG_SYS_DEFAULT = 2;
    public static final int MANIFEST = 1;
    public static final int APP_ICON = 1;
    public static final int SPLASH_BITMAP = 1;
    public static final int JRE_PATH = 1;
    public static final int JAVA_MIN_VER = 2;
    public static final int JAVA_MAX_VER = 3;
    public static final int SHOW_SPLASH = 4;
    public static final int SPLASH_WAITS_FOR_WINDOW = 5;
    public static final int SPLASH_TIMEOUT = 6;
    public static final int SPLASH_TIMEOUT_ERR = 7;
    public static final int CHDIR = 8;
    public static final int ERR_TITLE = 10;
    public static final int GUI_HEADER_STAYS_ALIVE = 11;
    public static final int JVM_OPTIONS = 12;
    public static final int CMD_LINE = 13;
    public static final int JAR = 14;
    public static final int MAIN_CLASS = 15;
    public static final int CLASSPATH = 16;
    public static final int WRAPPER = 17;
    public static final int REQUIRES_JDK = 18;
    public static final int ENV_VARIABLES = 19;
    public static final int PRIORITY_CLASS = 20;
    public static final int DOWNLOAD_URL = 21;
    public static final int SUPPORT_URL = 22;
    public static final int MUTEX_NAME = 23;
    public static final int INSTANCE_WINDOW_TITLE = 24;
    public static final int INITIAL_HEAP_SIZE = 25;
    public static final int INITIAL_HEAP_PERCENT = 26;
    public static final int MAX_HEAP_SIZE = 27;
    public static final int MAX_HEAP_PERCENT = 28;
    public static final int REQUIRES_64_BIT = 29;
    public static final int RESTART_ON_CRASH = 31;
    public static final int STARTUP_ERR = 101;
    public static final int JRE_NOT_FOUND_ERR = 102;
    public static final int JRE_VERSION_ERR = 103;
    public static final int LAUNCHER_ERR = 104;
    public static final int INSTANCE_ALREADY_EXISTS_MSG = 105;
    private final StringBuffer _sb = new StringBuffer();

    public String getContent() {
        return this._sb.toString();
    }

    public String getLine(int line) {
        return this._sb.toString().split("\n")[line - 1];
    }

    public File build(Config c) throws IOException {
        this._sb.append("LANGUAGE ");
        this._sb.append(0);
        this._sb.append(", ");
        this._sb.append(1);
        this._sb.append('\n');
        this.addVersionInfo(c.getVersionInfo());
        this.addJre(c.getJre());
        this.addManifest(1, c.getManifest());
        this.addIcon(1, c.getIcon());
        this.addText(10, c.getErrTitle());
        this.addText(21, c.getDownloadUrl());
        this.addText(22, c.getSupportUrl());
        this.addText(13, c.getCmdLine());
        this.addWindowsPath(8, c.getChdir());
        this.addText(20, String.valueOf(c.getPriorityClass()));
        this.addTrue(11, c.isStayAlive());
        this.addTrue(31, c.isRestartOnCrash());
        this.addSplash(c.getSplash());
        this.addMessages(c);
        if (c.getSingleInstance() != null) {
            this.addText(23, c.getSingleInstance().getMutexName());
            this.addText(24, c.getSingleInstance().getWindowTitle());
        }
        if (c.getVariables() != null && !c.getVariables().isEmpty()) {
            StringBuffer vars = new StringBuffer();
            this.append(vars, c.getVariables(), "\t");
            this.addText(19, vars.toString());
        }
        this.addTrue(17, !c.isDontWrapJar());
        if (c.getClassPath() != null) {
            this.addText(15, c.getClassPath().getMainClass());
            this.addWindowsPath(16, c.getClassPath().getPathsString());
        }
        if (c.isDontWrapJar() && c.getJar() != null) {
            this.addWindowsPath(14, c.getJar().getPath());
        }
        File file = Util.createTempFile("rc");
        if ("MS932".equals(System.getProperty("file.encoding"))) {
            this.writeKanjiResourceFile(file);
        } else {
            this.writeResourceFile(file);
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeResourceFile(File file) throws IOException {
        FileOutputStream os = null;
        OutputStreamWriter osw = null;
        BufferedWriter w = null;
        try {
            os = new FileOutputStream(file);
            osw = new OutputStreamWriter((OutputStream)os, "ISO-8859-1");
            w = new BufferedWriter(osw);
            w.write(this._sb.toString());
        }
        catch (Throwable throwable) {
            Util.close(w);
            Util.close(osw);
            Util.close(os);
            throw throwable;
        }
        Util.close(w);
        Util.close(osw);
        Util.close(os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeKanjiResourceFile(File file) throws IOException {
        FileOutputStream output = null;
        KanjiEscapeOutputStream kanji = null;
        OutputStreamWriter writer = null;
        BufferedWriter w = null;
        try {
            output = new FileOutputStream(file);
            kanji = new KanjiEscapeOutputStream(output);
            writer = new OutputStreamWriter(kanji);
            w = new BufferedWriter(writer);
            w.write(this._sb.toString());
        }
        catch (Throwable throwable) {
            Util.close(w);
            Util.close(writer);
            Util.close(kanji);
            Util.close(output);
            throw throwable;
        }
        Util.close(w);
        Util.close(writer);
        Util.close(kanji);
        Util.close(output);
    }

    private void addVersionInfo(VersionInfo v) {
        if (v == null) {
            return;
        }
        this._sb.append("1 VERSIONINFO\n");
        this._sb.append("FILEVERSION ");
        this._sb.append(v.getFileVersion().replaceAll("\\.", ", "));
        this._sb.append("\nPRODUCTVERSION ");
        this._sb.append(v.getProductVersion().replaceAll("\\.", ", "));
        this._sb.append("\nFILEFLAGSMASK 0\nFILEOS 0x40000\nFILETYPE 1\n{\n BLOCK \"StringFileInfo\"\n {\n  BLOCK \"");
        this._sb.append(String.format("%04X%04X", v.getLanguage().getId(), CharsetID.MULTILINGUAL.getId()));
        this._sb.append("\"\n  {\n");
        this.addVerBlockValue("CompanyName", v.getCompanyName());
        this.addVerBlockValue("FileDescription", v.getFileDescription());
        this.addVerBlockValue("FileVersion", v.getTxtFileVersion());
        this.addVerBlockValue("InternalName", v.getInternalName());
        this.addVerBlockValue("LegalCopyright", v.getCopyright());
        this.addVerBlockValue("LegalTrademarks", v.getTrademarks());
        this.addVerBlockValue("OriginalFilename", v.getOriginalFilename());
        this.addVerBlockValue("ProductName", v.getProductName());
        this.addVerBlockValue("ProductVersion", v.getTxtProductVersion());
        this._sb.append("  }\n }\nBLOCK \"VarFileInfo\"\n{\nVALUE \"Translation\", ");
        this._sb.append(String.format("0x%04X, 0x%04X", v.getLanguage().getId(), CharsetID.MULTILINGUAL.getId()));
        this._sb.append("\n}\n}");
    }

    private void addJre(Jre jre) {
        this.addWindowsPath(1, jre.getPath());
        this.addTrue(18, jre.getRequiresJdk());
        this.addTrue(29, jre.getRequires64Bit());
        this.addText(2, jre.getMinVersion());
        this.addText(3, jre.getMaxVersion());
        this.addInteger(25, jre.getInitialHeapSize());
        this.addInteger(26, jre.getInitialHeapPercent());
        this.addInteger(27, jre.getMaxHeapSize());
        this.addInteger(28, jre.getMaxHeapPercent());
        StringBuffer options = new StringBuffer();
        if (jre.getOptions() != null && !jre.getOptions().isEmpty()) {
            this.addSpace(options);
            this.append(options, jre.getOptions(), " ");
        }
        this.addText(12, options.toString());
    }

    private void addSplash(Splash splash) {
        if (splash == null) {
            return;
        }
        this.addTrue(4, true);
        this.addTrue(5, splash.getWaitForWindow());
        this.addText(6, String.valueOf(splash.getTimeout()));
        this.addTrue(7, splash.isTimeoutErr());
        this.addBitmap(1, splash.getFile());
    }

    private void addMessages(Config c) {
        Msg msg = c.getMessages();
        if (msg == null) {
            msg = new Msg();
        }
        this.addText(101, msg.getStartupErr());
        this.addText(102, msg.getJreNotFoundErr());
        this.addText(103, msg.getJreVersionErr());
        this.addText(104, msg.getLauncherErr());
        if (c.getSingleInstance() != null) {
            this.addText(105, msg.getInstanceAlreadyExistsMsg());
        }
    }

    private void append(StringBuffer sb, List<String> list, String separator) {
        for (int i = 0; i < list.size(); ++i) {
            sb.append(list.get(i));
            if (i >= list.size() - 1) continue;
            sb.append(separator);
        }
    }

    private void addText(int id, String text) {
        if (text == null || text.equals("")) {
            return;
        }
        this._sb.append(id);
        this._sb.append(" RCDATA BEGIN \"");
        this._sb.append(this.escape(text));
        this._sb.append("\\0\" END\n");
    }

    private void addTrue(int id, boolean value) {
        if (value) {
            this.addText(id, "true");
        }
    }

    private void addInteger(int id, Integer value) {
        if (value != null) {
            this.addText(id, value.toString());
        }
    }

    private void addWindowsPath(int id, String path) {
        if (path == null || path.equals("")) {
            return;
        }
        this._sb.append(id);
        this._sb.append(" RCDATA BEGIN \"");
        this._sb.append(path.replaceAll("\\\\", "\\\\\\\\").replaceAll("/", "\\\\\\\\"));
        this._sb.append("\\0\" END\n");
    }

    private void addManifest(int id, File manifest) {
        if (manifest == null || manifest.getPath().equals("")) {
            return;
        }
        this._sb.append(id);
        this._sb.append(" 24 \"");
        this._sb.append(this.getPath(Util.getAbsoluteFile(ConfigPersister.getInstance().getConfigPath(), manifest)));
        this._sb.append("\"\n");
    }

    private void addIcon(int id, File icon) {
        if (icon == null || icon.getPath().equals("")) {
            return;
        }
        this._sb.append(id);
        this._sb.append(" ICON DISCARDABLE \"");
        this._sb.append(this.getPath(Util.getAbsoluteFile(ConfigPersister.getInstance().getConfigPath(), icon)));
        this._sb.append("\"\n");
    }

    private void addBitmap(int id, File bitmap) {
        if (bitmap == null) {
            return;
        }
        this._sb.append(id);
        this._sb.append(" BITMAP \"");
        this._sb.append(this.getPath(Util.getAbsoluteFile(ConfigPersister.getInstance().getConfigPath(), bitmap)));
        this._sb.append("\"\n");
    }

    private String getPath(File f) {
        return f.getPath().replaceAll("\\\\", "\\\\\\\\");
    }

    private void addSpace(StringBuffer sb) {
        int len = sb.length();
        if (len-- > 0 && sb.charAt(len) != ' ') {
            sb.append(' ');
        }
    }

    private void addVerBlockValue(String key, String value) {
        this._sb.append("   VALUE \"");
        this._sb.append(key);
        this._sb.append("\", \"");
        if (value != null) {
            this._sb.append(this.escape(value));
        }
        this._sb.append("\"\n");
    }

    private String escape(String text) {
        return text.replace("\"", "\"\"").replace("\\", "\\\\").replace("\n", "\\r\\n");
    }
}

