/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.store.memento;

import com.jeta.forms.gui.common.FormUtils;
import com.jgoodies.forms.layout.CellConstraints;
import java.awt.Insets;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class CellConstraintsMemento
implements Externalizable {
    static final long serialVersionUID = 7894081609390290274L;
    public static final int VERSION = 1;
    private int m_column;
    private int m_row;
    private int m_colspan;
    private int m_rowspan;
    private Insets m_insets;
    private String m_valign;
    private String m_halign;

    public CellConstraintsMemento() {
    }

    public CellConstraintsMemento(CellConstraints cellConstraints) {
        this.m_column = cellConstraints.gridX;
        this.m_row = cellConstraints.gridY;
        this.m_colspan = cellConstraints.gridWidth;
        this.m_rowspan = cellConstraints.gridHeight;
        this.m_halign = cellConstraints.hAlign.toString();
        this.m_valign = cellConstraints.vAlign.toString();
        this.m_insets = cellConstraints.insets;
    }

    public CellConstraints createCellConstraints() {
        try {
            return new CellConstraints(this.m_column, this.m_row, this.m_colspan, this.m_rowspan, FormUtils.toAlignment(this.m_halign), FormUtils.toAlignment(this.m_valign), this.m_insets);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new CellConstraints();
        }
    }

    public int getRow() {
        return this.m_row;
    }

    public int getColumn() {
        return this.m_column;
    }

    public void readExternal(ObjectInput objectInput) throws ClassNotFoundException, IOException {
        int n = objectInput.readInt();
        this.m_column = objectInput.readInt();
        this.m_row = objectInput.readInt();
        this.m_colspan = objectInput.readInt();
        this.m_rowspan = objectInput.readInt();
        this.m_halign = (String)objectInput.readObject();
        this.m_valign = (String)objectInput.readObject();
        this.m_insets = (Insets)objectInput.readObject();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(1);
        objectOutput.writeInt(this.m_column);
        objectOutput.writeInt(this.m_row);
        objectOutput.writeInt(this.m_colspan);
        objectOutput.writeInt(this.m_rowspan);
        objectOutput.writeObject(this.m_halign);
        objectOutput.writeObject(this.m_valign);
        objectOutput.writeObject(this.m_insets);
    }
}

