/*
 * Decompiled with CFR 0.152.
 */
package net.sf.launch4j.binding;

import java.awt.Color;
import javax.swing.JComboBox;
import net.sf.launch4j.binding.Binding;
import net.sf.launch4j.binding.BindingException;
import net.sf.launch4j.binding.IValidatable;
import net.sf.launch4j.binding.Messages;
import org.apache.commons.beanutils.PropertyUtils;

public class JComboBoxBinding<T>
implements Binding {
    private final String _property;
    private final JComboBox<T> _combo;
    private final int _defaultValue;
    private final Color _validColor;

    public JComboBoxBinding(String property, JComboBox<T> combo, int defaultValue) {
        if (property == null || combo == null) {
            throw new NullPointerException();
        }
        if (property.equals("") || combo.getItemCount() == 0 || defaultValue < 0 || defaultValue >= combo.getItemCount()) {
            throw new IllegalArgumentException();
        }
        this._property = property;
        this._combo = combo;
        this._defaultValue = defaultValue;
        this._validColor = combo.getBackground();
    }

    @Override
    public String getProperty() {
        return this._property;
    }

    @Override
    public void clear(IValidatable bean) {
        this.select(this._defaultValue);
    }

    @Override
    public void put(IValidatable bean) {
        try {
            Integer i = (Integer)PropertyUtils.getProperty(bean, this._property);
            if (i == null) {
                throw new BindingException(Messages.getString("JComboBoxBinding.property.null"));
            }
            this.select(i);
        }
        catch (Exception e) {
            throw new BindingException(e);
        }
    }

    @Override
    public void get(IValidatable bean) {
        try {
            PropertyUtils.setProperty(bean, this._property, new Integer(this._combo.getSelectedIndex()));
            return;
        }
        catch (Exception e) {
            throw new BindingException(e);
        }
    }

    private void select(int index) {
        if (index < 0 || index >= this._combo.getItemCount()) {
            throw new BindingException(Messages.getString("JComboBoxBinding.index.out.of.bounds"));
        }
        this._combo.setSelectedIndex(index);
    }

    @Override
    public void markValid() {
        this._combo.setBackground(this._validColor);
        this._combo.requestFocusInWindow();
    }

    @Override
    public void markInvalid() {
        this._combo.setBackground(Binding.INVALID_COLOR);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this._combo.setEnabled(enabled);
    }
}

