/*
 * Decompiled with CFR 0.152.
 */
package net.sf.launch4j.config;

public class JreVersion
implements Comparable<JreVersion> {
    private int x1;
    private int x2;
    private int x3;
    private int x4;

    public static JreVersion parseString(String versionStr) {
        JreVersion ret = new JreVersion();
        if (versionStr == null || versionStr.trim().length() == 0) {
            return ret;
        }
        if (!versionStr.matches("(1\\.\\d\\.\\d(_\\d{1,3})?)|[1-9][0-9]{0,2}(\\.\\d{1,3}){0,2}")) {
            throw new IllegalArgumentException("JRE version is not in a right format.");
        }
        String[] parts = versionStr.split("[\\._]");
        int first = Integer.parseInt(parts[0]);
        if (first > 1) {
            ret.x1 = 1;
            ret.x2 = first;
            if (parts.length >= 2) {
                ret.x3 = Integer.parseInt(parts[1]);
                if (parts.length >= 3) {
                    ret.x4 = Integer.parseInt(parts[2]);
                }
            }
        } else {
            ret.x1 = first;
            if (parts.length >= 2) {
                ret.x2 = Integer.parseInt(parts[1]);
                if (parts.length >= 3) {
                    ret.x3 = Integer.parseInt(parts[2]);
                    if (parts.length == 4) {
                        ret.x4 = Integer.parseInt(parts[3]);
                    }
                }
            }
        }
        return ret;
    }

    public String toString() {
        if (this.x2 >= 9) {
            return this.x2 + "." + this.x3 + "." + this.x4;
        }
        return this.x1 + "." + this.x2 + "." + this.x3 + (this.x4 > 0 ? "_" + this.x4 : "");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.x1;
        result = 31 * result + this.x2;
        result = 31 * result + this.x3;
        result = 31 * result + this.x4;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JreVersion other = (JreVersion)obj;
        if (this.x1 != other.x1) {
            return false;
        }
        if (this.x2 != other.x2) {
            return false;
        }
        if (this.x3 != other.x3) {
            return false;
        }
        return this.x4 == other.x4;
    }

    @Override
    public int compareTo(JreVersion o) {
        if (this.equals(o)) {
            return 0;
        }
        if (this.x1 != o.x1) {
            return this.x1 - o.x1;
        }
        if (this.x2 != o.x2) {
            return this.x2 - o.x2;
        }
        if (this.x3 != o.x3) {
            return this.x3 - o.x3;
        }
        if (this.x4 != o.x4) {
            return this.x4 - o.x4;
        }
        throw new IllegalStateException("If you see this exception it means JreVersion::equals() method is buggy");
    }
}

