/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.gui.form;

import com.jeta.forms.gui.common.FormException;
import com.jeta.forms.gui.common.FormSpecAdapter;
import com.jeta.forms.gui.common.FormUtils;
import com.jeta.forms.gui.components.ComponentFactory;
import com.jeta.forms.gui.components.ComponentSource;
import com.jeta.forms.gui.components.EmptyComponentFactory;
import com.jeta.forms.gui.effects.Paintable;
import com.jeta.forms.gui.effects.Painter;
import com.jeta.forms.gui.form.BackgroundPainter;
import com.jeta.forms.gui.form.CellAssignmentCache;
import com.jeta.forms.gui.form.CellPainter;
import com.jeta.forms.gui.form.ComponentConstraints;
import com.jeta.forms.gui.form.FormAccessor;
import com.jeta.forms.gui.form.FormComponent;
import com.jeta.forms.gui.form.FormContainerComponent;
import com.jeta.forms.gui.form.FormIterator;
import com.jeta.forms.gui.form.GridCellEvent;
import com.jeta.forms.gui.form.GridCellListener;
import com.jeta.forms.gui.form.GridComponent;
import com.jeta.forms.gui.form.GridOverlay;
import com.jeta.forms.gui.form.GridOverlayFactory;
import com.jeta.forms.gui.form.GridViewEvent;
import com.jeta.forms.gui.form.GridViewListener;
import com.jeta.forms.gui.form.JETALayerLayout;
import com.jeta.forms.gui.form.ReadOnlyConstraints;
import com.jeta.forms.gui.form.StandardComponent;
import com.jeta.forms.logger.FormsLogger;
import com.jeta.forms.store.memento.FormGroupSet;
import com.jeta.forms.store.properties.effects.PaintProperty;
import com.jeta.forms.store.support.Matrix;
import com.jeta.open.gui.framework.JETAPanel;
import com.jeta.open.registry.JETARegistry;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public class GridView
extends JETAPanel
implements Paintable,
FormAccessor,
GridCellListener {
    private FormLayout m_formlayout;
    private FormContainer m_form;
    private JLayeredPane m_layered_pane;
    private BackgroundPainter m_background_painter;
    private CellAssignmentCache m_assignment_cache = new CellAssignmentCache(this);
    private GridOverlay m_overlay;
    private FormLayout.LayoutInfo m_layoutinfo = null;
    private CellPainter m_cell_painter;
    private Matrix m_cell_painters = new Matrix(0, 0);
    private FormGroupSet m_col_groups = new FormGroupSet();
    private FormGroupSet m_row_groups = new FormGroupSet();
    private long m_nested_mod_stamp = -1L;
    private boolean m_events_enabled = false;
    private LinkedList m_listeners = new LinkedList();
    public static final Integer BACKGROUND_PAINTER_LAYER = new Integer(0);
    public static final Integer CELL_PAINTER_LAYER = new Integer(1);
    public static final Integer FORM_LAYER = new Integer(2);
    public static final Integer OVERLAY_LAYER = new Integer(9);
    public static final Integer FOCUS_LAYER = new Integer(10);
    private GridComponent m_last_comp;

    public GridView() {
        this.setOpaque(true);
    }

    public GridView(String string, String string2) {
        this.initialize(string, string2);
    }

    public GridView(int n, int n2) {
        this.initialize(n, n2);
    }

    public void addComponent(GridComponent gridComponent, CellConstraints cellConstraints) {
        gridComponent.addListener(this);
        this.m_form.add((Component)gridComponent, cellConstraints);
        this.m_assignment_cache.addComponent(gridComponent);
        this.m_form.revalidate();
        this.fireGridEvent(new GridViewEvent(this, 8));
        this.unitTest();
    }

    public void addComponent(GridComponent gridComponent, ComponentConstraints componentConstraints) {
        this.addComponent(gridComponent, componentConstraints.createCellConstraints());
    }

    public void addListener(GridViewListener gridViewListener) {
        if (gridViewListener != null && !this.m_listeners.contains(gridViewListener)) {
            this.m_listeners.add(gridViewListener);
        }
    }

    public void cellChanged(GridCellEvent gridCellEvent) {
        if (gridCellEvent.getId() == 2) {
            this.fireGridEvent(new GridViewEvent(this, 9, gridCellEvent));
        } else if (gridCellEvent.getId() == 3) {
            this.fireGridEvent(new GridViewEvent(this, 10, gridCellEvent));
            this.m_last_comp = gridCellEvent.getSource();
        } else {
            this.fireGridEvent(new GridViewEvent(this, 8, gridCellEvent));
        }
    }

    public void deselectAll() {
        if (this.m_last_comp != null) {
            this.m_last_comp.setSelected(false);
        }
    }

    public void doLayout() {
        super.doLayout();
        this.m_form.doLayout();
    }

    public void enableEvents(boolean bl) {
        this.m_events_enabled = bl;
    }

    public void fireGridEvent(GridViewEvent gridViewEvent) {
        if (this.isEventsEnabled()) {
            if (gridViewEvent.getId() != 9 && gridViewEvent.getId() != 10) {
                this.refreshView();
            }
            this.m_layoutinfo = null;
            Iterator iterator = this.m_listeners.iterator();
            while (iterator.hasNext()) {
                try {
                    GridViewListener gridViewListener = (GridViewListener)iterator.next();
                    gridViewListener.gridChanged(gridViewEvent);
                }
                catch (Exception exception) {
                    FormsLogger.debug(exception);
                }
            }
        }
    }

    public static void fillCells(GridView gridView, ComponentSource componentSource) {
        try {
            for (int i = 1; i <= gridView.getColumnCount(); ++i) {
                for (int j = 1; j <= gridView.getRowCount(); ++j) {
                    EmptyComponentFactory emptyComponentFactory = new EmptyComponentFactory(componentSource);
                    StandardComponent standardComponent = (StandardComponent)emptyComponentFactory.createComponent("empty", gridView);
                    gridView.addComponent((GridComponent)standardComponent, new ReadOnlyConstraints(i, j));
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Rectangle getCellBounds(int n, int n2) {
        try {
            int n3 = this.getColumnOrgX(n);
            int n4 = this.getRowOrgY(n2);
            int n5 = this.getColumnWidth(n);
            int n6 = this.getRowHeight(n);
            return new Rectangle(n3, n4, n5, n6);
        }
        catch (Exception exception) {
            System.out.println("GridView.getCellBounds exception:  col: " + n + "  row: " + n2);
            exception.printStackTrace();
            return null;
        }
    }

    public Matrix getCellPainters() {
        FormUtils.safeAssert(this.m_cell_painters.getRowCount() == this.getRowCount());
        FormUtils.safeAssert(this.m_cell_painters.getColumnCount() == this.getColumnCount());
        return this.m_cell_painters;
    }

    public int getColumnCount() {
        return this.m_formlayout.getColumnCount();
    }

    public int getColumnOrgX(int n) {
        FormLayout.LayoutInfo layoutInfo = this.getLayoutInfo();
        return layoutInfo.columnOrigins[--n];
    }

    public FormGroupSet getColumnGroups() {
        return this.m_col_groups;
    }

    public String getColumnSpecs() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 1; i <= this.getColumnCount(); ++i) {
            ColumnSpec columnSpec = this.getColumnSpec(i);
            if (i > 1) {
                stringBuffer.append(",");
            }
            String string = columnSpec.toShortString();
            stringBuffer.append(FormSpecAdapter.fixup(string));
        }
        return stringBuffer.toString();
    }

    public int getColumnWidth(int n) {
        FormLayout.LayoutInfo layoutInfo = this.getLayoutInfo();
        return layoutInfo.columnOrigins[--n + 1] - layoutInfo.columnOrigins[n];
    }

    public ColumnSpec getColumnSpec(int n) {
        return this.m_formlayout.getColumnSpec(n);
    }

    public FormAccessor getFormAccessor() {
        return this;
    }

    public Container getFormContainer() {
        return this.m_form;
    }

    public String getFormName() {
        return this.getName();
    }

    long getModificationStamp() {
        return this.m_form.getModificationStamp();
    }

    long getNestedModificationStamp() {
        return this.m_nested_mod_stamp;
    }

    public int getRowCount() {
        return this.m_formlayout.getRowCount();
    }

    public FormLayout getFormLayout() {
        return this.m_formlayout;
    }

    public int getFormWidth() {
        FormLayout.LayoutInfo layoutInfo = this.getLayoutInfo();
        return layoutInfo.getWidth();
    }

    public int getFormHeight() {
        FormLayout.LayoutInfo layoutInfo = this.getLayoutInfo();
        return layoutInfo.getHeight();
    }

    public GridComponent getGridComponent(int n, int n2) {
        return this.m_assignment_cache.getGridComponent(n, n2);
    }

    public int getGridComponentCount() {
        return this.m_form.getComponentCount();
    }

    public GridComponent getGridComponent(int n) {
        Component component = this.m_form.getComponent(n);
        if (component instanceof GridComponent) {
            return (GridComponent)component;
        }
        return null;
    }

    FormLayout.LayoutInfo getLayoutInfo() {
        if (this.m_layoutinfo == null) {
            this.m_layoutinfo = this.m_formlayout.getLayoutInfo((Container)this.m_form);
        }
        return this.m_layoutinfo;
    }

    public PaintProperty getPaintProperty(int n, int n2) {
        Object object = this.m_cell_painters.getValue(n2 - 1, n - 1);
        if (object instanceof PaintProperty) {
            PaintProperty paintProperty = (PaintProperty)object;
            if (paintProperty != null) {
                return paintProperty;
            }
            return null;
        }
        if (object != null) {
            System.out.println("GridView.getPaintProperty failed  for col: " + n + " row: " + n2 + "  prop: " + object.getClass());
        }
        return null;
    }

    public FormComponent getParentForm() {
        for (Container container = this.getParent(); container != null && !(container instanceof Window); container = container.getParent()) {
            if (!(container instanceof FormComponent)) continue;
            FormComponent formComponent = (FormComponent)container;
            FormUtils.safeAssert(formComponent.getBean().getDelegate() == this);
            return formComponent;
        }
        FormUtils.safeAssert(false);
        return null;
    }

    public int getRowHeight(int n) {
        FormLayout.LayoutInfo layoutInfo = this.getLayoutInfo();
        return layoutInfo.rowOrigins[--n + 1] - layoutInfo.rowOrigins[n];
    }

    public int getRowOrgY(int n) {
        FormLayout.LayoutInfo layoutInfo = this.getLayoutInfo();
        return layoutInfo.rowOrigins[--n];
    }

    public GridComponent getOverlappingComponent(int n, int n2) {
        return this.m_assignment_cache.getOverlappingComponent(n, n2);
    }

    public GridOverlay getOverlay() {
        return this.m_overlay;
    }

    public FormGroupSet getRowGroups() {
        return this.m_row_groups;
    }

    public RowSpec getRowSpec(int n) {
        FormUtils.safeAssert(n >= 1 && n <= this.getRowCount());
        return this.m_formlayout.getRowSpec(n);
    }

    public String getRowSpecs() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 1; i <= this.getRowCount(); ++i) {
            RowSpec rowSpec = this.getRowSpec(i);
            if (i > 1) {
                stringBuffer.append(",");
            }
            String string = rowSpec.toString();
            stringBuffer.append(FormSpecAdapter.fixup(string));
        }
        return stringBuffer.toString();
    }

    public GridComponent getSelectedComponent() {
        Iterator iterator = this.gridIterator();
        while (iterator.hasNext()) {
            GridComponent gridComponent;
            GridComponent gridComponent2 = (GridComponent)iterator.next();
            if (!(gridComponent2 instanceof FormComponent ? (gridComponent2 = ((FormComponent)(gridComponent = (FormComponent)gridComponent2)).getSelectedComponent()) != null : (gridComponent2 instanceof FormContainerComponent ? (gridComponent2 = ((FormContainerComponent)(gridComponent = (FormContainerComponent)gridComponent2)).getSelectedComponent()) != null : gridComponent2.isSelected()))) continue;
            return gridComponent2;
        }
        return null;
    }

    public void initialize(int n, int n2) {
        this.enableEvents(FormUtils.isDesignMode());
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 1; i <= n; ++i) {
            if (i > 1) {
                stringBuffer.append(",");
            }
            stringBuffer.append("f:d:n");
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        for (int i = 1; i <= n2; ++i) {
            if (i > 1) {
                stringBuffer2.append(",");
            }
            stringBuffer2.append("c:d:n");
        }
        this.initialize(stringBuffer.toString(), stringBuffer2.toString());
        this.m_cell_painters = new Matrix(this.getRowCount(), this.getColumnCount());
    }

    void initialize(String string, String string2) {
        this.removeAll();
        string = FormSpecAdapter.fixupSpecs(string);
        string2 = FormSpecAdapter.fixupSpecs(string2);
        FormUtils.safeAssert(this.m_formlayout == null);
        this.setOpaque(true);
        this.m_formlayout = new FormLayout(string, string2);
        this.m_form = new FormContainer();
        this.m_form.setOpaque(false);
        this.m_form.setLayout((LayoutManager)this.m_formlayout);
        this.setLayout(new BorderLayout());
        this.m_layered_pane = new JLayeredPane();
        this.m_layered_pane.setOpaque(false);
        this.m_layered_pane.setLayout(new JETALayerLayout());
        this.m_background_painter = new BackgroundPainter();
        this.m_cell_painter = new CellPainter(this);
        this.m_layered_pane.add((Component)this.m_background_painter, BACKGROUND_PAINTER_LAYER);
        this.m_layered_pane.add((Component)this.m_cell_painter, CELL_PAINTER_LAYER);
        this.m_layered_pane.add((Component)this.m_form, FORM_LAYER);
        super.add((Component)this.m_layered_pane, "Center");
        if (FormUtils.isDesignMode()) {
            GridOverlayFactory gridOverlayFactory = (GridOverlayFactory)JETARegistry.lookup("grid.overlay.factory");
            if (gridOverlayFactory != null) {
                this.m_overlay = gridOverlayFactory.createOverlay(this);
                ((JComponent)this.getFormContainer()).setBorder(BorderFactory.createEmptyBorder(0, 0, 1, 1));
                this.m_layered_pane.add((Component)((JComponent)((Object)this.m_overlay)), OVERLAY_LAYER);
            } else {
                FormUtils.safeAssert(false);
            }
        }
    }

    public void insertColumn(int n, ColumnSpec columnSpec, ComponentFactory componentFactory) throws FormException {
        Iterator iterator;
        GridComponent gridComponent;
        int n2 = this.getColumnCount();
        LinkedList<GridComponent> linkedList = new LinkedList<GridComponent>();
        for (int i = 1; i <= this.getRowCount(); ++i) {
            gridComponent = componentFactory.createComponent("test", this);
            linkedList.add(gridComponent);
        }
        CellConstraints cellConstraints = new CellConstraints();
        gridComponent = this.getFormLayout();
        if (n > this.getColumnCount()) {
            n = this.getColumnCount() + 1;
            gridComponent.appendColumn(columnSpec);
        } else {
            gridComponent.insertColumn(n, columnSpec);
        }
        if (FormUtils.isDebug()) {
            iterator = this.gridIterator();
            while (iterator.hasNext()) {
                GridComponent gridComponent2 = (GridComponent)iterator.next();
                if (gridComponent2.getColumn() != n) continue;
                System.out.println("GridView.insertRow failed at: col: " + n + " row: " + gridComponent2.getRow() + "  gc: " + gridComponent2);
            }
        }
        iterator = linkedList.iterator();
        int n3 = 1;
        while (iterator.hasNext()) {
            GridComponent gridComponent3 = (GridComponent)iterator.next();
            this.addComponent(gridComponent3, cellConstraints.xy(n, n3));
            ++n3;
        }
        this.m_cell_painters.insertColumn(n - 1);
        FormUtils.safeAssert(this.getColumnCount() == n2 + 1);
        FormUtils.safeAssert(this.getGridComponentCount() == this.getColumnCount() * this.getRowCount());
        this.updateColumnGroups();
        this.fireGridEvent(new GridViewEvent(this, 4));
    }

    public void insertRow(int n, RowSpec rowSpec, ComponentFactory componentFactory) throws FormException {
        Iterator iterator;
        GridComponent gridComponent;
        int n2 = this.getRowCount();
        LinkedList<GridComponent> linkedList = new LinkedList<GridComponent>();
        for (int i = 1; i <= this.getColumnCount(); ++i) {
            gridComponent = componentFactory.createComponent("", this);
            linkedList.add(gridComponent);
        }
        CellConstraints cellConstraints = new CellConstraints();
        gridComponent = this.getFormLayout();
        if (n > this.getRowCount()) {
            n = this.getRowCount() + 1;
            gridComponent.appendRow(rowSpec);
        } else {
            gridComponent.insertRow(n, rowSpec);
        }
        if (FormUtils.isDebug()) {
            iterator = this.gridIterator();
            while (iterator.hasNext()) {
                GridComponent gridComponent2 = (GridComponent)iterator.next();
                if (gridComponent2.getRow() != n) continue;
                System.out.println("GridView.insertRow failed at: col: " + gridComponent2.getColumn() + " row: " + n + "  gc: " + gridComponent2);
            }
        }
        iterator = linkedList.iterator();
        int n3 = 1;
        while (iterator.hasNext()) {
            GridComponent gridComponent3 = (GridComponent)iterator.next();
            this.addComponent(gridComponent3, cellConstraints.xy(n3, n));
            ++n3;
        }
        this.m_cell_painters.insertRow(n - 1);
        FormUtils.safeAssert(this.getRowCount() == n2 + 1);
        FormUtils.safeAssert(this.getGridComponentCount() == this.getColumnCount() * this.getRowCount());
        this.updateRowGroups();
        this.fireGridEvent(new GridViewEvent(this, 1));
    }

    public boolean isEventsEnabled() {
        return this.m_events_enabled;
    }

    public boolean isGridVisible() {
        return this.m_overlay.isGridVisible();
    }

    public Iterator gridIterator() {
        return new ComponentIterator();
    }

    public Collection listComponents() {
        LinkedList linkedList = new LinkedList();
        Iterator iterator = this.gridIterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            FormUtils.safeAssert(e instanceof GridComponent);
            linkedList.add(e);
        }
        return linkedList;
    }

    public void refreshView() {
        this.syncCellAssignments();
        this.revalidate();
        this.repaint();
    }

    public void removeColumn(int n) {
        GridComponent gridComponent;
        if (n < 1 || n > this.getColumnCount()) {
            FormUtils.safeAssert(false);
            return;
        }
        this.m_cell_painters.removeColumn(n - 1);
        LinkedList<GridComponent> linkedList = new LinkedList<GridComponent>();
        Iterator iterator = this.gridIterator();
        while (iterator.hasNext()) {
            gridComponent = (GridComponent)iterator.next();
            if (gridComponent.getColumn() != n) continue;
            linkedList.add(gridComponent);
        }
        iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            gridComponent = (GridComponent)iterator.next();
            this.m_form.remove(gridComponent);
        }
        this.m_formlayout.removeColumn(n);
        this.updateColumnGroups();
        this.fireGridEvent(new GridViewEvent(this, 5));
    }

    public void removeListener(GridViewListener gridViewListener) {
        if (gridViewListener != null) {
            this.m_listeners.remove(gridViewListener);
        }
    }

    public void removeRow(int n) {
        GridComponent gridComponent;
        if (n < 1 || n > this.getRowCount()) {
            FormUtils.safeAssert(false);
            return;
        }
        this.m_cell_painters.removeRow(n - 1);
        LinkedList<GridComponent> linkedList = new LinkedList<GridComponent>();
        Iterator iterator = this.gridIterator();
        while (iterator.hasNext()) {
            gridComponent = (GridComponent)iterator.next();
            if (gridComponent.getRow() != n) continue;
            linkedList.add(gridComponent);
        }
        iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            gridComponent = (GridComponent)iterator.next();
            this.m_form.remove(gridComponent);
        }
        this.m_formlayout.removeRow(n);
        this.updateRowGroups();
        this.fireGridEvent(new GridViewEvent(this, 2));
    }

    public void replaceComponent(GridComponent gridComponent, GridComponent gridComponent2) {
        CellConstraints cellConstraints = gridComponent2.getConstraints().createCellConstraints();
        this.setComponent(gridComponent, cellConstraints);
        this.fireGridEvent(new GridViewEvent(this, 8));
    }

    public void revalidate() {
        if (this.m_form != null) {
            this.m_form.revalidate();
        }
        super.revalidate();
    }

    public void setBackgroundPainter(Painter painter) {
        if (this.m_background_painter != null) {
            this.m_background_painter.setBackgroundPainter(painter);
        }
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.m_layoutinfo = null;
    }

    public void setCellPainters(Matrix matrix) {
        if (matrix == null) {
            this.m_cell_painters = new Matrix(this.getRowCount(), this.getColumnCount());
        } else {
            this.m_cell_painters = matrix;
            if (matrix.getRowCount() != this.getRowCount() || matrix.getColumnCount() != this.getColumnCount()) {
                this.m_cell_painters = new Matrix(this.getRowCount(), this.getColumnCount());
            }
        }
    }

    public void setColumnSpec(int n, ColumnSpec columnSpec) {
        FormLayout formLayout = this.getFormLayout();
        ColumnSpec columnSpec2 = new ColumnSpec(columnSpec.getDefaultAlignment(), columnSpec.getSize(), columnSpec.getResizeWeight());
        formLayout.setColumnSpec(n, columnSpec2);
        this.m_form.revalidate();
        this.fireGridEvent(new GridViewEvent(this, 7));
    }

    public void setComponent(GridComponent gridComponent, CellConstraints cellConstraints) {
        GridComponent gridComponent2 = this.getGridComponent(cellConstraints.gridX, cellConstraints.gridY);
        if (gridComponent2 != null) {
            gridComponent2.removeListener(this);
            this.m_form.remove(gridComponent2);
        }
        gridComponent.addListener(this);
        this.m_form.add((Component)gridComponent, cellConstraints);
        this.m_form.revalidate();
        this.syncCellAssignments();
        this.fireGridEvent(new GridViewEvent(this, 8));
        this.unitTest();
    }

    public void setComponent(GridComponent gridComponent, ComponentConstraints componentConstraints) {
        this.setComponent(gridComponent, componentConstraints.createCellConstraints());
    }

    public void setConstraints(GridComponent gridComponent, CellConstraints cellConstraints) {
        this.m_formlayout.setConstraints((Component)gridComponent, cellConstraints);
        this.syncCellAssignments();
        this.m_form.revalidate();
        this.fireGridEvent(new GridViewEvent(this, 8, gridComponent));
    }

    public void setConstraints(GridComponent gridComponent, ComponentConstraints componentConstraints) {
        this.setConstraints(gridComponent, componentConstraints.createCellConstraints());
    }

    public void setGridVisible(boolean bl) {
        this.m_overlay.setGridVisible(bl);
    }

    public void setPaintProperty(int n, int n2, PaintProperty paintProperty) {
        this.m_cell_painters.setValue(n2 - 1, n - 1, paintProperty);
        this.repaint();
    }

    public void setColumnGroups(FormGroupSet formGroupSet) {
        if (formGroupSet != null) {
            int[][] nArray = formGroupSet.toArray();
            for (int i = 0; i < nArray.length; ++i) {
                int[] nArray2 = nArray[i];
                for (int j = 0; j < nArray2.length; ++j) {
                    int n = nArray2[j];
                    if (n >= 1 && n <= this.getColumnCount()) continue;
                    FormUtils.safeAssert(false);
                    return;
                }
            }
            this.m_formlayout.setColumnGroups(nArray);
            this.m_col_groups = formGroupSet;
            this.fireGridEvent(new GridViewEvent(this, 12));
        }
    }

    public void setRowGroups(FormGroupSet formGroupSet) {
        if (formGroupSet != null) {
            int[][] nArray = formGroupSet.toArray();
            for (int i = 0; i < nArray.length; ++i) {
                int[] nArray2 = nArray[i];
                for (int j = 0; j < nArray2.length; ++j) {
                    int n = nArray2[j];
                    if (n >= 1 && n <= this.getRowCount()) continue;
                    FormUtils.safeAssert(false);
                    return;
                }
            }
            this.m_formlayout.setRowGroups(nArray);
            this.m_row_groups = formGroupSet;
            this.fireGridEvent(new GridViewEvent(this, 11));
        }
    }

    public void setRowSpec(int n, RowSpec rowSpec) {
        FormLayout formLayout = this.getFormLayout();
        RowSpec rowSpec2 = new RowSpec(rowSpec.getDefaultAlignment(), rowSpec.getSize(), rowSpec.getResizeWeight());
        formLayout.setRowSpec(n, rowSpec2);
        this.m_form.revalidate();
        this.fireGridEvent(new GridViewEvent(this, 3));
    }

    private void syncCellAssignments() {
        this.m_assignment_cache.sync();
    }

    public void addBean(Component component, CellConstraints cellConstraints) {
        if (component == null) {
            System.err.println("addBean: comp cannot be null");
            return;
        }
        if (cellConstraints == null) {
            System.err.println("addBean: cc cannot be null");
            return;
        }
        this.m_form.add(component, cellConstraints);
        this.refreshView();
    }

    public CellConstraints getConstraints(Component component) {
        return this.getFormLayout().getConstraints(component);
    }

    public Container getContainer() {
        return this.getFormContainer();
    }

    public Iterator beanIterator() {
        return new FormIterator(this, false);
    }

    public Iterator beanIterator(boolean bl) {
        return new FormIterator(this, bl);
    }

    public Component removeBean(Component component) {
        if (component == null) {
            System.err.println("removeBean: comp cannot be null");
            return null;
        }
        return this.replaceBean(component, null);
    }

    public Component removeBean(String string) {
        if (string == null) {
            System.err.println("removeBean: compName cannot be null");
            return null;
        }
        for (int i = 0; i < this.m_form.getComponentCount(); ++i) {
            Component component;
            Component component2;
            JComponent jComponent;
            Component component3 = this.m_form.getComponent(i);
            if (string.equals(component3.getName())) {
                this.m_form.remove(component3);
                this.refreshView();
                return component3;
            }
            if (component3 instanceof GridComponent) {
                JViewport jViewport;
                jComponent = (GridComponent)component3;
                component2 = ((GridComponent)jComponent).getBeanChildComponent();
                if (component2 != null && string.equals(component2.getName())) {
                    this.m_form.remove(component3);
                    this.refreshView();
                    return component3;
                }
                if (!(component2 instanceof JScrollPane) || (jViewport = ((JScrollPane)(component = (JScrollPane)component2)).getViewport()) == null || (component2 = jViewport.getView()) == null || !string.equals(component2.getName())) continue;
                this.m_form.remove(component);
                this.refreshView();
                return component;
            }
            if (!(component3 instanceof JScrollPane) || (component2 = ((JScrollPane)(jComponent = (JScrollPane)component3)).getViewport()) == null || (component = ((JViewport)component2).getView()) == null || !string.equals(component.getName())) continue;
            this.m_form.remove(component3);
            this.refreshView();
            return component3;
        }
        return null;
    }

    public Component replaceBean(Component component, Component component2) {
        if (component == null) {
            System.err.println("replaceBean: oldComponent cannot be null");
            return null;
        }
        Component component3 = null;
        CellConstraints cellConstraints = null;
        for (int i = 0; i < this.m_form.getComponentCount(); ++i) {
            Component component4;
            Component component5;
            JComponent jComponent;
            component3 = this.m_form.getComponent(i);
            cellConstraints = this.m_formlayout.getConstraints(component3);
            if (component == component3) break;
            if (component3 instanceof GridComponent) {
                Component component6;
                JViewport jViewport;
                jComponent = (GridComponent)component3;
                component5 = ((GridComponent)jComponent).getBeanChildComponent();
                if (component5 instanceof JScrollPane && (jViewport = (component4 = (JScrollPane)component5).getViewport()) != null && (component6 = jViewport.getView()) == component) {
                    component3 = component4;
                    break;
                }
                if (component5 == component) {
                    break;
                }
            } else if (component3 instanceof JScrollPane && (component5 = ((JScrollPane)(jComponent = (JScrollPane)component3)).getViewport()) != null && (component4 = ((JViewport)component5).getView()) == component) break;
            component3 = null;
        }
        if (component3 != null) {
            this.m_form.remove(component3);
            if (component2 != null) {
                this.m_form.add(component2, cellConstraints);
            }
            this.refreshView();
            return component3;
        }
        System.err.println("replaceBean failed.  Unable to find oldComp: " + component.getClass() + "  name: " + component.getName());
        return null;
    }

    public Component replaceBean(String string, Component component) {
        if (string == null) {
            System.err.println("replaceBean failed.  compName cannot be null. ");
            return null;
        }
        Iterator iterator = this.beanIterator(false);
        while (iterator.hasNext()) {
            Component component2 = (Component)iterator.next();
            if (!string.equals(component2.getName())) continue;
            return this.replaceBean(component2, component);
        }
        System.err.println("replaceBean failed.  Unable to find compName: " + string);
        return null;
    }

    private void unitTest() {
    }

    public void updateColumnGroups() {
        try {
            FormGroupSet formGroupSet = new FormGroupSet();
            int[][] nArray = this.m_formlayout.getColumnGroups();
            for (int i = 0; i < nArray.length; ++i) {
                int[] nArray2 = nArray[i];
                if (nArray2 == null) continue;
                Integer n = new Integer(i + 1);
                for (int j = 0; j < nArray2.length; ++j) {
                    formGroupSet.assignToGroup(n, nArray2[j]);
                }
            }
            this.m_col_groups = formGroupSet;
        }
        catch (Exception exception) {
            FormsLogger.debug(exception);
        }
    }

    public void updateRowGroups() {
        try {
            FormGroupSet formGroupSet = new FormGroupSet();
            int[][] nArray = this.m_formlayout.getRowGroups();
            for (int i = 0; i < nArray.length; ++i) {
                int[] nArray2 = nArray[i];
                if (nArray2 == null) continue;
                Integer n = new Integer(i + 1);
                for (int j = 0; j < nArray2.length; ++j) {
                    formGroupSet.assignToGroup(n, nArray2[j]);
                }
            }
            this.m_row_groups = formGroupSet;
        }
        catch (Exception exception) {
            FormsLogger.debug(exception);
        }
    }

    private void updateParentModicationStamps(Container container, long l) {
        while (container != null) {
            if (container instanceof GridView) {
                GridView gridView = (GridView)container;
                gridView.m_nested_mod_stamp = l;
            }
            if (!((container = container.getParent()) instanceof Window) && !(container instanceof JInternalFrame)) continue;
            break;
        }
    }

    private class FormContainer
    extends JPanel {
        private long m_mod_stamp;

        private FormContainer() {
        }

        protected void addImpl(Component component, Object object, int n) {
            super.addImpl(component, object, n);
            this.m_mod_stamp = System.currentTimeMillis();
            GridView.this.updateParentModicationStamps(GridView.this.getParent(), this.m_mod_stamp);
        }

        public void remove(int n) {
            super.remove(n);
            this.m_mod_stamp = System.currentTimeMillis();
            GridView.this.updateParentModicationStamps(GridView.this.getParent(), this.m_mod_stamp);
        }

        public void removeAll() {
            super.removeAll();
            this.m_mod_stamp = System.currentTimeMillis();
            GridView.this.updateParentModicationStamps(GridView.this.getParent(), this.m_mod_stamp);
        }

        long getModificationStamp() {
            return this.m_mod_stamp;
        }
    }

    private class ComponentIterator
    implements Iterator {
        private int m_pos = -1;

        private ComponentIterator() {
        }

        public boolean hasNext() {
            for (int i = this.m_pos + 1; i < GridView.this.m_form.getComponentCount(); ++i) {
                Component component = GridView.this.m_form.getComponent(i);
                if (!(component instanceof GridComponent)) continue;
                this.m_pos = i - 1;
                return true;
            }
            return false;
        }

        public Object next() {
            ++this.m_pos;
            while (this.m_pos < GridView.this.m_form.getComponentCount()) {
                Component component = GridView.this.m_form.getComponent(this.m_pos);
                if (!(component instanceof GridComponent)) continue;
                return component;
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

