/*
 * LALXMLVCSInfo.h - LALXML VCS Information Header
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with with program; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 *
 * Copyright (C) 2009-2013 Adam Mercer
 * Copyright (C) 2014 Karl Wette
 */

/** \cond DONT_DOXYGEN */

#ifndef _LALXMLVCSINFOHEADER_H
#define _LALXMLVCSINFOHEADER_H

#include <lal/LALVCSInfoType.h>
#include <lal/LALXMLVCSInfo.h>
#include <lal/LALXMLConfig.h>

#ifdef __cplusplus
extern "C" {
#endif

/* VCS information defines */
#define LALXML_NAME "LALXML"
#define LALXML_VCS_ID "5dccdb192921334191a1fbb2a6b9ee57d7b9d522"
#define LALXML_VCS_DATE "2016-10-10 17:31:35 +0000"
#define LALXML_VCS_BRANCH "None"
#define LALXML_VCS_TAG "lalxml-v1.2.3"
#define LALXML_VCS_AUTHOR "Adam Mercer <adam.mercer@ligo.org>"
#define LALXML_VCS_COMMITTER "Adam Mercer <adam.mercer@ligo.org>"
#define LALXML_VCS_STATUS "CLEAN: All modifications committed"

/* Identable VCS information defines */
#define LALXML_VCS_IDENT_ID "$" "LALXMLId: 5dccdb192921334191a1fbb2a6b9ee57d7b9d522 " "$"
#define LALXML_VCS_IDENT_DATE "$" "LALXMLDate: 2016-10-10 17:31:35 +0000 " "$"
#define LALXML_VCS_IDENT_BRANCH "$" "LALXMLBranch: None " "$"
#define LALXML_VCS_IDENT_TAG "$" "LALXMLTag: lalxml-v1.2.3 " "$"
#define LALXML_VCS_IDENT_AUTHOR "$" "LALXMLAuthor: Adam Mercer <adam.mercer@ligo.org> " "$"
#define LALXML_VCS_IDENT_COMMITTER "$" "LALXMLCommitter: Adam Mercer <adam.mercer@ligo.org> " "$"
#define LALXML_VCS_IDENT_STATUS "$" "LALXMLStatus: CLEAN: All modifications committed " "$"

/* Header VCS information structure */
static const LALVCSInfo lalXMLVCSInfoHeader = { \
  LALXML_NAME, \
  LALXML_VERSION, \
  LALXML_VCS_ID, \
  LALXML_VCS_DATE, \
  LALXML_VCS_BRANCH, \
  LALXML_VCS_TAG, \
  LALXML_VCS_AUTHOR, \
  LALXML_VCS_COMMITTER, \
  LALXML_VCS_STATUS \
};

#ifdef __cplusplus
}
#endif

#endif /* _LALXMLVCSINFOHEADER_H */

/** \endcond */

/*
 * vim: tw=0 ts=2 et
 */
