%define _prefix /usr
%define _mandir %{_prefix}/share/man
%define _sysconfdir %{_prefix}/etc

Name: lalxml
Version: 1.1.16
Release: 1
Summary: LSC Algorithm XML Library
License: GPL
Group: LAL
Source: %{name}-%{version}.tar.gz
URL: https://www.lsc-group.phys.uwm.edu/daswg/projects/lalsuite.html
Packager: Adam Mercer <adam.mercer@ligo.org>
BuildRoot: %{_tmppath}/%{name}-%{version}-root
BuildRequires: swig, python-devel, octave-devel, libxml2-devel, numpy
BuildRequires: lal-devel >= 6.14.0
BuildRequires: lal-python >= 6.14.0
BuildRequires: lal-octave >= 6.14.0
Requires: gsl, libxml2
Requires:lal >= 6.14.0
Prefix: %{_prefix}

%description
The LSC Algorithm XML Library for gravitational wave data analysis. This
package contains the shared-object libraries needed to run applications
that use the LAL XML library.

%package devel
Summary: Files and documentation needed for compiling programs that use LAL XML
Group: LAL
Requires: %{name} = %{version}
Requires: gsl-devel, libxml2-devel
Requires: lal-devel >= 6.14.0
%description devel
The LSC Algorithm XML Library for gravitational wave data analysis. This
package contains files needed build applications that use the LAL XML
library.

%package python
Summary: Python bindings for LALXML
Group: LAL
Requires: %{name} = %{version}
Requires: python, numpy
Requires: lal-python >= 6.14.0
%description python
This package provides the Python bindings for LALXML.

%package octave
Summary: Octave bindings for LALXML
Group: LAL
Requires: %{name} = %{version}
Requires: octave
Requires: lal-octave >= 6.14.0
%description octave
This package provides the Octave bindings for LALXML.

%prep
%setup -q

%build
%configure --disable-gcc-flags --enable-swig
%{__make} V=1

%check
%{__make} V=1 check

%install
%make_install
rm -f $RPM_BUILD_ROOT%{_libdir}/*.la

%post
ldconfig

%postun
ldconfig

%clean
[ ${RPM_BUILD_ROOT} != "/" ] && rm -Rf ${RPM_BUILD_ROOT}
rm -Rf ${RPM_BUILD_DIR}/%{name}-%{version}

%files
%defattr(-,root,root)
%{_libdir}/*.so*
%{_sysconfdir}/*
%{_prefix}/share/lalxml/*

%files devel
%defattr(-,root,root)
%{_libdir}/*.a
%{_libdir}/pkgconfig/*
%{_includedir}/lal

%files python
%defattr(-,root,root)
%{_libdir}/python*/site-packages/lalxml/*.py
%{_libdir}/python*/site-packages/lalxml/*.pyc
%{_libdir}/python*/site-packages/lalxml/_lalxml.so*
%exclude %{_libdir}/python*/site-packages/lalxml/*.pyo

%files octave
%defattr(-,root,root)
%{_libexecdir}/octave/*/site/oct/*/lalxml.oct*
