/*
 * LALXMLVCSInfo.h - LALXML VCS Information Header
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with with program; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 *
 * Copyright (C) 2009-2013 Adam Mercer
 */

#ifndef _LALXMLVCSINFO_H
#define _LALXMLVCSINFO_H

#include <lal/LALVCSInfo.h>
#include <lal/LALXMLLibVCSInfo.h>

#ifdef __cplusplus
extern "C" {
#endif

/* vcs information defines */
#define LALXML_VCS_NAME "LALXML"
#define LALXML_VCS_ID "486e33f1b3fe43575b16acaf180491f1897780a1"
#define LALXML_VCS_DATE "2014-01-07 21:41:48 +0000"
#define LALXML_VCS_BRANCH "None"
#define LALXML_VCS_TAG "lalxml-v1.1.10"
#define LALXML_VCS_AUTHOR "Adam Mercer <adam.mercer@ligo.org>"
#define LALXML_VCS_COMMITTER "Adam Mercer <adam.mercer@ligo.org>"
#define LALXML_VCS_STATUS "CLEAN: All modifications committed"

/* vcs information defines - identable*/
#define LALXML_VCS_IDENT_ID "$" "LALXMLId: 486e33f1b3fe43575b16acaf180491f1897780a1 " "$"
#define LALXML_VCS_IDENT_DATE "$" "LALXMLDate: 2014-01-07 21:41:48 +0000 " "$"
#define LALXML_VCS_IDENT_BRANCH "$" "LALXMLBranch: None " "$"
#define LALXML_VCS_IDENT_TAG "$" "LALXMLTag: lalxml-v1.1.10 " "$"
#define LALXML_VCS_IDENT_AUTHOR "$" "LALXMLAuthor: Adam Mercer <adam.mercer@ligo.org> " "$"
#define LALXML_VCS_IDENT_COMMITTER "$" "LALXMLCommitter: Adam Mercer <adam.mercer@ligo.org> " "$"
#define LALXML_VCS_IDENT_STATUS "$" "LALXMLStatus: CLEAN: All modifications committed " "$"

/* vcs information structures */
static const struct tagLALVCSInfo lalXMLHeaderVCSInfo = { \
  LALXML_VCS_NAME, \
  LALXML_VERSION, \
  LALXML_VCS_ID, \
  LALXML_VCS_DATE, \
  LALXML_VCS_BRANCH, \
  LALXML_VCS_TAG, \
  LALXML_VCS_AUTHOR, \
  LALXML_VCS_COMMITTER, \
  LALXML_VCS_STATUS \
};

#ifdef __cplusplus
}
#endif

#endif /* _LALXMLVCSINFO_H */

/*
 * vim: tw=0 ts=2 et
 */
