%define nightly %{nil}
%define _prefix /usr
%define _mandir %{_prefix}/share/man
%define _sysconfdir %{_prefix}/etc
%define release 1

%if "%{?nightly:%{nightly}}%{!?nightly:0}" == "%{nil}"
%undefine nightly
%endif

Name: lalsimulation
Version: 1.8.1
Release: %{?nightly:0.%{nightly}}%{!?nightly:%{release}}%{?dist}
Summary: LSC Algorithm Simulation Library
License: GPLv2+
Group: LAL
Source: %{name}-%{version}%{?nightly:-%{nightly}}.tar.xz
URL: https://wiki.ligo.org/DASWG/LALSuite
Packager: Adam Mercer <adam.mercer@ligo.org>
BuildRequires: python2-rpm-macros
BuildRequires: gsl-devel
BuildRequires: numpy
BuildRequires: octave-devel
BuildRequires: python-devel
BuildRequires: swig >= 3.0.7
BuildRequires: lal-devel >= 6.19.0
BuildRequires: lal-octave >= 6.19.0
BuildRequires: python2-lal >= 6.19.0
BuildRequires: python-six
Requires: gsl
Requires: lal >= 6.19.0
Prefix: %{_prefix}

%description
The LSC Algorithm Simulation Library for gravitational wave data analysis. This
package contains the shared-object libraries needed to run applications
that use the LAL Simulation library.

%package devel
Summary: Files and documentation needed for compiling programs that use LAL Simulation
Group: LAL
Requires: %{name} = %{version}
Requires: gsl-devel
Requires: lal-devel >= 6.19.0
%description devel
The LSC Algorithm Simulation Library for gravitational wave data analysis. This
package contains files needed build applications that use the LAL Simulation
library.

%package -n python2-%{name}
Summary: Python %{python2_version} bindings for LALSimulation
Group: LAL
Requires: %{name} = %{version}
Requires: numpy
Requires: python
Requires: python2-lal >= 6.19.0
Obsoletes: %{name}-python
Provides: %{name}-python
%description -n python2-%{name}
This package provides the Python %{python2_version} Bindings for LALSimulation.

%package octave
Summary: Octave bindings for LALSimulation
Group: LAL
Requires: %{name} = %{version}
Requires: octave
Requires: lal-octave >= 6.19.0
%description octave
This package provides the Octave Bindings for LALSimulation.

%prep
%setup -q -n %{name}-%{version}%{?nightly:-%{nightly}}

%build
%configure --disable-gcc-flags --enable-swig --enable-openmp
%{__make} %{?_smp_mflags} V=1

%check
%{__make} %{?_smp_mflags} V=1 VERBOSE=1 check

%install
%make_install
find $RPM_BUILD_ROOT%{_libdir} -name '*.la' -delete
%post
ldconfig

%postun
ldconfig

%clean
[ ${RPM_BUILD_ROOT} != "/" ] && rm -Rf ${RPM_BUILD_ROOT}
rm -Rf ${RPM_BUILD_DIR}/%{name}-%{version}%{?nightly:-%{nightly}}

%files
%defattr(-,root,root)
%license COPYING
%{_bindir}/lalsim-*
%{_bindir}/lalsimulation_version
%{_datarootdir}/lalsimulation/LALSimNeutronStarEOS_*
%{_datarootdir}/lalsimulation/LIGO-P1200087*
%{_datarootdir}/lalsimulation/LIGO-P1600143*
%{_datarootdir}/lalsimulation/LIGO-T0900288*
%{_datarootdir}/lalsimulation/LIGO-T1600593*
%{_datarootdir}/lalsimulation/LIGO-T1800042*
%{_datarootdir}/lalsimulation/LIGO-T1800044*
%{_datarootdir}/lalsimulation/LIGO-T1800545*
%{_libdir}/*.so.*
%{_sysconfdir}/*

%files devel
%defattr(-,root,root)
%license COPYING
%{_includedir}/lal
%{_libdir}/*.a
%{_libdir}/*.so
%{_libdir}/pkgconfig/*

%files -n python2-%{name}
%defattr(-,root,root)
%license COPYING
%{python2_sitearch}/*

%files octave
%defattr(-,root,root)
%license COPYING
%{_prefix}/lib*/octave/*/site/oct/*/lalsimulation.oct*

# dates should be formatted using: 'date +"%a %b %d %Y"'
%changelog
* Wed Jan 23 2019 Adam Mercer <adam.mercer@ligo.org> 1.8.1-1
- added noise PSD files from LIGO-T1800545

* Thu Sep 13 2018 Adam Mercer <adam.mercer@ligo.org> 1.8.0-1
- Pre O3 release

* Thu Mar 16 2017 Adam Mercer <adam.mercer@ligo.org> 1.7.3-1
- fix Ldot equation in SpinTaylor

* Wed Mar 01 2017 Adam Mercer <adam.mercer@ligo.org> 1.7.2-1
- fix bug in SpinTaylor, spin precession vector had incorrect sign

* Sat Feb 25 2017 Adam Mercer <adam.mercer@ligo.org> 1.7.1-1
- fix memory leak in SpinTaylor code
- https://bugs.ligo.org/redmine/issues/5182

* Tue Feb 07 2017 Adam Mercer <adam.mercer@ligo.org> 1.7.0-1
- O2 release

* Mon Sep 26 2016 Adam Mercer <adam.mercer@ligo.org> 1.6.1-1
- ER10 release

* Thu Jun 23 2016 Adam Mercer <adam.mercer@ligo.org> 1.6.0-1
- ER9 release

* Fri Mar 25 2016 Adam Mercer <adam.mercer@ligo.org> 1.5.0-1
- Pre O2 packaging test release
