%define _prefix /usr
%define _mandir %{_prefix}/share/man
%define _sysconfdir %{_prefix}/etc

Name: lalmetaio
Version: 1.2.5
Release: 1
Summary: LSC Algorithm MetaIO Library
License: GPL
Group: LAL
Source: %{name}-%{version}.tar.gz
URL: https://www.lsc-group.phys.uwm.edu/daswg/projects/lalsuite.html
Packager: Adam Mercer <adam.mercer@ligo.org>
BuildRoot: %{_tmppath}/%{name}-%{version}-root
BuildRequires: python-devel octave-devel
Requires: libmetaio lal
Prefix: %{_prefix}

%description
The LSC Algorithm MetaIO Library for gravitational wave data analysis. This
package contains the shared-object libraries needed to run applications
that use the LAL MetaIO library.

%package devel
Summary: Files and documentation needed for compiling programs that use LAL MetaIO
Group: LAL
Requires: %{name} = %{version}
Requires: libmetaio-devel lal-devel
%description devel
The LSC Algorithm MetaIO Library for gravitational wave data analysis. This
package contains files needed build applications that use the LAL MetaIO
library.

%package python
Summary: Python Bindings for LALMetaIO
Group: LAL
Requires: %{name} = %{version}
Requires: python numpy lal-python
%description python
The LSC Algorithm Library for gravitational wave data analysis.
This package provides the Python bindings for LALMetaIO.

%package octave
Summary: Octave Bindings for LALMetaIO
Group: LAL
Requires: %{name} = %{version}
Requires: octave lal-octave
%description octave
The LSC Algorithm Library for gravitational wave data analysis.
This package provides the Octave bindings for LALMetaIO.

%prep
%setup -q

%build
%configure --disable-gcc-flags --enable-swig
%{__make} V=1

%install
%make_install
rm -f $RPM_BUILD_ROOT%{_libdir}/*.la

%post
ldconfig

%postun
ldconfig

%clean
[ ${RPM_BUILD_ROOT} != "/" ] && rm -Rf ${RPM_BUILD_ROOT}
rm -Rf ${RPM_BUILD_DIR}/%{name}-%{version}

%files
%defattr(-,root,root)
%{_libdir}/*.so*
%{_sysconfdir}/*

%files devel
%defattr(-,root,root)
%{_libdir}/*.a
%{_libdir}/pkgconfig/*
%{_includedir}/lal

%files python
%defattr(-,root,root)
%{_libdir}/python*/site-packages/lalmetaio/*.py
%{_libdir}/python*/site-packages/lalmetaio/*.pyc
%{_libdir}/python*/site-packages/lalmetaio/_lalmetaio.so*
%exclude %{_libdir}/python*/site-packages/lalmetaio/*.pyo

%files octave
%defattr(-,root,root)
%{_libexecdir}/octave/*/site/oct/*/lalmetaio.oct*

