/*
 * LALInspiralVCSInfo.h - LALInspiral VCS Information Header
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with with program; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 *
 * Copyright (C) 2009-2013 Adam Mercer
 * Copyright (C) 2014 Karl Wette
 */

#ifndef _LALINSPIRALVCSINFOHEADER_H
#define _LALINSPIRALVCSINFOHEADER_H

#include <lal/LALVCSInfoType.h>
#include <lal/LALInspiralVCSInfo.h>
#include <lal/LALInspiralConfig.h>

#ifdef __cplusplus
extern "C" {
#endif

/* vcs information defines */
#define LALINSPIRAL_NAME "LALInspiral"
#define LALINSPIRAL_VCS_ID "dc0d41e936fdc782e9f33bdcda2e5c9a4d0d9ce7"
#define LALINSPIRAL_VCS_DATE "2015-05-19 17:55:23 +0000"
#define LALINSPIRAL_VCS_BRANCH "None"
#define LALINSPIRAL_VCS_TAG "lalinspiral-v1.6.5"
#define LALINSPIRAL_VCS_AUTHOR "Adam Mercer <adam.mercer@ligo.org>"
#define LALINSPIRAL_VCS_COMMITTER "Adam Mercer <adam.mercer@ligo.org>"
#define LALINSPIRAL_VCS_STATUS "CLEAN: All modifications committed"

/* vcs information defines - identable*/
#define LALINSPIRAL_VCS_IDENT_ID "$" "LALInspiralId: dc0d41e936fdc782e9f33bdcda2e5c9a4d0d9ce7 " "$"
#define LALINSPIRAL_VCS_IDENT_DATE "$" "LALInspiralDate: 2015-05-19 17:55:23 +0000 " "$"
#define LALINSPIRAL_VCS_IDENT_BRANCH "$" "LALInspiralBranch: None " "$"
#define LALINSPIRAL_VCS_IDENT_TAG "$" "LALInspiralTag: lalinspiral-v1.6.5 " "$"
#define LALINSPIRAL_VCS_IDENT_AUTHOR "$" "LALInspiralAuthor: Adam Mercer <adam.mercer@ligo.org> " "$"
#define LALINSPIRAL_VCS_IDENT_COMMITTER "$" "LALInspiralCommitter: Adam Mercer <adam.mercer@ligo.org> " "$"
#define LALINSPIRAL_VCS_IDENT_STATUS "$" "LALInspiralStatus: CLEAN: All modifications committed " "$"

/* header vcs information structure */
static const struct tagLALVCSInfo lalInspiralVCSInfoHeader = { \
  LALINSPIRAL_NAME, \
  LALINSPIRAL_VERSION, \
  LALINSPIRAL_VCS_ID, \
  LALINSPIRAL_VCS_DATE, \
  LALINSPIRAL_VCS_BRANCH, \
  LALINSPIRAL_VCS_TAG, \
  LALINSPIRAL_VCS_AUTHOR, \
  LALINSPIRAL_VCS_COMMITTER, \
  LALINSPIRAL_VCS_STATUS \
};

#ifdef __cplusplus
}
#endif

#endif /* _LALINSPIRALVCSINFOHEADER_H */

/*
 * vim: tw=0 ts=2 et
 */
