/*
 * LALInferenceVCSInfo.h - LALInference VCS Information Header
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with with program; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 *
 * Copyright (C) 2009-2013 Adam Mercer
 * Copyright (C) 2014 Karl Wette
 */

/** \cond DONT_DOXYGEN */

#ifndef _LALINFERENCEVCSINFOHEADER_H
#define _LALINFERENCEVCSINFOHEADER_H

#include <lal/LALVCSInfoType.h>
#include <lal/LALInferenceVCSInfo.h>
#include <lal/LALInferenceConfig.h>

#ifdef __cplusplus
extern "C" {
#endif

/* VCS information defines */
#define LALINFERENCE_NAME "LALInference"
#define LALINFERENCE_VCS_ID "3dd62b16f4460de19415ea02a3f8607467f4c89e"
#define LALINFERENCE_VCS_DATE "2016-06-26 21:26:32 +0000"
#define LALINFERENCE_VCS_BRANCH "None"
#define LALINFERENCE_VCS_TAG "lalinference-v1.7.0"
#define LALINFERENCE_VCS_AUTHOR "Adam Mercer <adam.mercer@ligo.org>"
#define LALINFERENCE_VCS_COMMITTER "Adam Mercer <ramercer@gmail.com>"
#define LALINFERENCE_VCS_STATUS "CLEAN: All modifications committed"

/* Identable VCS information defines */
#define LALINFERENCE_VCS_IDENT_ID "$" "LALInferenceId: 3dd62b16f4460de19415ea02a3f8607467f4c89e " "$"
#define LALINFERENCE_VCS_IDENT_DATE "$" "LALInferenceDate: 2016-06-26 21:26:32 +0000 " "$"
#define LALINFERENCE_VCS_IDENT_BRANCH "$" "LALInferenceBranch: None " "$"
#define LALINFERENCE_VCS_IDENT_TAG "$" "LALInferenceTag: lalinference-v1.7.0 " "$"
#define LALINFERENCE_VCS_IDENT_AUTHOR "$" "LALInferenceAuthor: Adam Mercer <adam.mercer@ligo.org> " "$"
#define LALINFERENCE_VCS_IDENT_COMMITTER "$" "LALInferenceCommitter: Adam Mercer <ramercer@gmail.com> " "$"
#define LALINFERENCE_VCS_IDENT_STATUS "$" "LALInferenceStatus: CLEAN: All modifications committed " "$"

/* Header VCS information structure */
static const LALVCSInfo lalInferenceVCSInfoHeader = { \
  LALINFERENCE_NAME, \
  LALINFERENCE_VERSION, \
  LALINFERENCE_VCS_ID, \
  LALINFERENCE_VCS_DATE, \
  LALINFERENCE_VCS_BRANCH, \
  LALINFERENCE_VCS_TAG, \
  LALINFERENCE_VCS_AUTHOR, \
  LALINFERENCE_VCS_COMMITTER, \
  LALINFERENCE_VCS_STATUS \
};

#ifdef __cplusplus
}
#endif

#endif /* _LALINFERENCEVCSINFOHEADER_H */

/** \endcond */

/*
 * vim: tw=0 ts=2 et
 */
