/*
 * LALFrameVCSInfo.h - LALFrame VCS Information Header
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with with program; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 *
 * Copyright (C) 2009-2013 Adam Mercer
 * Copyright (C) 2014 Karl Wette
 */

/** \cond DONT_DOXYGEN */

#ifndef _LALFRAMEVCSINFOHEADER_H
#define _LALFRAMEVCSINFOHEADER_H

#include <lal/LALVCSInfoType.h>
#include <lal/LALFrameVCSInfo.h>
#include <lal/LALFrameConfig.h>

#ifdef __cplusplus
extern "C" {
#endif

/* VCS information defines */
#define LALFRAME_NAME "LALFrame"
#define LALFRAME_VCS_ID "a1664d2de7910a01819d19ba13160d191d4391a4"
#define LALFRAME_VCS_DATE "2016-10-10 17:31:34 +0000"
#define LALFRAME_VCS_BRANCH "None"
#define LALFRAME_VCS_TAG "lalframe-v1.4.2"
#define LALFRAME_VCS_AUTHOR "Adam Mercer <adam.mercer@ligo.org>"
#define LALFRAME_VCS_COMMITTER "Adam Mercer <adam.mercer@ligo.org>"
#define LALFRAME_VCS_STATUS "CLEAN: All modifications committed"

/* Identable VCS information defines */
#define LALFRAME_VCS_IDENT_ID "$" "LALFrameId: a1664d2de7910a01819d19ba13160d191d4391a4 " "$"
#define LALFRAME_VCS_IDENT_DATE "$" "LALFrameDate: 2016-10-10 17:31:34 +0000 " "$"
#define LALFRAME_VCS_IDENT_BRANCH "$" "LALFrameBranch: None " "$"
#define LALFRAME_VCS_IDENT_TAG "$" "LALFrameTag: lalframe-v1.4.2 " "$"
#define LALFRAME_VCS_IDENT_AUTHOR "$" "LALFrameAuthor: Adam Mercer <adam.mercer@ligo.org> " "$"
#define LALFRAME_VCS_IDENT_COMMITTER "$" "LALFrameCommitter: Adam Mercer <adam.mercer@ligo.org> " "$"
#define LALFRAME_VCS_IDENT_STATUS "$" "LALFrameStatus: CLEAN: All modifications committed " "$"

/* Header VCS information structure */
static const LALVCSInfo lalFrameVCSInfoHeader = { \
  LALFRAME_NAME, \
  LALFRAME_VERSION, \
  LALFRAME_VCS_ID, \
  LALFRAME_VCS_DATE, \
  LALFRAME_VCS_BRANCH, \
  LALFRAME_VCS_TAG, \
  LALFRAME_VCS_AUTHOR, \
  LALFRAME_VCS_COMMITTER, \
  LALFRAME_VCS_STATUS \
};

#ifdef __cplusplus
}
#endif

#endif /* _LALFRAMEVCSINFOHEADER_H */

/** \endcond */

/*
 * vim: tw=0 ts=2 et
 */
