%define _prefix /usr
%define _mandir %{_prefix}/share/man
%define _sysconfdir %{_prefix}/etc

Name: lalframe
Version: 1.3.0
Release: 1
Summary: LSC Algorithm Frame Library
License: GPL
Group: LAL
Source: %{name}-%{version}.tar.gz
URL: https://www.lsc-group.phys.uwm.edu/daswg/projects/lalsuite.html
Packager: Adam Mercer <adam.mercer@ligo.org>
BuildRoot: %{_tmppath}/%{name}-%{version}-root
BuildRequires: swig, python-devel, octave-devel, libframe-devel
BuildRequires: ldas-tools-framecppc-devel, numpy
BuildRequires: lal-devel >= 6.15.0
BuildRequires: lal-python >= 6.15.0
BuildRequires: lal-octave >= 6.15.0
Requires: libframe, ldas-tools-framecppc
Requires: lal >= 6.15.0
Prefix: %{_prefix}

%description
The LSC Algorithm Frame Library for gravitational wave data analysis. This
package contains the shared-object libraries needed to run applications
that use the LAL Frame library.

%package devel
Summary: Files and documentation needed for compiling programs that use LAL Frame
Group: LAL
Requires: %{name} = %{version}
Requires: libframe-devel, ldas-tools-framecppc-devel
Requires: lal-devel >= 6.15.0
%description devel
The LSC Algorithm Frame Library for gravitational wave data analysis. This
package contains files needed build applications that use the LAL Frame
library.

%package python
Summary: Python Bindings for LALFrame
Group: LAL
Requires: %{name} = %{version}
Requires: python, numpy
Requires: lal-python >= 6.15.0
%description python
The LSC Algorithm Library for gravitational wave data analysis.
This package provides the Python bindings for LALFrame.

%package octave
Summary: Octave Bindings for LALFrame
Group: LAL
Requires: %{name} = %{version}
Requires: octave
Requires: lal-octave >= 6.15.0
%description octave
The LSC Algorithm Library for gravitational wave data analysis.
This package provides the Octave bindings for LALFrame.

%prep
%setup -q

%build
%configure --disable-gcc-flags --enable-swig
%{__make} V=1

%check
%{__make} V=1 check

%install
%make_install
rm -f $RPM_BUILD_ROOT%{_libdir}/*.la

%post
ldconfig

%postun
ldconfig

%clean
[ ${RPM_BUILD_ROOT} != "/" ] && rm -Rf ${RPM_BUILD_ROOT}
rm -Rf ${RPM_BUILD_DIR}/%{name}-%{version}

%files
%defattr(-,root,root)
%{_libdir}/*.so*
%{_sysconfdir}/*
%{_bindir}/lalfr-*
%{_datadir}/man/man1/*

%files devel
%defattr(-,root,root)
%{_libdir}/*.a
%{_libdir}/pkgconfig/*
%{_includedir}/lal

%files python
%defattr(-,root,root)
%{_libdir}/python*/site-packages/lalframe/*.py
%{_libdir}/python*/site-packages/lalframe/*.pyc
%{_libdir}/python*/site-packages/lalframe/_lalframe.so*
%{_libdir}/python*/site-packages/lalframe/utils/*.py
%{_libdir}/python*/site-packages/lalframe/utils/*.pyc
%exclude %{_libdir}/python*/site-packages/lalframe/*.pyo
%exclude %{_libdir}/python*/site-packages/lalframe/utils/*.pyo

%files octave
%defattr(-,root,root)
%{_libexecdir}/octave/*/site/oct/*/lalframe.oct*
