/*
 * LALFrameVCSInfo.h - LALFrame VCS Information Header
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with with program; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 *
 * Copyright (C) 2009-2013 Adam Mercer
 */

#ifndef _LALFRAMEVCSINFO_H
#define _LALFRAMEVCSINFO_H

#include <lal/LALVCSInfo.h>
#include <lal/LALFrameLibVCSInfo.h>

#ifdef __cplusplus
extern "C" {
#endif

/* vcs information defines */
#define LALFRAME_VCS_NAME "LALFrame"
#define LALFRAME_VCS_ID "1190e9a88ed9f4ab56abc7f0d2b870dcd1a1d8de"
#define LALFRAME_VCS_DATE "2014-01-07 21:41:46 +0000"
#define LALFRAME_VCS_BRANCH "None"
#define LALFRAME_VCS_TAG "lalframe-v1.1.1"
#define LALFRAME_VCS_AUTHOR "Adam Mercer <adam.mercer@ligo.org>"
#define LALFRAME_VCS_COMMITTER "Adam Mercer <adam.mercer@ligo.org>"
#define LALFRAME_VCS_STATUS "CLEAN: All modifications committed"

/* vcs information defines - identable*/
#define LALFRAME_VCS_IDENT_ID "$" "LALFrameId: 1190e9a88ed9f4ab56abc7f0d2b870dcd1a1d8de " "$"
#define LALFRAME_VCS_IDENT_DATE "$" "LALFrameDate: 2014-01-07 21:41:46 +0000 " "$"
#define LALFRAME_VCS_IDENT_BRANCH "$" "LALFrameBranch: None " "$"
#define LALFRAME_VCS_IDENT_TAG "$" "LALFrameTag: lalframe-v1.1.1 " "$"
#define LALFRAME_VCS_IDENT_AUTHOR "$" "LALFrameAuthor: Adam Mercer <adam.mercer@ligo.org> " "$"
#define LALFRAME_VCS_IDENT_COMMITTER "$" "LALFrameCommitter: Adam Mercer <adam.mercer@ligo.org> " "$"
#define LALFRAME_VCS_IDENT_STATUS "$" "LALFrameStatus: CLEAN: All modifications committed " "$"

/* vcs information structures */
static const struct tagLALVCSInfo lalFrameHeaderVCSInfo = { \
  LALFRAME_VCS_NAME, \
  LALFRAME_VERSION, \
  LALFRAME_VCS_ID, \
  LALFRAME_VCS_DATE, \
  LALFRAME_VCS_BRANCH, \
  LALFRAME_VCS_TAG, \
  LALFRAME_VCS_AUTHOR, \
  LALFRAME_VCS_COMMITTER, \
  LALFRAME_VCS_STATUS \
};

#ifdef __cplusplus
}
#endif

#endif /* _LALFRAMEVCSINFO_H */

/*
 * vim: tw=0 ts=2 et
 */
