%define _prefix /usr
%define _mandir %{_prefix}/share/man
%define _sysconfdir %{_prefix}/etc

Name: laldetchar
Version: 0.3.4
Release: 1%{?dist}
Summary: LSC Algorithm DetChar Library
License: GPLv2+
Group: LAL
Source: %{name}-%{version}.tar.xz
URL: http://wiki.ligo.org/DASWG/LALSuite
Packager: Adam Mercer <adam.mercer@ligo.org>
BuildRoot: %{_tmppath}/%{name}-%{version}-root
BuildRequires: glib2-devel
BuildRequires: gsl-devel
BuildRequires: libmetaio-devel
BuildRequires: numpy
BuildRequires: octave-devel
BuildRequires: python-devel
BuildRequires: swig
BuildRequires: lal-devel >= 6.17.0
BuildRequires: lal-python >= 6.17.0
BuildRequires: lal-octave >= 6.17.0
BuildRequires: lalmetaio-devel >= 1.3.0
BuildRequires: lalmetaio-python >= 1.3.0
BuildRequires: lalmetaio-octave >= 1.3.0
BuildRequires: lalsimulation-devel >= 1.6.1
BuildRequires: lalsimulation-python >= 1.6.1
BuildRequires: lalsimulation-octave >= 1.6.1
BuildRequires: lalburst-devel >= 1.4.3
BuildRequires: lalburst-python >= 1.4.3
BuildRequires: lalburst-octave >= 1.4.3
Requires: glib2
Requires: gsl
Requires: libframe
Requires: libmetaio
Requires: lal >= 6.17.0
Requires: lalmetaio >= 1.3.0
Requires: lalsimulation >= 1.6.1
Requires: lalburst >= 1.4.3
Prefix: %{_prefix}

%description
The LSC Algorithm DetChar Library for gravitational wave data analysis. This
package contains the shared-object libraries needed to run applications
that use the LAL DetChar library.

%package devel
Summary: Files and documentation needed for compiling programs that use LAL DetChar
Group: LAL
Requires: %{name} = %{version}
Requires: glib2-devel
Requires: gsl-devel
Requires: libmetaio-devel
Requires: lal-devel >= 6.17.0
Requires: lalmetaio-devel >= 1.3.0
Requires: lalsimulation-devel >= 1.6.1
Requires: lalburst-devel >= 1.4.3
%description devel
The LSC Algorithm DetChar Library for gravitational wave data analysis. This
package contains files needed build applications that use the LAL DetChar
library.

%package python
Summary: Python Bindings for LALDetChar
Group: LAL
Requires: %{name} = %{version}
Requires: numpy
Requires: python
Requires: lal-python >= 6.17.0
Requires: lalmetaio-python >= 1.3.0
Requires: lalsimulation-python >= 1.6.1
Requires: lalburst-python >= 1.4.3
%description python
The LSC Algorithm Library for gravitational wave data analysis.
This package provides the Python bindings for LALDetChar.

%package octave
Summary: Octave Bindings for LALDetChar
Group: LAL
Requires: %{name} = %{version}
Requires: octave
Requires: lal-octave >= 6.17.0
Requires: lalmetaio-octave >= 1.3.0
Requires: lalsimulation-octave >= 1.6.1
Requires: lalburst-octave >= 1.4.3
%description octave
The LSC Algorithm Library for gravitational wave data analysis.
This package provides the Octave bindings for LALDetChar.

%prep
%setup -q

%build
%configure --disable-gcc-flags --enable-swig
%{__make} V=1

%check
%{__make} V=1 check

%install
%make_install
find $RPM_BUILD_ROOT%{_libdir} -name '*.la' -delete

%post
ldconfig

%postun
ldconfig

%clean
[ ${RPM_BUILD_ROOT} != "/" ] && rm -Rf ${RPM_BUILD_ROOT}
rm -Rf ${RPM_BUILD_DIR}/%{name}-%{version}

%files
%defattr(-,root,root)
%{_libdir}/*.so.*
%{_sysconfdir}/*

%files devel
%defattr(-,root,root)
%{_includedir}/lal
%{_libdir}/*.a
%{_libdir}/*.so
%{_libdir}/pkgconfig/*

%files python
%defattr(-,root,root)
%{_bindir}/laldetchar-*
%{_libdir}/python*

%files octave
%defattr(-,root,root)
%{_prefix}/lib*/octave/*/site/oct/*/laldetchar.oct*

# dates should be formatted using: 'date +"%a %b %d %Y"'
%changelog
* Mon Sep 26 2016 Adam Mercer <adam.mercer@ligo.org> 0.3.4-1
- ER10 release

* Thu Jun 23 2016 Adam Mercer <adam.mercer@ligo.org> 0.3.3-1
- ER9 release

* Fri Mar 25 2016 Adam Mercer <adam.mercer@ligo.org> 0.3.2-1
- Pre O2 packaging test release
