/*
 * LALDetCharVCSInfo.h - LALDetChar VCS Information
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with with program; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 *
 * Copyright (C) 2009-2013 Adam Mercer
 * Copyright (C) 2014 Karl Wette
 */

#ifndef _LALDETCHARVCSINFO_H
#define _LALDETCHARVCSINFO_H

#include <lal/LALVCSInfoType.h>

#ifdef __cplusplus
extern "C" {
#endif

/* global variables for vcs information */
extern const char *const lalDetCharVCSVersion;
extern const char *const lalDetCharVCSId;
extern const char *const lalDetCharVCSDate;
extern const char *const lalDetCharVCSBranch;
extern const char *const lalDetCharVCSTag;
extern const char *const lalDetCharVCSAuthor;
extern const char *const lalDetCharVCSCommitter;
extern const char *const lalDetCharVCSStatus;

/* global variables for vcs information - identable */
extern const char *const lalDetCharVCSIdentId;
extern const char *const lalDetCharVCSIdentDate;
extern const char *const lalDetCharVCSIdentBranch;
extern const char *const lalDetCharVCSIdentTag;
extern const char *const lalDetCharVCSIdentAuthor;
extern const char *const lalDetCharVCSIdentCommitter;
extern const char *const lalDetCharVCSIdentStatus;

/* library vcs information structure */
extern const struct tagLALVCSInfo lalDetCharVCSInfo;

/* configure arguments */
extern const char *const lalDetCharConfigureArgs;

/* configure date */
extern const char *const lalDetCharConfigureDate;

/* build date */
extern const char *const lalDetCharBuildDate;

#ifdef __cplusplus
}
#endif

#endif /* _LALDETCHARVCSINFO_H */

/*
 * vim: tw=0 ts=2 et
 */
