%define _prefix /usr
%define _mandir %{_prefix}/share/man
%define _sysconfdir %{_prefix}/etc

Name: laldetchar
Version: 0.3.0
Release: 1
Summary: LSC Algorithm DetChar Library
License: GPL
Group: LAL
Source: %{name}-%{version}.tar.gz
URL: http://www.lsc-group.phys.uwm.edu/lal
Packager: Adam Mercer <adam.mercer@ligo.org>
BuildRoot: %{_tmppath}/%{name}-%{version}-root
BuildRequires: swig, python-devel, octave-devel, gsl-devel, glib2-devel
BuildRequires: libmetaio-devel, numpy
BuildRequires: lal-devel >= 6.14.0
BuildRequires: lal-python >= 6.14.0
BuildRequires: lal-octave >= 6.14.0
BuildRequires: lalframe-devel >= 1.2.0
BuildRequires: lalframe-python >= 1.2.0
BuildRequires: lalframe-octave >= 1.2.0
BuildRequires: lalmetaio-devel >= 1.2.0
BuildRequires: lalmetaio-python >= 1.2.0
BuildRequires: lalmetaio-octave >= 1.2.0
BuildRequires: lalsimulation-devel >= 1.3.0
BuildRequires: lalsimulation-python >= 1.3.0
BuildRequires: lalsimulation-octave >= 1.3.0
BuildRequires: lalburst-devel >= 1.3.0
BuildRequires: lalburst-python >= 1.3.0
BuildRequires: lalburst-octave >= 1.3.0
Requires: gsl, libframe, libmetaio
Requires: lal >= 6.14.0
Requires: lalframe >= 1.2.0
Requires: lalmetaio >= 1.2.0
Requires: lalsimulation >= 1.3.0
Requires: lalburst >= 1.3.0
Prefix: %{_prefix}

%description
The LSC Algorithm DetChar Library for gravitational wave data analysis. This
package contains the shared-object libraries needed to run applications
that use the LAL DetChar library.

%package devel
Summary: Files and documentation needed for compiling programs that use LAL DetChar
Group: LAL
Requires: %{name} = %{version}
Requires: gsl-devel, glib2-devel, libmetaio-devel
Requires: lal-devel >= 6.14.0
Requires: lalmetaio-devel >= 1.2.0
Requires: lalsimulation-devel >= 1.3.0
Requires: lalburst-devel >= 1.3.0
%description devel
The LSC Algorithm DetChar Library for gravitational wave data analysis. This
package contains files needed build applications that use the LAL DetChar
library.

%package python
Summary: Python Bindings for LALDetChar
Group: LAL
Requires: %{name} = %{version}
Requires: python, numpy
Requires: lal-python >= 6.14.0
Requires: lalmetaio-python >= 1.2.0
Requires: lalsimulation-python >= 1.3.0
Requires: lalburst-python >= 1.3.0
%description python
The LSC Algorithm Library for gravitational wave data analysis.
This package provides the Python bindings for LALDetChar.

%package octave
Summary: Octave Bindings for LALDetChar
Group: LAL
Requires: %{name} = %{version}
Requires: octave
Requires: lal-octave >= 6.14.0
Requires: lalmetaio-octave >= 1.2.0
Requires: lalsimulation-octave >= 1.3.0
Requires: lalburst-octave >= 1.3.0
%description octave
The LSC Algorithm Library for gravitational wave data analysis.
This package provides the Octave bindings for LALDetChar.

%prep
%setup -q

%build
%configure --disable-gcc-flags --enable-swig
%{__make} V=1

%check
%{__make} V=1 check

%install
%make_install
rm -f $RPM_BUILD_ROOT%{_libdir}/*.la

%post
ldconfig

%postun
ldconfig

%clean
[ ${RPM_BUILD_ROOT} != "/" ] && rm -Rf ${RPM_BUILD_ROOT}
rm -Rf ${RPM_BUILD_DIR}/%{name}-%{version}

%files
%defattr(-,root,root)
%{_libdir}/*.so*
%{_sysconfdir}/*

%files devel
%defattr(-,root,root)
%{_libdir}/*.a
%{_libdir}/pkgconfig/*
%{_includedir}/lal

%files python
%defattr(-,root,root)
%{_bindir}/laldetchar-*
%{_libdir}/python*/site-packages/laldetchar/*.py
%{_libdir}/python*/site-packages/laldetchar/*.pyc
%{_libdir}/python*/site-packages/laldetchar/_laldetchar.so*
%{_libdir}/python*/site-packages/laldetchar/idq/*.py
%{_libdir}/python*/site-packages/laldetchar/idq/*.pyc
%{_libdir}/python*/site-packages/laldetchar/hveto/*.py
%{_libdir}/python*/site-packages/laldetchar/hveto/*.pyc
%{_libdir}/python*/site-packages/laldetchar/triggers/*.py
%{_libdir}/python*/site-packages/laldetchar/triggers/*.pyc
%exclude %{_libdir}/python*/site-packages/laldetchar/*.pyo
%exclude %{_libdir}/python*/site-packages/laldetchar/idq/*.pyo
%exclude %{_libdir}/python*/site-packages/laldetchar/hveto/*.pyo
%exclude %{_libdir}/python*/site-packages/laldetchar/triggers/*.pyo

%files octave
%defattr(-,root,root)
%{_libexecdir}/octave/*/site/oct/*/laldetchar.oct*
