/*
 * LALBurstVCSInfo.h - LALBurst VCS Information Header
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with with program; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 *
 * Copyright (C) 2009-2013 Adam Mercer
 * Copyright (C) 2014 Karl Wette
 */

/** \cond DONT_DOXYGEN */

#ifndef _LALBURSTVCSINFOHEADER_H
#define _LALBURSTVCSINFOHEADER_H

#include <lal/LALVCSInfoType.h>
#include <lal/LALBurstVCSInfo.h>
#include <lal/LALBurstConfig.h>

#ifdef __cplusplus
extern "C" {
#endif

/* VCS information defines */
#define LALBURST_NAME "LALBurst"
#define LALBURST_VCS_ID "e46e9b24827265ded75f7005ddf5f8190d1c7096"
#define LALBURST_VCS_DATE "2016-06-26 21:26:32 +0000"
#define LALBURST_VCS_BRANCH "None"
#define LALBURST_VCS_TAG "lalburst-v1.4.2"
#define LALBURST_VCS_AUTHOR "Adam Mercer <adam.mercer@ligo.org>"
#define LALBURST_VCS_COMMITTER "Adam Mercer <ramercer@gmail.com>"
#define LALBURST_VCS_STATUS "CLEAN: All modifications committed"

/* Identable VCS information defines */
#define LALBURST_VCS_IDENT_ID "$" "LALBurstId: e46e9b24827265ded75f7005ddf5f8190d1c7096 " "$"
#define LALBURST_VCS_IDENT_DATE "$" "LALBurstDate: 2016-06-26 21:26:32 +0000 " "$"
#define LALBURST_VCS_IDENT_BRANCH "$" "LALBurstBranch: None " "$"
#define LALBURST_VCS_IDENT_TAG "$" "LALBurstTag: lalburst-v1.4.2 " "$"
#define LALBURST_VCS_IDENT_AUTHOR "$" "LALBurstAuthor: Adam Mercer <adam.mercer@ligo.org> " "$"
#define LALBURST_VCS_IDENT_COMMITTER "$" "LALBurstCommitter: Adam Mercer <ramercer@gmail.com> " "$"
#define LALBURST_VCS_IDENT_STATUS "$" "LALBurstStatus: CLEAN: All modifications committed " "$"

/* Header VCS information structure */
static const LALVCSInfo lalBurstVCSInfoHeader = { \
  LALBURST_NAME, \
  LALBURST_VERSION, \
  LALBURST_VCS_ID, \
  LALBURST_VCS_DATE, \
  LALBURST_VCS_BRANCH, \
  LALBURST_VCS_TAG, \
  LALBURST_VCS_AUTHOR, \
  LALBURST_VCS_COMMITTER, \
  LALBURST_VCS_STATUS \
};

#ifdef __cplusplus
}
#endif

#endif /* _LALBURSTVCSINFOHEADER_H */

/** \endcond */

/*
 * vim: tw=0 ts=2 et
 */
