/*
 * LALBurstVCSInfo.h - LALBurst VCS Information Header
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with with program; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 *
 * Copyright (C) 2009-2013 Adam Mercer
 * Copyright (C) 2014 Karl Wette
 */

#ifndef _LALBURSTVCSINFOHEADER_H
#define _LALBURSTVCSINFOHEADER_H

#include <lal/LALVCSInfoType.h>
#include <lal/LALBurstVCSInfo.h>
#include <lal/LALBurstConfig.h>

#ifdef __cplusplus
extern "C" {
#endif

/* vcs information defines */
#define LALBURST_NAME "LALBurst"
#define LALBURST_VCS_ID "851b3494deb17c0f42a9c12c7b116ae081f5be61"
#define LALBURST_VCS_DATE "2015-08-3 22:14:26 +0000"
#define LALBURST_VCS_BRANCH "None"
#define LALBURST_VCS_TAG "lalburst-v1.4.0"
#define LALBURST_VCS_AUTHOR "Adam Mercer <adam.mercer@ligo.org>"
#define LALBURST_VCS_COMMITTER "Adam Mercer <adam.mercer@ligo.org>"
#define LALBURST_VCS_STATUS "CLEAN: All modifications committed"

/* vcs information defines - identable*/
#define LALBURST_VCS_IDENT_ID "$" "LALBurstId: 851b3494deb17c0f42a9c12c7b116ae081f5be61 " "$"
#define LALBURST_VCS_IDENT_DATE "$" "LALBurstDate: 2015-08-3 22:14:26 +0000 " "$"
#define LALBURST_VCS_IDENT_BRANCH "$" "LALBurstBranch: None " "$"
#define LALBURST_VCS_IDENT_TAG "$" "LALBurstTag: lalburst-v1.4.0 " "$"
#define LALBURST_VCS_IDENT_AUTHOR "$" "LALBurstAuthor: Adam Mercer <adam.mercer@ligo.org> " "$"
#define LALBURST_VCS_IDENT_COMMITTER "$" "LALBurstCommitter: Adam Mercer <adam.mercer@ligo.org> " "$"
#define LALBURST_VCS_IDENT_STATUS "$" "LALBurstStatus: CLEAN: All modifications committed " "$"

/* header vcs information structure */
static const struct tagLALVCSInfo lalBurstVCSInfoHeader = { \
  LALBURST_NAME, \
  LALBURST_VERSION, \
  LALBURST_VCS_ID, \
  LALBURST_VCS_DATE, \
  LALBURST_VCS_BRANCH, \
  LALBURST_VCS_TAG, \
  LALBURST_VCS_AUTHOR, \
  LALBURST_VCS_COMMITTER, \
  LALBURST_VCS_STATUS \
};

#ifdef __cplusplus
}
#endif

#endif /* _LALBURSTVCSINFOHEADER_H */

/*
 * vim: tw=0 ts=2 et
 */
