/*
 * LALBurstVCSInfo.h - LALBurst VCS Information Header
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with with program; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 *
 * Copyright (C) 2009-2013 Adam Mercer
 */

#ifndef _LALBURSTVCSINFO_H
#define _LALBURSTVCSINFO_H

#include <lal/LALVCSInfo.h>
#include <lal/LALBurstLibVCSInfo.h>

#ifdef __cplusplus
extern "C" {
#endif

/* vcs information defines */
#define LALBURST_VCS_NAME "LALBurst"
#define LALBURST_VCS_ID "deb14f07370aa85f17f495d26a2976750c1baef4"
#define LALBURST_VCS_DATE "2014-01-07 21:41:51 +0000"
#define LALBURST_VCS_BRANCH "None"
#define LALBURST_VCS_TAG "lalburst-v1.2.2"
#define LALBURST_VCS_AUTHOR "Adam Mercer <adam.mercer@ligo.org>"
#define LALBURST_VCS_COMMITTER "Adam Mercer <adam.mercer@ligo.org>"
#define LALBURST_VCS_STATUS "CLEAN: All modifications committed"

/* vcs information defines - identable*/
#define LALBURST_VCS_IDENT_ID "$" "LALBurstId: deb14f07370aa85f17f495d26a2976750c1baef4 " "$"
#define LALBURST_VCS_IDENT_DATE "$" "LALBurstDate: 2014-01-07 21:41:51 +0000 " "$"
#define LALBURST_VCS_IDENT_BRANCH "$" "LALBurstBranch: None " "$"
#define LALBURST_VCS_IDENT_TAG "$" "LALBurstTag: lalburst-v1.2.2 " "$"
#define LALBURST_VCS_IDENT_AUTHOR "$" "LALBurstAuthor: Adam Mercer <adam.mercer@ligo.org> " "$"
#define LALBURST_VCS_IDENT_COMMITTER "$" "LALBurstCommitter: Adam Mercer <adam.mercer@ligo.org> " "$"
#define LALBURST_VCS_IDENT_STATUS "$" "LALBurstStatus: CLEAN: All modifications committed " "$"

/* vcs information structures */
static const struct tagLALVCSInfo lalBurstHeaderVCSInfo = { \
  LALBURST_VCS_NAME, \
  LALBURST_VERSION, \
  LALBURST_VCS_ID, \
  LALBURST_VCS_DATE, \
  LALBURST_VCS_BRANCH, \
  LALBURST_VCS_TAG, \
  LALBURST_VCS_AUTHOR, \
  LALBURST_VCS_COMMITTER, \
  LALBURST_VCS_STATUS \
};

#ifdef __cplusplus
}
#endif

#endif /* _LALBURSTVCSINFO_H */

/*
 * vim: tw=0 ts=2 et
 */
