/*
 * LALAppsVCSInfo.h - LALApps VCS Information Header
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with with program; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 *
 * Copyright (C) 2009-2013 Adam Mercer
 * Copyright (C) 2014 Karl Wette
 */

/** \cond DONT_DOXYGEN */

#ifndef _LALAPPSVCSINFOHEADER_H
#define _LALAPPSVCSINFOHEADER_H

#include <lal/LALVCSInfoType.h>
#include <LALAppsVCSInfo.h>
#include <config.h>

#ifdef __cplusplus
extern "C" {
#endif

/* VCS information defines */
#define LALAPPS_NAME "LALApps"
#define LALAPPS_VCS_ID "6c73f0c9d565841e343bedb55f412531b52ec2ac"
#define LALAPPS_VCS_DATE "2016-10-10 17:31:35 +0000"
#define LALAPPS_VCS_BRANCH "None"
#define LALAPPS_VCS_TAG "lalapps-v6.20.0"
#define LALAPPS_VCS_AUTHOR "Adam Mercer <adam.mercer@ligo.org>"
#define LALAPPS_VCS_COMMITTER "Adam Mercer <adam.mercer@ligo.org>"
#define LALAPPS_VCS_STATUS "CLEAN: All modifications committed"

/* Identable VCS information defines */
#define LALAPPS_VCS_IDENT_ID "$" "LALAppsId: 6c73f0c9d565841e343bedb55f412531b52ec2ac " "$"
#define LALAPPS_VCS_IDENT_DATE "$" "LALAppsDate: 2016-10-10 17:31:35 +0000 " "$"
#define LALAPPS_VCS_IDENT_BRANCH "$" "LALAppsBranch: None " "$"
#define LALAPPS_VCS_IDENT_TAG "$" "LALAppsTag: lalapps-v6.20.0 " "$"
#define LALAPPS_VCS_IDENT_AUTHOR "$" "LALAppsAuthor: Adam Mercer <adam.mercer@ligo.org> " "$"
#define LALAPPS_VCS_IDENT_COMMITTER "$" "LALAppsCommitter: Adam Mercer <adam.mercer@ligo.org> " "$"
#define LALAPPS_VCS_IDENT_STATUS "$" "LALAppsStatus: CLEAN: All modifications committed " "$"

/* Header VCS information structure */
static const LALVCSInfo lalAppsVCSInfoHeader = { \
  LALAPPS_NAME, \
  LALAPPS_VERSION, \
  LALAPPS_VCS_ID, \
  LALAPPS_VCS_DATE, \
  LALAPPS_VCS_BRANCH, \
  LALAPPS_VCS_TAG, \
  LALAPPS_VCS_AUTHOR, \
  LALAPPS_VCS_COMMITTER, \
  LALAPPS_VCS_STATUS \
};

#ifdef __cplusplus
}
#endif

#endif /* _LALAPPSVCSINFOHEADER_H */

/** \endcond */

/*
 * vim: tw=0 ts=2 et
 */
