/*
  File autogenerated by gengetopt version 2.22.4
  generated with the following command:
  gengetopt --string-parser --conf-parser --show-required=[required]

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef FIX_UNUSED
#define FIX_UNUSED(X) (void) (X) /* avoid warnings for unused params */
#endif

#include <getopt.h>

#include "cmdline.h"

const char *gengetopt_args_info_purpose = "TwoSpect analysis program";

const char *gengetopt_args_info_usage = "Usage: lalapps_TwoSpect [OPTIONS]...";

const char *gengetopt_args_info_description = "";

const char *gengetopt_args_info_full_help[] = {
  "  -h, --help                    Print help and exit",
  "      --full-help               Print help, including hidden options, and exit",
  "  -V, --version                 Print version and exit",
  "      --config=filename         Configuration file in gengetopt format for \n                                  passing parameters",
  "  -d, --laldebug=INT            LAL debug level  (default=`0')",
  "\nObservational parameters:",
  "      --Tobs=DOUBLE             Total observation time (in seconds) [required]",
  "      --Tcoh=DOUBLE             SFT coherence time (in seconds) [required]",
  "      --SFToverlap=DOUBLE       SFT overlap (in seconds), usually Tcoh/2 \n                                  [required]",
  "      --t0=DOUBLE               Start time of the search (in GPS seconds) \n                                  [required]",
  "      --fmin=DOUBLE             Minimum frequency of band (Hz) [required]",
  "      --fspan=DOUBLE            Frequency span of band (Hz) [required]",
  "      --IFO=IFO code            Interferometer of whose data is being analyzed  \n                                  (possible values=\"H1\", \"L1\", \"V1\") \n                                  [required]",
  "      --avesqrtSh=DOUBLE        Expected average of square root of Sh \n                                  [required]",
  "      --blksize=INT             Blocksize for running median to determine \n                                  expected noise of input SFTs  (default=`101')",
  "      --sftType=STRING          SFT type of either 'standard' (v2 SFTs; FFT \n                                  coefficients * dt/RMS(window weights)) or \n                                  'vladimir' (Vladimir's Hann windowed SFT \n                                  version; FFT coefficients * 2*dt)  (possible \n                                  values=\"standard\", \"vladimir\" \n                                  default=`standard')",
  "\nInput/ouput parameters:",
  "      --outdirectory=directory  Output directory  (default=`output')",
  "      --outfilename=filename    Output file name  (default=`logfile.txt')",
  "      --configCopy=filename     Copy of the configuration file whose output is \n                                  gengetopt format  \n                                  (default=`input_values.conf')",
  "      --ULfilename=filename     Upper limit file name  (default=`uls.dat')",
  "      --normRMSoutput=filename  File for the output of the normalized RMS from \n                                  the non-slided data",
  "      --sftDir=path             Directory containing SFTs, e.g., /path/to/file \n                                  (conflicts with --sftFile/--timestampsFile)",
  "      --sftFile=path/filename   Path and filename of SFTs, e.g., \n                                  /path/to/file/sftdata.sft (one of \n                                  --sftDir/--timestampsFile)",
  "      --ephemDir=directory      Path to ephemeris files, e.g. \n                                  /path/to/ephemeris/files [required]",
  "      --ephemYear=STRING        Year or year range (e.g. 08-11) of ephemeris \n                                  files [required]",
  "\nTwoSpect search parameters:",
  "      --Pmin=DOUBLE             Minimum period to be searched (in seconds) \n                                  [required]",
  "      --Pmax=DOUBLE             Maximum period to be searched (in seconds) \n                                  [required]",
  "      --dfmin=DOUBLE            Minimum modulation depth to search (Hz) \n                                  [required]",
  "      --dfmax=DOUBLE            Maximum modulation depth to search (Hz) \n                                  [required]",
  "      --skyRegion=STRING        Region of the sky to search (e.g. \n                                  (ra1,dec1),(ra2,dec2),(ra3,dec3)...) or \n                                  allsky",
  "      --skyRegionFile=filename  File with the grid points",
  "      --linPolAngle=DOUBLE      Polarization angle to search using linear \n                                  polarization (when unspecified default is \n                                  circular polarization",
  "      --harmonicNumToSearch=INT Number of harmonics of the Pmin to Pmax range \n                                  to search  (default=`1')",
  "      --templateSearch          Flag for doing a pure template-based search on \n                                  search region specified by \n                                  (sky,f,fspan,hardcoded P, hardcoded asini)  \n                                  (default=off)",
  "\nTwoSpect threshold settings:",
  "      --ihsfactor=INT           Number of harmonics to sum in IHS algorithm  \n                                  (default=`5')",
  "      --ihsfar=DOUBLE           IHS FAR threshold",
  "      --ihsfom=DOUBLE           IHS FOM = 12*(L_IHS_loc - U_IHS_loc)^2",
  "      --ihsfomfar=DOUBLE        IHS FOM FAR threshold",
  "      --keepOnlyTopNumIHS=INT   Keep the top <number> of IHS candidates based \n                                  on significance",
  "      --tmplfar=DOUBLE          Template FAR threshold",
  "      --minTemplateLength=INT   Maximum number of pixels to use in the template \n                                   (default=`1')",
  "      --maxTemplateLength=INT   Maximum number of pixels to use in the template \n                                   (default=`1000')",
  "\nTwoSpect upper limit ranges:",
  "      --ULfmin=DOUBLE           Minimum signal frequency considered for the \n                                  upper limit value (Hz)",
  "      --ULfspan=DOUBLE          Span of signal frequencies considered for the \n                                  upper limit value (Hz)",
  "      --ULminimumDeltaf=DOUBLE  Minimum modulation depth counted in the upper \n                                  limit value (Hz)",
  "      --ULmaximumDeltaf=DOUBLE  Maximum modulation depth counted in the upper \n                                  limit value (Hz)",
  "      --allULvalsPerSkyLoc      Print all UL values in the band specified by \n                                  ULminimumDeltaf and ULmaximumDeltaf (default \n                                  is to print only the maximum UL value in the \n                                  band)  (default=off)",
  "\nSelf-detection of bad interferometer performance:",
  "      --markBadSFTs             Mark bad SFTs  (default=off)",
  "      --simpleBandRejection=DOUBLE\n                                Produce upper limits for each band, but if \n                                  second FFT plane std. dev. exceeds threshold \n                                  given here, don't follow up any IHS \n                                  candidates",
  "      --lineDetection=DOUBLE    Detect stationary lines above threshold, and, \n                                  if any present, set upper limit only, no \n                                  template follow-up",
  "\nTwoSpect performance options:",
  "      --FFTplanFlag=INT         0=Estimate, 1=Measure, 2=Patient, 3=Exhaustive  \n                                  (possible values=\"0\", \"1\", \"2\", \"3\" \n                                  default=`1')",
  "      --fastchisqinv            Use a faster central chi-sq inversion function \n                                  (roughly float precision instead of double)  \n                                  (default=off)",
  "      --useSSE                  Use SSE functions (caution: user needs to have \n                                  compiled for SSE or program fails)  \n                                  (default=off)",
  "      --followUpOutsideULrange  Follow up outliers outside the range of the UL \n                                  values  (default=off)",
  "\nInjection options:",
  "      --timestampsFile=path/filename\n                                File to read timestamps from (file-format: \n                                  lines with <seconds> <nanoseconds>; conflicts \n                                  with --sftDir/--sftFile options)",
  "      --injectionSources=@path/filename\n                                File containing sources to inject with a \n                                  required preceding @ symbol",
  "      --injRandSeed=INT         Random seed value for reproducable noise \n                                  (conflicts with --sftDir/--sftFile options)  \n                                  (default=`0')",
  "\nHidden options:",
  "      --weightedIHS             Use the noise-weighted IHS scheme  \n                                  (default=off)",
  "      --signalOnly              SFTs contain only signal, no noise  \n                                  (default=off)",
  "      --templateTest            Test the doubly-Fourier transformed data \n                                  against a single, exact template  \n                                  (default=off)",
  "      --templateTestF=DOUBLE    The template test frequency; templateTest flag \n                                  is required",
  "      --templateTestP=DOUBLE    The template test period; templateTest flag is \n                                  required",
  "      --templateTestDf=DOUBLE   The template test modulation depth; \n                                  templateTest flag is required",
  "      --ULsolver=INT            Solver function for the upper limit \n                                  calculation: \n                                  0=gsl_ncx2cdf_float_withouttinyprob_solver, \n                                  1=gsl_ncx2cdf_withouttinyprob_solver, \n                                  2=gsl_ncx2cdf_float_solver, \n                                  3=gsl_ncx2cdf_solver, \n                                  4=ncx2cdf_float_withouttinyprob_withmatlabchi2cdf_solver, \n                                  5=ncx2cdf_withouttinyprob_withmatlabchi2cdf_solver \n                                   (possible values=\"0\", \"1\", \"2\", \"3\", \n                                  \"4\", \"5\" default=`0')",
  "      --dopplerMultiplier=DOUBLE\n                                Multiplier for the Doppler velocity  \n                                  (default=`1.0')",
  "      --IHSonly                 IHS stage only is run. Output statistic is the \n                                  IHS statistic.  (default=off)",
  "      --noNotchHarmonics        Do not notch the daily/sidereal harmonics in \n                                  the IHS step.  (default=off)",
  "      --calcRthreshold          Calculate the threshold value for R given the \n                                  template false alarm rate  (default=off)",
  "      --BrentsMethod            Use Brent's method in the root finding \n                                  algorithm.  (default=off)",
  "      --antennaOff              Antenna pattern weights are /NOT/ used if this \n                                  flag is used  (default=off)",
  "      --noiseWeightOff          Turn off noise weighting if this flag is used  \n                                  (default=off)",
  "      --gaussTemplatesOnly      Gaussian templates only throughout the pipeline \n                                  if this flag is used  (default=off)",
  "      --periodHarmToCheck=INT   Number of harmonics/sub-harmonics of the IHS \n                                  candidates to test  (default=`5')",
  "      --periodFracToCheck=INT   Number of fractional periods to check in the \n                                  sense of [(1...N)+1]/[(1...N)+2]  \n                                  (default=`3')",
  "      --ULoff                   Turn off upper limits computation  \n                                  (default=off)",
  "      --printSFTtimes           Output a list <GPS sec> <GPS nanosec> of SFT \n                                  start times of input SFTs  (default=off)",
  "      --printUsedSFTtimes       Output a list <GPS sec> <GPS nanosec> of SFT \n                                  start times of the SFTs passing tests  \n                                  (default=off)",
  "      --printData               Print to ASCII files the data values  \n                                  (default=off)",
  "      --printUninitialized=INT  Print uninitialized values in TFdata_weighted \n                                  and TSofPowers vectors at n-th sky location \n                                  specified by option (if not enough sky \n                                  locations exist, then these vectors don't get \n                                  printed!)",
  "      --printSignalData         Print f0 and h0 per SFT of the signal, used \n                                  only with --injectionSources option  \n                                  (default=off)",
  "      --randSeed=INT            Random seed value",
  "      --chooseSeed              The random seed value is chosen based on the \n                                  input search parameters  (default=off)",
    0
};

static void
init_help_array(void)
{
  gengetopt_args_info_help[0] = gengetopt_args_info_full_help[0];
  gengetopt_args_info_help[1] = gengetopt_args_info_full_help[1];
  gengetopt_args_info_help[2] = gengetopt_args_info_full_help[2];
  gengetopt_args_info_help[3] = gengetopt_args_info_full_help[3];
  gengetopt_args_info_help[4] = gengetopt_args_info_full_help[4];
  gengetopt_args_info_help[5] = gengetopt_args_info_full_help[5];
  gengetopt_args_info_help[6] = gengetopt_args_info_full_help[6];
  gengetopt_args_info_help[7] = gengetopt_args_info_full_help[7];
  gengetopt_args_info_help[8] = gengetopt_args_info_full_help[8];
  gengetopt_args_info_help[9] = gengetopt_args_info_full_help[9];
  gengetopt_args_info_help[10] = gengetopt_args_info_full_help[10];
  gengetopt_args_info_help[11] = gengetopt_args_info_full_help[11];
  gengetopt_args_info_help[12] = gengetopt_args_info_full_help[12];
  gengetopt_args_info_help[13] = gengetopt_args_info_full_help[13];
  gengetopt_args_info_help[14] = gengetopt_args_info_full_help[14];
  gengetopt_args_info_help[15] = gengetopt_args_info_full_help[15];
  gengetopt_args_info_help[16] = gengetopt_args_info_full_help[16];
  gengetopt_args_info_help[17] = gengetopt_args_info_full_help[17];
  gengetopt_args_info_help[18] = gengetopt_args_info_full_help[18];
  gengetopt_args_info_help[19] = gengetopt_args_info_full_help[19];
  gengetopt_args_info_help[20] = gengetopt_args_info_full_help[20];
  gengetopt_args_info_help[21] = gengetopt_args_info_full_help[21];
  gengetopt_args_info_help[22] = gengetopt_args_info_full_help[22];
  gengetopt_args_info_help[23] = gengetopt_args_info_full_help[23];
  gengetopt_args_info_help[24] = gengetopt_args_info_full_help[24];
  gengetopt_args_info_help[25] = gengetopt_args_info_full_help[25];
  gengetopt_args_info_help[26] = gengetopt_args_info_full_help[26];
  gengetopt_args_info_help[27] = gengetopt_args_info_full_help[27];
  gengetopt_args_info_help[28] = gengetopt_args_info_full_help[28];
  gengetopt_args_info_help[29] = gengetopt_args_info_full_help[29];
  gengetopt_args_info_help[30] = gengetopt_args_info_full_help[30];
  gengetopt_args_info_help[31] = gengetopt_args_info_full_help[31];
  gengetopt_args_info_help[32] = gengetopt_args_info_full_help[32];
  gengetopt_args_info_help[33] = gengetopt_args_info_full_help[33];
  gengetopt_args_info_help[34] = gengetopt_args_info_full_help[34];
  gengetopt_args_info_help[35] = gengetopt_args_info_full_help[35];
  gengetopt_args_info_help[36] = gengetopt_args_info_full_help[36];
  gengetopt_args_info_help[37] = gengetopt_args_info_full_help[37];
  gengetopt_args_info_help[38] = gengetopt_args_info_full_help[38];
  gengetopt_args_info_help[39] = gengetopt_args_info_full_help[39];
  gengetopt_args_info_help[40] = gengetopt_args_info_full_help[40];
  gengetopt_args_info_help[41] = gengetopt_args_info_full_help[41];
  gengetopt_args_info_help[42] = gengetopt_args_info_full_help[42];
  gengetopt_args_info_help[43] = gengetopt_args_info_full_help[43];
  gengetopt_args_info_help[44] = gengetopt_args_info_full_help[44];
  gengetopt_args_info_help[45] = gengetopt_args_info_full_help[45];
  gengetopt_args_info_help[46] = gengetopt_args_info_full_help[46];
  gengetopt_args_info_help[47] = gengetopt_args_info_full_help[47];
  gengetopt_args_info_help[48] = gengetopt_args_info_full_help[48];
  gengetopt_args_info_help[49] = gengetopt_args_info_full_help[49];
  gengetopt_args_info_help[50] = gengetopt_args_info_full_help[50];
  gengetopt_args_info_help[51] = gengetopt_args_info_full_help[51];
  gengetopt_args_info_help[52] = gengetopt_args_info_full_help[52];
  gengetopt_args_info_help[53] = gengetopt_args_info_full_help[53];
  gengetopt_args_info_help[54] = gengetopt_args_info_full_help[54];
  gengetopt_args_info_help[55] = gengetopt_args_info_full_help[55];
  gengetopt_args_info_help[56] = gengetopt_args_info_full_help[56];
  gengetopt_args_info_help[57] = gengetopt_args_info_full_help[57];
  gengetopt_args_info_help[58] = gengetopt_args_info_full_help[58];
  gengetopt_args_info_help[59] = gengetopt_args_info_full_help[59];
  gengetopt_args_info_help[60] = gengetopt_args_info_full_help[60];
  gengetopt_args_info_help[61] = gengetopt_args_info_full_help[61];
  gengetopt_args_info_help[62] = gengetopt_args_info_full_help[62];
  gengetopt_args_info_help[63] = gengetopt_args_info_full_help[63];
  gengetopt_args_info_help[64] = 0; 
  
}

const char *gengetopt_args_info_help[65];

typedef enum {ARG_NO
  , ARG_FLAG
  , ARG_STRING
  , ARG_INT
  , ARG_DOUBLE
} cmdline_parser_arg_type;

static
void clear_given (struct gengetopt_args_info *args_info);
static
void clear_args (struct gengetopt_args_info *args_info);

static int
cmdline_parser_internal (int argc, char **argv, struct gengetopt_args_info *args_info,
                        struct cmdline_parser_params *params, const char *additional_error);

static int
cmdline_parser_required2 (struct gengetopt_args_info *args_info, const char *prog_name, const char *additional_error);
struct line_list
{
  char * string_arg;
  struct line_list * next;
};

static struct line_list *cmd_line_list = 0;
static struct line_list *cmd_line_list_tmp = 0;

static void
free_cmd_list(void)
{
  /* free the list of a previous call */
  if (cmd_line_list)
    {
      while (cmd_line_list) {
        cmd_line_list_tmp = cmd_line_list;
        cmd_line_list = cmd_line_list->next;
        free (cmd_line_list_tmp->string_arg);
        free (cmd_line_list_tmp);
      }
    }
}


const char *cmdline_parser_IFO_values[] = {"H1", "L1", "V1", 0}; /*< Possible values for IFO. */
const char *cmdline_parser_sftType_values[] = {"standard", "vladimir", 0}; /*< Possible values for sftType. */
const char *cmdline_parser_FFTplanFlag_values[] = {"0", "1", "2", "3", 0}; /*< Possible values for FFTplanFlag. */
const char *cmdline_parser_ULsolver_values[] = {"0", "1", "2", "3", "4", "5", 0}; /*< Possible values for ULsolver. */

static char *
gengetopt_strdup (const char *s);

static
void clear_given (struct gengetopt_args_info *args_info)
{
  args_info->help_given = 0 ;
  args_info->full_help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->config_given = 0 ;
  args_info->laldebug_given = 0 ;
  args_info->Tobs_given = 0 ;
  args_info->Tcoh_given = 0 ;
  args_info->SFToverlap_given = 0 ;
  args_info->t0_given = 0 ;
  args_info->fmin_given = 0 ;
  args_info->fspan_given = 0 ;
  args_info->IFO_given = 0 ;
  args_info->avesqrtSh_given = 0 ;
  args_info->blksize_given = 0 ;
  args_info->sftType_given = 0 ;
  args_info->outdirectory_given = 0 ;
  args_info->outfilename_given = 0 ;
  args_info->configCopy_given = 0 ;
  args_info->ULfilename_given = 0 ;
  args_info->normRMSoutput_given = 0 ;
  args_info->sftDir_given = 0 ;
  args_info->sftFile_given = 0 ;
  args_info->ephemDir_given = 0 ;
  args_info->ephemYear_given = 0 ;
  args_info->Pmin_given = 0 ;
  args_info->Pmax_given = 0 ;
  args_info->dfmin_given = 0 ;
  args_info->dfmax_given = 0 ;
  args_info->skyRegion_given = 0 ;
  args_info->skyRegionFile_given = 0 ;
  args_info->linPolAngle_given = 0 ;
  args_info->harmonicNumToSearch_given = 0 ;
  args_info->templateSearch_given = 0 ;
  args_info->ihsfactor_given = 0 ;
  args_info->ihsfar_given = 0 ;
  args_info->ihsfom_given = 0 ;
  args_info->ihsfomfar_given = 0 ;
  args_info->keepOnlyTopNumIHS_given = 0 ;
  args_info->tmplfar_given = 0 ;
  args_info->minTemplateLength_given = 0 ;
  args_info->maxTemplateLength_given = 0 ;
  args_info->ULfmin_given = 0 ;
  args_info->ULfspan_given = 0 ;
  args_info->ULminimumDeltaf_given = 0 ;
  args_info->ULmaximumDeltaf_given = 0 ;
  args_info->allULvalsPerSkyLoc_given = 0 ;
  args_info->markBadSFTs_given = 0 ;
  args_info->simpleBandRejection_given = 0 ;
  args_info->lineDetection_given = 0 ;
  args_info->FFTplanFlag_given = 0 ;
  args_info->fastchisqinv_given = 0 ;
  args_info->useSSE_given = 0 ;
  args_info->followUpOutsideULrange_given = 0 ;
  args_info->timestampsFile_given = 0 ;
  args_info->injectionSources_given = 0 ;
  args_info->injRandSeed_given = 0 ;
  args_info->weightedIHS_given = 0 ;
  args_info->signalOnly_given = 0 ;
  args_info->templateTest_given = 0 ;
  args_info->templateTestF_given = 0 ;
  args_info->templateTestP_given = 0 ;
  args_info->templateTestDf_given = 0 ;
  args_info->ULsolver_given = 0 ;
  args_info->dopplerMultiplier_given = 0 ;
  args_info->IHSonly_given = 0 ;
  args_info->noNotchHarmonics_given = 0 ;
  args_info->calcRthreshold_given = 0 ;
  args_info->BrentsMethod_given = 0 ;
  args_info->antennaOff_given = 0 ;
  args_info->noiseWeightOff_given = 0 ;
  args_info->gaussTemplatesOnly_given = 0 ;
  args_info->periodHarmToCheck_given = 0 ;
  args_info->periodFracToCheck_given = 0 ;
  args_info->ULoff_given = 0 ;
  args_info->printSFTtimes_given = 0 ;
  args_info->printUsedSFTtimes_given = 0 ;
  args_info->printData_given = 0 ;
  args_info->printUninitialized_given = 0 ;
  args_info->printSignalData_given = 0 ;
  args_info->randSeed_given = 0 ;
  args_info->chooseSeed_given = 0 ;
}

static
void clear_args (struct gengetopt_args_info *args_info)
{
  FIX_UNUSED (args_info);
  args_info->config_arg = NULL;
  args_info->config_orig = NULL;
  args_info->laldebug_arg = 0;
  args_info->laldebug_orig = NULL;
  args_info->Tobs_orig = NULL;
  args_info->Tcoh_orig = NULL;
  args_info->SFToverlap_orig = NULL;
  args_info->t0_orig = NULL;
  args_info->fmin_orig = NULL;
  args_info->fspan_orig = NULL;
  args_info->IFO_arg = NULL;
  args_info->IFO_orig = NULL;
  args_info->avesqrtSh_orig = NULL;
  args_info->blksize_arg = 101;
  args_info->blksize_orig = NULL;
  args_info->sftType_arg = gengetopt_strdup ("standard");
  args_info->sftType_orig = NULL;
  args_info->outdirectory_arg = gengetopt_strdup ("output");
  args_info->outdirectory_orig = NULL;
  args_info->outfilename_arg = gengetopt_strdup ("logfile.txt");
  args_info->outfilename_orig = NULL;
  args_info->configCopy_arg = gengetopt_strdup ("input_values.conf");
  args_info->configCopy_orig = NULL;
  args_info->ULfilename_arg = gengetopt_strdup ("uls.dat");
  args_info->ULfilename_orig = NULL;
  args_info->normRMSoutput_arg = NULL;
  args_info->normRMSoutput_orig = NULL;
  args_info->sftDir_arg = NULL;
  args_info->sftDir_orig = NULL;
  args_info->sftFile_arg = NULL;
  args_info->sftFile_orig = NULL;
  args_info->ephemDir_arg = NULL;
  args_info->ephemDir_orig = NULL;
  args_info->ephemYear_arg = NULL;
  args_info->ephemYear_orig = NULL;
  args_info->Pmin_orig = NULL;
  args_info->Pmax_orig = NULL;
  args_info->dfmin_orig = NULL;
  args_info->dfmax_orig = NULL;
  args_info->skyRegion_arg = NULL;
  args_info->skyRegion_orig = NULL;
  args_info->skyRegionFile_arg = NULL;
  args_info->skyRegionFile_orig = NULL;
  args_info->linPolAngle_orig = NULL;
  args_info->harmonicNumToSearch_arg = 1;
  args_info->harmonicNumToSearch_orig = NULL;
  args_info->templateSearch_flag = 0;
  args_info->ihsfactor_arg = 5;
  args_info->ihsfactor_orig = NULL;
  args_info->ihsfar_orig = NULL;
  args_info->ihsfom_orig = NULL;
  args_info->ihsfomfar_orig = NULL;
  args_info->keepOnlyTopNumIHS_orig = NULL;
  args_info->tmplfar_orig = NULL;
  args_info->minTemplateLength_arg = 1;
  args_info->minTemplateLength_orig = NULL;
  args_info->maxTemplateLength_arg = 1000;
  args_info->maxTemplateLength_orig = NULL;
  args_info->ULfmin_orig = NULL;
  args_info->ULfspan_orig = NULL;
  args_info->ULminimumDeltaf_orig = NULL;
  args_info->ULmaximumDeltaf_orig = NULL;
  args_info->allULvalsPerSkyLoc_flag = 0;
  args_info->markBadSFTs_flag = 0;
  args_info->simpleBandRejection_orig = NULL;
  args_info->lineDetection_orig = NULL;
  args_info->FFTplanFlag_arg = 1;
  args_info->FFTplanFlag_orig = NULL;
  args_info->fastchisqinv_flag = 0;
  args_info->useSSE_flag = 0;
  args_info->followUpOutsideULrange_flag = 0;
  args_info->timestampsFile_arg = NULL;
  args_info->timestampsFile_orig = NULL;
  args_info->injectionSources_arg = NULL;
  args_info->injectionSources_orig = NULL;
  args_info->injRandSeed_arg = 0;
  args_info->injRandSeed_orig = NULL;
  args_info->weightedIHS_flag = 0;
  args_info->signalOnly_flag = 0;
  args_info->templateTest_flag = 0;
  args_info->templateTestF_orig = NULL;
  args_info->templateTestP_orig = NULL;
  args_info->templateTestDf_orig = NULL;
  args_info->ULsolver_arg = 0;
  args_info->ULsolver_orig = NULL;
  args_info->dopplerMultiplier_arg = 1.0;
  args_info->dopplerMultiplier_orig = NULL;
  args_info->IHSonly_flag = 0;
  args_info->noNotchHarmonics_flag = 0;
  args_info->calcRthreshold_flag = 0;
  args_info->BrentsMethod_flag = 0;
  args_info->antennaOff_flag = 0;
  args_info->noiseWeightOff_flag = 0;
  args_info->gaussTemplatesOnly_flag = 0;
  args_info->periodHarmToCheck_arg = 5;
  args_info->periodHarmToCheck_orig = NULL;
  args_info->periodFracToCheck_arg = 3;
  args_info->periodFracToCheck_orig = NULL;
  args_info->ULoff_flag = 0;
  args_info->printSFTtimes_flag = 0;
  args_info->printUsedSFTtimes_flag = 0;
  args_info->printData_flag = 0;
  args_info->printUninitialized_orig = NULL;
  args_info->printSignalData_flag = 0;
  args_info->randSeed_orig = NULL;
  args_info->chooseSeed_flag = 0;
  
}

static
void init_args_info(struct gengetopt_args_info *args_info)
{

  init_help_array(); 
  args_info->help_help = gengetopt_args_info_full_help[0] ;
  args_info->full_help_help = gengetopt_args_info_full_help[1] ;
  args_info->version_help = gengetopt_args_info_full_help[2] ;
  args_info->config_help = gengetopt_args_info_full_help[3] ;
  args_info->laldebug_help = gengetopt_args_info_full_help[4] ;
  args_info->Tobs_help = gengetopt_args_info_full_help[6] ;
  args_info->Tcoh_help = gengetopt_args_info_full_help[7] ;
  args_info->SFToverlap_help = gengetopt_args_info_full_help[8] ;
  args_info->t0_help = gengetopt_args_info_full_help[9] ;
  args_info->fmin_help = gengetopt_args_info_full_help[10] ;
  args_info->fspan_help = gengetopt_args_info_full_help[11] ;
  args_info->IFO_help = gengetopt_args_info_full_help[12] ;
  args_info->IFO_min = 1;
  args_info->IFO_max = 1;
  args_info->avesqrtSh_help = gengetopt_args_info_full_help[13] ;
  args_info->blksize_help = gengetopt_args_info_full_help[14] ;
  args_info->sftType_help = gengetopt_args_info_full_help[15] ;
  args_info->outdirectory_help = gengetopt_args_info_full_help[17] ;
  args_info->outfilename_help = gengetopt_args_info_full_help[18] ;
  args_info->configCopy_help = gengetopt_args_info_full_help[19] ;
  args_info->ULfilename_help = gengetopt_args_info_full_help[20] ;
  args_info->normRMSoutput_help = gengetopt_args_info_full_help[21] ;
  args_info->sftDir_help = gengetopt_args_info_full_help[22] ;
  args_info->sftFile_help = gengetopt_args_info_full_help[23] ;
  args_info->ephemDir_help = gengetopt_args_info_full_help[24] ;
  args_info->ephemYear_help = gengetopt_args_info_full_help[25] ;
  args_info->Pmin_help = gengetopt_args_info_full_help[27] ;
  args_info->Pmax_help = gengetopt_args_info_full_help[28] ;
  args_info->dfmin_help = gengetopt_args_info_full_help[29] ;
  args_info->dfmax_help = gengetopt_args_info_full_help[30] ;
  args_info->skyRegion_help = gengetopt_args_info_full_help[31] ;
  args_info->skyRegionFile_help = gengetopt_args_info_full_help[32] ;
  args_info->linPolAngle_help = gengetopt_args_info_full_help[33] ;
  args_info->harmonicNumToSearch_help = gengetopt_args_info_full_help[34] ;
  args_info->templateSearch_help = gengetopt_args_info_full_help[35] ;
  args_info->ihsfactor_help = gengetopt_args_info_full_help[37] ;
  args_info->ihsfar_help = gengetopt_args_info_full_help[38] ;
  args_info->ihsfom_help = gengetopt_args_info_full_help[39] ;
  args_info->ihsfomfar_help = gengetopt_args_info_full_help[40] ;
  args_info->keepOnlyTopNumIHS_help = gengetopt_args_info_full_help[41] ;
  args_info->tmplfar_help = gengetopt_args_info_full_help[42] ;
  args_info->minTemplateLength_help = gengetopt_args_info_full_help[43] ;
  args_info->maxTemplateLength_help = gengetopt_args_info_full_help[44] ;
  args_info->ULfmin_help = gengetopt_args_info_full_help[46] ;
  args_info->ULfspan_help = gengetopt_args_info_full_help[47] ;
  args_info->ULminimumDeltaf_help = gengetopt_args_info_full_help[48] ;
  args_info->ULmaximumDeltaf_help = gengetopt_args_info_full_help[49] ;
  args_info->allULvalsPerSkyLoc_help = gengetopt_args_info_full_help[50] ;
  args_info->markBadSFTs_help = gengetopt_args_info_full_help[52] ;
  args_info->simpleBandRejection_help = gengetopt_args_info_full_help[53] ;
  args_info->lineDetection_help = gengetopt_args_info_full_help[54] ;
  args_info->FFTplanFlag_help = gengetopt_args_info_full_help[56] ;
  args_info->fastchisqinv_help = gengetopt_args_info_full_help[57] ;
  args_info->useSSE_help = gengetopt_args_info_full_help[58] ;
  args_info->followUpOutsideULrange_help = gengetopt_args_info_full_help[59] ;
  args_info->timestampsFile_help = gengetopt_args_info_full_help[61] ;
  args_info->injectionSources_help = gengetopt_args_info_full_help[62] ;
  args_info->injRandSeed_help = gengetopt_args_info_full_help[63] ;
  args_info->weightedIHS_help = gengetopt_args_info_full_help[65] ;
  args_info->signalOnly_help = gengetopt_args_info_full_help[66] ;
  args_info->templateTest_help = gengetopt_args_info_full_help[67] ;
  args_info->templateTestF_help = gengetopt_args_info_full_help[68] ;
  args_info->templateTestP_help = gengetopt_args_info_full_help[69] ;
  args_info->templateTestDf_help = gengetopt_args_info_full_help[70] ;
  args_info->ULsolver_help = gengetopt_args_info_full_help[71] ;
  args_info->dopplerMultiplier_help = gengetopt_args_info_full_help[72] ;
  args_info->IHSonly_help = gengetopt_args_info_full_help[73] ;
  args_info->noNotchHarmonics_help = gengetopt_args_info_full_help[74] ;
  args_info->calcRthreshold_help = gengetopt_args_info_full_help[75] ;
  args_info->BrentsMethod_help = gengetopt_args_info_full_help[76] ;
  args_info->antennaOff_help = gengetopt_args_info_full_help[77] ;
  args_info->noiseWeightOff_help = gengetopt_args_info_full_help[78] ;
  args_info->gaussTemplatesOnly_help = gengetopt_args_info_full_help[79] ;
  args_info->periodHarmToCheck_help = gengetopt_args_info_full_help[80] ;
  args_info->periodFracToCheck_help = gengetopt_args_info_full_help[81] ;
  args_info->ULoff_help = gengetopt_args_info_full_help[82] ;
  args_info->printSFTtimes_help = gengetopt_args_info_full_help[83] ;
  args_info->printUsedSFTtimes_help = gengetopt_args_info_full_help[84] ;
  args_info->printData_help = gengetopt_args_info_full_help[85] ;
  args_info->printUninitialized_help = gengetopt_args_info_full_help[86] ;
  args_info->printSignalData_help = gengetopt_args_info_full_help[87] ;
  args_info->randSeed_help = gengetopt_args_info_full_help[88] ;
  args_info->chooseSeed_help = gengetopt_args_info_full_help[89] ;
  
}

void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n",
     (strlen(CMDLINE_PARSER_PACKAGE_NAME) ? CMDLINE_PARSER_PACKAGE_NAME : CMDLINE_PARSER_PACKAGE),
     CMDLINE_PARSER_VERSION);
}

static void print_help_common(void) {
  cmdline_parser_print_version ();

  if (strlen(gengetopt_args_info_purpose) > 0)
    printf("\n%s\n", gengetopt_args_info_purpose);

  if (strlen(gengetopt_args_info_usage) > 0)
    printf("\n%s\n", gengetopt_args_info_usage);

  printf("\n");

  if (strlen(gengetopt_args_info_description) > 0)
    printf("%s\n\n", gengetopt_args_info_description);
}

void
cmdline_parser_print_help (void)
{
  int i = 0;
  print_help_common();
  while (gengetopt_args_info_help[i])
    printf("%s\n", gengetopt_args_info_help[i++]);
}

void
cmdline_parser_print_full_help (void)
{
  int i = 0;
  print_help_common();
  while (gengetopt_args_info_full_help[i])
    printf("%s\n", gengetopt_args_info_full_help[i++]);
}

void
cmdline_parser_init (struct gengetopt_args_info *args_info)
{
  clear_given (args_info);
  clear_args (args_info);
  init_args_info (args_info);
}

void
cmdline_parser_params_init(struct cmdline_parser_params *params)
{
  if (params)
    { 
      params->override = 0;
      params->initialize = 1;
      params->check_required = 1;
      params->check_ambiguity = 0;
      params->print_errors = 1;
    }
}

struct cmdline_parser_params *
cmdline_parser_params_create(void)
{
  struct cmdline_parser_params *params = 
    (struct cmdline_parser_params *)malloc(sizeof(struct cmdline_parser_params));
  cmdline_parser_params_init(params);  
  return params;
}

static void
free_string_field (char **s)
{
  if (*s)
    {
      free (*s);
      *s = 0;
    }
}

/** @brief generic value variable */
union generic_value {
    int int_arg;
    double double_arg;
    char *string_arg;
    const char *default_string_arg;
};

/** @brief holds temporary values for multiple options */
struct generic_list
{
  union generic_value arg;
  char *orig;
  struct generic_list *next;
};

/**
 * @brief add a node at the head of the list 
 */
static void add_node(struct generic_list **list) {
  struct generic_list *new_node = (struct generic_list *) malloc (sizeof (struct generic_list));
  new_node->next = *list;
  *list = new_node;
  new_node->arg.string_arg = 0;
  new_node->orig = 0;
}


static void
free_multiple_string_field(unsigned int len, char ***arg, char ***orig)
{
  unsigned int i;
  if (*arg) {
    for (i = 0; i < len; ++i)
      {
        free_string_field(&((*arg)[i]));
        free_string_field(&((*orig)[i]));
      }
    free_string_field(&((*arg)[0])); /* free default string */

    free (*arg);
    *arg = 0;
    free (*orig);
    *orig = 0;
  }
}

static void
cmdline_parser_release (struct gengetopt_args_info *args_info)
{

  free_string_field (&(args_info->config_arg));
  free_string_field (&(args_info->config_orig));
  free_string_field (&(args_info->laldebug_orig));
  free_string_field (&(args_info->Tobs_orig));
  free_string_field (&(args_info->Tcoh_orig));
  free_string_field (&(args_info->SFToverlap_orig));
  free_string_field (&(args_info->t0_orig));
  free_string_field (&(args_info->fmin_orig));
  free_string_field (&(args_info->fspan_orig));
  free_multiple_string_field (args_info->IFO_given, &(args_info->IFO_arg), &(args_info->IFO_orig));
  free_string_field (&(args_info->avesqrtSh_orig));
  free_string_field (&(args_info->blksize_orig));
  free_string_field (&(args_info->sftType_arg));
  free_string_field (&(args_info->sftType_orig));
  free_string_field (&(args_info->outdirectory_arg));
  free_string_field (&(args_info->outdirectory_orig));
  free_string_field (&(args_info->outfilename_arg));
  free_string_field (&(args_info->outfilename_orig));
  free_string_field (&(args_info->configCopy_arg));
  free_string_field (&(args_info->configCopy_orig));
  free_string_field (&(args_info->ULfilename_arg));
  free_string_field (&(args_info->ULfilename_orig));
  free_string_field (&(args_info->normRMSoutput_arg));
  free_string_field (&(args_info->normRMSoutput_orig));
  free_string_field (&(args_info->sftDir_arg));
  free_string_field (&(args_info->sftDir_orig));
  free_string_field (&(args_info->sftFile_arg));
  free_string_field (&(args_info->sftFile_orig));
  free_string_field (&(args_info->ephemDir_arg));
  free_string_field (&(args_info->ephemDir_orig));
  free_string_field (&(args_info->ephemYear_arg));
  free_string_field (&(args_info->ephemYear_orig));
  free_string_field (&(args_info->Pmin_orig));
  free_string_field (&(args_info->Pmax_orig));
  free_string_field (&(args_info->dfmin_orig));
  free_string_field (&(args_info->dfmax_orig));
  free_string_field (&(args_info->skyRegion_arg));
  free_string_field (&(args_info->skyRegion_orig));
  free_string_field (&(args_info->skyRegionFile_arg));
  free_string_field (&(args_info->skyRegionFile_orig));
  free_string_field (&(args_info->linPolAngle_orig));
  free_string_field (&(args_info->harmonicNumToSearch_orig));
  free_string_field (&(args_info->ihsfactor_orig));
  free_string_field (&(args_info->ihsfar_orig));
  free_string_field (&(args_info->ihsfom_orig));
  free_string_field (&(args_info->ihsfomfar_orig));
  free_string_field (&(args_info->keepOnlyTopNumIHS_orig));
  free_string_field (&(args_info->tmplfar_orig));
  free_string_field (&(args_info->minTemplateLength_orig));
  free_string_field (&(args_info->maxTemplateLength_orig));
  free_string_field (&(args_info->ULfmin_orig));
  free_string_field (&(args_info->ULfspan_orig));
  free_string_field (&(args_info->ULminimumDeltaf_orig));
  free_string_field (&(args_info->ULmaximumDeltaf_orig));
  free_string_field (&(args_info->simpleBandRejection_orig));
  free_string_field (&(args_info->lineDetection_orig));
  free_string_field (&(args_info->FFTplanFlag_orig));
  free_string_field (&(args_info->timestampsFile_arg));
  free_string_field (&(args_info->timestampsFile_orig));
  free_string_field (&(args_info->injectionSources_arg));
  free_string_field (&(args_info->injectionSources_orig));
  free_string_field (&(args_info->injRandSeed_orig));
  free_string_field (&(args_info->templateTestF_orig));
  free_string_field (&(args_info->templateTestP_orig));
  free_string_field (&(args_info->templateTestDf_orig));
  free_string_field (&(args_info->ULsolver_orig));
  free_string_field (&(args_info->dopplerMultiplier_orig));
  free_string_field (&(args_info->periodHarmToCheck_orig));
  free_string_field (&(args_info->periodFracToCheck_orig));
  free_string_field (&(args_info->printUninitialized_orig));
  free_string_field (&(args_info->randSeed_orig));
  
  

  clear_given (args_info);
}

/**
 * @param val the value to check
 * @param values the possible values
 * @return the index of the matched value:
 * -1 if no value matched,
 * -2 if more than one value has matched
 */
static int
check_possible_values(const char *val, const char *values[])
{
  int i, found, last;
  size_t len;

  if (!val)   /* otherwise strlen() crashes below */
    return -1; /* -1 means no argument for the option */

  found = last = 0;

  for (i = 0, len = strlen(val); values[i]; ++i)
    {
      if (strncmp(val, values[i], len) == 0)
        {
          ++found;
          last = i;
          if (strlen(values[i]) == len)
            return i; /* exact macth no need to check more */
        }
    }

  if (found == 1) /* one match: OK */
    return last;

  return (found ? -2 : -1); /* return many values or none matched */
}


static void
write_into_file(FILE *outfile, const char *opt, const char *arg, const char *values[])
{
  int found = -1;
  if (arg) {
    if (values) {
      found = check_possible_values(arg, values);      
    }
    if (found >= 0)
      fprintf(outfile, "%s=\"%s\" # %s\n", opt, arg, values[found]);
    else
      fprintf(outfile, "%s=\"%s\"\n", opt, arg);
  } else {
    fprintf(outfile, "%s\n", opt);
  }
}

static void
write_multiple_into_file(FILE *outfile, int len, const char *opt, char **arg, const char *values[])
{
  int i;
  
  for (i = 0; i < len; ++i)
    write_into_file(outfile, opt, (arg ? arg[i] : 0), values);
}

int
cmdline_parser_dump(FILE *outfile, struct gengetopt_args_info *args_info)
{
  int i = 0;

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot dump options to stream\n", CMDLINE_PARSER_PACKAGE);
      return EXIT_FAILURE;
    }

  if (args_info->help_given)
    write_into_file(outfile, "help", 0, 0 );
  if (args_info->full_help_given)
    write_into_file(outfile, "full-help", 0, 0 );
  if (args_info->version_given)
    write_into_file(outfile, "version", 0, 0 );
  if (args_info->config_given)
    write_into_file(outfile, "config", args_info->config_orig, 0);
  if (args_info->laldebug_given)
    write_into_file(outfile, "laldebug", args_info->laldebug_orig, 0);
  if (args_info->Tobs_given)
    write_into_file(outfile, "Tobs", args_info->Tobs_orig, 0);
  if (args_info->Tcoh_given)
    write_into_file(outfile, "Tcoh", args_info->Tcoh_orig, 0);
  if (args_info->SFToverlap_given)
    write_into_file(outfile, "SFToverlap", args_info->SFToverlap_orig, 0);
  if (args_info->t0_given)
    write_into_file(outfile, "t0", args_info->t0_orig, 0);
  if (args_info->fmin_given)
    write_into_file(outfile, "fmin", args_info->fmin_orig, 0);
  if (args_info->fspan_given)
    write_into_file(outfile, "fspan", args_info->fspan_orig, 0);
  write_multiple_into_file(outfile, args_info->IFO_given, "IFO", args_info->IFO_orig, cmdline_parser_IFO_values);
  if (args_info->avesqrtSh_given)
    write_into_file(outfile, "avesqrtSh", args_info->avesqrtSh_orig, 0);
  if (args_info->blksize_given)
    write_into_file(outfile, "blksize", args_info->blksize_orig, 0);
  if (args_info->sftType_given)
    write_into_file(outfile, "sftType", args_info->sftType_orig, cmdline_parser_sftType_values);
  if (args_info->outdirectory_given)
    write_into_file(outfile, "outdirectory", args_info->outdirectory_orig, 0);
  if (args_info->outfilename_given)
    write_into_file(outfile, "outfilename", args_info->outfilename_orig, 0);
  if (args_info->configCopy_given)
    write_into_file(outfile, "configCopy", args_info->configCopy_orig, 0);
  if (args_info->ULfilename_given)
    write_into_file(outfile, "ULfilename", args_info->ULfilename_orig, 0);
  if (args_info->normRMSoutput_given)
    write_into_file(outfile, "normRMSoutput", args_info->normRMSoutput_orig, 0);
  if (args_info->sftDir_given)
    write_into_file(outfile, "sftDir", args_info->sftDir_orig, 0);
  if (args_info->sftFile_given)
    write_into_file(outfile, "sftFile", args_info->sftFile_orig, 0);
  if (args_info->ephemDir_given)
    write_into_file(outfile, "ephemDir", args_info->ephemDir_orig, 0);
  if (args_info->ephemYear_given)
    write_into_file(outfile, "ephemYear", args_info->ephemYear_orig, 0);
  if (args_info->Pmin_given)
    write_into_file(outfile, "Pmin", args_info->Pmin_orig, 0);
  if (args_info->Pmax_given)
    write_into_file(outfile, "Pmax", args_info->Pmax_orig, 0);
  if (args_info->dfmin_given)
    write_into_file(outfile, "dfmin", args_info->dfmin_orig, 0);
  if (args_info->dfmax_given)
    write_into_file(outfile, "dfmax", args_info->dfmax_orig, 0);
  if (args_info->skyRegion_given)
    write_into_file(outfile, "skyRegion", args_info->skyRegion_orig, 0);
  if (args_info->skyRegionFile_given)
    write_into_file(outfile, "skyRegionFile", args_info->skyRegionFile_orig, 0);
  if (args_info->linPolAngle_given)
    write_into_file(outfile, "linPolAngle", args_info->linPolAngle_orig, 0);
  if (args_info->harmonicNumToSearch_given)
    write_into_file(outfile, "harmonicNumToSearch", args_info->harmonicNumToSearch_orig, 0);
  if (args_info->templateSearch_given)
    write_into_file(outfile, "templateSearch", 0, 0 );
  if (args_info->ihsfactor_given)
    write_into_file(outfile, "ihsfactor", args_info->ihsfactor_orig, 0);
  if (args_info->ihsfar_given)
    write_into_file(outfile, "ihsfar", args_info->ihsfar_orig, 0);
  if (args_info->ihsfom_given)
    write_into_file(outfile, "ihsfom", args_info->ihsfom_orig, 0);
  if (args_info->ihsfomfar_given)
    write_into_file(outfile, "ihsfomfar", args_info->ihsfomfar_orig, 0);
  if (args_info->keepOnlyTopNumIHS_given)
    write_into_file(outfile, "keepOnlyTopNumIHS", args_info->keepOnlyTopNumIHS_orig, 0);
  if (args_info->tmplfar_given)
    write_into_file(outfile, "tmplfar", args_info->tmplfar_orig, 0);
  if (args_info->minTemplateLength_given)
    write_into_file(outfile, "minTemplateLength", args_info->minTemplateLength_orig, 0);
  if (args_info->maxTemplateLength_given)
    write_into_file(outfile, "maxTemplateLength", args_info->maxTemplateLength_orig, 0);
  if (args_info->ULfmin_given)
    write_into_file(outfile, "ULfmin", args_info->ULfmin_orig, 0);
  if (args_info->ULfspan_given)
    write_into_file(outfile, "ULfspan", args_info->ULfspan_orig, 0);
  if (args_info->ULminimumDeltaf_given)
    write_into_file(outfile, "ULminimumDeltaf", args_info->ULminimumDeltaf_orig, 0);
  if (args_info->ULmaximumDeltaf_given)
    write_into_file(outfile, "ULmaximumDeltaf", args_info->ULmaximumDeltaf_orig, 0);
  if (args_info->allULvalsPerSkyLoc_given)
    write_into_file(outfile, "allULvalsPerSkyLoc", 0, 0 );
  if (args_info->markBadSFTs_given)
    write_into_file(outfile, "markBadSFTs", 0, 0 );
  if (args_info->simpleBandRejection_given)
    write_into_file(outfile, "simpleBandRejection", args_info->simpleBandRejection_orig, 0);
  if (args_info->lineDetection_given)
    write_into_file(outfile, "lineDetection", args_info->lineDetection_orig, 0);
  if (args_info->FFTplanFlag_given)
    write_into_file(outfile, "FFTplanFlag", args_info->FFTplanFlag_orig, cmdline_parser_FFTplanFlag_values);
  if (args_info->fastchisqinv_given)
    write_into_file(outfile, "fastchisqinv", 0, 0 );
  if (args_info->useSSE_given)
    write_into_file(outfile, "useSSE", 0, 0 );
  if (args_info->followUpOutsideULrange_given)
    write_into_file(outfile, "followUpOutsideULrange", 0, 0 );
  if (args_info->timestampsFile_given)
    write_into_file(outfile, "timestampsFile", args_info->timestampsFile_orig, 0);
  if (args_info->injectionSources_given)
    write_into_file(outfile, "injectionSources", args_info->injectionSources_orig, 0);
  if (args_info->injRandSeed_given)
    write_into_file(outfile, "injRandSeed", args_info->injRandSeed_orig, 0);
  if (args_info->weightedIHS_given)
    write_into_file(outfile, "weightedIHS", 0, 0 );
  if (args_info->signalOnly_given)
    write_into_file(outfile, "signalOnly", 0, 0 );
  if (args_info->templateTest_given)
    write_into_file(outfile, "templateTest", 0, 0 );
  if (args_info->templateTestF_given)
    write_into_file(outfile, "templateTestF", args_info->templateTestF_orig, 0);
  if (args_info->templateTestP_given)
    write_into_file(outfile, "templateTestP", args_info->templateTestP_orig, 0);
  if (args_info->templateTestDf_given)
    write_into_file(outfile, "templateTestDf", args_info->templateTestDf_orig, 0);
  if (args_info->ULsolver_given)
    write_into_file(outfile, "ULsolver", args_info->ULsolver_orig, cmdline_parser_ULsolver_values);
  if (args_info->dopplerMultiplier_given)
    write_into_file(outfile, "dopplerMultiplier", args_info->dopplerMultiplier_orig, 0);
  if (args_info->IHSonly_given)
    write_into_file(outfile, "IHSonly", 0, 0 );
  if (args_info->noNotchHarmonics_given)
    write_into_file(outfile, "noNotchHarmonics", 0, 0 );
  if (args_info->calcRthreshold_given)
    write_into_file(outfile, "calcRthreshold", 0, 0 );
  if (args_info->BrentsMethod_given)
    write_into_file(outfile, "BrentsMethod", 0, 0 );
  if (args_info->antennaOff_given)
    write_into_file(outfile, "antennaOff", 0, 0 );
  if (args_info->noiseWeightOff_given)
    write_into_file(outfile, "noiseWeightOff", 0, 0 );
  if (args_info->gaussTemplatesOnly_given)
    write_into_file(outfile, "gaussTemplatesOnly", 0, 0 );
  if (args_info->periodHarmToCheck_given)
    write_into_file(outfile, "periodHarmToCheck", args_info->periodHarmToCheck_orig, 0);
  if (args_info->periodFracToCheck_given)
    write_into_file(outfile, "periodFracToCheck", args_info->periodFracToCheck_orig, 0);
  if (args_info->ULoff_given)
    write_into_file(outfile, "ULoff", 0, 0 );
  if (args_info->printSFTtimes_given)
    write_into_file(outfile, "printSFTtimes", 0, 0 );
  if (args_info->printUsedSFTtimes_given)
    write_into_file(outfile, "printUsedSFTtimes", 0, 0 );
  if (args_info->printData_given)
    write_into_file(outfile, "printData", 0, 0 );
  if (args_info->printUninitialized_given)
    write_into_file(outfile, "printUninitialized", args_info->printUninitialized_orig, 0);
  if (args_info->printSignalData_given)
    write_into_file(outfile, "printSignalData", 0, 0 );
  if (args_info->randSeed_given)
    write_into_file(outfile, "randSeed", args_info->randSeed_orig, 0);
  if (args_info->chooseSeed_given)
    write_into_file(outfile, "chooseSeed", 0, 0 );
  

  i = EXIT_SUCCESS;
  return i;
}

int
cmdline_parser_file_save(const char *filename, struct gengetopt_args_info *args_info)
{
  FILE *outfile;
  int i = 0;

  outfile = fopen(filename, "w");

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot open file for writing: %s\n", CMDLINE_PARSER_PACKAGE, filename);
      return EXIT_FAILURE;
    }

  i = cmdline_parser_dump(outfile, args_info);
  fclose (outfile);

  return i;
}

void
cmdline_parser_free (struct gengetopt_args_info *args_info)
{
  cmdline_parser_release (args_info);
}

/** @brief replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = 0;
  if (!s)
    return result;

  result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

static char *
get_multiple_arg_token(const char *arg)
{
  const char *tok;
  char *ret;
  size_t len, num_of_escape, i, j;

  if (!arg)
    return 0;

  tok = strchr (arg, ',');
  num_of_escape = 0;

  /* make sure it is not escaped */
  while (tok)
    {
      if (*(tok-1) == '\\')
        {
          /* find the next one */
          tok = strchr (tok+1, ',');
          ++num_of_escape;
        }
      else
        break;
    }

  if (tok)
    len = (size_t)(tok - arg + 1);
  else
    len = strlen (arg) + 1;

  len -= num_of_escape;

  ret = (char *) malloc (len);

  i = 0;
  j = 0;
  while (arg[i] && (j < len-1))
    {
      if (arg[i] == '\\' && 
	  arg[ i + 1 ] && 
	  arg[ i + 1 ] == ',')
        ++i;

      ret[j++] = arg[i++];
    }

  ret[len-1] = '\0';

  return ret;
}

static const char *
get_multiple_arg_token_next(const char *arg)
{
  const char *tok;

  if (!arg)
    return 0;

  tok = strchr (arg, ',');

  /* make sure it is not escaped */
  while (tok)
    {
      if (*(tok-1) == '\\')
        {
          /* find the next one */
          tok = strchr (tok+1, ',');
        }
      else
        break;
    }

  if (! tok || strlen(tok) == 1)
    return 0;

  return tok+1;
}

static int
check_multiple_option_occurrences(const char *prog_name, unsigned int option_given, unsigned int min, unsigned int max, const char *option_desc);

int
check_multiple_option_occurrences(const char *prog_name, unsigned int option_given, unsigned int min, unsigned int max, const char *option_desc)
{
  int error = 0;

  if (option_given && (min > 0 || max > 0))
    {
      if (min > 0 && max > 0)
        {
          if (min == max)
            {
              /* specific occurrences */
              if (option_given != (unsigned int) min)
                {
                  fprintf (stderr, "%s: %s option occurrences must be %d\n",
                    prog_name, option_desc, min);
                  error = 1;
                }
            }
          else if (option_given < (unsigned int) min
                || option_given > (unsigned int) max)
            {
              /* range occurrences */
              fprintf (stderr, "%s: %s option occurrences must be between %d and %d\n",
                prog_name, option_desc, min, max);
              error = 1;
            }
        }
      else if (min > 0)
        {
          /* at least check */
          if (option_given < min)
            {
              fprintf (stderr, "%s: %s option occurrences must be at least %d\n",
                prog_name, option_desc, min);
              error = 1;
            }
        }
      else if (max > 0)
        {
          /* at most check */
          if (option_given > max)
            {
              fprintf (stderr, "%s: %s option occurrences must be at most %d\n",
                prog_name, option_desc, max);
              error = 1;
            }
        }
    }
    
  return error;
}
int
cmdline_parser (int argc, char **argv, struct gengetopt_args_info *args_info)
{
  return cmdline_parser2 (argc, argv, args_info, 0, 1, 1);
}

int
cmdline_parser_ext (int argc, char **argv, struct gengetopt_args_info *args_info,
                   struct cmdline_parser_params *params)
{
  int result;
  result = cmdline_parser_internal (argc, argv, args_info, params, 0);

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser2 (int argc, char **argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required)
{
  int result;
  struct cmdline_parser_params params;
  
  params.override = override;
  params.initialize = initialize;
  params.check_required = check_required;
  params.check_ambiguity = 0;
  params.print_errors = 1;

  result = cmdline_parser_internal (argc, argv, args_info, &params, 0);

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser_required (struct gengetopt_args_info *args_info, const char *prog_name)
{
  int result = EXIT_SUCCESS;

  if (cmdline_parser_required2(args_info, prog_name, 0) > 0)
    result = EXIT_FAILURE;

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser_required2 (struct gengetopt_args_info *args_info, const char *prog_name, const char *additional_error)
{
  int error = 0;
  FIX_UNUSED (additional_error);

  /* checks for required options */
  if (! args_info->Tobs_given)
    {
      fprintf (stderr, "%s: '--Tobs' option required%s\n", prog_name, (additional_error ? additional_error : ""));
      error = 1;
    }
  
  if (! args_info->Tcoh_given)
    {
      fprintf (stderr, "%s: '--Tcoh' option required%s\n", prog_name, (additional_error ? additional_error : ""));
      error = 1;
    }
  
  if (! args_info->SFToverlap_given)
    {
      fprintf (stderr, "%s: '--SFToverlap' option required%s\n", prog_name, (additional_error ? additional_error : ""));
      error = 1;
    }
  
  if (! args_info->t0_given)
    {
      fprintf (stderr, "%s: '--t0' option required%s\n", prog_name, (additional_error ? additional_error : ""));
      error = 1;
    }
  
  if (! args_info->fmin_given)
    {
      fprintf (stderr, "%s: '--fmin' option required%s\n", prog_name, (additional_error ? additional_error : ""));
      error = 1;
    }
  
  if (! args_info->fspan_given)
    {
      fprintf (stderr, "%s: '--fspan' option required%s\n", prog_name, (additional_error ? additional_error : ""));
      error = 1;
    }
  
  if (! args_info->IFO_given)
    {
      fprintf (stderr, "%s: '--IFO' option required%s\n", prog_name, (additional_error ? additional_error : ""));
      error = 1;
    }
  
  if (check_multiple_option_occurrences(prog_name, args_info->IFO_given, args_info->IFO_min, args_info->IFO_max, "'--IFO'"))
     error = 1;
  
  if (! args_info->avesqrtSh_given)
    {
      fprintf (stderr, "%s: '--avesqrtSh' option required%s\n", prog_name, (additional_error ? additional_error : ""));
      error = 1;
    }
  
  if (! args_info->ephemDir_given)
    {
      fprintf (stderr, "%s: '--ephemDir' option required%s\n", prog_name, (additional_error ? additional_error : ""));
      error = 1;
    }
  
  if (! args_info->ephemYear_given)
    {
      fprintf (stderr, "%s: '--ephemYear' option required%s\n", prog_name, (additional_error ? additional_error : ""));
      error = 1;
    }
  
  if (! args_info->Pmin_given)
    {
      fprintf (stderr, "%s: '--Pmin' option required%s\n", prog_name, (additional_error ? additional_error : ""));
      error = 1;
    }
  
  if (! args_info->Pmax_given)
    {
      fprintf (stderr, "%s: '--Pmax' option required%s\n", prog_name, (additional_error ? additional_error : ""));
      error = 1;
    }
  
  if (! args_info->dfmin_given)
    {
      fprintf (stderr, "%s: '--dfmin' option required%s\n", prog_name, (additional_error ? additional_error : ""));
      error = 1;
    }
  
  if (! args_info->dfmax_given)
    {
      fprintf (stderr, "%s: '--dfmax' option required%s\n", prog_name, (additional_error ? additional_error : ""));
      error = 1;
    }
  
  
  /* checks for dependences among options */
  if (args_info->templateTestF_given && ! args_info->templateTest_given)
    {
      fprintf (stderr, "%s: '--templateTestF' option depends on option 'templateTest'%s\n", prog_name, (additional_error ? additional_error : ""));
      error = 1;
    }
  if (args_info->templateTestP_given && ! args_info->templateTest_given)
    {
      fprintf (stderr, "%s: '--templateTestP' option depends on option 'templateTest'%s\n", prog_name, (additional_error ? additional_error : ""));
      error = 1;
    }
  if (args_info->templateTestDf_given && ! args_info->templateTest_given)
    {
      fprintf (stderr, "%s: '--templateTestDf' option depends on option 'templateTest'%s\n", prog_name, (additional_error ? additional_error : ""));
      error = 1;
    }
  if (args_info->printSignalData_given && ! args_info->injectionSources_given)
    {
      fprintf (stderr, "%s: '--printSignalData' option depends on option 'injectionSources'%s\n", prog_name, (additional_error ? additional_error : ""));
      error = 1;
    }

  return error;
}


static char *package_name = 0;

/**
 * @brief updates an option
 * @param field the generic pointer to the field to update
 * @param orig_field the pointer to the orig field
 * @param field_given the pointer to the number of occurrence of this option
 * @param prev_given the pointer to the number of occurrence already seen
 * @param value the argument for this option (if null no arg was specified)
 * @param possible_values the possible values for this option (if specified)
 * @param default_value the default value (in case the option only accepts fixed values)
 * @param arg_type the type of this option
 * @param check_ambiguity @see cmdline_parser_params.check_ambiguity
 * @param override @see cmdline_parser_params.override
 * @param no_free whether to free a possible previous value
 * @param multiple_option whether this is a multiple option
 * @param long_opt the corresponding long option
 * @param short_opt the corresponding short option (or '-' if none)
 * @param additional_error possible further error specification
 */
static
int update_arg(void *field, char **orig_field,
               unsigned int *field_given, unsigned int *prev_given, 
               char *value, const char *possible_values[],
               const char *default_value,
               cmdline_parser_arg_type arg_type,
               int check_ambiguity, int override,
               int no_free, int multiple_option,
               const char *long_opt, char short_opt,
               const char *additional_error)
{
  char *stop_char = 0;
  const char *val = value;
  int found;
  char **string_field;
  FIX_UNUSED (field);

  stop_char = 0;
  found = 0;

  if (!multiple_option && prev_given && (*prev_given || (check_ambiguity && *field_given)))
    {
      if (short_opt != '-')
        fprintf (stderr, "%s: `--%s' (`-%c') option given more than once%s\n", 
               package_name, long_opt, short_opt,
               (additional_error ? additional_error : ""));
      else
        fprintf (stderr, "%s: `--%s' option given more than once%s\n", 
               package_name, long_opt,
               (additional_error ? additional_error : ""));
      return 1; /* failure */
    }

  if (possible_values && (found = check_possible_values((value ? value : default_value), possible_values)) < 0)
    {
      if (short_opt != '-')
        fprintf (stderr, "%s: %s argument, \"%s\", for option `--%s' (`-%c')%s\n", 
          package_name, (found == -2) ? "ambiguous" : "invalid", value, long_opt, short_opt,
          (additional_error ? additional_error : ""));
      else
        fprintf (stderr, "%s: %s argument, \"%s\", for option `--%s'%s\n", 
          package_name, (found == -2) ? "ambiguous" : "invalid", value, long_opt,
          (additional_error ? additional_error : ""));
      return 1; /* failure */
    }
    
  if (field_given && *field_given && ! override)
    return 0;
  if (prev_given)
    (*prev_given)++;
  if (field_given)
    (*field_given)++;
  if (possible_values)
    val = possible_values[found];

  switch(arg_type) {
  case ARG_FLAG:
    *((int *)field) = !*((int *)field);
    break;
  case ARG_INT:
    if (val) *((int *)field) = strtol (val, &stop_char, 0);
    break;
  case ARG_DOUBLE:
    if (val) *((double *)field) = strtod (val, &stop_char);
    break;
  case ARG_STRING:
    if (val) {
      string_field = (char **)field;
      if (!no_free && *string_field)
        free (*string_field); /* free previous string */
      *string_field = gengetopt_strdup (val);
    }
    break;
  default:
    break;
  };

  /* check numeric conversion */
  switch(arg_type) {
  case ARG_INT:
  case ARG_DOUBLE:
    if (val && !(stop_char && *stop_char == '\0')) {
      fprintf(stderr, "%s: invalid numeric value: %s\n", package_name, val);
      return 1; /* failure */
    }
    break;
  default:
    ;
  };

  /* store the original value */
  switch(arg_type) {
  case ARG_NO:
  case ARG_FLAG:
    break;
  default:
    if (value && orig_field) {
      if (no_free) {
        *orig_field = value;
      } else {
        if (*orig_field)
          free (*orig_field); /* free previous string */
        *orig_field = gengetopt_strdup (value);
      }
    }
  };

  return 0; /* OK */
}

/**
 * @brief store information about a multiple option in a temporary list
 * @param list where to (temporarily) store multiple options
 */
static
int update_multiple_arg_temp(struct generic_list **list,
               unsigned int *prev_given, const char *val,
               const char *possible_values[], const char *default_value,
               cmdline_parser_arg_type arg_type,
               const char *long_opt, char short_opt,
               const char *additional_error)
{
  /* store single arguments */
  char *multi_token;
  const char *multi_next;

  if (arg_type == ARG_NO) {
    (*prev_given)++;
    return 0; /* OK */
  }

  multi_token = get_multiple_arg_token(val);
  multi_next = get_multiple_arg_token_next (val);

  while (1)
    {
      add_node (list);
      if (update_arg((void *)&((*list)->arg), &((*list)->orig), 0,
          prev_given, multi_token, possible_values, default_value, 
          arg_type, 0, 1, 1, 1, long_opt, short_opt, additional_error)) {
        if (multi_token) free(multi_token);
        return 1; /* failure */
      }

      if (multi_next)
        {
          multi_token = get_multiple_arg_token(multi_next);
          multi_next = get_multiple_arg_token_next (multi_next);
        }
      else
        break;
    }

  return 0; /* OK */
}

/**
 * @brief free the passed list (including possible string argument)
 */
static
void free_list(struct generic_list *list, short string_arg)
{
  if (list) {
    struct generic_list *tmp;
    while (list)
      {
        tmp = list;
        if (string_arg && list->arg.string_arg)
          free (list->arg.string_arg);
        if (list->orig)
          free (list->orig);
        list = list->next;
        free (tmp);
      }
  }
}

/**
 * @brief updates a multiple option starting from the passed list
 */
static
void update_multiple_arg(void *field, char ***orig_field,
               unsigned int field_given, unsigned int prev_given, union generic_value *default_value,
               cmdline_parser_arg_type arg_type,
               struct generic_list *list)
{
  int i;
  struct generic_list *tmp;

  if (prev_given && list) {
    *orig_field = (char **) realloc (*orig_field, (field_given + prev_given) * sizeof (char *));

    switch(arg_type) {
    case ARG_INT:
      *((int **)field) = (int *)realloc (*((int **)field), (field_given + prev_given) * sizeof (int)); break;
    case ARG_DOUBLE:
      *((double **)field) = (double *)realloc (*((double **)field), (field_given + prev_given) * sizeof (double)); break;
    case ARG_STRING:
      *((char ***)field) = (char **)realloc (*((char ***)field), (field_given + prev_given) * sizeof (char *)); break;
    default:
      break;
    };
    
    for (i = (prev_given - 1); i >= 0; --i)
      {
        tmp = list;
        
        switch(arg_type) {
        case ARG_INT:
          (*((int **)field))[i + field_given] = tmp->arg.int_arg; break;
        case ARG_DOUBLE:
          (*((double **)field))[i + field_given] = tmp->arg.double_arg; break;
        case ARG_STRING:
          (*((char ***)field))[i + field_given] = tmp->arg.string_arg; break;
        default:
          break;
        }        
        (*orig_field) [i + field_given] = list->orig;
        list = list->next;
        free (tmp);
      }
  } else { /* set the default value */
    if (default_value && ! field_given) {
      switch(arg_type) {
      case ARG_INT:
        if (! *((int **)field)) {
          *((int **)field) = (int *)malloc (sizeof (int));
          (*((int **)field))[0] = default_value->int_arg; 
        }
        break;
      case ARG_DOUBLE:
        if (! *((double **)field)) {
          *((double **)field) = (double *)malloc (sizeof (double));
          (*((double **)field))[0] = default_value->double_arg;
        }
        break;
      case ARG_STRING:
        if (! *((char ***)field)) {
          *((char ***)field) = (char **)malloc (sizeof (char *));
          (*((char ***)field))[0] = gengetopt_strdup(default_value->string_arg);
        }
        break;
      default: break;
      }
      if (!(*orig_field)) {
        *orig_field = (char **) malloc (sizeof (char *));
        (*orig_field)[0] = 0;
      }
    }
  }
}

int
cmdline_parser_internal (
  int argc, char **argv, struct gengetopt_args_info *args_info,
                        struct cmdline_parser_params *params, const char *additional_error)
{
  int c;	/* Character of the parsed option.  */

  struct generic_list * IFO_list = NULL;
  int error = 0;
  struct gengetopt_args_info local_args_info;
  
  int override;
  int initialize;
  int check_required;
  int check_ambiguity;
  
  package_name = argv[0];
  
  override = params->override;
  initialize = params->initialize;
  check_required = params->check_required;
  check_ambiguity = params->check_ambiguity;

  if (initialize)
    cmdline_parser_init (args_info);

  cmdline_parser_init (&local_args_info);

  optarg = 0;
  optind = 0;
  opterr = params->print_errors;
  optopt = '?';

  while (1)
    {
      int option_index = 0;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "full-help",	0, NULL, 0 },
        { "version",	0, NULL, 'V' },
        { "config",	1, NULL, 0 },
        { "laldebug",	1, NULL, 'd' },
        { "Tobs",	1, NULL, 0 },
        { "Tcoh",	1, NULL, 0 },
        { "SFToverlap",	1, NULL, 0 },
        { "t0",	1, NULL, 0 },
        { "fmin",	1, NULL, 0 },
        { "fspan",	1, NULL, 0 },
        { "IFO",	1, NULL, 0 },
        { "avesqrtSh",	1, NULL, 0 },
        { "blksize",	1, NULL, 0 },
        { "sftType",	1, NULL, 0 },
        { "outdirectory",	1, NULL, 0 },
        { "outfilename",	1, NULL, 0 },
        { "configCopy",	1, NULL, 0 },
        { "ULfilename",	1, NULL, 0 },
        { "normRMSoutput",	1, NULL, 0 },
        { "sftDir",	1, NULL, 0 },
        { "sftFile",	1, NULL, 0 },
        { "ephemDir",	1, NULL, 0 },
        { "ephemYear",	1, NULL, 0 },
        { "Pmin",	1, NULL, 0 },
        { "Pmax",	1, NULL, 0 },
        { "dfmin",	1, NULL, 0 },
        { "dfmax",	1, NULL, 0 },
        { "skyRegion",	1, NULL, 0 },
        { "skyRegionFile",	1, NULL, 0 },
        { "linPolAngle",	1, NULL, 0 },
        { "harmonicNumToSearch",	1, NULL, 0 },
        { "templateSearch",	0, NULL, 0 },
        { "ihsfactor",	1, NULL, 0 },
        { "ihsfar",	1, NULL, 0 },
        { "ihsfom",	1, NULL, 0 },
        { "ihsfomfar",	1, NULL, 0 },
        { "keepOnlyTopNumIHS",	1, NULL, 0 },
        { "tmplfar",	1, NULL, 0 },
        { "minTemplateLength",	1, NULL, 0 },
        { "maxTemplateLength",	1, NULL, 0 },
        { "ULfmin",	1, NULL, 0 },
        { "ULfspan",	1, NULL, 0 },
        { "ULminimumDeltaf",	1, NULL, 0 },
        { "ULmaximumDeltaf",	1, NULL, 0 },
        { "allULvalsPerSkyLoc",	0, NULL, 0 },
        { "markBadSFTs",	0, NULL, 0 },
        { "simpleBandRejection",	1, NULL, 0 },
        { "lineDetection",	1, NULL, 0 },
        { "FFTplanFlag",	1, NULL, 0 },
        { "fastchisqinv",	0, NULL, 0 },
        { "useSSE",	0, NULL, 0 },
        { "followUpOutsideULrange",	0, NULL, 0 },
        { "timestampsFile",	1, NULL, 0 },
        { "injectionSources",	1, NULL, 0 },
        { "injRandSeed",	1, NULL, 0 },
        { "weightedIHS",	0, NULL, 0 },
        { "signalOnly",	0, NULL, 0 },
        { "templateTest",	0, NULL, 0 },
        { "templateTestF",	1, NULL, 0 },
        { "templateTestP",	1, NULL, 0 },
        { "templateTestDf",	1, NULL, 0 },
        { "ULsolver",	1, NULL, 0 },
        { "dopplerMultiplier",	1, NULL, 0 },
        { "IHSonly",	0, NULL, 0 },
        { "noNotchHarmonics",	0, NULL, 0 },
        { "calcRthreshold",	0, NULL, 0 },
        { "BrentsMethod",	0, NULL, 0 },
        { "antennaOff",	0, NULL, 0 },
        { "noiseWeightOff",	0, NULL, 0 },
        { "gaussTemplatesOnly",	0, NULL, 0 },
        { "periodHarmToCheck",	1, NULL, 0 },
        { "periodFracToCheck",	1, NULL, 0 },
        { "ULoff",	0, NULL, 0 },
        { "printSFTtimes",	0, NULL, 0 },
        { "printUsedSFTtimes",	0, NULL, 0 },
        { "printData",	0, NULL, 0 },
        { "printUninitialized",	1, NULL, 0 },
        { "printSignalData",	0, NULL, 0 },
        { "randSeed",	1, NULL, 0 },
        { "chooseSeed",	0, NULL, 0 },
        { 0,  0, 0, 0 }
      };

      c = getopt_long (argc, argv, "hVd:", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          cmdline_parser_print_help ();
          cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'V':	/* Print version and exit.  */
          cmdline_parser_print_version ();
          cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'd':	/* LAL debug level.  */
        
        
          if (update_arg( (void *)&(args_info->laldebug_arg), 
               &(args_info->laldebug_orig), &(args_info->laldebug_given),
              &(local_args_info.laldebug_given), optarg, 0, "0", ARG_INT,
              check_ambiguity, override, 0, 0,
              "laldebug", 'd',
              additional_error))
            goto failure;
        
          break;

        case 0:	/* Long option with no short option */
          if (strcmp (long_options[option_index].name, "full-help") == 0) {
            cmdline_parser_print_full_help ();
            cmdline_parser_free (&local_args_info);
            exit (EXIT_SUCCESS);
          }

          /* Configuration file in gengetopt format for passing parameters.  */
          if (strcmp (long_options[option_index].name, "config") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->config_arg), 
                 &(args_info->config_orig), &(args_info->config_given),
                &(local_args_info.config_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "config", '-',
                additional_error))
              goto failure;
          
          }
          /* Total observation time (in seconds).  */
          else if (strcmp (long_options[option_index].name, "Tobs") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->Tobs_arg), 
                 &(args_info->Tobs_orig), &(args_info->Tobs_given),
                &(local_args_info.Tobs_given), optarg, 0, 0, ARG_DOUBLE,
                check_ambiguity, override, 0, 0,
                "Tobs", '-',
                additional_error))
              goto failure;
          
          }
          /* SFT coherence time (in seconds).  */
          else if (strcmp (long_options[option_index].name, "Tcoh") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->Tcoh_arg), 
                 &(args_info->Tcoh_orig), &(args_info->Tcoh_given),
                &(local_args_info.Tcoh_given), optarg, 0, 0, ARG_DOUBLE,
                check_ambiguity, override, 0, 0,
                "Tcoh", '-',
                additional_error))
              goto failure;
          
          }
          /* SFT overlap (in seconds), usually Tcoh/2.  */
          else if (strcmp (long_options[option_index].name, "SFToverlap") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->SFToverlap_arg), 
                 &(args_info->SFToverlap_orig), &(args_info->SFToverlap_given),
                &(local_args_info.SFToverlap_given), optarg, 0, 0, ARG_DOUBLE,
                check_ambiguity, override, 0, 0,
                "SFToverlap", '-',
                additional_error))
              goto failure;
          
          }
          /* Start time of the search (in GPS seconds).  */
          else if (strcmp (long_options[option_index].name, "t0") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->t0_arg), 
                 &(args_info->t0_orig), &(args_info->t0_given),
                &(local_args_info.t0_given), optarg, 0, 0, ARG_DOUBLE,
                check_ambiguity, override, 0, 0,
                "t0", '-',
                additional_error))
              goto failure;
          
          }
          /* Minimum frequency of band (Hz).  */
          else if (strcmp (long_options[option_index].name, "fmin") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->fmin_arg), 
                 &(args_info->fmin_orig), &(args_info->fmin_given),
                &(local_args_info.fmin_given), optarg, 0, 0, ARG_DOUBLE,
                check_ambiguity, override, 0, 0,
                "fmin", '-',
                additional_error))
              goto failure;
          
          }
          /* Frequency span of band (Hz).  */
          else if (strcmp (long_options[option_index].name, "fspan") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->fspan_arg), 
                 &(args_info->fspan_orig), &(args_info->fspan_given),
                &(local_args_info.fspan_given), optarg, 0, 0, ARG_DOUBLE,
                check_ambiguity, override, 0, 0,
                "fspan", '-',
                additional_error))
              goto failure;
          
          }
          /* Interferometer of whose data is being analyzed.  */
          else if (strcmp (long_options[option_index].name, "IFO") == 0)
          {
          
            if (update_multiple_arg_temp(&IFO_list, 
                &(local_args_info.IFO_given), optarg, cmdline_parser_IFO_values, 0, ARG_STRING,
                "IFO", '-',
                additional_error))
              goto failure;
          
          }
          /* Expected average of square root of Sh.  */
          else if (strcmp (long_options[option_index].name, "avesqrtSh") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->avesqrtSh_arg), 
                 &(args_info->avesqrtSh_orig), &(args_info->avesqrtSh_given),
                &(local_args_info.avesqrtSh_given), optarg, 0, 0, ARG_DOUBLE,
                check_ambiguity, override, 0, 0,
                "avesqrtSh", '-',
                additional_error))
              goto failure;
          
          }
          /* Blocksize for running median to determine expected noise of input SFTs.  */
          else if (strcmp (long_options[option_index].name, "blksize") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->blksize_arg), 
                 &(args_info->blksize_orig), &(args_info->blksize_given),
                &(local_args_info.blksize_given), optarg, 0, "101", ARG_INT,
                check_ambiguity, override, 0, 0,
                "blksize", '-',
                additional_error))
              goto failure;
          
          }
          /* SFT type of either 'standard' (v2 SFTs; FFT coefficients * dt/RMS(window weights)) or 'vladimir' (Vladimir's Hann windowed SFT version; FFT coefficients * 2*dt).  */
          else if (strcmp (long_options[option_index].name, "sftType") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->sftType_arg), 
                 &(args_info->sftType_orig), &(args_info->sftType_given),
                &(local_args_info.sftType_given), optarg, cmdline_parser_sftType_values, "standard", ARG_STRING,
                check_ambiguity, override, 0, 0,
                "sftType", '-',
                additional_error))
              goto failure;
          
          }
          /* Output directory.  */
          else if (strcmp (long_options[option_index].name, "outdirectory") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->outdirectory_arg), 
                 &(args_info->outdirectory_orig), &(args_info->outdirectory_given),
                &(local_args_info.outdirectory_given), optarg, 0, "output", ARG_STRING,
                check_ambiguity, override, 0, 0,
                "outdirectory", '-',
                additional_error))
              goto failure;
          
          }
          /* Output file name.  */
          else if (strcmp (long_options[option_index].name, "outfilename") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->outfilename_arg), 
                 &(args_info->outfilename_orig), &(args_info->outfilename_given),
                &(local_args_info.outfilename_given), optarg, 0, "logfile.txt", ARG_STRING,
                check_ambiguity, override, 0, 0,
                "outfilename", '-',
                additional_error))
              goto failure;
          
          }
          /* Copy of the configuration file whose output is gengetopt format.  */
          else if (strcmp (long_options[option_index].name, "configCopy") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->configCopy_arg), 
                 &(args_info->configCopy_orig), &(args_info->configCopy_given),
                &(local_args_info.configCopy_given), optarg, 0, "input_values.conf", ARG_STRING,
                check_ambiguity, override, 0, 0,
                "configCopy", '-',
                additional_error))
              goto failure;
          
          }
          /* Upper limit file name.  */
          else if (strcmp (long_options[option_index].name, "ULfilename") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->ULfilename_arg), 
                 &(args_info->ULfilename_orig), &(args_info->ULfilename_given),
                &(local_args_info.ULfilename_given), optarg, 0, "uls.dat", ARG_STRING,
                check_ambiguity, override, 0, 0,
                "ULfilename", '-',
                additional_error))
              goto failure;
          
          }
          /* File for the output of the normalized RMS from the non-slided data.  */
          else if (strcmp (long_options[option_index].name, "normRMSoutput") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->normRMSoutput_arg), 
                 &(args_info->normRMSoutput_orig), &(args_info->normRMSoutput_given),
                &(local_args_info.normRMSoutput_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "normRMSoutput", '-',
                additional_error))
              goto failure;
          
          }
          /* Directory containing SFTs, e.g., /path/to/file (conflicts with --sftFile/--timestampsFile).  */
          else if (strcmp (long_options[option_index].name, "sftDir") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->sftDir_arg), 
                 &(args_info->sftDir_orig), &(args_info->sftDir_given),
                &(local_args_info.sftDir_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "sftDir", '-',
                additional_error))
              goto failure;
          
          }
          /* Path and filename of SFTs, e.g., /path/to/file/sftdata.sft (one of --sftDir/--timestampsFile).  */
          else if (strcmp (long_options[option_index].name, "sftFile") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->sftFile_arg), 
                 &(args_info->sftFile_orig), &(args_info->sftFile_given),
                &(local_args_info.sftFile_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "sftFile", '-',
                additional_error))
              goto failure;
          
          }
          /* Path to ephemeris files, e.g. /path/to/ephemeris/files.  */
          else if (strcmp (long_options[option_index].name, "ephemDir") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->ephemDir_arg), 
                 &(args_info->ephemDir_orig), &(args_info->ephemDir_given),
                &(local_args_info.ephemDir_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "ephemDir", '-',
                additional_error))
              goto failure;
          
          }
          /* Year or year range (e.g. 08-11) of ephemeris files.  */
          else if (strcmp (long_options[option_index].name, "ephemYear") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->ephemYear_arg), 
                 &(args_info->ephemYear_orig), &(args_info->ephemYear_given),
                &(local_args_info.ephemYear_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "ephemYear", '-',
                additional_error))
              goto failure;
          
          }
          /* Minimum period to be searched (in seconds).  */
          else if (strcmp (long_options[option_index].name, "Pmin") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->Pmin_arg), 
                 &(args_info->Pmin_orig), &(args_info->Pmin_given),
                &(local_args_info.Pmin_given), optarg, 0, 0, ARG_DOUBLE,
                check_ambiguity, override, 0, 0,
                "Pmin", '-',
                additional_error))
              goto failure;
          
          }
          /* Maximum period to be searched (in seconds).  */
          else if (strcmp (long_options[option_index].name, "Pmax") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->Pmax_arg), 
                 &(args_info->Pmax_orig), &(args_info->Pmax_given),
                &(local_args_info.Pmax_given), optarg, 0, 0, ARG_DOUBLE,
                check_ambiguity, override, 0, 0,
                "Pmax", '-',
                additional_error))
              goto failure;
          
          }
          /* Minimum modulation depth to search (Hz).  */
          else if (strcmp (long_options[option_index].name, "dfmin") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->dfmin_arg), 
                 &(args_info->dfmin_orig), &(args_info->dfmin_given),
                &(local_args_info.dfmin_given), optarg, 0, 0, ARG_DOUBLE,
                check_ambiguity, override, 0, 0,
                "dfmin", '-',
                additional_error))
              goto failure;
          
          }
          /* Maximum modulation depth to search (Hz).  */
          else if (strcmp (long_options[option_index].name, "dfmax") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->dfmax_arg), 
                 &(args_info->dfmax_orig), &(args_info->dfmax_given),
                &(local_args_info.dfmax_given), optarg, 0, 0, ARG_DOUBLE,
                check_ambiguity, override, 0, 0,
                "dfmax", '-',
                additional_error))
              goto failure;
          
          }
          /* Region of the sky to search (e.g. (ra1,dec1),(ra2,dec2),(ra3,dec3)...) or allsky.  */
          else if (strcmp (long_options[option_index].name, "skyRegion") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->skyRegion_arg), 
                 &(args_info->skyRegion_orig), &(args_info->skyRegion_given),
                &(local_args_info.skyRegion_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "skyRegion", '-',
                additional_error))
              goto failure;
          
          }
          /* File with the grid points.  */
          else if (strcmp (long_options[option_index].name, "skyRegionFile") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->skyRegionFile_arg), 
                 &(args_info->skyRegionFile_orig), &(args_info->skyRegionFile_given),
                &(local_args_info.skyRegionFile_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "skyRegionFile", '-',
                additional_error))
              goto failure;
          
          }
          /* Polarization angle to search using linear polarization (when unspecified default is circular polarization.  */
          else if (strcmp (long_options[option_index].name, "linPolAngle") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->linPolAngle_arg), 
                 &(args_info->linPolAngle_orig), &(args_info->linPolAngle_given),
                &(local_args_info.linPolAngle_given), optarg, 0, 0, ARG_DOUBLE,
                check_ambiguity, override, 0, 0,
                "linPolAngle", '-',
                additional_error))
              goto failure;
          
          }
          /* Number of harmonics of the Pmin to Pmax range to search.  */
          else if (strcmp (long_options[option_index].name, "harmonicNumToSearch") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->harmonicNumToSearch_arg), 
                 &(args_info->harmonicNumToSearch_orig), &(args_info->harmonicNumToSearch_given),
                &(local_args_info.harmonicNumToSearch_given), optarg, 0, "1", ARG_INT,
                check_ambiguity, override, 0, 0,
                "harmonicNumToSearch", '-',
                additional_error))
              goto failure;
          
          }
          /* Flag for doing a pure template-based search on search region specified by (sky,f,fspan,hardcoded P, hardcoded asini).  */
          else if (strcmp (long_options[option_index].name, "templateSearch") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->templateSearch_flag), 0, &(args_info->templateSearch_given),
                &(local_args_info.templateSearch_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "templateSearch", '-',
                additional_error))
              goto failure;
          
          }
          /* Number of harmonics to sum in IHS algorithm.  */
          else if (strcmp (long_options[option_index].name, "ihsfactor") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->ihsfactor_arg), 
                 &(args_info->ihsfactor_orig), &(args_info->ihsfactor_given),
                &(local_args_info.ihsfactor_given), optarg, 0, "5", ARG_INT,
                check_ambiguity, override, 0, 0,
                "ihsfactor", '-',
                additional_error))
              goto failure;
          
          }
          /* IHS FAR threshold.  */
          else if (strcmp (long_options[option_index].name, "ihsfar") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->ihsfar_arg), 
                 &(args_info->ihsfar_orig), &(args_info->ihsfar_given),
                &(local_args_info.ihsfar_given), optarg, 0, 0, ARG_DOUBLE,
                check_ambiguity, override, 0, 0,
                "ihsfar", '-',
                additional_error))
              goto failure;
          
          }
          /* IHS FOM = 12*(L_IHS_loc - U_IHS_loc)^2.  */
          else if (strcmp (long_options[option_index].name, "ihsfom") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->ihsfom_arg), 
                 &(args_info->ihsfom_orig), &(args_info->ihsfom_given),
                &(local_args_info.ihsfom_given), optarg, 0, 0, ARG_DOUBLE,
                check_ambiguity, override, 0, 0,
                "ihsfom", '-',
                additional_error))
              goto failure;
          
          }
          /* IHS FOM FAR threshold.  */
          else if (strcmp (long_options[option_index].name, "ihsfomfar") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->ihsfomfar_arg), 
                 &(args_info->ihsfomfar_orig), &(args_info->ihsfomfar_given),
                &(local_args_info.ihsfomfar_given), optarg, 0, 0, ARG_DOUBLE,
                check_ambiguity, override, 0, 0,
                "ihsfomfar", '-',
                additional_error))
              goto failure;
          
          }
          /* Keep the top <number> of IHS candidates based on significance.  */
          else if (strcmp (long_options[option_index].name, "keepOnlyTopNumIHS") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->keepOnlyTopNumIHS_arg), 
                 &(args_info->keepOnlyTopNumIHS_orig), &(args_info->keepOnlyTopNumIHS_given),
                &(local_args_info.keepOnlyTopNumIHS_given), optarg, 0, 0, ARG_INT,
                check_ambiguity, override, 0, 0,
                "keepOnlyTopNumIHS", '-',
                additional_error))
              goto failure;
          
          }
          /* Template FAR threshold.  */
          else if (strcmp (long_options[option_index].name, "tmplfar") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->tmplfar_arg), 
                 &(args_info->tmplfar_orig), &(args_info->tmplfar_given),
                &(local_args_info.tmplfar_given), optarg, 0, 0, ARG_DOUBLE,
                check_ambiguity, override, 0, 0,
                "tmplfar", '-',
                additional_error))
              goto failure;
          
          }
          /* Maximum number of pixels to use in the template.  */
          else if (strcmp (long_options[option_index].name, "minTemplateLength") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->minTemplateLength_arg), 
                 &(args_info->minTemplateLength_orig), &(args_info->minTemplateLength_given),
                &(local_args_info.minTemplateLength_given), optarg, 0, "1", ARG_INT,
                check_ambiguity, override, 0, 0,
                "minTemplateLength", '-',
                additional_error))
              goto failure;
          
          }
          /* Maximum number of pixels to use in the template.  */
          else if (strcmp (long_options[option_index].name, "maxTemplateLength") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->maxTemplateLength_arg), 
                 &(args_info->maxTemplateLength_orig), &(args_info->maxTemplateLength_given),
                &(local_args_info.maxTemplateLength_given), optarg, 0, "1000", ARG_INT,
                check_ambiguity, override, 0, 0,
                "maxTemplateLength", '-',
                additional_error))
              goto failure;
          
          }
          /* Minimum signal frequency considered for the upper limit value (Hz).  */
          else if (strcmp (long_options[option_index].name, "ULfmin") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->ULfmin_arg), 
                 &(args_info->ULfmin_orig), &(args_info->ULfmin_given),
                &(local_args_info.ULfmin_given), optarg, 0, 0, ARG_DOUBLE,
                check_ambiguity, override, 0, 0,
                "ULfmin", '-',
                additional_error))
              goto failure;
          
          }
          /* Span of signal frequencies considered for the upper limit value (Hz).  */
          else if (strcmp (long_options[option_index].name, "ULfspan") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->ULfspan_arg), 
                 &(args_info->ULfspan_orig), &(args_info->ULfspan_given),
                &(local_args_info.ULfspan_given), optarg, 0, 0, ARG_DOUBLE,
                check_ambiguity, override, 0, 0,
                "ULfspan", '-',
                additional_error))
              goto failure;
          
          }
          /* Minimum modulation depth counted in the upper limit value (Hz).  */
          else if (strcmp (long_options[option_index].name, "ULminimumDeltaf") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->ULminimumDeltaf_arg), 
                 &(args_info->ULminimumDeltaf_orig), &(args_info->ULminimumDeltaf_given),
                &(local_args_info.ULminimumDeltaf_given), optarg, 0, 0, ARG_DOUBLE,
                check_ambiguity, override, 0, 0,
                "ULminimumDeltaf", '-',
                additional_error))
              goto failure;
          
          }
          /* Maximum modulation depth counted in the upper limit value (Hz).  */
          else if (strcmp (long_options[option_index].name, "ULmaximumDeltaf") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->ULmaximumDeltaf_arg), 
                 &(args_info->ULmaximumDeltaf_orig), &(args_info->ULmaximumDeltaf_given),
                &(local_args_info.ULmaximumDeltaf_given), optarg, 0, 0, ARG_DOUBLE,
                check_ambiguity, override, 0, 0,
                "ULmaximumDeltaf", '-',
                additional_error))
              goto failure;
          
          }
          /* Print all UL values in the band specified by ULminimumDeltaf and ULmaximumDeltaf (default is to print only the maximum UL value in the band).  */
          else if (strcmp (long_options[option_index].name, "allULvalsPerSkyLoc") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->allULvalsPerSkyLoc_flag), 0, &(args_info->allULvalsPerSkyLoc_given),
                &(local_args_info.allULvalsPerSkyLoc_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "allULvalsPerSkyLoc", '-',
                additional_error))
              goto failure;
          
          }
          /* Mark bad SFTs.  */
          else if (strcmp (long_options[option_index].name, "markBadSFTs") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->markBadSFTs_flag), 0, &(args_info->markBadSFTs_given),
                &(local_args_info.markBadSFTs_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "markBadSFTs", '-',
                additional_error))
              goto failure;
          
          }
          /* Produce upper limits for each band, but if second FFT plane std. dev. exceeds threshold given here, don't follow up any IHS candidates.  */
          else if (strcmp (long_options[option_index].name, "simpleBandRejection") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->simpleBandRejection_arg), 
                 &(args_info->simpleBandRejection_orig), &(args_info->simpleBandRejection_given),
                &(local_args_info.simpleBandRejection_given), optarg, 0, 0, ARG_DOUBLE,
                check_ambiguity, override, 0, 0,
                "simpleBandRejection", '-',
                additional_error))
              goto failure;
          
          }
          /* Detect stationary lines above threshold, and, if any present, set upper limit only, no template follow-up.  */
          else if (strcmp (long_options[option_index].name, "lineDetection") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->lineDetection_arg), 
                 &(args_info->lineDetection_orig), &(args_info->lineDetection_given),
                &(local_args_info.lineDetection_given), optarg, 0, 0, ARG_DOUBLE,
                check_ambiguity, override, 0, 0,
                "lineDetection", '-',
                additional_error))
              goto failure;
          
          }
          /* 0=Estimate, 1=Measure, 2=Patient, 3=Exhaustive.  */
          else if (strcmp (long_options[option_index].name, "FFTplanFlag") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->FFTplanFlag_arg), 
                 &(args_info->FFTplanFlag_orig), &(args_info->FFTplanFlag_given),
                &(local_args_info.FFTplanFlag_given), optarg, cmdline_parser_FFTplanFlag_values, "1", ARG_INT,
                check_ambiguity, override, 0, 0,
                "FFTplanFlag", '-',
                additional_error))
              goto failure;
          
          }
          /* Use a faster central chi-sq inversion function (roughly float precision instead of double).  */
          else if (strcmp (long_options[option_index].name, "fastchisqinv") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->fastchisqinv_flag), 0, &(args_info->fastchisqinv_given),
                &(local_args_info.fastchisqinv_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "fastchisqinv", '-',
                additional_error))
              goto failure;
          
          }
          /* Use SSE functions (caution: user needs to have compiled for SSE or program fails).  */
          else if (strcmp (long_options[option_index].name, "useSSE") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->useSSE_flag), 0, &(args_info->useSSE_given),
                &(local_args_info.useSSE_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "useSSE", '-',
                additional_error))
              goto failure;
          
          }
          /* Follow up outliers outside the range of the UL values.  */
          else if (strcmp (long_options[option_index].name, "followUpOutsideULrange") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->followUpOutsideULrange_flag), 0, &(args_info->followUpOutsideULrange_given),
                &(local_args_info.followUpOutsideULrange_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "followUpOutsideULrange", '-',
                additional_error))
              goto failure;
          
          }
          /* File to read timestamps from (file-format: lines with <seconds> <nanoseconds>; conflicts with --sftDir/--sftFile options).  */
          else if (strcmp (long_options[option_index].name, "timestampsFile") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->timestampsFile_arg), 
                 &(args_info->timestampsFile_orig), &(args_info->timestampsFile_given),
                &(local_args_info.timestampsFile_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "timestampsFile", '-',
                additional_error))
              goto failure;
          
          }
          /* File containing sources to inject with a required preceding @ symbol.  */
          else if (strcmp (long_options[option_index].name, "injectionSources") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->injectionSources_arg), 
                 &(args_info->injectionSources_orig), &(args_info->injectionSources_given),
                &(local_args_info.injectionSources_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "injectionSources", '-',
                additional_error))
              goto failure;
          
          }
          /* Random seed value for reproducable noise (conflicts with --sftDir/--sftFile options).  */
          else if (strcmp (long_options[option_index].name, "injRandSeed") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->injRandSeed_arg), 
                 &(args_info->injRandSeed_orig), &(args_info->injRandSeed_given),
                &(local_args_info.injRandSeed_given), optarg, 0, "0", ARG_INT,
                check_ambiguity, override, 0, 0,
                "injRandSeed", '-',
                additional_error))
              goto failure;
          
          }
          /* Use the noise-weighted IHS scheme.  */
          else if (strcmp (long_options[option_index].name, "weightedIHS") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->weightedIHS_flag), 0, &(args_info->weightedIHS_given),
                &(local_args_info.weightedIHS_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "weightedIHS", '-',
                additional_error))
              goto failure;
          
          }
          /* SFTs contain only signal, no noise.  */
          else if (strcmp (long_options[option_index].name, "signalOnly") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->signalOnly_flag), 0, &(args_info->signalOnly_given),
                &(local_args_info.signalOnly_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "signalOnly", '-',
                additional_error))
              goto failure;
          
          }
          /* Test the doubly-Fourier transformed data against a single, exact template.  */
          else if (strcmp (long_options[option_index].name, "templateTest") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->templateTest_flag), 0, &(args_info->templateTest_given),
                &(local_args_info.templateTest_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "templateTest", '-',
                additional_error))
              goto failure;
          
          }
          /* The template test frequency; templateTest flag is required.  */
          else if (strcmp (long_options[option_index].name, "templateTestF") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->templateTestF_arg), 
                 &(args_info->templateTestF_orig), &(args_info->templateTestF_given),
                &(local_args_info.templateTestF_given), optarg, 0, 0, ARG_DOUBLE,
                check_ambiguity, override, 0, 0,
                "templateTestF", '-',
                additional_error))
              goto failure;
          
          }
          /* The template test period; templateTest flag is required.  */
          else if (strcmp (long_options[option_index].name, "templateTestP") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->templateTestP_arg), 
                 &(args_info->templateTestP_orig), &(args_info->templateTestP_given),
                &(local_args_info.templateTestP_given), optarg, 0, 0, ARG_DOUBLE,
                check_ambiguity, override, 0, 0,
                "templateTestP", '-',
                additional_error))
              goto failure;
          
          }
          /* The template test modulation depth; templateTest flag is required.  */
          else if (strcmp (long_options[option_index].name, "templateTestDf") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->templateTestDf_arg), 
                 &(args_info->templateTestDf_orig), &(args_info->templateTestDf_given),
                &(local_args_info.templateTestDf_given), optarg, 0, 0, ARG_DOUBLE,
                check_ambiguity, override, 0, 0,
                "templateTestDf", '-',
                additional_error))
              goto failure;
          
          }
          /* Solver function for the upper limit calculation: 0=gsl_ncx2cdf_float_withouttinyprob_solver, 1=gsl_ncx2cdf_withouttinyprob_solver, 2=gsl_ncx2cdf_float_solver, 3=gsl_ncx2cdf_solver, 4=ncx2cdf_float_withouttinyprob_withmatlabchi2cdf_solver, 5=ncx2cdf_withouttinyprob_withmatlabchi2cdf_solver.  */
          else if (strcmp (long_options[option_index].name, "ULsolver") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->ULsolver_arg), 
                 &(args_info->ULsolver_orig), &(args_info->ULsolver_given),
                &(local_args_info.ULsolver_given), optarg, cmdline_parser_ULsolver_values, "0", ARG_INT,
                check_ambiguity, override, 0, 0,
                "ULsolver", '-',
                additional_error))
              goto failure;
          
          }
          /* Multiplier for the Doppler velocity.  */
          else if (strcmp (long_options[option_index].name, "dopplerMultiplier") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->dopplerMultiplier_arg), 
                 &(args_info->dopplerMultiplier_orig), &(args_info->dopplerMultiplier_given),
                &(local_args_info.dopplerMultiplier_given), optarg, 0, "1.0", ARG_DOUBLE,
                check_ambiguity, override, 0, 0,
                "dopplerMultiplier", '-',
                additional_error))
              goto failure;
          
          }
          /* IHS stage only is run. Output statistic is the IHS statistic..  */
          else if (strcmp (long_options[option_index].name, "IHSonly") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->IHSonly_flag), 0, &(args_info->IHSonly_given),
                &(local_args_info.IHSonly_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "IHSonly", '-',
                additional_error))
              goto failure;
          
          }
          /* Do not notch the daily/sidereal harmonics in the IHS step..  */
          else if (strcmp (long_options[option_index].name, "noNotchHarmonics") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->noNotchHarmonics_flag), 0, &(args_info->noNotchHarmonics_given),
                &(local_args_info.noNotchHarmonics_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "noNotchHarmonics", '-',
                additional_error))
              goto failure;
          
          }
          /* Calculate the threshold value for R given the template false alarm rate.  */
          else if (strcmp (long_options[option_index].name, "calcRthreshold") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->calcRthreshold_flag), 0, &(args_info->calcRthreshold_given),
                &(local_args_info.calcRthreshold_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "calcRthreshold", '-',
                additional_error))
              goto failure;
          
          }
          /* Use Brent's method in the root finding algorithm..  */
          else if (strcmp (long_options[option_index].name, "BrentsMethod") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->BrentsMethod_flag), 0, &(args_info->BrentsMethod_given),
                &(local_args_info.BrentsMethod_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "BrentsMethod", '-',
                additional_error))
              goto failure;
          
          }
          /* Antenna pattern weights are /NOT/ used if this flag is used.  */
          else if (strcmp (long_options[option_index].name, "antennaOff") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->antennaOff_flag), 0, &(args_info->antennaOff_given),
                &(local_args_info.antennaOff_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "antennaOff", '-',
                additional_error))
              goto failure;
          
          }
          /* Turn off noise weighting if this flag is used.  */
          else if (strcmp (long_options[option_index].name, "noiseWeightOff") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->noiseWeightOff_flag), 0, &(args_info->noiseWeightOff_given),
                &(local_args_info.noiseWeightOff_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "noiseWeightOff", '-',
                additional_error))
              goto failure;
          
          }
          /* Gaussian templates only throughout the pipeline if this flag is used.  */
          else if (strcmp (long_options[option_index].name, "gaussTemplatesOnly") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->gaussTemplatesOnly_flag), 0, &(args_info->gaussTemplatesOnly_given),
                &(local_args_info.gaussTemplatesOnly_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "gaussTemplatesOnly", '-',
                additional_error))
              goto failure;
          
          }
          /* Number of harmonics/sub-harmonics of the IHS candidates to test.  */
          else if (strcmp (long_options[option_index].name, "periodHarmToCheck") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->periodHarmToCheck_arg), 
                 &(args_info->periodHarmToCheck_orig), &(args_info->periodHarmToCheck_given),
                &(local_args_info.periodHarmToCheck_given), optarg, 0, "5", ARG_INT,
                check_ambiguity, override, 0, 0,
                "periodHarmToCheck", '-',
                additional_error))
              goto failure;
          
          }
          /* Number of fractional periods to check in the sense of [(1...N)+1]/[(1...N)+2].  */
          else if (strcmp (long_options[option_index].name, "periodFracToCheck") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->periodFracToCheck_arg), 
                 &(args_info->periodFracToCheck_orig), &(args_info->periodFracToCheck_given),
                &(local_args_info.periodFracToCheck_given), optarg, 0, "3", ARG_INT,
                check_ambiguity, override, 0, 0,
                "periodFracToCheck", '-',
                additional_error))
              goto failure;
          
          }
          /* Turn off upper limits computation.  */
          else if (strcmp (long_options[option_index].name, "ULoff") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->ULoff_flag), 0, &(args_info->ULoff_given),
                &(local_args_info.ULoff_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "ULoff", '-',
                additional_error))
              goto failure;
          
          }
          /* Output a list <GPS sec> <GPS nanosec> of SFT start times of input SFTs.  */
          else if (strcmp (long_options[option_index].name, "printSFTtimes") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->printSFTtimes_flag), 0, &(args_info->printSFTtimes_given),
                &(local_args_info.printSFTtimes_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "printSFTtimes", '-',
                additional_error))
              goto failure;
          
          }
          /* Output a list <GPS sec> <GPS nanosec> of SFT start times of the SFTs passing tests.  */
          else if (strcmp (long_options[option_index].name, "printUsedSFTtimes") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->printUsedSFTtimes_flag), 0, &(args_info->printUsedSFTtimes_given),
                &(local_args_info.printUsedSFTtimes_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "printUsedSFTtimes", '-',
                additional_error))
              goto failure;
          
          }
          /* Print to ASCII files the data values.  */
          else if (strcmp (long_options[option_index].name, "printData") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->printData_flag), 0, &(args_info->printData_given),
                &(local_args_info.printData_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "printData", '-',
                additional_error))
              goto failure;
          
          }
          /* Print uninitialized values in TFdata_weighted and TSofPowers vectors at n-th sky location specified by option (if not enough sky locations exist, then these vectors don't get printed!).  */
          else if (strcmp (long_options[option_index].name, "printUninitialized") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->printUninitialized_arg), 
                 &(args_info->printUninitialized_orig), &(args_info->printUninitialized_given),
                &(local_args_info.printUninitialized_given), optarg, 0, 0, ARG_INT,
                check_ambiguity, override, 0, 0,
                "printUninitialized", '-',
                additional_error))
              goto failure;
          
          }
          /* Print f0 and h0 per SFT of the signal, used only with --injectionSources option.  */
          else if (strcmp (long_options[option_index].name, "printSignalData") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->printSignalData_flag), 0, &(args_info->printSignalData_given),
                &(local_args_info.printSignalData_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "printSignalData", '-',
                additional_error))
              goto failure;
          
          }
          /* Random seed value.  */
          else if (strcmp (long_options[option_index].name, "randSeed") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->randSeed_arg), 
                 &(args_info->randSeed_orig), &(args_info->randSeed_given),
                &(local_args_info.randSeed_given), optarg, 0, 0, ARG_INT,
                check_ambiguity, override, 0, 0,
                "randSeed", '-',
                additional_error))
              goto failure;
          
          }
          /* The random seed value is chosen based on the input search parameters.  */
          else if (strcmp (long_options[option_index].name, "chooseSeed") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->chooseSeed_flag), 0, &(args_info->chooseSeed_given),
                &(local_args_info.chooseSeed_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "chooseSeed", '-',
                additional_error))
              goto failure;
          
          }
          
          break;
        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          goto failure;

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c%s\n", CMDLINE_PARSER_PACKAGE, c, (additional_error ? additional_error : ""));
          abort ();
        } /* switch */
    } /* while */


  update_multiple_arg((void *)&(args_info->IFO_arg),
    &(args_info->IFO_orig), args_info->IFO_given,
    local_args_info.IFO_given, 0,
    ARG_STRING, IFO_list);

  args_info->IFO_given += local_args_info.IFO_given;
  local_args_info.IFO_given = 0;
  
  if (check_required)
    {
      error += cmdline_parser_required2 (args_info, argv[0], additional_error);
    }

  cmdline_parser_release (&local_args_info);

  if ( error )
    return (EXIT_FAILURE);

  return 0;

failure:
  free_list (IFO_list, 1 );
  
  cmdline_parser_release (&local_args_info);
  return (EXIT_FAILURE);
}

#ifndef CONFIG_FILE_LINE_SIZE
#define CONFIG_FILE_LINE_SIZE 2048
#endif
#define ADDITIONAL_ERROR " in configuration file "

#define CONFIG_FILE_LINE_BUFFER_SIZE (CONFIG_FILE_LINE_SIZE+3)
/* 3 is for "--" and "=" */

static int
_cmdline_parser_configfile (const char *filename, int *my_argc)
{
  FILE* file;
  char my_argv[CONFIG_FILE_LINE_BUFFER_SIZE+1];
  char linebuf[CONFIG_FILE_LINE_SIZE];
  int line_num = 0;
  int result = 0, equal;
  char *fopt, *farg;
  char *str_index;
  size_t len, next_token;
  char delimiter;

  if ((file = fopen(filename, "r")) == 0)
    {
      fprintf (stderr, "%s: Error opening configuration file '%s'\n",
               CMDLINE_PARSER_PACKAGE, filename);
      return EXIT_FAILURE;
    }

  while ((fgets(linebuf, CONFIG_FILE_LINE_SIZE, file)) != 0)
    {
      ++line_num;
      my_argv[0] = '\0';
      len = strlen(linebuf);
      if (len > (CONFIG_FILE_LINE_BUFFER_SIZE-1))
        {
          fprintf (stderr, "%s:%s:%d: Line too long in configuration file\n",
                   CMDLINE_PARSER_PACKAGE, filename, line_num);
          result = EXIT_FAILURE;
          break;
        }

      /* find first non-whitespace character in the line */
      next_token = strspn (linebuf, " \t\r\n");
      str_index  = linebuf + next_token;

      if ( str_index[0] == '\0' || str_index[0] == '#')
        continue; /* empty line or comment line is skipped */

      fopt = str_index;

      /* truncate fopt at the end of the first non-valid character */
      next_token = strcspn (fopt, " \t\r\n=");

      if (fopt[next_token] == '\0') /* the line is over */
        {
          farg  = 0;
          equal = 0;
          goto noarg;
        }

      /* remember if equal sign is present */
      equal = (fopt[next_token] == '=');
      fopt[next_token++] = '\0';

      /* advance pointers to the next token after the end of fopt */
      next_token += strspn (fopt + next_token, " \t\r\n");

      /* check for the presence of equal sign, and if so, skip it */
      if ( !equal )
        if ((equal = (fopt[next_token] == '=')))
          {
            next_token++;
            next_token += strspn (fopt + next_token, " \t\r\n");
          }
      str_index  += next_token;

      /* find argument */
      farg = str_index;
      if ( farg[0] == '\"' || farg[0] == '\'' )
        { /* quoted argument */
          str_index = strchr (++farg, str_index[0] ); /* skip opening quote */
          if (! str_index)
            {
              fprintf
                (stderr,
                 "%s:%s:%d: unterminated string in configuration file\n",
                 CMDLINE_PARSER_PACKAGE, filename, line_num);
              result = EXIT_FAILURE;
              break;
            }
        }
      else
        { /* read up the remaining part up to a delimiter */
          next_token = strcspn (farg, " \t\r\n#\'\"");
          str_index += next_token;
        }

      /* truncate farg at the delimiter and store it for further check */
      delimiter = *str_index, *str_index++ = '\0';

      /* everything but comment is illegal at the end of line */
      if (delimiter != '\0' && delimiter != '#')
        {
          str_index += strspn(str_index, " \t\r\n");
          if (*str_index != '\0' && *str_index != '#')
            {
              fprintf
                (stderr,
                 "%s:%s:%d: malformed string in configuration file\n",
                 CMDLINE_PARSER_PACKAGE, filename, line_num);
              result = EXIT_FAILURE;
              break;
            }
        }

    noarg:
      if (!strcmp(fopt,"include")) {
        if (farg && *farg) {
          result = _cmdline_parser_configfile(farg, my_argc);
        } else {
          fprintf(stderr, "%s:%s:%d: include requires a filename argument.\n",
                  CMDLINE_PARSER_PACKAGE, filename, line_num);
        }
        continue;
      }
      len = strlen(fopt);
      strcat (my_argv, len > 1 ? "--" : "-");
      strcat (my_argv, fopt);
      if (len > 1 && ((farg && *farg) || equal))
        strcat (my_argv, "=");
      if (farg && *farg)
        strcat (my_argv, farg);
      ++(*my_argc);

      cmd_line_list_tmp = (struct line_list *) malloc (sizeof (struct line_list));
      cmd_line_list_tmp->next = cmd_line_list;
      cmd_line_list = cmd_line_list_tmp;
      cmd_line_list->string_arg = gengetopt_strdup(my_argv);
    } /* while */

  if (file)
    fclose(file);
  return result;
}

int
cmdline_parser_configfile (
  const char *filename,
                           struct gengetopt_args_info *args_info,
                           int override, int initialize, int check_required)
{
  struct cmdline_parser_params params;

  params.override = override;
  params.initialize = initialize;
  params.check_required = check_required;
  params.check_ambiguity = 0;
  params.print_errors = 1;
  
  return cmdline_parser_config_file (filename, args_info, &params);
}

int
cmdline_parser_config_file (const char *filename,
                           struct gengetopt_args_info *args_info,
                           struct cmdline_parser_params *params)
{
  int i, result;
  int my_argc = 1;
  char **my_argv_arg;
  char *additional_error;

  /* store the program name */
  cmd_line_list_tmp = (struct line_list *) malloc (sizeof (struct line_list));
  cmd_line_list_tmp->next = cmd_line_list;
  cmd_line_list = cmd_line_list_tmp;
  cmd_line_list->string_arg = gengetopt_strdup (CMDLINE_PARSER_PACKAGE);

  result = _cmdline_parser_configfile(filename, &my_argc);

  if (result != EXIT_FAILURE) {
    my_argv_arg = (char **) malloc((my_argc+1) * sizeof(char *));
    cmd_line_list_tmp = cmd_line_list;

    for (i = my_argc - 1; i >= 0; --i) {
      my_argv_arg[i] = cmd_line_list_tmp->string_arg;
      cmd_line_list_tmp = cmd_line_list_tmp->next;
    }

    my_argv_arg[my_argc] = 0;

    additional_error = (char *)malloc(strlen(filename) + strlen(ADDITIONAL_ERROR) + 1);
    strcpy (additional_error, ADDITIONAL_ERROR);
    strcat (additional_error, filename);
    result =
      cmdline_parser_internal (my_argc, my_argv_arg, args_info,
                              params,
                              additional_error);

    free (additional_error);
    free (my_argv_arg);
  }

  free_cmd_list();
  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

static unsigned int
cmdline_parser_create_argv(const char *cmdline_, char ***argv_ptr, const char *prog_name)
{
  char *cmdline, *p;
  size_t n = 0, j;
  int i;

  if (prog_name) {
    cmd_line_list_tmp = (struct line_list *) malloc (sizeof (struct line_list));
    cmd_line_list_tmp->next = cmd_line_list;
    cmd_line_list = cmd_line_list_tmp;
    cmd_line_list->string_arg = gengetopt_strdup (prog_name);

    ++n;
  }

  cmdline = gengetopt_strdup(cmdline_);
  p = cmdline;

  while (p && strlen(p))
    {
      j = strcspn(p, " \t");
      ++n;
      if (j && j < strlen(p))
        {
          p[j] = '\0';

          cmd_line_list_tmp = (struct line_list *) malloc (sizeof (struct line_list));
          cmd_line_list_tmp->next = cmd_line_list;
          cmd_line_list = cmd_line_list_tmp;
          cmd_line_list->string_arg = gengetopt_strdup (p);

          p += (j+1);
          p += strspn(p, " \t");
        }
      else
        {
          cmd_line_list_tmp = (struct line_list *) malloc (sizeof (struct line_list));
          cmd_line_list_tmp->next = cmd_line_list;
          cmd_line_list = cmd_line_list_tmp;
          cmd_line_list->string_arg = gengetopt_strdup (p);

          break;
        }
    }

  *argv_ptr = (char **) malloc((n + 1) * sizeof(char *));
  cmd_line_list_tmp = cmd_line_list;
  for (i = (n-1); i >= 0; --i)
    {
      (*argv_ptr)[i] = cmd_line_list_tmp->string_arg;
      cmd_line_list_tmp = cmd_line_list_tmp->next;
    }

  (*argv_ptr)[n] = 0;

  free(cmdline);
  return n;
}

int
cmdline_parser_string(const char *cmdline, struct gengetopt_args_info *args_info, const char *prog_name)
{
  return cmdline_parser_string2(cmdline, args_info, prog_name, 0, 1, 1);
}

int
cmdline_parser_string2(const char *cmdline, struct gengetopt_args_info *args_info, const char *prog_name,
    int override, int initialize, int check_required)
{
  struct cmdline_parser_params params;

  params.override = override;
  params.initialize = initialize;
  params.check_required = check_required;
  params.check_ambiguity = 0;
  params.print_errors = 1;

  return cmdline_parser_string_ext(cmdline, args_info, prog_name, &params);
}

int
cmdline_parser_string_ext(const char *cmdline, struct gengetopt_args_info *args_info, const char *prog_name,
    struct cmdline_parser_params *params)
{
  char **argv_ptr = 0;
  int result;
  unsigned int argc;
  
  argc = cmdline_parser_create_argv(cmdline, &argv_ptr, prog_name);
  
  result =
    cmdline_parser_internal (argc, argv_ptr, args_info, params, 0);
  
  if (argv_ptr)
    {
      free (argv_ptr);
    }

  free_cmd_list();
  
  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

