%define _prefix /usr
%define _mandir %{_prefix}/share/man
%define _sysconfdir %{_prefix}/etc
%define _pkgpythondir %{_prefix}/lib64/python2.6/site-packages/lalapps
%define _pkgpyexecdir %{_libdir}/python2.6/site-packages/lalapps

Name: lalapps
Version: 6.14.0
Release: 1
Summary: LSC Algorithm Library Applications
License: GPL
Group: LAL
Source: %{name}-%{version}.tar.gz
URL: https://www.lsc-group.phys.uwm.edu/daswg/projects/lalsuite.html
Packager: Duncan Brown <dbrown@ligo.caltech.edu>
BuildRoot: %{_tmppath}/%{name}-%{version}-root
BuildRequires: gsl-devel fftw3-devel libframe-devel libmetaio-devel lal-devel lalframe-devel lalmetaio-devel lalsimulation-devel lalburst-devel lalinspiral-devel lalstochastic-devel lalpulsar-devel lalinference-devel
Requires: healpy gsl fftw3 libframe libmetaio lal lalframe lalmetaio lalsimulation lalburst lalinspiral lalstochastic lalpulsar lalinference python
Prefix: %{_prefix}

%description
The LSC Algorithm Library Applications for gravitational wave data analysis.
This package contains applications that are built on tools in the LSC
Algorithm Library.

%prep
%setup -q

%build
nightly_version=
%configure --enable-nightly=${nightly_version:-no} --disable-gcc-flags --disable-debug
%{__make} V=1

%install
%makeinstall

%post
ldconfig

%postun
ldconfig

%clean
[ ${RPM_BUILD_ROOT} != "/" ] && rm -Rf ${RPM_BUILD_ROOT}
rm -Rf ${RPM_BUILD_DIR}/%{name}-%{version}

%files
%defattr(-,root,root)
%{_bindir}/*
%{_pkgpythondir}/*
%{_mandir}/man1/*
%{_datadir}/lalapps/*
%{_sysconfdir}/lalapps-user-env.*
