%define nightly %{nil}
%define _sysconfdir %{_prefix}/etc
%define release 1
%define configure_opts GSL_LIBS="-lgsl"

%if "%{?nightly:%{nightly}}%{!?nightly:0}" == "%{nil}"
%undefine nightly
%endif

# -- metadata ---------------

Name: lal
Version: 7.0.0
Release: %{?nightly:0.%{nightly}}%{!?nightly:%{release}}%{?dist}
Summary: LSC Algorithm Library
License: GPLv2+
Group: LAL
Source0: http://software.ligo.org/lscsoft/source/lalsuite/%{name}-%{version}%{?nightly:-%{nightly}}.tar.xz
URL: https://wiki.ligo.org/Computing/LALSuite
Packager: Adam Mercer <adam.mercer@ligo.org>
Prefix: %{_prefix}

# -- build requirements -----

# C
BuildRequires: bc
BuildRequires: fftw-devel
BuildRequires: gcc
BuildRequires: gcc-c++
BuildRequires: gsl-devel
BuildRequires: hdf5-devel
BuildRequires: less
BuildRequires: make
BuildRequires: pkgconfig >= 0.18.0

# swig
BuildRequires: swig >= 3.0.9

# python2
BuildRequires: python2-rpm-macros
BuildRequires: python
BuildRequires: python-devel
BuildRequires: python2-dateutil
BuildRequires: python2-freezegun
BuildRequires: python2-glue >= 1.54.1
BuildRequires: python2-ligo-segments
BuildRequires: python2-mock
BuildRequires: python2-numpy
BuildRequires: python-pathlib
BuildRequires: pytest
BuildRequires: python2-six
BuildRequires: python2-scipy

# python3x
BuildRequires: python-srpm-macros
BuildRequires: python3-rpm-macros
BuildRequires: epel-rpm-macros
BuildRequires: python%{python3_pkgversion}
BuildRequires: python%{python3_pkgversion}-devel
BuildRequires: python%{python3_pkgversion}-dateutil
BuildRequires: python%{python3_pkgversion}-freezegun
BuildRequires: python%{python3_pkgversion}-glue >= 1.54.1
BuildRequires: python%{python3_pkgversion}-ligo-segments
BuildRequires: python%{python3_pkgversion}-numpy
BuildRequires: python%{python3_pkgversion}-pytest
BuildRequires: python%{python3_pkgversion}-six
BuildRequires: python%{python3_pkgversion}-scipy

# octave
BuildRequires: octave-devel

# -- packages ---------------

# lal
Requires: fftw
Requires: gsl
Requires: hdf5
Requires: less
Obsoletes: python-pylal < 0.13.2-1

%description
The LSC Algorithm Library for gravitational wave data analysis.
This package contains the shared-object libraries needed to run applications
that use the LAL library.

# lal-devel
%package devel
Summary: Files and documentation needed for compiling programs that use LAL
Group: LAL
Requires: %{name} = %{version}
Requires: fftw-devel
Requires: gsl-devel
Requires: hdf5-devel
%description devel
The LSC Algorithm Library for gravitational wave data analysis.
This package contains files needed build applications that use the LAL library
as well as the documentation for the library.

# python2-lal
%package -n python2-%{name}
Summary: Python %{python2_version} bindings for LAL
Group: LAL
Requires: %{name} = %{version}
Requires: python
Requires: python2-dateutil
Requires: python2-glue >= 1.54.1
Requires: python2-ligo-segments
Requires: python2-numpy
Requires: python2-scipy
Requires: python2-six
Provides: %{name}-python = %{version}-%{release}
Obsoletes: %{name}-python < %{version}-%{release}
%{?python_provide:%python_provide python2-%{name}}
%description -n python2-%{name}
The LSC Algorithm Library for gravitational wave data analysis.
This package provides the Python %{python2_version} bindings.

# python3x-lal
%package -n python%{python3_pkgversion}-%{name}
Summary: Python %{python3_version} bindings for LAL
Group: LAL
Requires: %{name} = %{version}
Requires: python%{python3_pkgversion}
Requires: python%{python3_pkgversion}-dateutil
Requires: python%{python3_pkgversion}-glue >= 1.54.1
Requires: python%{python3_pkgversion}-ligo-segments
Requires: python%{python3_pkgversion}-numpy
Requires: python%{python3_pkgversion}-scipy
Requires: python%{python3_pkgversion}-six
%{?python_provide:%python_provide python%{python3_pkgversion}-%{name}}
%description -n python%{python3_pkgversion}-%{name}
The LSC Algorithm Library for gravitational wave data analysis.
This package provides the Python %{python3_version} bindings.

# lal-octave
%package octave
Summary: Octave bindings for LAL
Group: LAL
Requires: %{name} = %{version}
Requires: octave
%description octave
The LSC Algorithm Library for gravitational wave data analysis.
This package provides the Octave bindings.

# -- build stages -----------

%prep
%setup -q -n %{name}-%{version}%{?nightly:-%{nightly}}

%build
# build C library with python2
%configure %{configure_opts} --disable-gcc-flags --enable-swig PYTHON=%{__python2}
%{__make} %{?_smp_mflags} V=1

# build python3 library (copy things so we don't have to rebuild them)
rm -rf %py3dir
cp -r . %py3dir
pushd %py3dir
rm -rfv python/%{name}/*.{la,lo,o} python/%{name}/.libs
%configure %{configure_opts} --disable-doxygen --disable-gcc-flags --disable-swig-octave --enable-swig-python PYTHON=%{__python3}
%{__make} V=1 -C swig
%{__make} V=1 -C python/%{name}
popd

%check
# C + python2 + octave
%{__make} %{?_smp_mflags} V=1 VERBOSE=1 check
# python3
[ -d %py3dir/test/python ] && %{__make} %{?_smp_mflags} V=1 VERBOSE=1 -C %py3dir -C test/python check

%install
# C + python2 + octave
%make_install
# python3
%{__make} -C %py3dir -C swig install-exec-am DESTDIR=%{?buildroot}
%{__make} -C %py3dir -C python/%{name} install DESTDIR=%{?buildroot}
find $RPM_BUILD_ROOT%{_libdir} -name '*.la' -delete

%post
ldconfig

%postun
ldconfig

%clean
[ ${RPM_BUILD_ROOT} != "/" ] && rm -Rf ${RPM_BUILD_ROOT}
rm -Rf ${RPM_BUILD_DIR}/%{name}-%{version}%{?nightly:-%{nightly}}

# -- files ------------------

%files
%defattr(-,root,root)
%license COPYING
%{_bindir}/lal_simd_detect
%{_bindir}/lal_version
%{_libdir}/*.so.*
%{_sysconfdir}/lal-user-env.*

%files devel
%defattr(-,root,root)
%license COPYING
%{_includedir}/lal
%{_libdir}/*.a
%{_libdir}/*.so
%{_libdir}/pkgconfig/*

%files -n python2-%{name}
%defattr(-,root,root)
%license COPYING
%{python2_sitearch}/*

%files -n python%{python3_pkgversion}-%{name}
%defattr(-,root,root)
%license COPYING
%{python3_sitearch}/*

%files octave
%defattr(-,root,root)
%license COPYING
%{_prefix}/lib*/octave/*/site/oct/*/lal.oct*

# -- changelog --------------

# dates should be formatted using: 'date +"%a %b %d %Y"'
%changelog
* Mon Jun 08 2020 Adam Mercer <adam.mercer@ligo.org> 7.0.0-1
- Update for 7.0.0

* Wed Mar 25 2020 Duncan Macleod <duncan.macleod@ligo.org> 6.22.0-1
- Update for 6.22.0

* Mon Dec 09 2019 Adam Mercer <adam.mercer@ligo.org> 6.21.0-3
- Packaging updates

* Wed Dec 04 2019 Adam Mercer <adam.mercer@ligo.org> 6.21.0-2
- Packaging updates

* Fri Nov 22 2019 Adam Mercer <adam.mercer@ligo.org> 6.21.0-1
- O3b release

* Wed Jun 26 2019 Adam Mercer <adam.mercer@ligo.org> 6.20.2-1
- MKL FFT fixes

* Fri May 24 2019 Adam Mercer <adam.mercer@ligo.org> 6.20.1-1
- O3 point release

* Thu May 23 2019 Adam Mercer <adam.mercer@ligo.org> 6.20.0-1
- O3 release

* Mon Feb 25 2019 Adam Mercer <adam.mercer@ligo.org> 6.19.2-1
- ER13 release

* Mon Jan 07 2019 Adam Mercer <adam.mercer@ligo.org> 6.19.1-1
- Intel FFT complilation fixes

* Thu Sep 13 2018 Adam Mercer <adam.mercer@ligo.org> 6.19.0-1
- Pre O3 release

* Tue Feb 07 2017 Adam Mercer <adam.mercer@ligo.org> 6.18.0-1
- O2 release

* Mon Sep 26 2016 Adam Mercer <adam.mercer@lgio.org> 6.17.0-1
- ER10 Release

* Tue Jun 21 2016 Adam Mercer <adam.mercer@ligo.org> 6.16.1-1
- ER9 Release

* Fri Mar 25 2016 Adam Mercer <adam.mercer@ligo.org> 6.16.0-1
- Pre O2 packaging test release
