/*
 * LALVCSInfo.h - LAL VCS Information Header
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with with program; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 *
 * Copyright (C) 2009-2013 Adam Mercer
 * Copyright (C) 2014 Karl Wette
 */

/** \cond DONT_DOXYGEN */

#ifndef _LALVCSINFOHEADER_H
#define _LALVCSINFOHEADER_H

#include <lal/LALVCSInfoType.h>
#include <lal/LALVCSInfo.h>
#include <lal/LALConfig.h>

#ifdef __cplusplus
extern "C" {
#endif

/* VCS information defines */
#define LAL_NAME "LAL"
#define LAL_VCS_ID "b5ca2b6bee576a61027135359046e758ccc4eadf"
#define LAL_VCS_DATE "2016-10-10 17:31:34 +0000"
#define LAL_VCS_BRANCH "None"
#define LAL_VCS_TAG "lal-v6.17.0"
#define LAL_VCS_AUTHOR "Adam Mercer <adam.mercer@ligo.org>"
#define LAL_VCS_COMMITTER "Adam Mercer <adam.mercer@ligo.org>"
#define LAL_VCS_STATUS "CLEAN: All modifications committed"

/* Identable VCS information defines */
#define LAL_VCS_IDENT_ID "$" "LALId: b5ca2b6bee576a61027135359046e758ccc4eadf " "$"
#define LAL_VCS_IDENT_DATE "$" "LALDate: 2016-10-10 17:31:34 +0000 " "$"
#define LAL_VCS_IDENT_BRANCH "$" "LALBranch: None " "$"
#define LAL_VCS_IDENT_TAG "$" "LALTag: lal-v6.17.0 " "$"
#define LAL_VCS_IDENT_AUTHOR "$" "LALAuthor: Adam Mercer <adam.mercer@ligo.org> " "$"
#define LAL_VCS_IDENT_COMMITTER "$" "LALCommitter: Adam Mercer <adam.mercer@ligo.org> " "$"
#define LAL_VCS_IDENT_STATUS "$" "LALStatus: CLEAN: All modifications committed " "$"

/* Header VCS information structure */
static const LALVCSInfo lalVCSInfoHeader = { \
  LAL_NAME, \
  LAL_VERSION, \
  LAL_VCS_ID, \
  LAL_VCS_DATE, \
  LAL_VCS_BRANCH, \
  LAL_VCS_TAG, \
  LAL_VCS_AUTHOR, \
  LAL_VCS_COMMITTER, \
  LAL_VCS_STATUS \
};

#ifdef __cplusplus
}
#endif

#endif /* _LALVCSINFOHEADER_H */

/** \endcond */

/*
 * vim: tw=0 ts=2 et
 */
