/*
 * LALVCSInfo.h - LAL VCS Information Header
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with with program; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 *
 * Copyright (C) 2009-2013 Adam Mercer
 */

#ifndef _LALVCSINFO_H
#define _LALVCSINFO_H

#include <lal/LALLibVCSInfo.h>

#ifdef __cplusplus
extern "C" {
#endif

/* vcs information defines */
#define LAL_NAME "LAL"
#define LAL_VCS_ID "8140347ea6fa4167d17e64e1fe0c0d3d151cf229"
#define LAL_VCS_DATE "2014-01-07 21:41:44 +0000"
#define LAL_VCS_BRANCH "None"
#define LAL_VCS_TAG "lal-v6.12.0"
#define LAL_VCS_AUTHOR "Adam Mercer <adam.mercer@ligo.org>"
#define LAL_VCS_COMMITTER "Adam Mercer <adam.mercer@ligo.org>"
#define LAL_VCS_STATUS "CLEAN: All modifications committed"

/* vcs information defines - identable*/
#define LAL_VCS_IDENT_ID "$" "LALId: 8140347ea6fa4167d17e64e1fe0c0d3d151cf229 " "$"
#define LAL_VCS_IDENT_DATE "$" "LALDate: 2014-01-07 21:41:44 +0000 " "$"
#define LAL_VCS_IDENT_BRANCH "$" "LALBranch: None " "$"
#define LAL_VCS_IDENT_TAG "$" "LALTag: lal-v6.12.0 " "$"
#define LAL_VCS_IDENT_AUTHOR "$" "LALAuthor: Adam Mercer <adam.mercer@ligo.org> " "$"
#define LAL_VCS_IDENT_COMMITTER "$" "LALCommitter: Adam Mercer <adam.mercer@ligo.org> " "$"
#define LAL_VCS_IDENT_STATUS "$" "LALStatus: CLEAN: All modifications committed " "$"

/* header vcs information structure */
static const struct tagLALVCSInfo lalHeaderVCSInfo = { \
  LAL_NAME, \
  LAL_VERSION, \
  LAL_VCS_ID, \
  LAL_VCS_DATE, \
  LAL_VCS_BRANCH, \
  LAL_VCS_TAG, \
  LAL_VCS_AUTHOR, \
  LAL_VCS_COMMITTER, \
  LAL_VCS_STATUS \
};

/*
 * function prototypes
 */

/* function to compare two LALVCSInfo structures */
int XLALVCSInfoCompare(const LALVCSInfo *header, const LALVCSInfo *library);

#ifdef __cplusplus
}
#endif

#endif /* _LALVCSINFO_H */

/*
 * vim: tw=0 ts=2 et
 */
