# Dependencies for the_Foundation
if (NOT IOS)
    find_package (PkgConfig)
    pkg_check_modules (ZLIB zlib)
    pkg_check_modules (PCRE libpcre)    # Regular expressions
    if (TFDN_ENABLE_WEBREQUEST)
        pkg_check_modules (CURL libcurl)
    else ()
        set (CURL_FOUND NO)
        set (iHaveCurl NO)
    endif ()
    if (TFDN_ENABLE_TLSREQUEST)
        pkg_check_modules (OPENSSL eopenssl11)  # BSD
	if (NOT OPENSSL_FOUND)
            pkg_check_modules (OPENSSL openssl)
        endif ()
    else ()
        set (OPENSSL_FOUND NO)
        set (iHaveOpenSSL NO)
    endif ()
    # Unicode text strings
    set (UNISTRING_DIR "" CACHE PATH "Location of libunistring")
    if (UNISTRING_DIR STREQUAL "")
        find_file (UNISTR_H unistr.h PATHS /usr/local/include /opt/homebrew/include)
        if (NOT UNISTR_H)
            message (FATAL_ERROR "Not found: unistr.h from GNU libunistring (set UNISTRING_DIR)")
        endif ()
        get_filename_component (UNISTRING_DIR ${UNISTR_H} PATH)
        get_filename_component (UNISTRING_DIR ${UNISTRING_DIR} PATH)
    endif ()
    if (UNISTRING_DIR STREQUAL "/usr")
        # Default system library.
        set (UNISTRING_LIBRARIES unistring)
    else ()
        set (UNISTRING_INCLUDE_DIRS ${UNISTRING_DIR}/include)
        set (UNISTRING_LIBRARIES -L${UNISTRING_DIR}/lib unistring)
    endif ()
else ()
    if (IOS_DIR STREQUAL "")
        message (FATAL_ERROR "iOS dependencies not found (set IOS_DIR)")
    endif ()
    set (ZLIB_FOUND YES)
    set (ZLIB_LIBRARIES z)
    set (PCRE_FOUND YES)
    set (PCRE_LIBRARIES ${IOS_DIR}/lib/libpcre.a)
    set (PCRE_INCLUDE_DIRS ${IOS_DIR}/include)
    if (TFDN_ENABLE_WEBREQUEST)
        set (CURL_FOUND YES)
        set (CURL_LIBRARIES ${IOS_DIR}/lib/libcurl.a "-framework CoreFoundation" "-framework Security")
        set (CURL_INCLUDE_DIRS ${IOS_DIR}/include)
    else ()
        set (CURL_FOUND NO)
    endif ()
    if (TFDN_ENABLE_TLSREQUEST)
        set (OPENSSL_FOUND YES)
        set (OPENSSL_INCLUDE_DIRS ${IOS_DIR}/include)
        set (OPENSSL_LDFLAGS ${IOS_DIR}/lib/libssl.a;${IOS_DIR}/lib/libcrypto.a)
    else ()
        set (OPENSSL_FOUND NO)
    endif ()
    set (UNISTRING_INCLUDE_DIRS ${IOS_DIR}/include)
    set (UNISTRING_LIBRARIES ${IOS_DIR}/lib/libunistring.a;${IOS_DIR}/lib/libiconv.a)
endif ()

if (ZLIB_FOUND)
    set (iHaveZlib YES)
endif ()
if (PCRE_FOUND)
    set (iHavePcre YES)
endif ()
if (CURL_FOUND)
    set (iHaveCurl YES)
endif ()
if (OPENSSL_FOUND)
    set (iHaveOpenSSL YES)
endif ()

macro (tfdn_link_depends target mode)
    target_include_directories (${target} ${mode}
        ${UNISTRING_INCLUDE_DIRS}
        ${ZLIB_INCLUDE_DIRS}
        ${PCRE_INCLUDE_DIRS}
        ${CURL_INCLUDE_DIRS}
        ${OPENSSL_INCLUDE_DIRS}
    )
    target_link_libraries (${target} ${mode} ${UNISTRING_LIBRARIES} pthread m)
    if (ZLIB_FOUND)
        target_link_libraries (${target} ${mode} ${ZLIB_LIBRARIES})
    endif ()
    if (PCRE_FOUND)
        target_link_libraries (${target} ${mode} ${PCRE_LIBRARIES})
    endif ()
    if (CURL_FOUND)
        target_link_libraries (${target} ${mode} ${CURL_LIBRARIES})
    endif ()
    if (OPENSSL_FOUND)
        target_link_libraries (${target} ${mode} ${OPENSSL_LDFLAGS})
    endif ()
endmacro ()
