# tests for the dss merge query

TITLE + merge

export TZ=EST5EDT

VIEW data ../lsa/data

TEST 01 'basics'
	EXEC -x lsa '{count}' $data/lsa.dat
		OUTPUT - $'586/586'
	EXEC -x lsa '{scan}|{count}' $data/lsa.dat
	EXEC -x lsa '{merge -k time}|{count}' $data/lsa.dat
	EXEC -x lsa '{count}' $data/lsa.dat $data/lsa.dat
		OUTPUT - $'1172/1172'
	EXEC -x lsa '{merge -k time}|{count}' $data/lsa.dat $data/lsa.dat

TEST 02 'details'
	EXEC -x lsa '{merge -k time}|{print "%(time)s %(src_addr)s"}' $data/lsa.dat $data/lsa.dat
		OUTPUT - $'2002-05-29+23:15:10.173998000 10.254.3.35
2002-05-29+23:15:10.173998000 10.254.3.35
2002-05-29+23:15:10.459109000 10.254.3.35
2002-05-29+23:15:10.459109000 10.254.3.35
2002-05-29+23:15:10.459109000 10.254.3.35
2002-05-29+23:15:10.459109000 10.254.3.35
2002-05-29+23:15:10.570374000 10.254.3.35
2002-05-29+23:15:10.570374000 10.254.3.35
2002-05-29+23:15:13.574803000 10.254.3.35
2002-05-29+23:15:13.574803000 10.254.3.35
2002-05-29+23:15:13.648518000 10.254.3.99
2002-05-29+23:15:13.648518000 10.254.3.99
2002-05-29+23:15:14.620845000 10.254.3.99
2002-05-29+23:15:14.620845000 10.254.3.99
2002-05-29+23:15:14.620845000 10.254.3.99
2002-05-29+23:15:14.620845000 10.254.3.99
2002-05-29+23:15:14.620845000 10.254.3.99
2002-05-29+23:15:14.620845000 10.254.3.99
2002-05-29+23:15:14.620845000 10.254.3.99
2002-05-29+23:15:14.620845000 10.254.3.99
2002-05-29+23:15:14.620845000 10.254.3.99
2002-05-29+23:15:14.620845000 10.254.3.99
2002-05-29+23:15:16.670028000 10.254.3.67
2002-05-29+23:15:16.670028000 10.254.3.67
2002-05-29+23:15:16.681613000 10.254.3.94
2002-05-29+23:15:16.681613000 10.254.3.94
2002-05-29+23:15:28.342977000 10.254.1.8
2002-05-29+23:15:28.342977000 10.254.1.8
2002-05-29+23:15:28.342977000 10.254.1.8
2002-05-29+23:15:28.342977000 10.254.1.8
2002-05-29+23:15:28.957688000 10.254.10.24
2002-05-29+23:15:28.957688000 10.254.10.24
2002-05-29+23:15:37.743157000 10.254.3.99
2002-05-29+23:15:37.743157000 10.254.3.99
2002-05-29+23:15:39.140540000 10.254.3.99
2002-05-29+23:15:39.140540000 10.254.3.99
2002-05-29+23:15:39.140540000 10.254.3.99
2002-05-29+23:15:39.140540000 10.254.3.99
2002-05-29+23:15:41.079621000 10.254.3.67
2002-05-29+23:15:41.079621000 10.254.3.67
2002-05-29+23:15:41.096500000 10.254.3.94
2002-05-29+23:15:41.096500000 10.254.3.94
2002-05-29+23:15:44.023196000 10.254.3.109
2002-05-29+23:15:44.023196000 10.254.3.109
2002-05-29+23:15:44.023196000 10.254.3.109
2002-05-29+23:15:44.023196000 10.254.3.109
2002-05-29+23:15:44.023196000 10.254.3.109
2002-05-29+23:15:44.023196000 10.254.3.109
2002-05-29+23:15:44.023196000 10.254.3.109
2002-05-29+23:15:44.023196000 10.254.3.109
2002-05-29+23:15:44.023196000 10.254.3.109
2002-05-29+23:15:44.023196000 10.254.3.109
2002-05-29+23:15:44.035084000 10.254.3.35
2002-05-29+23:15:44.035084000 10.254.3.35
2002-05-29+23:15:45.910553000 10.254.3.67
2002-05-29+23:15:45.910553000 10.254.3.67
2002-05-29+23:15:45.922516000 10.254.3.94
2002-05-29+23:15:45.922516000 10.254.3.94
2002-05-29+23:15:49.989794000 10.254.3.35
2002-05-29+23:15:49.989794000 10.254.3.35
2002-05-29+23:15:54.553693000 10.254.3.99
2002-05-29+23:15:54.553693000 10.254.3.99
2002-05-29+23:15:58.377673000 10.254.3.35
2002-05-29+23:15:58.377673000 10.254.3.35
2002-05-29+23:15:58.386120000 10.254.3.35
2002-05-29+23:15:58.386120000 10.254.3.35
2002-05-29+23:15:58.389279000 10.254.3.35
2002-05-29+23:15:58.389279000 10.254.3.35
2002-05-29+23:15:58.394201000 10.254.3.35
2002-05-29+23:15:58.394201000 10.254.3.35
2002-05-29+23:15:59.630138000 10.254.1.8
2002-05-29+23:15:59.630138000 10.254.1.8
2002-05-29+23:16:03.379815000 10.254.3.35
2002-05-29+23:16:03.379815000 10.254.3.35
2002-05-29+23:16:03.379815000 10.254.3.35
2002-05-29+23:16:03.379815000 10.254.3.35
2002-05-29+23:16:03.379815000 10.254.3.35
2002-05-29+23:16:03.379815000 10.254.3.35
2002-05-29+23:16:03.379815000 10.254.3.35
2002-05-29+23:16:03.379815000 10.254.3.35
2002-05-29+23:16:07.050048000 10.254.3.94
2002-05-29+23:16:07.050048000 10.254.3.94
2002-05-29+23:16:12.172382000 10.254.3.35
2002-05-29+23:16:12.172382000 10.254.3.35
2002-05-29+23:16:32.590827000 10.254.1.8
2002-05-29+23:16:32.590827000 10.254.1.8
2002-05-29+23:16:32.590827000 10.254.1.8
2002-05-29+23:16:32.590827000 10.254.1.8
2002-05-29+23:16:32.590827000 10.254.1.8
2002-05-29+23:16:32.590827000 10.254.1.8
2002-05-29+23:16:32.590827000 10.254.1.8
2002-05-29+23:16:32.590827000 10.254.1.8
2002-05-29+23:16:33.206444000 10.254.3.94
2002-05-29+23:16:33.206444000 10.254.3.94
2002-05-29+23:16:41.240071000 10.254.3.26
2002-05-29+23:16:41.240071000 10.254.3.26
2002-05-29+23:16:54.910583000 10.254.10.24
2002-05-29+23:16:54.910583000 10.254.10.24
2002-05-29+23:16:54.910583000 10.254.10.24
2002-05-29+23:16:54.910583000 10.254.10.24
2002-05-29+23:17:07.285200000 10.254.3.99
2002-05-29+23:17:07.285200000 10.254.3.99
2002-05-29+23:17:07.287637000 10.254.3.99
2002-05-29+23:17:07.287637000 10.254.3.99
2002-05-29+23:17:07.527194000 10.254.3.94
2002-05-29+23:17:07.527194000 10.254.3.94
2002-05-29+23:17:20.410979000 10.254.3.67
2002-05-29+23:17:20.410979000 10.254.3.67
2002-05-29+23:17:20.421970000 10.254.3.94
2002-05-29+23:17:20.421970000 10.254.3.94
2002-05-29+23:17:24.027903000 10.254.3.9
2002-05-29+23:17:24.027903000 10.254.3.9
2002-05-29+23:17:24.134338000 10.254.3.26
2002-05-29+23:17:24.134338000 10.254.3.26
2002-05-29+23:17:38.316611000 10.254.3.35
2002-05-29+23:17:38.316611000 10.254.3.35
2002-05-29+23:17:38.551229000 10.254.3.35
2002-05-29+23:17:38.551229000 10.254.3.35
2002-05-29+23:17:38.557905000 10.254.3.35
2002-05-29+23:17:38.557905000 10.254.3.35
2002-05-29+23:17:38.567153000 10.254.3.35
2002-05-29+23:17:38.567153000 10.254.3.35
2002-05-29+23:17:38.572529000 10.254.3.35
2002-05-29+23:17:38.572529000 10.254.3.35
2002-05-29+23:17:43.324478000 10.254.3.35
2002-05-29+23:17:43.324478000 10.254.3.35
2002-05-29+23:17:43.324478000 10.254.3.35
2002-05-29+23:17:43.324478000 10.254.3.35
2002-05-29+23:17:43.324478000 10.254.3.35
2002-05-29+23:17:43.324478000 10.254.3.35
2002-05-29+23:17:43.324478000 10.254.3.35
2002-05-29+23:17:43.324478000 10.254.3.35
2002-05-29+23:17:54.207952000 10.254.10.24
2002-05-29+23:17:54.207952000 10.254.10.24
2002-05-29+23:17:54.207952000 10.254.10.24
2002-05-29+23:17:54.207952000 10.254.10.24
2002-05-29+23:18:00.453843000 10.254.3.35
2002-05-29+23:18:00.453843000 10.254.3.35
2002-05-29+23:18:00.453843000 10.254.3.35
2002-05-29+23:18:00.453843000 10.254.3.35
2002-05-29+23:18:04.422084000 10.254.3.35
2002-05-29+23:18:04.422084000 10.254.3.35
2002-05-29+23:18:04.422084000 10.254.3.35
2002-05-29+23:18:04.422084000 10.254.3.35
2002-05-29+23:18:04.422084000 10.254.3.35
2002-05-29+23:18:04.422084000 10.254.3.35
2002-05-29+23:18:05.965949000 10.254.1.2
2002-05-29+23:18:05.965949000 10.254.1.2
2002-05-29+23:18:10.561022000 10.254.3.35
2002-05-29+23:18:10.561022000 10.254.3.35
2002-05-29+23:18:11.622887000 10.254.3.35
2002-05-29+23:18:11.622887000 10.254.3.35
2002-05-29+23:18:13.538793000 10.254.3.99
2002-05-29+23:18:13.538793000 10.254.3.99
2002-05-29+23:18:15.380214000 10.254.1.8
2002-05-29+23:18:15.380214000 10.254.1.8
2002-05-29+23:18:15.424662000 10.254.1.2
2002-05-29+23:18:15.424662000 10.254.1.2
2002-05-29+23:18:16.684304000 10.254.3.9
2002-05-29+23:18:16.684304000 10.254.3.9
2002-05-29+23:18:25.200802000 10.254.10.24
2002-05-29+23:18:25.200802000 10.254.10.24
2002-05-29+23:18:25.209708000 10.254.10.24
2002-05-29+23:18:25.209708000 10.254.10.24
2002-05-29+23:18:27.122075000 10.254.3.99
2002-05-29+23:18:27.122075000 10.254.3.99
2002-05-29+23:18:28.289680000 10.254.10.3
2002-05-29+23:18:28.289680000 10.254.10.3
2002-05-29+23:18:50.464869000 10.254.10.3
2002-05-29+23:18:50.464869000 10.254.10.3
2002-05-29+23:18:50.464869000 10.254.10.3
2002-05-29+23:18:50.464869000 10.254.10.3
2002-05-29+23:18:50.467113000 10.254.10.3
2002-05-29+23:18:50.467113000 10.254.10.3
2002-05-29+23:18:50.859628000 10.254.3.99
2002-05-29+23:18:50.859628000 10.254.3.99
2002-05-29+23:18:51.566622000 10.254.10.3
2002-05-29+23:18:51.566622000 10.254.10.3
2002-05-29+23:18:51.570455000 10.254.10.3
2002-05-29+23:18:51.570455000 10.254.10.3
2002-05-29+23:18:52.087960000 10.254.3.35
2002-05-29+23:18:52.087960000 10.254.3.35
2002-05-29+23:18:52.087960000 10.254.3.35
2002-05-29+23:18:52.087960000 10.254.3.35
2002-05-29+23:18:53.572797000 10.254.3.35
2002-05-29+23:18:53.572797000 10.254.3.35
2002-05-29+23:18:58.711342000 10.254.3.35
2002-05-29+23:18:58.711342000 10.254.3.35
2002-05-29+23:18:58.718016000 10.254.3.35
2002-05-29+23:18:58.718016000 10.254.3.35
2002-05-29+23:18:58.721753000 10.254.3.35
2002-05-29+23:18:58.721753000 10.254.3.35
2002-05-29+23:18:58.728054000 10.254.3.35
2002-05-29+23:18:58.728054000 10.254.3.35
2002-05-29+23:19:03.715424000 10.254.3.35
2002-05-29+23:19:03.715424000 10.254.3.35
2002-05-29+23:19:03.715424000 10.254.3.35
2002-05-29+23:19:03.715424000 10.254.3.35
2002-05-29+23:19:03.715424000 10.254.3.35
2002-05-29+23:19:03.715424000 10.254.3.35
2002-05-29+23:19:03.715424000 10.254.3.35
2002-05-29+23:19:03.715424000 10.254.3.35
2002-05-29+23:19:07.391074000 10.254.1.2
2002-05-29+23:19:07.391074000 10.254.1.2
2002-05-29+23:19:22.479771000 10.254.3.94
2002-05-29+23:19:22.479771000 10.254.3.94
2002-05-29+23:19:23.833230000 10.254.3.94
2002-05-29+23:19:23.833230000 10.254.3.94
2002-05-29+23:19:35.395026000 10.254.3.94
2002-05-29+23:19:35.395026000 10.254.3.94
2002-05-29+23:19:39.002869000 10.254.3.9
2002-05-29+23:19:39.002869000 10.254.3.9
2002-05-29+23:19:40.314101000 10.254.3.26
2002-05-29+23:19:40.314101000 10.254.3.26
2002-05-29+23:19:44.694826000 10.254.3.99
2002-05-29+23:19:44.694826000 10.254.3.99
2002-05-29+23:19:44.968722000 10.254.10.3
2002-05-29+23:19:44.968722000 10.254.10.3
2002-05-29+23:19:49.421499000 10.254.3.99
2002-05-29+23:19:49.421499000 10.254.3.99
2002-05-29+23:19:49.421499000 10.254.3.99
2002-05-29+23:19:49.421499000 10.254.3.99
2002-05-29+23:19:49.423660000 10.254.3.99
2002-05-29+23:19:49.423660000 10.254.3.99
2002-05-29+23:19:58.450621000 10.254.3.26
2002-05-29+23:19:58.450621000 10.254.3.26
2002-05-29+23:19:58.450621000 10.254.3.26
2002-05-29+23:19:58.450621000 10.254.3.26
2002-05-29+23:20:09.761507000 10.254.3.26
2002-05-29+23:20:09.761507000 10.254.3.26
2002-05-29+23:20:18.182361000 10.254.3.35
2002-05-29+23:20:18.182361000 10.254.3.35
2002-05-29+23:20:18.217918000 10.254.3.26
2002-05-29+23:20:18.217918000 10.254.3.26
2002-05-29+23:20:18.905322000 10.254.3.67
2002-05-29+23:20:18.905322000 10.254.3.67
2002-05-29+23:20:18.910348000 10.254.3.67
2002-05-29+23:20:18.910348000 10.254.3.67
2002-05-29+23:20:18.910348000 10.254.3.67
2002-05-29+23:20:18.910348000 10.254.3.67
2002-05-29+23:20:18.916731000 10.254.3.94
2002-05-29+23:20:18.916731000 10.254.3.94
2002-05-29+23:20:18.929264000 10.254.3.94
2002-05-29+23:20:18.929264000 10.254.3.94
2002-05-29+23:20:18.929264000 10.254.3.94
2002-05-29+23:20:18.929264000 10.254.3.94
2002-05-29+23:20:27.874379000 10.254.3.99
2002-05-29+23:20:27.874379000 10.254.3.99
2002-05-29+23:20:27.874379000 10.254.3.99
2002-05-29+23:20:27.874379000 10.254.3.99
2002-05-29+23:20:27.874379000 10.254.3.99
2002-05-29+23:20:27.874379000 10.254.3.99
2002-05-29+23:20:27.874379000 10.254.3.99
2002-05-29+23:20:27.874379000 10.254.3.99
2002-05-29+23:20:27.874379000 10.254.3.99
2002-05-29+23:20:27.874379000 10.254.3.99
2002-05-29+23:20:27.874379000 10.254.3.99
2002-05-29+23:20:27.874379000 10.254.3.99
2002-05-29+23:20:27.874379000 10.254.3.99
2002-05-29+23:20:27.874379000 10.254.3.99
2002-05-29+23:20:27.874379000 10.254.3.99
2002-05-29+23:20:27.874379000 10.254.3.99
2002-05-29+23:20:27.874379000 10.254.3.99
2002-05-29+23:20:27.874379000 10.254.3.99
2002-05-29+23:20:27.874379000 10.254.3.99
2002-05-29+23:20:27.874379000 10.254.3.99
2002-05-29+23:20:27.874379000 10.254.3.99
2002-05-29+23:20:27.874379000 10.254.3.99
2002-05-29+23:20:27.874379000 10.254.3.99
2002-05-29+23:20:27.874379000 10.254.3.99
2002-05-29+23:20:27.874379000 10.254.3.99
2002-05-29+23:20:27.874379000 10.254.3.99
2002-05-29+23:20:27.874379000 10.254.3.99
2002-05-29+23:20:27.874379000 10.254.3.99
2002-05-29+23:20:27.874379000 10.254.3.99
2002-05-29+23:20:27.874379000 10.254.3.99
2002-05-29+23:20:27.874379000 10.254.3.99
2002-05-29+23:20:27.874379000 10.254.3.99
2002-05-29+23:20:27.874379000 10.254.3.99
2002-05-29+23:20:27.874379000 10.254.3.99
2002-05-29+23:20:27.874379000 10.254.3.99
2002-05-29+23:20:27.874379000 10.254.3.99
2002-05-29+23:20:27.874379000 10.254.3.99
2002-05-29+23:20:27.874379000 10.254.3.99
2002-05-29+23:20:27.874379000 10.254.3.99
2002-05-29+23:20:27.874379000 10.254.3.99
2002-05-29+23:20:37.593193000 10.254.3.9
2002-05-29+23:20:37.593193000 10.254.3.9
2002-05-29+23:20:38.880719000 10.254.3.35
2002-05-29+23:20:38.880719000 10.254.3.35
2002-05-29+23:20:38.889198000 10.254.3.35
2002-05-29+23:20:38.889198000 10.254.3.35
2002-05-29+23:20:38.891242000 10.254.3.35
2002-05-29+23:20:38.891242000 10.254.3.35
2002-05-29+23:20:38.896569000 10.254.3.35
2002-05-29+23:20:38.896569000 10.254.3.35
2002-05-29+23:20:43.168222000 10.254.10.24
2002-05-29+23:20:43.168222000 10.254.10.24
2002-05-29+23:20:43.168222000 10.254.10.24
2002-05-29+23:20:43.168222000 10.254.10.24
2002-05-29+23:20:43.881611000 10.254.3.35
2002-05-29+23:20:43.881611000 10.254.3.35
2002-05-29+23:20:43.881611000 10.254.3.35
2002-05-29+23:20:43.881611000 10.254.3.35
2002-05-29+23:20:43.881611000 10.254.3.35
2002-05-29+23:20:43.881611000 10.254.3.35
2002-05-29+23:20:43.881611000 10.254.3.35
2002-05-29+23:20:43.881611000 10.254.3.35
2002-05-29+23:20:47.696349000 10.254.3.26
2002-05-29+23:20:47.696349000 10.254.3.26
2002-05-29+23:20:49.362398000 10.254.3.35
2002-05-29+23:20:49.362398000 10.254.3.35
2002-05-29+23:20:52.842437000 10.254.3.26
2002-05-29+23:20:52.842437000 10.254.3.26
2002-05-29+23:20:52.842437000 10.254.3.26
2002-05-29+23:20:52.842437000 10.254.3.26
2002-05-29+23:20:52.842437000 10.254.3.26
2002-05-29+23:20:52.842437000 10.254.3.26
2002-05-29+23:20:52.842437000 10.254.3.26
2002-05-29+23:20:52.842437000 10.254.3.26
2002-05-29+23:20:52.842437000 10.254.3.26
2002-05-29+23:20:52.842437000 10.254.3.26
2002-05-29+23:20:52.842437000 10.254.3.26
2002-05-29+23:20:52.842437000 10.254.3.26
2002-05-29+23:20:52.842437000 10.254.3.26
2002-05-29+23:20:52.842437000 10.254.3.26
2002-05-29+23:20:52.842437000 10.254.3.26
2002-05-29+23:20:52.842437000 10.254.3.26
2002-05-29+23:20:52.842437000 10.254.3.26
2002-05-29+23:20:52.842437000 10.254.3.26
2002-05-29+23:20:52.842437000 10.254.3.26
2002-05-29+23:20:52.842437000 10.254.3.26
2002-05-29+23:20:52.842437000 10.254.3.26
2002-05-29+23:20:52.842437000 10.254.3.26
2002-05-29+23:20:52.842437000 10.254.3.26
2002-05-29+23:20:52.842437000 10.254.3.26
2002-05-29+23:20:52.842437000 10.254.3.26
2002-05-29+23:20:52.842437000 10.254.3.26
2002-05-29+23:20:52.842437000 10.254.3.26
2002-05-29+23:20:52.842437000 10.254.3.26
2002-05-29+23:20:52.842437000 10.254.3.26
2002-05-29+23:20:52.842437000 10.254.3.26
2002-05-29+23:20:52.842437000 10.254.3.26
2002-05-29+23:20:52.842437000 10.254.3.26
2002-05-29+23:20:52.842437000 10.254.3.26
2002-05-29+23:20:52.842437000 10.254.3.26
2002-05-29+23:20:52.854118000 10.254.3.26
2002-05-29+23:20:52.854118000 10.254.3.26
2002-05-29+23:20:52.854118000 10.254.3.26
2002-05-29+23:20:52.854118000 10.254.3.26
2002-05-29+23:20:52.854118000 10.254.3.26
2002-05-29+23:20:52.854118000 10.254.3.26
2002-05-29+23:20:52.854118000 10.254.3.26
2002-05-29+23:20:52.854118000 10.254.3.26
2002-05-29+23:20:52.854118000 10.254.3.26
2002-05-29+23:20:52.854118000 10.254.3.26
2002-05-29+23:20:52.854118000 10.254.3.26
2002-05-29+23:20:52.854118000 10.254.3.26
2002-05-29+23:20:52.854118000 10.254.3.26
2002-05-29+23:20:52.854118000 10.254.3.26
2002-05-29+23:20:52.854118000 10.254.3.26
2002-05-29+23:20:52.854118000 10.254.3.26
2002-05-29+23:20:52.854118000 10.254.3.26
2002-05-29+23:20:52.854118000 10.254.3.26
2002-05-29+23:20:52.854118000 10.254.3.26
2002-05-29+23:20:52.854118000 10.254.3.26
2002-05-29+23:20:52.854118000 10.254.3.26
2002-05-29+23:20:52.854118000 10.254.3.26
2002-05-29+23:20:52.854118000 10.254.3.26
2002-05-29+23:20:52.854118000 10.254.3.26
2002-05-29+23:20:52.854118000 10.254.3.26
2002-05-29+23:20:52.854118000 10.254.3.26
2002-05-29+23:20:52.854118000 10.254.3.26
2002-05-29+23:20:52.854118000 10.254.3.26
2002-05-29+23:20:52.854118000 10.254.3.26
2002-05-29+23:20:52.854118000 10.254.3.26
2002-05-29+23:20:52.901600000 10.254.3.26
2002-05-29+23:20:52.901600000 10.254.3.26
2002-05-29+23:20:52.923436000 10.254.3.9
2002-05-29+23:20:52.923436000 10.254.3.9
2002-05-29+23:20:52.923436000 10.254.3.9
2002-05-29+23:20:52.923436000 10.254.3.9
2002-05-29+23:20:52.923436000 10.254.3.9
2002-05-29+23:20:52.923436000 10.254.3.9
2002-05-29+23:20:52.923436000 10.254.3.9
2002-05-29+23:20:52.923436000 10.254.3.9
2002-05-29+23:20:52.923436000 10.254.3.9
2002-05-29+23:20:52.923436000 10.254.3.9
2002-05-29+23:20:52.923436000 10.254.3.9
2002-05-29+23:20:52.923436000 10.254.3.9
2002-05-29+23:20:52.923436000 10.254.3.9
2002-05-29+23:20:52.923436000 10.254.3.9
2002-05-29+23:20:52.923436000 10.254.3.9
2002-05-29+23:20:52.923436000 10.254.3.9
2002-05-29+23:20:52.923436000 10.254.3.9
2002-05-29+23:20:52.923436000 10.254.3.9
2002-05-29+23:20:52.923436000 10.254.3.9
2002-05-29+23:20:52.923436000 10.254.3.9
2002-05-29+23:20:52.923436000 10.254.3.9
2002-05-29+23:20:52.923436000 10.254.3.9
2002-05-29+23:20:52.923436000 10.254.3.9
2002-05-29+23:20:52.923436000 10.254.3.9
2002-05-29+23:20:52.923436000 10.254.3.9
2002-05-29+23:20:52.923436000 10.254.3.9
2002-05-29+23:20:52.923436000 10.254.3.9
2002-05-29+23:20:52.923436000 10.254.3.9
2002-05-29+23:20:52.923436000 10.254.3.9
2002-05-29+23:20:52.923436000 10.254.3.9
2002-05-29+23:20:52.923436000 10.254.3.9
2002-05-29+23:20:52.923436000 10.254.3.9
2002-05-29+23:20:52.923436000 10.254.3.9
2002-05-29+23:20:52.923436000 10.254.3.9
2002-05-29+23:20:53.002680000 10.254.3.9
2002-05-29+23:20:53.002680000 10.254.3.9
2002-05-29+23:20:53.002680000 10.254.3.9
2002-05-29+23:20:53.002680000 10.254.3.9
2002-05-29+23:20:53.002680000 10.254.3.9
2002-05-29+23:20:53.002680000 10.254.3.9
2002-05-29+23:20:53.002680000 10.254.3.9
2002-05-29+23:20:53.002680000 10.254.3.9
2002-05-29+23:20:53.002680000 10.254.3.9
2002-05-29+23:20:53.002680000 10.254.3.9
2002-05-29+23:20:53.002680000 10.254.3.9
2002-05-29+23:20:53.002680000 10.254.3.9
2002-05-29+23:20:53.002680000 10.254.3.9
2002-05-29+23:20:53.002680000 10.254.3.9
2002-05-29+23:20:53.002680000 10.254.3.9
2002-05-29+23:20:53.002680000 10.254.3.9
2002-05-29+23:20:53.002680000 10.254.3.9
2002-05-29+23:20:53.002680000 10.254.3.9
2002-05-29+23:20:53.002680000 10.254.3.9
2002-05-29+23:20:53.002680000 10.254.3.9
2002-05-29+23:20:53.002680000 10.254.3.9
2002-05-29+23:20:53.002680000 10.254.3.9
2002-05-29+23:20:53.002680000 10.254.3.9
2002-05-29+23:20:53.002680000 10.254.3.9
2002-05-29+23:20:53.002680000 10.254.3.9
2002-05-29+23:20:53.002680000 10.254.3.9
2002-05-29+23:20:53.002680000 10.254.3.9
2002-05-29+23:20:53.002680000 10.254.3.9
2002-05-29+23:20:53.002680000 10.254.3.9
2002-05-29+23:20:53.002680000 10.254.3.9
2002-05-29+23:20:54.101442000 10.254.10.3
2002-05-29+23:20:54.101442000 10.254.10.3
2002-05-29+23:20:54.771995000 10.254.3.67
2002-05-29+23:20:54.771995000 10.254.3.67
2002-05-29+23:20:54.782432000 10.254.3.94
2002-05-29+23:20:54.782432000 10.254.3.94
2002-05-29+23:21:04.891537000 10.254.10.24
2002-05-29+23:21:04.891537000 10.254.10.24
2002-05-29+23:21:04.891537000 10.254.10.24
2002-05-29+23:21:04.891537000 10.254.10.24
2002-05-29+23:21:04.891537000 10.254.10.24
2002-05-29+23:21:04.891537000 10.254.10.24
2002-05-29+23:21:08.386921000 10.254.1.8
2002-05-29+23:21:08.386921000 10.254.1.8
2002-05-29+23:21:13.276501000 10.254.10.3
2002-05-29+23:21:13.276501000 10.254.10.3
2002-05-29+23:21:13.276501000 10.254.10.3
2002-05-29+23:21:13.276501000 10.254.10.3
2002-05-29+23:21:13.276501000 10.254.10.3
2002-05-29+23:21:13.276501000 10.254.10.3
2002-05-29+23:21:13.276501000 10.254.10.3
2002-05-29+23:21:13.276501000 10.254.10.3
2002-05-29+23:21:13.300980000 10.254.10.24
2002-05-29+23:21:13.300980000 10.254.10.24
2002-05-29+23:21:13.300980000 10.254.10.24
2002-05-29+23:21:13.300980000 10.254.10.24
2002-05-29+23:21:13.300980000 10.254.10.24
2002-05-29+23:21:13.300980000 10.254.10.24
2002-05-29+23:21:13.300980000 10.254.10.24
2002-05-29+23:21:13.300980000 10.254.10.24
2002-05-29+23:21:21.556743000 10.254.3.99
2002-05-29+23:21:21.556743000 10.254.3.99
2002-05-29+23:21:21.556743000 10.254.3.99
2002-05-29+23:21:21.556743000 10.254.3.99
2002-05-29+23:21:33.583966000 10.254.3.99
2002-05-29+23:21:33.583966000 10.254.3.99
2002-05-29+23:21:53.702271000 10.254.3.9
2002-05-29+23:21:53.702271000 10.254.3.9
2002-05-29+23:21:57.552330000 10.254.3.99
2002-05-29+23:21:57.552330000 10.254.3.99
2002-05-29+23:22:11.448312000 10.254.3.99
2002-05-29+23:22:11.448312000 10.254.3.99
2002-05-29+23:22:11.448312000 10.254.3.99
2002-05-29+23:22:11.448312000 10.254.3.99
2002-05-29+23:22:11.448312000 10.254.3.99
2002-05-29+23:22:11.448312000 10.254.3.99
2002-05-29+23:22:11.448312000 10.254.3.99
2002-05-29+23:22:11.448312000 10.254.3.99
2002-05-29+23:22:11.449881000 10.254.3.99
2002-05-29+23:22:11.449881000 10.254.3.99
2002-05-29+23:22:12.402368000 10.254.3.99
2002-05-29+23:22:12.402368000 10.254.3.99
2002-05-29+23:22:12.402368000 10.254.3.99
2002-05-29+23:22:12.402368000 10.254.3.99
2002-05-29+23:22:12.402368000 10.254.3.99
2002-05-29+23:22:12.402368000 10.254.3.99
2002-05-29+23:22:12.409564000 10.254.3.99
2002-05-29+23:22:12.409564000 10.254.3.99
2002-05-29+23:22:12.409564000 10.254.3.99
2002-05-29+23:22:12.409564000 10.254.3.99
2002-05-29+23:22:12.409564000 10.254.3.99
2002-05-29+23:22:12.409564000 10.254.3.99
2002-05-29+23:22:12.409564000 10.254.3.99
2002-05-29+23:22:12.409564000 10.254.3.99
2002-05-29+23:22:13.238334000 10.254.3.94
2002-05-29+23:22:13.238334000 10.254.3.94
2002-05-29+23:22:15.140995000 10.254.3.67
2002-05-29+23:22:15.140995000 10.254.3.67
2002-05-29+23:22:15.149364000 10.254.3.94
2002-05-29+23:22:15.149364000 10.254.3.94
2002-05-29+23:22:19.078604000 10.254.3.35
2002-05-29+23:22:19.078604000 10.254.3.35
2002-05-29+23:22:19.087117000 10.254.3.35
2002-05-29+23:22:19.087117000 10.254.3.35
2002-05-29+23:22:19.089241000 10.254.3.35
2002-05-29+23:22:19.089241000 10.254.3.35
2002-05-29+23:22:19.094214000 10.254.3.35
2002-05-29+23:22:19.094214000 10.254.3.35
2002-05-29+23:22:21.801891000 10.254.3.94
2002-05-29+23:22:21.801891000 10.254.3.94
2002-05-29+23:22:21.801891000 10.254.3.94
2002-05-29+23:22:21.801891000 10.254.3.94
2002-05-29+23:22:21.801891000 10.254.3.94
2002-05-29+23:22:21.801891000 10.254.3.94
2002-05-29+23:22:24.081781000 10.254.3.35
2002-05-29+23:22:24.081781000 10.254.3.35
2002-05-29+23:22:24.081781000 10.254.3.35
2002-05-29+23:22:24.081781000 10.254.3.35
2002-05-29+23:22:24.081781000 10.254.3.35
2002-05-29+23:22:24.081781000 10.254.3.35
2002-05-29+23:22:24.081781000 10.254.3.35
2002-05-29+23:22:24.081781000 10.254.3.35
2002-05-29+23:22:26.278815000 10.254.3.67
2002-05-29+23:22:26.278815000 10.254.3.67
2002-05-29+23:22:26.290319000 10.254.3.94
2002-05-29+23:22:26.290319000 10.254.3.94
2002-05-29+23:22:48.088888000 10.254.10.3
2002-05-29+23:22:48.088888000 10.254.10.3
2002-05-29+23:22:49.159093000 10.254.3.99
2002-05-29+23:22:49.159093000 10.254.3.99
2002-05-29+23:22:55.189961000 10.254.3.9
2002-05-29+23:22:55.189961000 10.254.3.9
2002-05-29+23:23:01.853755000 10.254.10.24
2002-05-29+23:23:01.853755000 10.254.10.24
2002-05-29+23:23:01.853755000 10.254.10.24
2002-05-29+23:23:01.853755000 10.254.10.24
2002-05-29+23:23:07.290786000 10.254.3.99
2002-05-29+23:23:07.290786000 10.254.3.99
2002-05-29+23:23:11.435237000 10.254.3.26
2002-05-29+23:23:11.435237000 10.254.3.26
2002-05-29+23:23:16.224654000 10.254.1.2
2002-05-29+23:23:16.224654000 10.254.1.2
2002-05-29+23:23:16.224654000 10.254.1.2
2002-05-29+23:23:16.224654000 10.254.1.2
2002-05-29+23:23:16.224654000 10.254.1.2
2002-05-29+23:23:16.224654000 10.254.1.2
2002-05-29+23:23:16.224654000 10.254.1.2
2002-05-29+23:23:16.224654000 10.254.1.2
2002-05-29+23:23:16.224654000 10.254.1.2
2002-05-29+23:23:16.224654000 10.254.1.2
2002-05-29+23:23:16.224654000 10.254.1.2
2002-05-29+23:23:16.224654000 10.254.1.2
2002-05-29+23:23:16.224654000 10.254.1.2
2002-05-29+23:23:16.224654000 10.254.1.2
2002-05-29+23:23:16.224654000 10.254.1.2
2002-05-29+23:23:16.224654000 10.254.1.2
2002-05-29+23:23:16.224654000 10.254.1.2
2002-05-29+23:23:16.224654000 10.254.1.2
2002-05-29+23:23:16.224654000 10.254.1.2
2002-05-29+23:23:16.224654000 10.254.1.2
2002-05-29+23:23:16.224654000 10.254.1.2
2002-05-29+23:23:16.224654000 10.254.1.2
2002-05-29+23:23:16.224654000 10.254.1.2
2002-05-29+23:23:16.224654000 10.254.1.2
2002-05-29+23:23:16.224654000 10.254.1.2
2002-05-29+23:23:16.224654000 10.254.1.2
2002-05-29+23:23:16.224654000 10.254.1.2
2002-05-29+23:23:16.224654000 10.254.1.2
2002-05-29+23:23:16.224654000 10.254.1.2
2002-05-29+23:23:16.224654000 10.254.1.2
2002-05-29+23:23:16.224654000 10.254.1.2
2002-05-29+23:23:16.224654000 10.254.1.2
2002-05-29+23:23:16.224654000 10.254.1.2
2002-05-29+23:23:16.224654000 10.254.1.2
2002-05-29+23:23:16.224654000 10.254.1.2
2002-05-29+23:23:16.224654000 10.254.1.2
2002-05-29+23:23:16.224654000 10.254.1.2
2002-05-29+23:23:16.224654000 10.254.1.2
2002-05-29+23:23:16.224654000 10.254.1.2
2002-05-29+23:23:16.224654000 10.254.1.2
2002-05-29+23:23:16.224654000 10.254.1.2
2002-05-29+23:23:16.224654000 10.254.1.2
2002-05-29+23:23:16.224654000 10.254.1.2
2002-05-29+23:23:16.224654000 10.254.1.2
2002-05-29+23:23:16.224654000 10.254.1.2
2002-05-29+23:23:16.224654000 10.254.1.2
2002-05-29+23:23:16.224654000 10.254.1.2
2002-05-29+23:23:16.224654000 10.254.1.2
2002-05-29+23:23:16.224654000 10.254.1.2
2002-05-29+23:23:16.224654000 10.254.1.2
2002-05-29+23:23:16.224654000 10.254.1.2
2002-05-29+23:23:16.224654000 10.254.1.2
2002-05-29+23:23:16.224654000 10.254.1.2
2002-05-29+23:23:16.224654000 10.254.1.2
2002-05-29+23:23:22.892531000 10.254.3.26
2002-05-29+23:23:22.892531000 10.254.3.26
2002-05-29+23:23:36.674517000 10.254.3.9
2002-05-29+23:23:36.674517000 10.254.3.9
2002-05-29+23:23:37.379864000 10.254.3.26
2002-05-29+23:23:37.379864000 10.254.3.26
2002-05-29+23:23:37.379864000 10.254.3.26
2002-05-29+23:23:37.379864000 10.254.3.26
2002-05-29+23:23:53.117862000 10.254.3.67
2002-05-29+23:23:53.117862000 10.254.3.67
2002-05-29+23:23:53.129104000 10.254.3.94
2002-05-29+23:23:53.129104000 10.254.3.94
2002-05-29+23:23:54.714680000 10.254.3.26
2002-05-29+23:23:54.714680000 10.254.3.26
2002-05-29+23:23:57.024464000 10.254.10.3
2002-05-29+23:23:57.024464000 10.254.10.3
2002-05-29+23:23:57.740638000 10.254.3.99
2002-05-29+23:23:57.740638000 10.254.3.99
2002-05-29+23:23:59.248079000 10.254.3.35
2002-05-29+23:23:59.248079000 10.254.3.35
2002-05-29+23:23:59.254725000 10.254.3.35
2002-05-29+23:23:59.254725000 10.254.3.35
2002-05-29+23:23:59.259022000 10.254.3.35
2002-05-29+23:23:59.259022000 10.254.3.35
2002-05-29+23:23:59.264012000 10.254.3.35
2002-05-29+23:23:59.264012000 10.254.3.35
2002-05-29+23:24:04.251765000 10.254.3.35
2002-05-29+23:24:04.251765000 10.254.3.35
2002-05-29+23:24:04.251765000 10.254.3.35
2002-05-29+23:24:04.251765000 10.254.3.35
2002-05-29+23:24:04.251765000 10.254.3.35
2002-05-29+23:24:04.251765000 10.254.3.35
2002-05-29+23:24:04.251765000 10.254.3.35
2002-05-29+23:24:04.251765000 10.254.3.35
2002-05-29+23:24:27.466166000 10.254.10.3
2002-05-29+23:24:27.466166000 10.254.10.3
2002-05-29+23:24:27.466166000 10.254.10.3
2002-05-29+23:24:27.466166000 10.254.10.3
2002-05-29+23:24:27.468954000 10.254.10.3
2002-05-29+23:24:27.468954000 10.254.10.3
2002-05-29+23:24:36.298235000 10.254.3.99
2002-05-29+23:24:36.298235000 10.254.3.99
2002-05-29+23:24:41.098149000 10.254.3.94
2002-05-29+23:24:41.098149000 10.254.3.94
2002-05-29+23:24:47.383316000 10.254.3.35
2002-05-29+23:24:47.383316000 10.254.3.35
2002-05-29+23:24:50.411450000 10.254.3.35
2002-05-29+23:24:50.411450000 10.254.3.35
2002-05-29+23:24:50.411450000 10.254.3.35
2002-05-29+23:24:50.411450000 10.254.3.35
2002-05-29+23:24:50.411450000 10.254.3.35
2002-05-29+23:24:50.411450000 10.254.3.35
2002-05-29+23:24:50.411450000 10.254.3.35
2002-05-29+23:24:50.411450000 10.254.3.35
2002-05-29+23:24:55.176723000 10.254.10.24
2002-05-29+23:24:55.176723000 10.254.10.24
2002-05-29+23:24:55.176723000 10.254.10.24
2002-05-29+23:24:55.176723000 10.254.10.24
2002-05-29+23:24:55.288037000 10.254.3.67
2002-05-29+23:24:55.288037000 10.254.3.67
2002-05-29+23:24:55.298476000 10.254.3.94
2002-05-29+23:24:55.298476000 10.254.3.94
2002-05-29+23:24:58.873495000 10.254.3.35
2002-05-29+23:24:58.873495000 10.254.3.35
2002-05-29+23:25:07.228420000 10.254.3.9
2002-05-29+23:25:07.228420000 10.254.3.9
2002-05-29+23:25:11.017254000 10.254.3.35
2002-05-29+23:25:11.017254000 10.254.3.35
2002-05-29+23:25:12.222406000 10.254.3.94
2002-05-29+23:25:12.222406000 10.254.3.94
2002-05-29+23:25:15.341214000 10.254.1.8
2002-05-29+23:25:15.341214000 10.254.1.8
2002-05-29+23:25:16.482439000 10.254.3.67
2002-05-29+23:25:16.482439000 10.254.3.67
2002-05-29+23:25:16.493837000 10.254.3.94
2002-05-29+23:25:16.493837000 10.254.3.94
2002-05-29+23:25:19.411003000 10.254.3.35
2002-05-29+23:25:19.411003000 10.254.3.35
2002-05-29+23:25:19.419506000 10.254.3.35
2002-05-29+23:25:19.419506000 10.254.3.35
2002-05-29+23:25:19.422122000 10.254.3.35
2002-05-29+23:25:19.422122000 10.254.3.35
2002-05-29+23:25:19.427056000 10.254.3.35
2002-05-29+23:25:19.427056000 10.254.3.35
2002-05-29+23:25:20.128680000 10.254.3.67
2002-05-29+23:25:20.128680000 10.254.3.67
2002-05-29+23:25:20.138692000 10.254.3.94
2002-05-29+23:25:20.138692000 10.254.3.94
2002-05-29+23:25:23.229010000 10.254.3.94
2002-05-29+23:25:23.229010000 10.254.3.94
2002-05-29+23:25:24.412871000 10.254.3.35
2002-05-29+23:25:24.412871000 10.254.3.35
2002-05-29+23:25:24.412871000 10.254.3.35
2002-05-29+23:25:24.412871000 10.254.3.35
2002-05-29+23:25:24.412871000 10.254.3.35
2002-05-29+23:25:24.412871000 10.254.3.35
2002-05-29+23:25:24.412871000 10.254.3.35
2002-05-29+23:25:24.412871000 10.254.3.35
2002-05-29+23:25:34.298029000 10.254.3.67
2002-05-29+23:25:34.298029000 10.254.3.67
2002-05-29+23:25:34.308982000 10.254.3.94
2002-05-29+23:25:34.308982000 10.254.3.94
2002-05-29+23:25:34.845246000 10.254.10.3
2002-05-29+23:25:34.845246000 10.254.10.3
2002-05-29+23:25:34.845246000 10.254.10.3
2002-05-29+23:25:34.845246000 10.254.10.3
2002-05-29+23:25:37.248930000 10.254.3.67
2002-05-29+23:25:37.248930000 10.254.3.67
2002-05-29+23:25:37.260399000 10.254.3.94
2002-05-29+23:25:37.260399000 10.254.3.94
2002-05-29+23:25:51.061780000 10.254.10.24
2002-05-29+23:25:51.061780000 10.254.10.24
2002-05-29+23:25:51.069749000 10.254.10.24
2002-05-29+23:25:51.069749000 10.254.10.24
2002-05-29+23:25:56.994728000 10.254.10.3
2002-05-29+23:25:56.994728000 10.254.10.3
2002-05-29+23:25:57.489349000 10.254.3.67
2002-05-29+23:25:57.489349000 10.254.3.67
2002-05-29+23:25:57.489349000 10.254.3.67
2002-05-29+23:25:57.489349000 10.254.3.67
2002-05-29+23:25:57.489349000 10.254.3.67
2002-05-29+23:25:57.489349000 10.254.3.67
2002-05-29+23:25:57.508736000 10.254.3.94
2002-05-29+23:25:57.508736000 10.254.3.94
2002-05-29+23:25:57.508736000 10.254.3.94
2002-05-29+23:25:57.508736000 10.254.3.94
2002-05-29+23:25:57.508736000 10.254.3.94
2002-05-29+23:25:57.508736000 10.254.3.94
2002-05-29+23:26:00.200183000 10.254.3.99
2002-05-29+23:26:00.200183000 10.254.3.99
2002-05-29+23:26:06.947949000 10.254.3.9
2002-05-29+23:26:06.947949000 10.254.3.9
2002-05-29+23:26:09.968783000 10.254.3.35
2002-05-29+23:26:09.968783000 10.254.3.35
2002-05-29+23:26:20.732374000 10.254.10.3
2002-05-29+23:26:20.732374000 10.254.10.3
2002-05-29+23:26:20.732374000 10.254.10.3
2002-05-29+23:26:20.732374000 10.254.10.3
2002-05-29+23:26:20.983122000 10.254.3.99
2002-05-29+23:26:20.983122000 10.254.3.99
2002-05-29+23:26:35.907572000 10.254.3.9
2002-05-29+23:26:35.907572000 10.254.3.9
2002-05-29+23:26:35.907572000 10.254.3.9
2002-05-29+23:26:35.907572000 10.254.3.9
2002-05-29+23:26:35.907572000 10.254.3.9
2002-05-29+23:26:35.907572000 10.254.3.9
2002-05-29+23:26:35.907572000 10.254.3.9
2002-05-29+23:26:35.907572000 10.254.3.9
2002-05-29+23:26:35.907572000 10.254.3.9
2002-05-29+23:26:35.907572000 10.254.3.9
2002-05-29+23:26:35.907572000 10.254.3.9
2002-05-29+23:26:35.907572000 10.254.3.9
2002-05-29+23:26:35.907572000 10.254.3.9
2002-05-29+23:26:35.907572000 10.254.3.9
2002-05-29+23:26:35.907572000 10.254.3.9
2002-05-29+23:26:35.907572000 10.254.3.9
2002-05-29+23:26:35.907572000 10.254.3.9
2002-05-29+23:26:35.907572000 10.254.3.9
2002-05-29+23:26:37.480438000 10.254.3.94
2002-05-29+23:26:37.480438000 10.254.3.94
2002-05-29+23:26:37.480438000 10.254.3.94
2002-05-29+23:26:37.480438000 10.254.3.94
2002-05-29+23:26:37.488024000 10.254.3.94
2002-05-29+23:26:37.488024000 10.254.3.94
2002-05-29+23:26:50.843252000 10.254.3.9
2002-05-29+23:26:50.843252000 10.254.3.9
2002-05-29+23:26:59.589739000 10.254.3.35
2002-05-29+23:26:59.589739000 10.254.3.35
2002-05-29+23:26:59.596456000 10.254.3.35
2002-05-29+23:26:59.596456000 10.254.3.35
2002-05-29+23:26:59.600798000 10.254.3.35
2002-05-29+23:26:59.600798000 10.254.3.35
2002-05-29+23:26:59.605670000 10.254.3.35
2002-05-29+23:26:59.605670000 10.254.3.35
2002-05-29+23:27:03.069569000 10.254.3.26
2002-05-29+23:27:03.069569000 10.254.3.26
2002-05-29+23:27:03.069569000 10.254.3.26
2002-05-29+23:27:03.069569000 10.254.3.26
2002-05-29+23:27:04.420710000 10.254.3.35
2002-05-29+23:27:04.420710000 10.254.3.35
2002-05-29+23:27:04.420710000 10.254.3.35
2002-05-29+23:27:04.420710000 10.254.3.35
2002-05-29+23:27:04.591110000 10.254.3.35
2002-05-29+23:27:04.591110000 10.254.3.35
2002-05-29+23:27:04.591110000 10.254.3.35
2002-05-29+23:27:04.591110000 10.254.3.35
2002-05-29+23:27:04.591110000 10.254.3.35
2002-05-29+23:27:04.591110000 10.254.3.35
2002-05-29+23:27:04.591110000 10.254.3.35
2002-05-29+23:27:04.591110000 10.254.3.35
2002-05-29+23:27:07.582644000 10.254.3.94
2002-05-29+23:27:07.582644000 10.254.3.94
2002-05-29+23:27:09.235266000 10.254.3.99
2002-05-29+23:27:09.235266000 10.254.3.99
2002-05-29+23:27:19.227154000 10.254.3.35
2002-05-29+23:27:19.227154000 10.254.3.35
2002-05-29+23:27:32.206048000 10.254.1.2
2002-05-29+23:27:32.206048000 10.254.1.2
2002-05-29+23:27:43.106840000 10.254.1.8
2002-05-29+23:27:43.106840000 10.254.1.8
2002-05-29+23:27:43.106840000 10.254.1.8
2002-05-29+23:27:43.106840000 10.254.1.8
2002-05-29+23:27:43.106840000 10.254.1.8
2002-05-29+23:27:43.106840000 10.254.1.8
2002-05-29+23:27:43.108953000 10.254.1.8
2002-05-29+23:27:43.108953000 10.254.1.8
2002-05-29+23:27:43.790026000 10.254.3.99
2002-05-29+23:27:43.790026000 10.254.3.99
2002-05-29+23:27:46.765629000 10.254.3.35
2002-05-29+23:27:46.765629000 10.254.3.35
2002-05-29+23:27:50.238254000 10.254.3.35
2002-05-29+23:27:50.238254000 10.254.3.35
2002-05-29+23:27:50.346680000 10.254.3.9
2002-05-29+23:27:50.346680000 10.254.3.9
2002-05-29+23:27:50.902589000 10.254.3.26
2002-05-29+23:27:50.902589000 10.254.3.26
2002-05-29+23:27:55.193142000 10.254.3.67
2002-05-29+23:27:55.193142000 10.254.3.67
2002-05-29+23:27:56.876336000 10.254.1.8
2002-05-29+23:27:56.876336000 10.254.1.8
2002-05-29+23:27:56.876336000 10.254.1.8
2002-05-29+23:27:56.876336000 10.254.1.8
2002-05-29+23:27:56.876336000 10.254.1.8
2002-05-29+23:27:56.876336000 10.254.1.8
2002-05-29+23:27:56.876336000 10.254.1.8
2002-05-29+23:27:56.876336000 10.254.1.8
2002-05-29+23:27:56.876336000 10.254.1.8
2002-05-29+23:27:56.876336000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.905745000 10.254.1.8
2002-05-29+23:27:56.927173000 10.254.1.8
2002-05-29+23:27:56.927173000 10.254.1.8
2002-05-29+23:27:56.927173000 10.254.1.8
2002-05-29+23:27:56.927173000 10.254.1.8
2002-05-29+23:27:56.927173000 10.254.1.8
2002-05-29+23:27:56.927173000 10.254.1.8
2002-05-29+23:27:56.927173000 10.254.1.8
2002-05-29+23:27:56.927173000 10.254.1.8
2002-05-29+23:27:56.927173000 10.254.1.8
2002-05-29+23:27:56.927173000 10.254.1.8
2002-05-29+23:27:56.927173000 10.254.1.8
2002-05-29+23:27:56.927173000 10.254.1.8
2002-05-29+23:27:56.927173000 10.254.1.8
2002-05-29+23:27:56.927173000 10.254.1.8
2002-05-29+23:27:56.927173000 10.254.1.8
2002-05-29+23:27:56.927173000 10.254.1.8
2002-05-29+23:27:56.927173000 10.254.1.8
2002-05-29+23:27:56.927173000 10.254.1.8
2002-05-29+23:27:56.927173000 10.254.1.8
2002-05-29+23:27:56.927173000 10.254.1.8
2002-05-29+23:27:56.927173000 10.254.1.8
2002-05-29+23:27:56.927173000 10.254.1.8
2002-05-29+23:27:56.927173000 10.254.1.8
2002-05-29+23:27:56.927173000 10.254.1.8
2002-05-29+23:27:56.927173000 10.254.1.8
2002-05-29+23:27:56.927173000 10.254.1.8
2002-05-29+23:27:56.927173000 10.254.1.8
2002-05-29+23:27:56.927173000 10.254.1.8
2002-05-29+23:27:56.927173000 10.254.1.8
2002-05-29+23:27:56.927173000 10.254.1.8
2002-05-29+23:27:56.927173000 10.254.1.8
2002-05-29+23:27:56.927173000 10.254.1.8
2002-05-29+23:27:56.927173000 10.254.1.8
2002-05-29+23:27:56.927173000 10.254.1.8
2002-05-29+23:27:56.927173000 10.254.1.8
2002-05-29+23:27:56.927173000 10.254.1.8
2002-05-29+23:27:56.927173000 10.254.1.8
2002-05-29+23:27:56.927173000 10.254.1.8
2002-05-29+23:27:56.927173000 10.254.1.8
2002-05-29+23:27:56.927173000 10.254.1.8
2002-05-29+23:27:56.927173000 10.254.1.8
2002-05-29+23:27:56.927173000 10.254.1.8
2002-05-29+23:27:56.927173000 10.254.1.8
2002-05-29+23:27:56.927173000 10.254.1.8
2002-05-29+23:27:56.927173000 10.254.1.8
2002-05-29+23:27:56.927173000 10.254.1.8
2002-05-29+23:27:56.927173000 10.254.1.8
2002-05-29+23:27:56.927173000 10.254.1.8
2002-05-29+23:27:56.927173000 10.254.1.8
2002-05-29+23:27:56.927173000 10.254.1.8
2002-05-29+23:27:56.927173000 10.254.1.8
2002-05-29+23:27:56.927173000 10.254.1.8
2002-05-29+23:27:56.927173000 10.254.1.8
2002-05-29+23:27:56.927173000 10.254.1.8
2002-05-29+23:27:57.896097000 10.254.1.8
2002-05-29+23:27:57.896097000 10.254.1.8
2002-05-29+23:27:57.896097000 10.254.1.8
2002-05-29+23:27:57.896097000 10.254.1.8
2002-05-29+23:27:57.896097000 10.254.1.8
2002-05-29+23:27:57.896097000 10.254.1.8
2002-05-29+23:27:57.896097000 10.254.1.8
2002-05-29+23:27:57.896097000 10.254.1.8
2002-05-29+23:27:57.896097000 10.254.1.8
2002-05-29+23:27:57.896097000 10.254.1.8
2002-05-29+23:27:57.896097000 10.254.1.8
2002-05-29+23:27:57.896097000 10.254.1.8
2002-05-29+23:27:57.896097000 10.254.1.8
2002-05-29+23:27:57.896097000 10.254.1.8
2002-05-29+23:28:06.023095000 10.254.3.94
2002-05-29+23:28:06.023095000 10.254.3.94
2002-05-29+23:28:17.477696000 10.254.3.35
2002-05-29+23:28:17.477696000 10.254.3.35
2002-05-29+23:28:22.572360000 10.254.3.94
2002-05-29+23:28:22.572360000 10.254.3.94
2002-05-29+23:28:23.811080000 10.254.3.94
2002-05-29+23:28:23.811080000 10.254.3.94
2002-05-29+23:28:23.811080000 10.254.3.94
2002-05-29+23:28:23.811080000 10.254.3.94
2002-05-29+23:28:23.811080000 10.254.3.94
2002-05-29+23:28:23.811080000 10.254.3.94
2002-05-29+23:28:23.811080000 10.254.3.94
2002-05-29+23:28:23.811080000 10.254.3.94
2002-05-29+23:28:26.821795000 10.254.3.67
2002-05-29+23:28:26.821795000 10.254.3.67
2002-05-29+23:28:26.833770000 10.254.3.94
2002-05-29+23:28:26.833770000 10.254.3.94
2002-05-29+23:28:28.761955000 10.254.3.35
2002-05-29+23:28:28.761955000 10.254.3.35
2002-05-29+23:28:28.761955000 10.254.3.35
2002-05-29+23:28:28.761955000 10.254.3.35
2002-05-29+23:28:36.490999000 10.254.3.67
2002-05-29+23:28:36.490999000 10.254.3.67
2002-05-29+23:28:36.501680000 10.254.3.94
2002-05-29+23:28:36.501680000 10.254.3.94
2002-05-29+23:28:39.766555000 10.254.3.35
2002-05-29+23:28:39.766555000 10.254.3.35
2002-05-29+23:28:39.774969000 10.254.3.35
2002-05-29+23:28:39.774969000 10.254.3.35
2002-05-29+23:28:39.778018000 10.254.3.35
2002-05-29+23:28:39.778018000 10.254.3.35
2002-05-29+23:28:39.783417000 10.254.3.35
2002-05-29+23:28:39.783417000 10.254.3.35
2002-05-29+23:28:41.139581000 10.254.3.67
2002-05-29+23:28:41.139581000 10.254.3.67
2002-05-29+23:28:41.139581000 10.254.3.67
2002-05-29+23:28:41.139581000 10.254.3.67
2002-05-29+23:28:41.155446000 10.254.3.94
2002-05-29+23:28:41.155446000 10.254.3.94
2002-05-29+23:28:41.155446000 10.254.3.94
2002-05-29+23:28:41.155446000 10.254.3.94
2002-05-29+23:28:41.536425000 10.254.3.9
2002-05-29+23:28:41.536425000 10.254.3.9
2002-05-29+23:28:44.770018000 10.254.3.35
2002-05-29+23:28:44.770018000 10.254.3.35
2002-05-29+23:28:44.770018000 10.254.3.35
2002-05-29+23:28:44.770018000 10.254.3.35
2002-05-29+23:28:44.770018000 10.254.3.35
2002-05-29+23:28:44.770018000 10.254.3.35
2002-05-29+23:28:44.770018000 10.254.3.35
2002-05-29+23:28:44.770018000 10.254.3.35
2002-05-29+23:28:46.003169000 10.254.3.26
2002-05-29+23:28:46.003169000 10.254.3.26
2002-05-29+23:28:48.367290000 10.254.3.99
2002-05-29+23:28:48.367290000 10.254.3.99
2002-05-29+23:28:48.367290000 10.254.3.99
2002-05-29+23:28:48.367290000 10.254.3.99
2002-05-29+23:28:48.367290000 10.254.3.99
2002-05-29+23:28:48.367290000 10.254.3.99
2002-05-29+23:28:48.367290000 10.254.3.99
2002-05-29+23:28:48.367290000 10.254.3.99
2002-05-29+23:28:48.367290000 10.254.3.99
2002-05-29+23:28:48.367290000 10.254.3.99
2002-05-29+23:28:48.367290000 10.254.3.99
2002-05-29+23:28:48.367290000 10.254.3.99
2002-05-29+23:28:48.367290000 10.254.3.99
2002-05-29+23:28:48.367290000 10.254.3.99
2002-05-29+23:28:48.367290000 10.254.3.99
2002-05-29+23:28:48.367290000 10.254.3.99
2002-05-29+23:28:48.383389000 10.254.3.99
2002-05-29+23:28:48.383389000 10.254.3.99
2002-05-29+23:28:48.383389000 10.254.3.99
2002-05-29+23:28:48.383389000 10.254.3.99
2002-05-29+23:28:48.383389000 10.254.3.99
2002-05-29+23:28:48.383389000 10.254.3.99
2002-05-29+23:28:48.383389000 10.254.3.99
2002-05-29+23:28:48.383389000 10.254.3.99
2002-05-29+23:28:48.383389000 10.254.3.99
2002-05-29+23:28:48.383389000 10.254.3.99
2002-05-29+23:28:48.383389000 10.254.3.99
2002-05-29+23:28:48.383389000 10.254.3.99
2002-05-29+23:28:48.383389000 10.254.3.99
2002-05-29+23:28:48.383389000 10.254.3.99
2002-05-29+23:28:48.383389000 10.254.3.99
2002-05-29+23:28:48.383389000 10.254.3.99
2002-05-29+23:28:48.383389000 10.254.3.99
2002-05-29+23:28:48.383389000 10.254.3.99
2002-05-29+23:28:48.383389000 10.254.3.99
2002-05-29+23:28:48.383389000 10.254.3.99
2002-05-29+23:28:48.383389000 10.254.3.99
2002-05-29+23:28:48.383389000 10.254.3.99
2002-05-29+23:28:48.383389000 10.254.3.99
2002-05-29+23:28:48.383389000 10.254.3.99
2002-05-29+23:28:48.383389000 10.254.3.99
2002-05-29+23:28:48.383389000 10.254.3.99
2002-05-29+23:28:58.080693000 10.254.10.24
2002-05-29+23:28:58.080693000 10.254.10.24
2002-05-29+23:28:58.080693000 10.254.10.24
2002-05-29+23:28:58.080693000 10.254.10.24
2002-05-29+23:29:08.022293000 10.254.3.35
2002-05-29+23:29:08.022293000 10.254.3.35
2002-05-29+23:29:14.486322000 10.254.3.99
2002-05-29+23:29:14.486322000 10.254.3.99
2002-05-29+23:29:21.623514000 10.254.3.26
2002-05-29+23:29:21.623514000 10.254.3.26
2002-05-29+23:29:31.929910000 10.254.3.67
2002-05-29+23:29:31.929910000 10.254.3.67
2002-05-29+23:29:31.940874000 10.254.3.94
2002-05-29+23:29:31.940874000 10.254.3.94
2002-05-29+23:29:31.954677000 10.254.1.8
2002-05-29+23:29:31.954677000 10.254.1.8
2002-05-29+23:29:31.954677000 10.254.1.8
2002-05-29+23:29:31.954677000 10.254.1.8
2002-05-29+23:29:31.954677000 10.254.1.8
2002-05-29+23:29:31.954677000 10.254.1.8
2002-05-29+23:29:31.954677000 10.254.1.8
2002-05-29+23:29:31.954677000 10.254.1.8
2002-05-29+23:29:31.954677000 10.254.1.8
2002-05-29+23:29:31.954677000 10.254.1.8
2002-05-29+23:29:31.962327000 10.254.1.8
2002-05-29+23:29:31.962327000 10.254.1.8
2002-05-29+23:29:31.962327000 10.254.1.8
2002-05-29+23:29:31.962327000 10.254.1.8
2002-05-29+23:29:31.962327000 10.254.1.8
2002-05-29+23:29:31.962327000 10.254.1.8
2002-05-29+23:29:31.962327000 10.254.1.8
2002-05-29+23:29:31.962327000 10.254.1.8
2002-05-29+23:29:31.962327000 10.254.1.8
2002-05-29+23:29:31.962327000 10.254.1.8
2002-05-29+23:29:31.962327000 10.254.1.8
2002-05-29+23:29:31.962327000 10.254.1.8
2002-05-29+23:29:31.962327000 10.254.1.8
2002-05-29+23:29:31.962327000 10.254.1.8
2002-05-29+23:29:36.717830000 10.254.10.24
2002-05-29+23:29:36.717830000 10.254.10.24
2002-05-29+23:29:36.717830000 10.254.10.24
2002-05-29+23:29:36.717830000 10.254.10.24
2002-05-29+23:29:36.728784000 10.254.10.24
2002-05-29+23:29:36.728784000 10.254.10.24
2002-05-29+23:29:42.335099000 10.254.3.35
2002-05-29+23:29:42.335099000 10.254.3.35
2002-05-29+23:29:43.335792000 10.254.3.35
2002-05-29+23:29:43.335792000 10.254.3.35
2002-05-29+23:29:56.683821000 10.254.3.9
2002-05-29+23:29:56.683821000 10.254.3.9
2002-05-29+23:29:56.903042000 10.254.3.9
2002-05-29+23:29:56.903042000 10.254.3.9
2002-05-29+23:29:56.903042000 10.254.3.9
2002-05-29+23:29:56.903042000 10.254.3.9
2002-05-29+23:29:56.903042000 10.254.3.9
2002-05-29+23:29:56.903042000 10.254.3.9
2002-05-29+23:29:56.903042000 10.254.3.9
2002-05-29+23:29:56.903042000 10.254.3.9
2002-05-29+23:29:56.903042000 10.254.3.9
2002-05-29+23:29:56.903042000 10.254.3.9
2002-05-29+23:29:56.903042000 10.254.3.9
2002-05-29+23:29:56.903042000 10.254.3.9
2002-05-29+23:29:56.903042000 10.254.3.9
2002-05-29+23:29:56.903042000 10.254.3.9
2002-05-29+23:29:56.903042000 10.254.3.9
2002-05-29+23:29:56.903042000 10.254.3.9
2002-05-29+23:29:56.903042000 10.254.3.9
2002-05-29+23:29:56.903042000 10.254.3.9
2002-05-29+23:29:56.903042000 10.254.3.9
2002-05-29+23:29:56.903042000 10.254.3.9
2002-05-29+23:29:56.903042000 10.254.3.9
2002-05-29+23:29:56.903042000 10.254.3.9
2002-05-29+23:29:56.903042000 10.254.3.9
2002-05-29+23:29:56.903042000 10.254.3.9
2002-05-29+23:29:56.903042000 10.254.3.9
2002-05-29+23:29:56.903042000 10.254.3.9
2002-05-29+23:29:56.913208000 10.254.3.9
2002-05-29+23:29:56.913208000 10.254.3.9
2002-05-29+23:29:56.913208000 10.254.3.9
2002-05-29+23:29:56.913208000 10.254.3.9
2002-05-29+23:29:56.926790000 10.254.3.26
2002-05-29+23:29:56.926790000 10.254.3.26
2002-05-29+23:29:59.326672000 10.254.3.9
2002-05-29+23:29:59.326672000 10.254.3.9
2002-05-29+23:29:59.331433000 10.254.3.9
2002-05-29+23:29:59.331433000 10.254.3.9
2002-05-29+23:30:00.015200000 10.254.3.35
2002-05-29+23:30:00.015200000 10.254.3.35
2002-05-29+23:30:00.022034000 10.254.3.35
2002-05-29+23:30:00.022034000 10.254.3.35
2002-05-29+23:30:00.025635000 10.254.3.35
2002-05-29+23:30:00.025635000 10.254.3.35
2002-05-29+23:30:00.030594000 10.254.3.35
2002-05-29+23:30:00.030594000 10.254.3.35'
	EXEC -x lsa '{merge -k time -k src_addr}|{print "%(time)s %(src_addr)s"}' $data/lsa.dat $data/lsa.dat
