/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.konan.serialization;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.serialization.IrFileSerializer;
import org.jetbrains.kotlin.backend.common.serialization.IrSerializationSettings;
import org.jetbrains.kotlin.backend.konan.serialization.KonanDeclarationTable;
import org.jetbrains.kotlin.backend.konan.serialization.KonanFakeOverrideClassFilter;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.NativeRuntimeNames;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/backend/konan/serialization/KonanIrFileSerializer;", "Lorg/jetbrains/kotlin/backend/common/serialization/IrFileSerializer;", "settings", "Lorg/jetbrains/kotlin/backend/common/serialization/IrSerializationSettings;", "declarationTable", "Lorg/jetbrains/kotlin/backend/konan/serialization/KonanDeclarationTable;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/serialization/IrSerializationSettings;Lorg/jetbrains/kotlin/backend/konan/serialization/KonanDeclarationTable;)V", "backendSpecificExplicitRoot", "", "node", "Lorg/jetbrains/kotlin/ir/declarations/IrAnnotationContainer;", "backendSpecificSerializeAllMembers", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "ir.serialization.native"})
public class KonanIrFileSerializer
extends IrFileSerializer {
    public KonanIrFileSerializer(@NotNull IrSerializationSettings settings, @NotNull KonanDeclarationTable declarationTable) {
        Intrinsics.checkNotNullParameter(settings, "settings");
        Intrinsics.checkNotNullParameter(declarationTable, "declarationTable");
        super(settings, declarationTable);
    }

    @Override
    public boolean backendSpecificExplicitRoot(@NotNull IrAnnotationContainer node) {
        ClassId classId;
        Intrinsics.checkNotNullParameter(node, "node");
        IrAnnotationContainer irAnnotationContainer = node;
        if (irAnnotationContainer instanceof IrFunction) {
            classId = NativeRuntimeNames.Annotations.INSTANCE.getExportForCppRuntimeClassId();
        } else if (irAnnotationContainer instanceof IrClass) {
            classId = NativeRuntimeNames.Annotations.INSTANCE.getExportTypeInfoClassId();
        } else {
            return false;
        }
        ClassId classId2 = classId;
        return IrUtilsKt.hasAnnotation(node, classId2);
    }

    @Override
    public boolean backendSpecificSerializeAllMembers(@NotNull IrClass irClass) {
        Intrinsics.checkNotNullParameter(irClass, "irClass");
        return !KonanFakeOverrideClassFilter.INSTANCE.needToConstructFakeOverrides(irClass);
    }
}

