/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cfg;

import com.google.common.collect.ImmutableBiMap;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.ElementBase;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartFMap;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.cfg.ControlFlowBuilder;
import org.jetbrains.kotlin.cfg.ControlFlowProcessor;
import org.jetbrains.kotlin.cfg.GenerationTrigger;
import org.jetbrains.kotlin.cfg.Label;
import org.jetbrains.kotlin.cfg.LoopInfo;
import org.jetbrains.kotlin.cfg.WhenChecker;
import org.jetbrains.kotlin.cfg.pseudocode.ControlFlowInstructionsGenerator;
import org.jetbrains.kotlin.cfg.pseudocode.PseudoValue;
import org.jetbrains.kotlin.cfg.pseudocode.Pseudocode;
import org.jetbrains.kotlin.cfg.pseudocode.PseudocodeImpl;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.Instruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.AccessTarget;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.InstructionWithValue;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.MagicKind;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.contracts.description.EventOccurrencesRange;
import org.jetbrains.kotlin.contracts.description.EventOccurrencesRangeKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Named;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.AnonymousFunctionDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtBreakExpression;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtContinueExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationContainer;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDelegatedSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtDoubleColonExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionWithLabel;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFinallySection;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtInitializerList;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtScriptInitializer;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtStatementExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntryWithExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeList;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtThrowExpression;
import org.jetbrains.kotlin.psi.KtTryExpression;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenConditionInRange;
import org.jetbrains.kotlin.psi.KtWhenConditionIsPattern;
import org.jetbrains.kotlin.psi.KtWhenConditionWithExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.KtWhileExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.CompileTimeConstantUtils;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMapping;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatch;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.calls.tower.TowerLevelsKt;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForObject;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.Qualifier;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.receivers.TransientReceiver;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.DoubleColonLHS;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0017\u0018B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u001c\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/cfg/ControlFlowProcessor;", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "<init>", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "builder", "Lorg/jetbrains/kotlin/cfg/ControlFlowBuilder;", "generatePseudocode", "Lorg/jetbrains/kotlin/cfg/pseudocode/Pseudocode;", "subroutine", "Lorg/jetbrains/kotlin/psi/KtElement;", "generate", "eventOccurrencesRange", "Lorg/jetbrains/kotlin/contracts/description/EventOccurrencesRange;", "generateImplicitReturnValue", "", "bodyExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "processLocalDeclaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "CatchFinallyLabels", "CFPVisitor", "cfg"})
public final class ControlFlowProcessor {
    @NotNull
    private final BindingTrace trace;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final ControlFlowBuilder builder;

    public ControlFlowProcessor(@NotNull BindingTrace trace, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter(trace, "trace");
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        this.trace = trace;
        this.languageVersionSettings = languageVersionSettings;
        this.builder = new ControlFlowInstructionsGenerator();
    }

    @NotNull
    public final Pseudocode generatePseudocode(@NotNull KtElement subroutine) {
        Intrinsics.checkNotNullParameter(subroutine, "subroutine");
        Pseudocode pseudocode = this.generate(subroutine, null);
        Intrinsics.checkNotNull(pseudocode, "null cannot be cast to non-null type org.jetbrains.kotlin.cfg.pseudocode.PseudocodeImpl");
        ((PseudocodeImpl)pseudocode).postProcess();
        return pseudocode;
    }

    private final Pseudocode generate(KtElement subroutine, EventOccurrencesRange eventOccurrencesRange) {
        this.builder.enterSubroutine(subroutine, eventOccurrencesRange);
        CFPVisitor cfpVisitor = new CFPVisitor(this.builder);
        if (subroutine instanceof KtDeclarationWithBody && !(subroutine instanceof KtSecondaryConstructor)) {
            List<KtParameter> list = ((KtDeclarationWithBody)subroutine).getValueParameters();
            Intrinsics.checkNotNullExpressionValue(list, "getValueParameters(...)");
            List<KtParameter> valueParameters = list;
            for (KtParameter valueParameter2 : valueParameters) {
                cfpVisitor.generateInstructions(valueParameter2);
            }
            KtExpression bodyExpression = ((KtDeclarationWithBody)subroutine).getBodyExpression();
            if (bodyExpression != null) {
                cfpVisitor.generateInstructions(bodyExpression);
                if (!((KtDeclarationWithBody)subroutine).hasBlockBody()) {
                    this.generateImplicitReturnValue(bodyExpression, subroutine);
                }
            }
        } else {
            cfpVisitor.generateInstructions(subroutine);
        }
        return this.builder.exitSubroutine(subroutine, eventOccurrencesRange);
    }

    private final void generateImplicitReturnValue(KtExpression bodyExpression, KtElement subroutine) {
        CallableDescriptor callableDescriptor = (CallableDescriptor)this.trace.get(BindingContext.DECLARATION_TO_DESCRIPTOR, subroutine);
        if (callableDescriptor == null) {
            return;
        }
        CallableDescriptor subroutineDescriptor = callableDescriptor;
        KotlinType returnType = subroutineDescriptor.getReturnType();
        if (returnType != null && KotlinBuiltIns.isUnit(returnType) && subroutineDescriptor instanceof AnonymousFunctionDescriptor) {
            return;
        }
        PseudoValue pseudoValue = this.builder.getBoundValue(bodyExpression);
        if (pseudoValue == null) {
            return;
        }
        PseudoValue returnValue = pseudoValue;
        this.builder.returnValue(bodyExpression, returnValue, subroutine);
    }

    private final void processLocalDeclaration(KtDeclaration subroutine) {
        Label afterDeclaration = this.builder.createUnboundLabel("after local declaration");
        this.builder.nondeterministicJump(afterDeclaration, subroutine, null);
        this.generate(subroutine, null);
        this.builder.bindLabel(afterDeclaration);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00bd\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004*\u0001\u000f\b\u0082\u0004\u0018\u00002\u00020\u0001:\u0002\u00f0\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u0010\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J1\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u001c\"\u00020\u0013H\u0002\u00a2\u0006\u0002\u0010\u001dJ(\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u00132\u000e\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130 2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J5\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001a2\u0016\u0010\u001b\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00130\u001c\"\u0004\u0018\u00010\u0013H\u0002\u00a2\u0006\u0002\u0010\u001dJ\u001e\u0010!\u001a\u00020\f2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\"0 2\u0006\u0010\u001f\u001a\u00020\"H\u0002J\u001a\u0010#\u001a\u00020\f2\b\u0010\u001b\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001f\u001a\u00020\u0013H\u0002J\u0014\u0010$\u001a\u0004\u0018\u00010\u00172\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\u001e\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00170 2\u000e\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130 H\u0002J\u0018\u0010&\u001a\u00020\f2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0017H\u0002J\u0012\u0010*\u001a\u00020+2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\u0010\u0010,\u001a\u00020+2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010-\u001a\u00020\f2\u0006\u0010.\u001a\u00020/H\u0016J\u0010\u00100\u001a\u00020\f2\u0006\u0010.\u001a\u000201H\u0016J\u0010\u00102\u001a\u00020\f2\u0006\u0010.\u001a\u000203H\u0016J\u0010\u00104\u001a\u00020\f2\u0006\u0010.\u001a\u000205H\u0016J\u0010\u00106\u001a\u00020\f2\u0006\u0010.\u001a\u000207H\u0016J\u0010\u00108\u001a\u00020\f2\u0006\u0010.\u001a\u000209H\u0016J\u0010\u0010:\u001a\u00020\f2\u0006\u0010.\u001a\u00020;H\u0016J\u0010\u0010<\u001a\u00020\f2\u0006\u0010.\u001a\u00020;H\u0002J\u001a\u0010=\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170>2\b\u0010?\u001a\u0004\u0018\u00010\u0017H\u0002J\u001a\u0010@\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170>2\b\u0010.\u001a\u0004\u0018\u00010\"H\u0002J\u0010\u0010A\u001a\u00020\f2\u0006\u0010.\u001a\u00020;H\u0002J*\u0010B\u001a\u00020\f2\b\u0010C\u001a\u0004\u0018\u00010\"2\u000e\u0010D\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170>2\u0006\u0010E\u001a\u00020\"H\u0002J(\u0010F\u001a\u00020\f2\u0006\u0010C\u001a\u00020G2\u000e\u0010D\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170>2\u0006\u0010E\u001a\u00020\"H\u0002J2\u0010H\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020J0I2\u000e\u0010D\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170>2\f\u0010K\u001a\b\u0012\u0004\u0012\u00020M0LH\u0002J\u001e\u0010N\u001a\u00020\f2\u0006\u0010O\u001a\u00020G2\f\u0010P\u001a\b\u0012\u0002\b\u0003\u0018\u00010LH\u0002J\u0010\u0010Q\u001a\u00020\f2\u0006\u0010O\u001a\u00020GH\u0002J\u0016\u0010R\u001a\b\u0012\u0004\u0012\u00020\"0 2\u0006\u0010O\u001a\u00020GH\u0002J\u0010\u0010S\u001a\u00020\f2\u0006\u0010.\u001a\u00020TH\u0016J\u0010\u0010U\u001a\u00020V2\u0006\u0010W\u001a\u00020XH\u0002J\u0010\u0010Y\u001a\u00020\f2\u0006\u0010.\u001a\u00020ZH\u0016J\u0010\u0010[\u001a\u00020\f2\u0006\u0010.\u001a\u00020\\H\u0016J\u0012\u0010]\u001a\u0004\u0018\u00010^2\u0006\u0010.\u001a\u00020\\H\u0002J\u0010\u0010_\u001a\u00020\f2\u0006\u0010.\u001a\u00020`H\u0016J\u0010\u0010a\u001a\u00020\f2\u0006\u0010.\u001a\u00020bH\u0016J\u0010\u0010c\u001a\u00020\f2\u0006\u0010.\u001a\u00020dH\u0016J,\u0010e\u001a\u00020\f2\b\u0010f\u001a\u0004\u0018\u00010\"2\u0018\u0010g\u001a\u0014\u0012\u0004\u0012\u00020\"\u0012\n\u0012\b\u0012\u0004\u0012\u00020M0L0hH\u0002J\u0010\u0010i\u001a\u00020\f2\u0006\u0010.\u001a\u00020dH\u0002J\u0010\u0010j\u001a\u00020\f2\u0006\u0010.\u001a\u00020dH\u0002J\u0010\u0010k\u001a\u00020\f2\u0006\u0010.\u001a\u00020lH\u0016J\u0010\u0010m\u001a\u00020\f2\u0006\u0010.\u001a\u00020nH\u0016J\u0012\u0010o\u001a\u0004\u0018\u00010p2\u0006\u0010.\u001a\u00020\"H\u0002J\u0012\u0010q\u001a\u0004\u0018\u00010p2\u0006\u0010.\u001a\u00020\"H\u0002J\u0012\u0010r\u001a\u0004\u0018\u00010p2\u0006\u0010.\u001a\u00020sH\u0002J\u0010\u0010t\u001a\u00020V2\u0006\u0010u\u001a\u00020vH\u0002J\u0018\u0010w\u001a\u00020V2\u0006\u0010x\u001a\u00020s2\u0006\u0010y\u001a\u00020zH\u0002J\u0018\u0010{\u001a\u00020V2\u0006\u0010x\u001a\u00020s2\u0006\u0010y\u001a\u00020pH\u0002J\u0010\u0010|\u001a\u00020\f2\u0006\u0010.\u001a\u00020vH\u0016J\u0018\u0010}\u001a\u00020\f2\u0006\u0010u\u001a\u00020v2\u0006\u0010~\u001a\u00020\u0013H\u0002J\u0012\u0010\u007f\u001a\u00020\f2\b\u0010\u0080\u0001\u001a\u00030\u0081\u0001H\u0016J\u0013\u0010\u0082\u0001\u001a\u00020\u00172\b\u0010\u0080\u0001\u001a\u00030\u0081\u0001H\u0002J\u0012\u0010\u0083\u0001\u001a\u00020\f2\u0007\u0010.\u001a\u00030\u0084\u0001H\u0016J\u0012\u0010\u0085\u0001\u001a\u00020V2\u0007\u0010.\u001a\u00030\u0084\u0001H\u0002J!\u0010\u0086\u0001\u001a\u00020\f2\b\u0010\u0087\u0001\u001a\u00030\u0088\u00012\f\b\u0002\u0010\u0089\u0001\u001a\u0005\u0018\u00010\u008a\u0001H\u0002J\u001d\u0010\u008b\u0001\u001a\u00020\f2\b\u0010\u008c\u0001\u001a\u00030\u0088\u00012\b\u0010\u0089\u0001\u001a\u00030\u008a\u0001H\u0002J\u0013\u0010\u008d\u0001\u001a\u00020\f2\b\u0010\u0087\u0001\u001a\u00030\u008e\u0001H\u0016J\u0013\u0010\u008f\u0001\u001a\u00020\f2\b\u0010\u0090\u0001\u001a\u00030\u0091\u0001H\u0016J\u0012\u0010\u0092\u0001\u001a\u00020\f2\u0007\u0010.\u001a\u00030\u0093\u0001H\u0016J\u0012\u0010\u0094\u0001\u001a\u00020\f2\u0007\u0010.\u001a\u00030\u0095\u0001H\u0016J\u0013\u0010\u0096\u0001\u001a\u0004\u0018\u00010\"2\u0006\u0010.\u001a\u00020\"H\u0002J\u0013\u0010\u0097\u0001\u001a\u00020\f2\b\u0010\u0098\u0001\u001a\u00030\u0099\u0001H\u0016J\u0012\u0010\u009a\u0001\u001a\u00020\f2\u0007\u0010'\u001a\u00030\u009b\u0001H\u0016J\u001b\u0010\u009a\u0001\u001a\u00020\f2\u0007\u0010'\u001a\u00030\u009b\u00012\u0007\u0010\u009c\u0001\u001a\u00020VH\u0002J\u0013\u0010\u009d\u0001\u001a\u00020\f2\b\u0010\u009e\u0001\u001a\u00030\u009f\u0001H\u0016J\u0012\u0010\u00a0\u0001\u001a\u00020\f2\u0007\u0010.\u001a\u00030\u00a1\u0001H\u0016J\t\u0010\u00a2\u0001\u001a\u00020\fH\u0002J\u0012\u0010\u00a3\u0001\u001a\u00020\f2\u0007\u0010.\u001a\u00030\u00a4\u0001H\u0016J\u0011\u0010\u00a5\u0001\u001a\u00020\f2\u0006\u0010.\u001a\u00020GH\u0016J\u0012\u0010\u00a6\u0001\u001a\u00020\f2\u0007\u0010.\u001a\u00030\u00a7\u0001H\u0016J\u0012\u0010\u00a8\u0001\u001a\u00020\f2\u0007\u0010.\u001a\u00030\u00a9\u0001H\u0016J\u0012\u0010\u00aa\u0001\u001a\u00020\f2\u0007\u0010.\u001a\u00030\u00ab\u0001H\u0016J\u0013\u0010\u00ac\u0001\u001a\u00020\f2\b\u0010\u00ad\u0001\u001a\u00030\u00ae\u0001H\u0016J\u0012\u0010\u00af\u0001\u001a\u00020\f2\u0007\u0010.\u001a\u00030\u00b0\u0001H\u0016J\u0013\u0010\u00b1\u0001\u001a\u00020\f2\b\u0010\u00b2\u0001\u001a\u00030\u00b3\u0001H\u0016J\u0013\u0010\u00b4\u0001\u001a\u00020\f2\b\u0010\u00b5\u0001\u001a\u00030\u00b6\u0001H\u0016J\u0013\u0010\u00b7\u0001\u001a\u00020\f2\b\u0010\u00b8\u0001\u001a\u00030\u00b9\u0001H\u0002J\u0013\u0010\u00ba\u0001\u001a\u00020\f2\b\u0010\u00b8\u0001\u001a\u00030\u00bb\u0001H\u0002J\u0013\u0010\u00bc\u0001\u001a\u00020\f2\b\u0010\u00bd\u0001\u001a\u00030\u00b9\u0001H\u0002J\u0013\u0010\u00be\u0001\u001a\u00020\f2\b\u0010\u00bf\u0001\u001a\u00030\u00c0\u0001H\u0016J\u0013\u0010\u00c1\u0001\u001a\u00020\f2\b\u0010\u00c2\u0001\u001a\u00030\u00c3\u0001H\u0016J\u0013\u0010\u00c4\u0001\u001a\u00020\f2\b\u0010\u00b8\u0001\u001a\u00030\u00b9\u0001H\u0002J\u0019\u0010\u00c5\u0001\u001a\u00020\f2\u000e\u0010\u00c6\u0001\u001a\t\u0012\u0005\u0012\u00030\u0081\u00010 H\u0002J\u0013\u0010\u00c7\u0001\u001a\u00020\f2\b\u0010\u00c8\u0001\u001a\u00030\u00c9\u0001H\u0016J\u0013\u0010\u00ca\u0001\u001a\u00020\f2\b\u0010\u00cb\u0001\u001a\u00030\u00cc\u0001H\u0016J\u0013\u0010\u00cd\u0001\u001a\u00020\f2\b\u0010\u00ce\u0001\u001a\u00030\u00cf\u0001H\u0016J\u0013\u0010\u00d0\u0001\u001a\u00020\f2\b\u0010\u00cb\u0001\u001a\u00030\u00d1\u0001H\u0002J\u0013\u0010\u00d2\u0001\u001a\u00020\f2\b\u0010\u00d3\u0001\u001a\u00030\u00d4\u0001H\u0016J\u0013\u0010\u00d5\u0001\u001a\u00020\f2\b\u0010\u00d3\u0001\u001a\u00030\u00d6\u0001H\u0016J\u0013\u0010\u00d7\u0001\u001a\u00020\f2\b\u0010\u00ce\u0001\u001a\u00030\u00d8\u0001H\u0016J\u0013\u0010\u00d9\u0001\u001a\u00020\f2\b\u0010\u00da\u0001\u001a\u00030\u00db\u0001H\u0016J\u0012\u0010\u00dc\u0001\u001a\u00020\f2\u0007\u0010.\u001a\u00030\u00dd\u0001H\u0016J\u0011\u0010\u00de\u0001\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001b\u0010\u00df\u0001\u001a\u00020V2\u0006\u0010.\u001a\u00020\"2\b\u0010\u00e0\u0001\u001a\u00030\u00e1\u0001H\u0002J\u0012\u0010\u00e2\u0001\u001a\u00020V2\u0007\u0010\u00e3\u0001\u001a\u00020\u0013H\u0002J\u0017\u0010\u00e4\u0001\u001a\u00020V2\f\u0010P\u001a\b\u0012\u0002\b\u0003\u0018\u00010LH\u0002J\u0016\u0010\u00e2\u0001\u001a\u00030\u00e5\u00012\n\u0010P\u001a\u0006\u0012\u0002\b\u00030LH\u0002J#\u0010\u00e6\u0001\u001a\u0010\u0012\u0004\u0012\u00020\u0017\u0012\u0005\u0012\u00030\u00e8\u00010\u00e7\u00012\n\u0010P\u001a\u0006\u0012\u0002\b\u00030LH\u0002JA\u0010\u00e6\u0001\u001a\u000f\u0012\u0004\u0012\u00020\u0017\u0012\u0005\u0012\u00030\u00e8\u00010I2\u0007\u0010\u00e3\u0001\u001a\u00020\u00132\n\u0010\u00e9\u0001\u001a\u0005\u0018\u00010\u00e8\u00012\u0014\u0010\u00ea\u0001\u001a\u000f\u0012\u0004\u0012\u00020\u0017\u0012\u0005\u0012\u00030\u00e8\u00010IH\u0002J=\u0010\u00eb\u0001\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020J0I2\b\u0010\u00ec\u0001\u001a\u00030\u00ed\u00012\u0007\u0010\u00ee\u0001\u001a\u00020J2\u0013\u0010\u00ef\u0001\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020J0IH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\t\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\r0\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010\u00a8\u0006\u00f1\u0001"}, d2={"Lorg/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor;", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "builder", "Lorg/jetbrains/kotlin/cfg/ControlFlowBuilder;", "<init>", "(Lorg/jetbrains/kotlin/cfg/ControlFlowProcessor;Lorg/jetbrains/kotlin/cfg/ControlFlowBuilder;)V", "catchFinallyStack", "Ljava/util/Stack;", "Lorg/jetbrains/kotlin/cfg/ControlFlowProcessor$CatchFinallyLabels;", "deferredGeneratorsStack", "", "Lkotlin/Function1;", "", "Lorg/jetbrains/kotlin/cfg/DeferredGenerator;", "conditionVisitor", "org/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor$conditionVisitor$1", "Lorg/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor$conditionVisitor$1;", "mark", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "generateInstructions", "checkNothingType", "createSyntheticValue", "Lorg/jetbrains/kotlin/cfg/pseudocode/PseudoValue;", "instructionElement", "kind", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/eval/MagicKind;", "from", "", "(Lorg/jetbrains/kotlin/psi/KtElement;Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/eval/MagicKind;[Lorg/jetbrains/kotlin/psi/KtElement;)Lorg/jetbrains/kotlin/cfg/pseudocode/PseudoValue;", "createNonSyntheticValue", "to", "", "mergeValues", "Lorg/jetbrains/kotlin/psi/KtExpression;", "copyValue", "getBoundOrUnreachableValue", "elementsToValues", "generateInitializer", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "initValue", "getResolvedCallAccessTarget", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/eval/AccessTarget;", "getDeclarationAccessTarget", "visitParenthesizedExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtParenthesizedExpression;", "visitAnnotatedExpression", "Lorg/jetbrains/kotlin/psi/KtAnnotatedExpression;", "visitThisExpression", "Lorg/jetbrains/kotlin/psi/KtThisExpression;", "visitConstantExpression", "Lorg/jetbrains/kotlin/psi/KtConstantExpression;", "visitSimpleNameExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "visitLabeledExpression", "Lorg/jetbrains/kotlin/psi/KtLabeledExpression;", "visitBinaryExpression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "generateBooleanOperation", "getValueAsFunction", "Lkotlin/Function0;", "value", "getDeferredValue", "generateBothArgumentsAndMark", "visitAssignment", "lhs", "rhsDeferredValue", "parentExpression", "generateArrayAssignment", "Lorg/jetbrains/kotlin/psi/KtArrayAccessExpression;", "getArraySetterArguments", "Lcom/intellij/util/SmartFMap;", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "setResolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "generateArrayAccess", "arrayAccessExpression", "resolvedCall", "generateArrayAccessWithoutCall", "generateArrayAccessArguments", "visitUnaryExpression", "Lorg/jetbrains/kotlin/psi/KtUnaryExpression;", "isIncrementOrDecrement", "", "operationType", "Lcom/intellij/psi/tree/IElementType;", "visitIfExpression", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "visitTryExpression", "Lorg/jetbrains/kotlin/psi/KtTryExpression;", "generateTryAndCatches", "Lorg/jetbrains/kotlin/cfg/Label;", "visitWhileExpression", "Lorg/jetbrains/kotlin/psi/KtWhileExpression;", "visitDoWhileExpression", "Lorg/jetbrains/kotlin/psi/KtDoWhileExpression;", "visitForExpression", "Lorg/jetbrains/kotlin/psi/KtForExpression;", "generateLoopConventionCall", "loopRange", "callSlice", "Lorg/jetbrains/kotlin/util/slicedMap/ReadOnlySlice;", "declareLoopParameter", "writeLoopParameterAssignment", "visitBreakExpression", "Lorg/jetbrains/kotlin/psi/KtBreakExpression;", "visitContinueExpression", "Lorg/jetbrains/kotlin/psi/KtContinueExpression;", "getNearestLoopExpression", "Lorg/jetbrains/kotlin/psi/KtLoopExpression;", "getCorrespondingLoopWithoutLabel", "getCorrespondingLoop", "Lorg/jetbrains/kotlin/psi/KtExpressionWithLabel;", "returnCrossesTryCatchBoundary", "returnExpression", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "jumpCrossesTryCatchBoundary", "jumpExpression", "jumpTarget", "Lcom/intellij/psi/PsiElement;", "jumpDoesNotCrossFunctionBoundary", "visitReturnExpression", "checkReturnLabelTarget", "labeledElement", "visitParameter", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "computePseudoValueForParameter", "visitBlockExpression", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "isBlockInDoWhile", "visitFunction", "function", "Lorg/jetbrains/kotlin/psi/KtFunction;", "eventOccurrencesRange", "Lorg/jetbrains/kotlin/contracts/description/EventOccurrencesRange;", "visitInlinedFunction", "lambdaFunctionLiteral", "visitNamedFunction", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "visitLambdaExpression", "lambdaExpression", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "visitQualifiedExpression", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "visitCallExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "generateAndGetReceiverIfAny", "visitProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "visitDestructuringDeclaration", "Lorg/jetbrains/kotlin/psi/KtDestructuringDeclaration;", "generateWriteForEntries", "visitPropertyAccessor", "accessor", "Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;", "visitBinaryWithTypeRHSExpression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpressionWithTypeRHS;", "generateJumpsToCatchAndFinally", "visitThrowExpression", "Lorg/jetbrains/kotlin/psi/KtThrowExpression;", "visitArrayAccessExpression", "visitIsExpression", "Lorg/jetbrains/kotlin/psi/KtIsExpression;", "visitWhenExpression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "visitObjectLiteralExpression", "Lorg/jetbrains/kotlin/psi/KtObjectLiteralExpression;", "visitObjectDeclaration", "objectDeclaration", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "visitStringTemplateExpression", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "visitTypeProjection", "typeProjection", "Lorg/jetbrains/kotlin/psi/KtTypeProjection;", "visitAnonymousInitializer", "classInitializer", "Lorg/jetbrains/kotlin/psi/KtAnonymousInitializer;", "generateHeaderDelegationSpecifiers", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "generateInitializersForClassOrObject", "Lorg/jetbrains/kotlin/psi/KtDeclarationContainer;", "processEntryOrObject", "entryOrObject", "visitClass", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "visitScript", "script", "Lorg/jetbrains/kotlin/psi/KtScript;", "generateDeclarationForLocalClassOrObjectIfNeeded", "processParameters", "parameters", "visitSecondaryConstructor", "constructor", "Lorg/jetbrains/kotlin/psi/KtSecondaryConstructor;", "visitSuperTypeCallEntry", "call", "Lorg/jetbrains/kotlin/psi/KtSuperTypeCallEntry;", "visitInitializerList", "list", "Lorg/jetbrains/kotlin/psi/KtInitializerList;", "generateCallOrMarkUnresolved", "Lorg/jetbrains/kotlin/psi/KtCallElement;", "visitDelegatedSuperTypeEntry", "specifier", "Lorg/jetbrains/kotlin/psi/KtDelegatedSuperTypeEntry;", "visitSuperTypeEntry", "Lorg/jetbrains/kotlin/psi/KtSuperTypeEntry;", "visitSuperTypeList", "Lorg/jetbrains/kotlin/psi/KtSuperTypeList;", "visitKtFile", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "visitDoubleColonExpression", "Lorg/jetbrains/kotlin/psi/KtDoubleColonExpression;", "visitKtElement", "generateQualifier", "qualifier", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/Qualifier;", "generateCall", "callElement", "checkAndGenerateCall", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/eval/InstructionWithValue;", "getReceiverValues", "", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "receiver", "receiverValuesArg", "generateValueArgument", "valueArgument", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "parameterDescriptor", "parameterValuesArg", "FinallyBlockGenerator", "cfg"})
    @SourceDebugExtension(value={"SMAP\nControlFlowProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ControlFlowProcessor.kt\norg/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,1701:1\n1#2:1702\n1#2:1713\n1#2:1739\n1611#3,9:1703\n1863#3:1712\n1864#3:1714\n1620#3:1715\n1454#3,5:1716\n1863#3,2:1724\n1611#3,9:1729\n1863#3:1738\n1864#3:1740\n1620#3:1741\n1863#3,2:1742\n142#4:1721\n154#4:1726\n158#4:1727\n154#4:1728\n1251#5,2:1722\n*S KotlinDebug\n*F\n+ 1 ControlFlowProcessor.kt\norg/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor\n*L\n228#1:1713\n1501#1:1739\n228#1:1703,9\n228#1:1712\n228#1:1714\n228#1:1715\n481#1:1716,5\n1417#1:1724,2\n1501#1:1729,9\n1501#1:1738\n1501#1:1740\n1501#1:1741\n1606#1:1742,2\n863#1:1721\n1435#1:1726\n1436#1:1727\n1437#1:1728\n939#1:1722,2\n*E\n"})
    private final class CFPVisitor
    extends KtVisitorVoid {
        @NotNull
        private final ControlFlowBuilder builder;
        @NotNull
        private final Stack<CatchFinallyLabels> catchFinallyStack;
        @NotNull
        private final Stack<List<Function1<ControlFlowBuilder, Unit>>> deferredGeneratorsStack;
        @NotNull
        private final conditionVisitor.1 conditionVisitor;

        public CFPVisitor(ControlFlowBuilder builder) {
            Intrinsics.checkNotNullParameter(builder, "builder");
            this.builder = builder;
            this.catchFinallyStack = new Stack();
            this.deferredGeneratorsStack = new Stack();
            this.conditionVisitor = new KtVisitorVoid(this){
                final /* synthetic */ CFPVisitor this$0;
                {
                    this.this$0 = $receiver;
                }

                private final KtExpression getSubjectExpression(KtWhenCondition condition) {
                    PsiElement $this$getStrictParentOfType$iv = condition;
                    boolean $i$f$getStrictParentOfType = false;
                    KtWhenExpression ktWhenExpression = PsiTreeUtil.getParentOfType($this$getStrictParentOfType$iv, KtWhenExpression.class, true);
                    return ktWhenExpression != null ? ktWhenExpression.getSubjectExpression() : null;
                }

                public void visitWhenConditionInRange(KtWhenConditionInRange condition) {
                    Intrinsics.checkNotNullParameter(condition, "condition");
                    KtOperationReferenceExpression ktOperationReferenceExpression = condition.getOperationReference();
                    Intrinsics.checkNotNullExpressionValue(ktOperationReferenceExpression, "getOperationReference(...)");
                    if (!CFPVisitor.access$generateCall(this.this$0, ktOperationReferenceExpression)) {
                        KtExpression rangeExpression = condition.getRangeExpression();
                        this.this$0.generateInstructions(rangeExpression);
                        KtElement[] ktElementArray = new KtElement[]{rangeExpression};
                        CFPVisitor.access$createNonSyntheticValue(this.this$0, condition, MagicKind.UNRESOLVED_CALL, ktElementArray);
                    }
                }

                public void visitWhenConditionIsPattern(KtWhenConditionIsPattern condition) {
                    Intrinsics.checkNotNullParameter(condition, "condition");
                    CFPVisitor.access$mark(this.this$0, condition);
                    KtElement[] ktElementArray = new KtElement[]{this.getSubjectExpression(condition)};
                    CFPVisitor.access$createNonSyntheticValue(this.this$0, condition, MagicKind.IS, ktElementArray);
                }

                public void visitWhenConditionWithExpression(KtWhenConditionWithExpression condition) {
                    Intrinsics.checkNotNullParameter(condition, "condition");
                    CFPVisitor.access$mark(this.this$0, condition);
                    KtExpression expression2 = condition.getExpression();
                    this.this$0.generateInstructions(expression2);
                    KtExpression subjectExpression = this.getSubjectExpression(condition);
                    if (subjectExpression != null) {
                        KtElement[] ktElementArray = new KtElement[]{subjectExpression, expression2};
                        CFPVisitor.access$createNonSyntheticValue(this.this$0, condition, MagicKind.EQUALS_IN_WHEN_CONDITION, ktElementArray);
                    } else {
                        CFPVisitor.access$copyValue(this.this$0, expression2, condition);
                    }
                }

                public void visitKtElement(KtElement element) {
                    Intrinsics.checkNotNullParameter(element, "element");
                    throw new UnsupportedOperationException("[ControlFlowProcessor] " + element);
                }
            };
        }

        private final void mark(KtElement element) {
            this.builder.mark(element);
        }

        public final void generateInstructions(@Nullable KtElement element) {
            if (element == null) {
                return;
            }
            element.accept(this);
            this.checkNothingType(element);
        }

        private final void checkNothingType(KtElement element) {
            if (!(element instanceof KtExpression)) {
                return;
            }
            KtExpression ktExpression = KtPsiUtil.deparenthesize((KtExpression)element);
            if (ktExpression == null) {
                return;
            }
            KtExpression expression2 = ktExpression;
            if (expression2 instanceof KtStatementExpression || expression2 instanceof KtTryExpression || expression2 instanceof KtIfExpression || expression2 instanceof KtWhenExpression) {
                return;
            }
            KotlinType type2 = ControlFlowProcessor.this.trace.getBindingContext().getType(expression2);
            if (type2 != null && KotlinBuiltIns.isNothing(type2)) {
                this.builder.jumpToError(expression2);
            }
        }

        private final PseudoValue createSyntheticValue(KtElement instructionElement, MagicKind kind, KtElement ... from2) {
            return this.builder.magic(instructionElement, null, this.elementsToValues(ArraysKt.asList(from2)), kind).getOutputValue();
        }

        private final PseudoValue createNonSyntheticValue(KtElement to, List<? extends KtElement> from2, MagicKind kind) {
            return this.builder.magic(to, to, this.elementsToValues(from2), kind).getOutputValue();
        }

        private final PseudoValue createNonSyntheticValue(KtElement to, MagicKind kind, KtElement ... from2) {
            return this.createNonSyntheticValue(to, ArraysKt.asList(from2), kind);
        }

        private final void mergeValues(List<? extends KtExpression> from2, KtExpression to) {
            this.builder.merge(to, this.elementsToValues(from2));
        }

        private final void copyValue(KtElement from2, KtElement to) {
            block0: {
                PseudoValue pseudoValue = this.getBoundOrUnreachableValue(from2);
                if (pseudoValue == null) break block0;
                PseudoValue it = pseudoValue;
                boolean bl = false;
                this.builder.bindValue(it, to);
            }
        }

        private final PseudoValue getBoundOrUnreachableValue(KtElement element) {
            if (element == null) {
                return null;
            }
            PseudoValue value2 = this.builder.getBoundValue(element);
            return value2 != null || element instanceof KtDeclaration ? value2 : this.builder.newValue(element);
        }

        /*
         * WARNING - void declaration
         */
        private final List<PseudoValue> elementsToValues(List<? extends KtElement> from2) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = from2;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                PseudoValue it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                KtElement element = (KtElement)element$iv$iv;
                boolean bl2 = false;
                if (this.getBoundOrUnreachableValue(element) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        private final void generateInitializer(KtDeclaration declaration, PseudoValue initValue) {
            this.builder.write(declaration, declaration, initValue, this.getDeclarationAccessTarget(declaration), MapsKt.emptyMap());
        }

        private final AccessTarget getResolvedCallAccessTarget(KtElement element) {
            AccessTarget accessTarget;
            BindingContext bindingContext = ControlFlowProcessor.this.trace.getBindingContext();
            Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(element, bindingContext);
            if (resolvedCall2 != null) {
                ResolvedCall<? extends CallableDescriptor> it = resolvedCall2;
                boolean bl = false;
                accessTarget = new AccessTarget.Call(it);
            } else {
                accessTarget = AccessTarget.BlackBox.INSTANCE;
            }
            return accessTarget;
        }

        private final AccessTarget getDeclarationAccessTarget(KtElement element) {
            DeclarationDescriptor descriptor = ControlFlowProcessor.this.trace.get(BindingContext.DECLARATION_TO_DESCRIPTOR, element);
            return descriptor instanceof VariableDescriptor ? (AccessTarget)new AccessTarget.Declaration((VariableDescriptor)descriptor) : (AccessTarget)AccessTarget.BlackBox.INSTANCE;
        }

        @Override
        public void visitParenthesizedExpression(@NotNull KtParenthesizedExpression expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            this.mark(expression2);
            KtExpression innerExpression = expression2.getExpression();
            if (innerExpression != null) {
                this.generateInstructions(innerExpression);
                this.copyValue(innerExpression, expression2);
            }
        }

        @Override
        public void visitAnnotatedExpression(@NotNull KtAnnotatedExpression expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            KtExpression baseExpression = expression2.getBaseExpression();
            if (baseExpression != null) {
                this.generateInstructions(baseExpression);
                this.copyValue(baseExpression, expression2);
            }
        }

        @Override
        public void visitThisExpression(@NotNull KtThisExpression expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            KtElement ktElement = expression2;
            BindingContext bindingContext = ControlFlowProcessor.this.trace.getBindingContext();
            Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(ktElement, bindingContext);
            if (resolvedCall2 == null) {
                this.createNonSyntheticValue((KtElement)expression2, MagicKind.UNRESOLVED_CALL, new KtElement[0]);
                return;
            }
            CallableDescriptor callableDescriptor = resolvedCall2.getResultingDescriptor();
            Intrinsics.checkNotNullExpressionValue(callableDescriptor, "getResultingDescriptor(...)");
            CallableDescriptor resultingDescriptor = callableDescriptor;
            if (resultingDescriptor instanceof ReceiverParameterDescriptor) {
                this.builder.readVariable(expression2, resolvedCall2, this.getReceiverValues(resolvedCall2));
            }
            KtElement ktElement2 = expression2;
            KtReferenceExpression ktReferenceExpression = expression2.getInstanceReference();
            Intrinsics.checkNotNullExpressionValue(ktReferenceExpression, "getInstanceReference(...)");
            this.copyValue(ktElement2, ktReferenceExpression);
        }

        @Override
        public void visitConstantExpression(@NotNull KtConstantExpression expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            KtExpression ktExpression = expression2;
            BindingContext bindingContext = ControlFlowProcessor.this.trace.getBindingContext();
            Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
            CompileTimeConstant<?> constant = ConstantExpressionEvaluator.Companion.getConstant(ktExpression, bindingContext);
            this.builder.loadConstant(expression2, constant);
        }

        @Override
        public void visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            KtElement ktElement = expression2;
            BindingContext bindingContext = ControlFlowProcessor.this.trace.getBindingContext();
            Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(ktElement, bindingContext);
            if (resolvedCall2 instanceof VariableAsFunctionResolvedCall) {
                this.generateCall(((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getVariableCall());
            } else {
                if (resolvedCall2 == null) {
                    KtExpression ktExpression;
                    boolean bl = ControlFlowProcessor.this.languageVersionSettings.supportsFeature(LanguageFeature.ProhibitQualifiedAccessToUninitializedEnumEntry);
                    if (bl) {
                        KtQualifiedExpression ktQualifiedExpression = KtPsiUtilKt.getTopmostParentQualifiedExpressionForSelector(expression2);
                        ktExpression = ktQualifiedExpression != null ? (KtExpression)ktQualifiedExpression : (KtExpression)expression2;
                    } else if (!bl) {
                        ktExpression = expression2;
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    KtExpression qualifierExpression = ktExpression;
                    Qualifier qualifier = (Qualifier)ControlFlowProcessor.this.trace.getBindingContext().get(BindingContext.QUALIFIER, qualifierExpression);
                    if (qualifier != null && this.generateQualifier(expression2, qualifier)) {
                        return;
                    }
                }
                if (!this.generateCall(expression2) && !(expression2.getParent() instanceof KtCallExpression)) {
                    KtElement[] ktElementArray = new KtElement[]{this.generateAndGetReceiverIfAny(expression2)};
                    this.createNonSyntheticValue((KtElement)expression2, MagicKind.UNRESOLVED_CALL, ktElementArray);
                }
            }
        }

        @Override
        public void visitLabeledExpression(@NotNull KtLabeledExpression expression2) {
            KtExpression deparenthesizedBaseExpression;
            KtSimpleNameExpression labelNameExpression;
            Intrinsics.checkNotNullParameter(expression2, "expression");
            this.mark(expression2);
            KtExpression baseExpression = expression2.getBaseExpression();
            if (baseExpression != null) {
                this.generateInstructions(baseExpression);
                this.copyValue(baseExpression, expression2);
            }
            if (!((labelNameExpression = expression2.getTargetLabel()) == null || (deparenthesizedBaseExpression = KtPsiUtil.deparenthesize(expression2)) instanceof KtLambdaExpression || deparenthesizedBaseExpression instanceof KtLoopExpression || deparenthesizedBaseExpression instanceof KtNamedFunction)) {
                ControlFlowProcessor.this.trace.report(Errors.REDUNDANT_LABEL_WARNING.on((KtElement)((PsiElement)labelNameExpression)));
            }
        }

        @Override
        public void visitBinaryExpression(@NotNull KtBinaryExpression expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            KtOperationReferenceExpression ktOperationReferenceExpression = expression2.getOperationReference();
            Intrinsics.checkNotNullExpressionValue(ktOperationReferenceExpression, "getOperationReference(...)");
            KtOperationReferenceExpression operationReference = ktOperationReferenceExpression;
            IElementType operationType = operationReference.getReferencedNameElementType();
            KtExpression left = expression2.getLeft();
            KtExpression right = expression2.getRight();
            if (operationType == KtTokens.ANDAND || operationType == KtTokens.OROR) {
                this.generateBooleanOperation(expression2);
            } else if (operationType == KtTokens.EQ) {
                this.visitAssignment(left, this.getDeferredValue(right), expression2);
            } else {
                ImmutableBiMap<KtSingleValueToken, Name> immutableBiMap = OperatorConventions.ASSIGNMENT_OPERATIONS;
                Intrinsics.checkNotNullExpressionValue(immutableBiMap, "ASSIGNMENT_OPERATIONS");
                if (((Map)immutableBiMap).containsKey(operationType)) {
                    KtElement ktElement = expression2;
                    BindingContext bindingContext = ControlFlowProcessor.this.trace.getBindingContext();
                    Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
                    ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(ktElement, bindingContext);
                    if (resolvedCall2 != null) {
                        PseudoValue rhsValue = this.generateCall(resolvedCall2).getOutputValue();
                        IElementType iElementType = expression2.getOperationToken();
                        Intrinsics.checkNotNull(iElementType, "null cannot be cast to non-null type org.jetbrains.kotlin.lexer.KtToken");
                        Name assignMethodName = OperatorConventions.getNameForOperationSymbol((KtToken)iElementType);
                        if (!Intrinsics.areEqual(((Named)resolvedCall2.getResultingDescriptor()).getName(), assignMethodName)) {
                            this.visitAssignment(left, this.getValueAsFunction(rhsValue), expression2);
                        }
                    } else {
                        this.generateBothArgumentsAndMark(expression2);
                    }
                } else if (operationType == KtTokens.ELVIS) {
                    this.generateInstructions(left);
                    this.mark(expression2);
                    Label afterElvis = this.builder.createUnboundLabel("after elvis operator");
                    this.builder.jumpOnTrue(afterElvis, expression2, this.builder.getBoundValue(left));
                    this.generateInstructions(right);
                    this.builder.bindLabel(afterElvis);
                    KtExpression[] ktExpressionArray = new KtExpression[]{left, right};
                    this.mergeValues(CollectionsKt.listOfNotNull(ktExpressionArray), expression2);
                    if (right != null && ControlFlowProcessor.this.languageVersionSettings.supportsFeature(LanguageFeature.ProhibitNonExhaustiveIfInRhsOfElvis)) {
                        BindingContextUtilsKt.recordUsedAsExpression(right, ControlFlowProcessor.this.trace, true);
                    }
                } else if (!this.generateCall(expression2)) {
                    this.generateBothArgumentsAndMark(expression2);
                }
            }
        }

        private final void generateBooleanOperation(KtBinaryExpression expression2) {
            IElementType operationType = expression2.getOperationReference().getReferencedNameElementType();
            KtExpression left = expression2.getLeft();
            KtExpression right = expression2.getRight();
            Label resultLabel = this.builder.createUnboundLabel("result of boolean operation");
            this.generateInstructions(left);
            if (operationType == KtTokens.ANDAND) {
                this.builder.jumpOnFalse(resultLabel, expression2, this.builder.getBoundValue(left));
            } else {
                this.builder.jumpOnTrue(resultLabel, expression2, this.builder.getBoundValue(left));
            }
            this.generateInstructions(right);
            this.builder.bindLabel(resultLabel);
            ControlFlowBuilder.PredefinedOperation operation = operationType == KtTokens.ANDAND ? ControlFlowBuilder.PredefinedOperation.AND : ControlFlowBuilder.PredefinedOperation.OR;
            KtExpression[] ktExpressionArray = new KtExpression[]{left, right};
            this.builder.predefinedOperation(expression2, operation, this.elementsToValues(CollectionsKt.listOfNotNull(ktExpressionArray)));
        }

        private final Function0<PseudoValue> getValueAsFunction(PseudoValue value2) {
            return () -> CFPVisitor.getValueAsFunction$lambda$3(value2);
        }

        private final Function0<PseudoValue> getDeferredValue(KtExpression expression2) {
            return () -> CFPVisitor.getDeferredValue$lambda$4(this, expression2);
        }

        private final void generateBothArgumentsAndMark(KtBinaryExpression expression2) {
            KtExpression right;
            KtExpression left = KtPsiUtil.deparenthesize(expression2.getLeft());
            if (left != null) {
                this.generateInstructions(left);
            }
            if ((right = expression2.getRight()) != null) {
                this.generateInstructions(right);
            }
            this.mark(expression2);
            KtElement[] ktElementArray = new KtElement[]{left, right};
            this.createNonSyntheticValue((KtElement)expression2, MagicKind.UNRESOLVED_CALL, ktElementArray);
        }

        private final void visitAssignment(KtExpression lhs, Function0<? extends PseudoValue> rhsDeferredValue, KtExpression parentExpression) {
            PseudoValue rightValue;
            PseudoValue pseudoValue;
            KtExpression left;
            block11: {
                Object object;
                block13: {
                    block12: {
                        left = KtPsiUtil.deparenthesize(lhs);
                        if (left != null) break block11;
                        object = rhsDeferredValue.invoke();
                        if (object == null) break block12;
                        PseudoValue it = object;
                        boolean bl = false;
                        List<PseudoValue> list = CollectionsKt.listOf(it);
                        object = list;
                        if (list != null) break block13;
                    }
                    object = CollectionsKt.emptyList();
                }
                List<PseudoValue> arguments = object;
                this.builder.magic(parentExpression, parentExpression, arguments, MagicKind.UNSUPPORTED_ELEMENT);
                return;
            }
            if (left instanceof KtArrayAccessExpression) {
                this.generateArrayAssignment((KtArrayAccessExpression)left, rhsDeferredValue, parentExpression);
                return;
            }
            SmartFMap smartFMap = SmartFMap.emptyMap();
            Intrinsics.checkNotNullExpressionValue(smartFMap, "emptyMap(...)");
            Map<PseudoValue, ReceiverValue> receiverValues = smartFMap;
            AccessTarget accessTarget = AccessTarget.BlackBox.INSTANCE;
            if (left instanceof KtSimpleNameExpression || left instanceof KtQualifiedExpression) {
                accessTarget = this.getResolvedCallAccessTarget(KtPsiUtilKt.getQualifiedElementSelector(left));
                if (accessTarget instanceof AccessTarget.Call) {
                    receiverValues = this.getReceiverValues(((AccessTarget.Call)accessTarget).getResolvedCall());
                }
            } else if (left instanceof KtProperty) {
                accessTarget = this.getDeclarationAccessTarget(left);
            }
            if (accessTarget == AccessTarget.BlackBox.INSTANCE && !(left instanceof KtProperty)) {
                this.generateInstructions(left);
                KtElement[] ktElementArray = new KtElement[]{left};
                this.createSyntheticValue(left, MagicKind.VALUE_CONSUMER, ktElementArray);
            }
            if ((pseudoValue = (rightValue = rhsDeferredValue.invoke())) == null) {
                pseudoValue = this.createSyntheticValue(parentExpression, MagicKind.UNRECOGNIZED_WRITE_RHS, new KtElement[0]);
            }
            PseudoValue rValue = pseudoValue;
            this.builder.write(parentExpression, left, rValue, accessTarget, receiverValues);
        }

        private final void generateArrayAssignment(KtArrayAccessExpression lhs, Function0<? extends PseudoValue> rhsDeferredValue, KtExpression parentExpression) {
            ResolvedCall setResolvedCall = (ResolvedCall)ControlFlowProcessor.this.trace.get(BindingContext.INDEXED_LVALUE_SET, lhs);
            if (setResolvedCall == null) {
                this.generateArrayAccess(lhs, null);
                PseudoValue[] pseudoValueArray = new PseudoValue[]{this.getBoundOrUnreachableValue(lhs), rhsDeferredValue.invoke()};
                List<PseudoValue> arguments = CollectionsKt.listOfNotNull(pseudoValueArray);
                this.builder.magic(parentExpression, parentExpression, arguments, MagicKind.UNRESOLVED_CALL);
                return;
            }
            Intrinsics.checkNotNull(parentExpression, "null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtOperationExpression");
            if (((KtOperationExpression)parentExpression).getOperationReference().getReferencedNameElementType() == KtTokens.EQ) {
                this.mark(lhs);
            }
            this.generateInstructions(lhs.getArrayExpression());
            Map<PseudoValue, ReceiverValue> receiverValues = this.getReceiverValues(setResolvedCall);
            SmartFMap<PseudoValue, ValueParameterDescriptor> argumentValues = this.getArraySetterArguments(rhsDeferredValue, setResolvedCall);
            this.builder.call(parentExpression, setResolvedCall, receiverValues, (Map<PseudoValue, ? extends ValueParameterDescriptor>)argumentValues);
        }

        /*
         * WARNING - void declaration
         */
        private final SmartFMap<PseudoValue, ValueParameterDescriptor> getArraySetterArguments(Function0<? extends PseudoValue> rhsDeferredValue, ResolvedCall<FunctionDescriptor> setResolvedCall) {
            void destination$iv;
            void $this$flatMapTo$iv;
            List<ValueParameterDescriptor> list = setResolvedCall.getResultingDescriptor().getValueParameters();
            Intrinsics.checkNotNullExpressionValue(list, "getValueParameters(...)");
            Iterable iterable = list;
            Collection collection = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv : $this$flatMapTo$iv) {
                ValueParameterDescriptor descriptor = (ValueParameterDescriptor)element$iv;
                boolean bl = false;
                Object object = setResolvedCall.getValueArguments().get(descriptor);
                if (object == null || (object = object.getArguments()) == null) {
                    object = CollectionsKt.emptyList();
                }
                Iterable list$iv = (Iterable)object;
                CollectionsKt.addAll(destination$iv, list$iv);
            }
            ArrayList valueArguments = (ArrayList)destination$iv;
            ValueArgument rhsArgument = (ValueArgument)CollectionsKt.lastOrNull(valueArguments);
            SmartFMap<PseudoValue, ValueParameterDescriptor> smartFMap = SmartFMap.emptyMap();
            Intrinsics.checkNotNullExpressionValue(smartFMap, "emptyMap(...)");
            SmartFMap<PseudoValue, ValueParameterDescriptor> argumentValues = smartFMap;
            Iterator iterator2 = valueArguments.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
            Iterator iterator3 = iterator2;
            while (iterator3.hasNext()) {
                ArgumentMatch argumentMapping2;
                ValueArgument valueArgument = (ValueArgument)iterator3.next();
                ArgumentMapping bl = setResolvedCall.getArgumentMapping(valueArgument);
                if ((bl instanceof ArgumentMatch ? (ArgumentMatch)bl : null) == null) continue;
                argumentMapping2 = argumentMapping2;
                ValueParameterDescriptor parameterDescriptor = argumentMapping2.getValueParameter();
                if (valueArgument != rhsArgument) {
                    Intrinsics.checkNotNull(valueArgument);
                    argumentValues = this.generateValueArgument(valueArgument, parameterDescriptor, argumentValues);
                    continue;
                }
                PseudoValue rhsValue = rhsDeferredValue.invoke();
                if (rhsValue == null) continue;
                argumentValues = argumentValues.plus(rhsValue, parameterDescriptor);
            }
            return argumentValues;
        }

        private final void generateArrayAccess(KtArrayAccessExpression arrayAccessExpression, ResolvedCall<?> resolvedCall2) {
            if (this.builder.getBoundValue(arrayAccessExpression) != null) {
                return;
            }
            this.mark(arrayAccessExpression);
            if (!this.checkAndGenerateCall(resolvedCall2)) {
                this.generateArrayAccessWithoutCall(arrayAccessExpression);
            }
        }

        private final void generateArrayAccessWithoutCall(KtArrayAccessExpression arrayAccessExpression) {
            this.createNonSyntheticValue((KtElement)arrayAccessExpression, this.generateArrayAccessArguments(arrayAccessExpression), MagicKind.UNRESOLVED_CALL);
        }

        private final List<KtExpression> generateArrayAccessArguments(KtArrayAccessExpression arrayAccessExpression) {
            ArrayList<KtExpression> inputExpressions = new ArrayList<KtExpression>();
            KtExpression arrayExpression = arrayAccessExpression.getArrayExpression();
            if (arrayExpression != null) {
                inputExpressions.add(arrayExpression);
            }
            this.generateInstructions(arrayExpression);
            for (KtExpression index : arrayAccessExpression.getIndexExpressions()) {
                this.generateInstructions(index);
                inputExpressions.add(index);
            }
            return inputExpressions;
        }

        @Override
        public void visitUnaryExpression(@NotNull KtUnaryExpression expression2) {
            PseudoValue rhsValue;
            PseudoValue pseudoValue;
            Intrinsics.checkNotNullParameter(expression2, "expression");
            KtSimpleNameExpression ktSimpleNameExpression = expression2.getOperationReference();
            Intrinsics.checkNotNullExpressionValue(ktSimpleNameExpression, "getOperationReference(...)");
            KtSimpleNameExpression operationSign = ktSimpleNameExpression;
            IElementType operationType = operationSign.getReferencedNameElementType();
            KtExpression ktExpression = expression2.getBaseExpression();
            if (ktExpression == null) {
                return;
            }
            KtExpression baseExpression = ktExpression;
            if (KtTokens.EXCLEXCL == operationType) {
                this.generateInstructions(baseExpression);
                this.builder.predefinedOperation(expression2, ControlFlowBuilder.PredefinedOperation.NOT_NULL_ASSERTION, this.elementsToValues(CollectionsKt.listOf(baseExpression)));
                return;
            }
            boolean incrementOrDecrement = this.isIncrementOrDecrement(operationType);
            KtElement ktElement = expression2;
            BindingContext bindingContext = ControlFlowProcessor.this.trace.getBindingContext();
            Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(ktElement, bindingContext);
            if (resolvedCall2 != null) {
                pseudoValue = this.generateCall(resolvedCall2).getOutputValue();
            } else {
                this.generateInstructions(baseExpression);
                KtElement[] ktElementArray = new KtElement[]{baseExpression};
                pseudoValue = rhsValue = this.createNonSyntheticValue((KtElement)expression2, MagicKind.UNRESOLVED_CALL, ktElementArray);
            }
            if (incrementOrDecrement && resolvedCall2 != null) {
                this.visitAssignment(baseExpression, this.getValueAsFunction(rhsValue), expression2);
                if (expression2 instanceof KtPostfixExpression) {
                    this.copyValue(baseExpression, expression2);
                }
            }
        }

        private final boolean isIncrementOrDecrement(IElementType operationType) {
            return operationType == KtTokens.PLUSPLUS || operationType == KtTokens.MINUSMINUS;
        }

        @Override
        public void visitIfExpression(@NotNull KtIfExpression expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            this.mark(expression2);
            ArrayList<KtExpression> branches = new ArrayList<KtExpression>(2);
            KtExpression condition = expression2.getCondition();
            this.generateInstructions(condition);
            Label elseLabel = this.builder.createUnboundLabel("else branch");
            this.builder.jumpOnFalse(elseLabel, expression2, this.builder.getBoundValue(condition));
            KtExpression thenBranch = expression2.getThen();
            if (thenBranch != null) {
                branches.add(thenBranch);
                this.generateInstructions(thenBranch);
            } else {
                this.builder.loadUnit(expression2);
            }
            Label resultLabel = this.builder.createUnboundLabel("'if' expression result");
            this.builder.jump(resultLabel, expression2);
            this.builder.bindLabel(elseLabel);
            KtExpression elseBranch = expression2.getElse();
            if (elseBranch != null) {
                branches.add(elseBranch);
                this.generateInstructions(elseBranch);
            } else {
                this.builder.loadUnit(expression2);
            }
            this.builder.bindLabel(resultLabel);
            this.mergeValues((List<? extends KtExpression>)branches, expression2);
        }

        @Override
        public void visitTryExpression(@NotNull KtTryExpression expression2) {
            boolean hasFinally;
            Intrinsics.checkNotNullParameter(expression2, "expression");
            this.mark(expression2);
            KtFinallySection finallyBlock = expression2.getFinallyBlock();
            FinallyBlockGenerator finallyBlockGenerator = new FinallyBlockGenerator(finallyBlock);
            boolean bl = hasFinally = finallyBlock != null;
            if (hasFinally) {
                this.builder.enterTryFinally(new GenerationTrigger(finallyBlockGenerator){
                    private boolean working;
                    final /* synthetic */ FinallyBlockGenerator $finallyBlockGenerator;
                    {
                        this.$finallyBlockGenerator = $finallyBlockGenerator;
                    }

                    public void generate() {
                        if (this.working) {
                            return;
                        }
                        this.working = true;
                        this.$finallyBlockGenerator.generate();
                        this.working = false;
                    }
                });
            }
            Label onExceptionToFinallyBlock = this.generateTryAndCatches(expression2);
            if (hasFinally) {
                boolean bl2;
                boolean bl3 = bl2 = onExceptionToFinallyBlock != null;
                if (_Assertions.ENABLED && !bl2) {
                    boolean bl4 = false;
                    String string2 = "No finally label generated: " + expression2.getText();
                    throw new AssertionError((Object)string2);
                }
                this.builder.exitTryFinally();
                Label skipFinallyToErrorBlock = this.builder.createUnboundLabel("skipFinallyToErrorBlock");
                this.builder.jump(skipFinallyToErrorBlock, expression2);
                Label label = onExceptionToFinallyBlock;
                Intrinsics.checkNotNull(label);
                this.builder.bindLabel(label);
                finallyBlockGenerator.generate();
                this.builder.jumpToError(expression2);
                this.builder.bindLabel(skipFinallyToErrorBlock);
                finallyBlockGenerator.generate();
            }
            ArrayList<KtExpression> branches = new ArrayList<KtExpression>();
            branches.add(expression2.getTryBlock());
            for (KtCatchClause catchClause : expression2.getCatchClauses()) {
                KtExpression it;
                if (catchClause.getCatchBody() == null) continue;
                boolean bl5 = false;
                branches.add(it);
            }
            this.mergeValues((List<? extends KtExpression>)branches, expression2);
        }

        private final Label generateTryAndCatches(KtTryExpression expression2) {
            List<KtCatchClause> list = expression2.getCatchClauses();
            Intrinsics.checkNotNullExpressionValue(list, "getCatchClauses(...)");
            List<KtCatchClause> catchClauses = list;
            boolean hasCatches = !((Collection)catchClauses).isEmpty();
            Label onException = null;
            if (hasCatches) {
                onException = this.builder.createUnboundLabel("onException");
                this.builder.nondeterministicJump(onException, expression2, null);
            }
            Label onExceptionToFinallyBlock = null;
            if (expression2.getFinallyBlock() != null) {
                onExceptionToFinallyBlock = this.builder.createUnboundLabel("onExceptionToFinallyBlock");
                this.builder.nondeterministicJump(onExceptionToFinallyBlock, expression2, null);
            }
            KtBlockExpression ktBlockExpression = expression2.getTryBlock();
            Intrinsics.checkNotNullExpressionValue(ktBlockExpression, "getTryBlock(...)");
            KtBlockExpression tryBlock = ktBlockExpression;
            this.catchFinallyStack.push(new CatchFinallyLabels(onException, onExceptionToFinallyBlock, expression2));
            this.generateInstructions(tryBlock);
            this.generateJumpsToCatchAndFinally();
            this.catchFinallyStack.pop();
            if (hasCatches && onException != null) {
                Label afterCatches = this.builder.createUnboundLabel("afterCatches");
                this.builder.jump(afterCatches, expression2);
                this.builder.bindLabel(onException);
                LinkedList<Label> catchLabels = new LinkedList<Label>();
                int catchClausesSize = catchClauses.size();
                int n = catchClausesSize - 1;
                for (int i = 0; i < n; ++i) {
                    catchLabels.add(this.builder.createUnboundLabel("catch " + i));
                }
                if (!catchLabels.isEmpty()) {
                    this.builder.nondeterministicJump((List<? extends Label>)catchLabels, expression2);
                }
                boolean isFirst = true;
                for (KtCatchClause catchClause : catchClauses) {
                    Intrinsics.checkNotNull(catchClause);
                    this.builder.enterBlockScope(catchClause);
                    if (!isFirst) {
                        Object e = catchLabels.remove();
                        Intrinsics.checkNotNullExpressionValue(e, "remove(...)");
                        this.builder.bindLabel((Label)e);
                    } else {
                        isFirst = false;
                    }
                    KtParameter catchParameter = catchClause.getCatchParameter();
                    if (catchParameter != null) {
                        this.builder.declareParameter(catchParameter);
                        this.generateInitializer(catchParameter, this.createSyntheticValue(catchParameter, MagicKind.FAKE_INITIALIZER, new KtElement[0]));
                    }
                    this.generateInstructions(catchClause.getCatchBody());
                    this.builder.jump(afterCatches, expression2);
                    this.builder.exitBlockScope(catchClause);
                }
                this.builder.bindLabel(afterCatches);
            }
            return onExceptionToFinallyBlock;
        }

        @Override
        public void visitWhileExpression(@NotNull KtWhileExpression expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            LoopInfo loopInfo = this.builder.enterLoop(expression2);
            this.builder.bindLabel(loopInfo.getConditionEntryPoint());
            KtExpression condition = expression2.getCondition();
            this.generateInstructions(condition);
            this.mark(expression2);
            if (!CompileTimeConstantUtils.canBeReducedToBooleanConstant(condition, ControlFlowProcessor.this.trace.getBindingContext(), true)) {
                this.builder.jumpOnFalse(loopInfo.getExitPoint(), expression2, this.builder.getBoundValue(condition));
            } else {
                boolean bl;
                boolean bl2 = bl = condition != null;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl3 = false;
                    String string2 = "Invalid while condition: " + expression2.getText();
                    throw new AssertionError((Object)string2);
                }
                KtExpression ktExpression = condition;
                Intrinsics.checkNotNull(ktExpression);
                KtElement[] ktElementArray = new KtElement[]{condition};
                this.createSyntheticValue(ktExpression, MagicKind.VALUE_CONSUMER, ktElementArray);
            }
            this.builder.enterLoopBody(expression2);
            this.generateInstructions(expression2.getBody());
            this.builder.jump(loopInfo.getEntryPoint(), expression2);
            this.builder.exitLoopBody(expression2);
            this.builder.bindLabel(loopInfo.getExitPoint());
            this.builder.loadUnit(expression2);
        }

        @Override
        public void visitDoWhileExpression(@NotNull KtDoWhileExpression expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            this.builder.enterBlockScope(expression2);
            this.mark(expression2);
            LoopInfo loopInfo = this.builder.enterLoop(expression2);
            this.builder.enterLoopBody(expression2);
            this.generateInstructions(expression2.getBody());
            this.builder.exitLoopBody(expression2);
            this.builder.bindLabel(loopInfo.getConditionEntryPoint());
            KtExpression condition = expression2.getCondition();
            this.generateInstructions(condition);
            this.builder.exitBlockScope(expression2);
            if (!CompileTimeConstantUtils.canBeReducedToBooleanConstant(condition, ControlFlowProcessor.this.trace.getBindingContext(), true)) {
                this.builder.jumpOnTrue(loopInfo.getEntryPoint(), expression2, this.builder.getBoundValue(expression2.getCondition()));
            } else {
                boolean bl;
                boolean bl2 = bl = condition != null;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl3 = false;
                    String string2 = "Invalid do / while condition: " + expression2.getText();
                    throw new AssertionError((Object)string2);
                }
                KtExpression ktExpression = condition;
                Intrinsics.checkNotNull(ktExpression);
                KtElement[] ktElementArray = new KtElement[]{condition};
                this.createSyntheticValue(ktExpression, MagicKind.VALUE_CONSUMER, ktElementArray);
                this.builder.jump(loopInfo.getEntryPoint(), expression2);
            }
            this.builder.bindLabel(loopInfo.getExitPoint());
            this.builder.loadUnit(expression2);
        }

        @Override
        public void visitForExpression(@NotNull KtForExpression expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            this.builder.enterBlockScope(expression2);
            KtExpression loopRange = expression2.getLoopRange();
            this.generateInstructions(loopRange);
            WritableSlice<KtExpression, ResolvedCall<FunctionDescriptor>> writableSlice = BindingContext.LOOP_RANGE_ITERATOR_RESOLVED_CALL;
            Intrinsics.checkNotNullExpressionValue(writableSlice, "LOOP_RANGE_ITERATOR_RESOLVED_CALL");
            this.generateLoopConventionCall(loopRange, (ReadOnlySlice<KtExpression, ResolvedCall<FunctionDescriptor>>)writableSlice);
            this.declareLoopParameter(expression2);
            LoopInfo loopInfo = this.builder.enterLoop(expression2);
            this.builder.bindLabel(loopInfo.getConditionEntryPoint());
            WritableSlice<KtExpression, ResolvedCall<FunctionDescriptor>> writableSlice2 = BindingContext.LOOP_RANGE_HAS_NEXT_RESOLVED_CALL;
            Intrinsics.checkNotNullExpressionValue(writableSlice2, "LOOP_RANGE_HAS_NEXT_RESOLVED_CALL");
            this.generateLoopConventionCall(loopRange, (ReadOnlySlice<KtExpression, ResolvedCall<FunctionDescriptor>>)writableSlice2);
            this.builder.nondeterministicJump(loopInfo.getExitPoint(), expression2, null);
            WritableSlice<KtExpression, ResolvedCall<FunctionDescriptor>> writableSlice3 = BindingContext.LOOP_RANGE_NEXT_RESOLVED_CALL;
            Intrinsics.checkNotNullExpressionValue(writableSlice3, "LOOP_RANGE_NEXT_RESOLVED_CALL");
            this.generateLoopConventionCall(loopRange, (ReadOnlySlice<KtExpression, ResolvedCall<FunctionDescriptor>>)writableSlice3);
            this.writeLoopParameterAssignment(expression2);
            this.mark(expression2);
            this.builder.enterLoopBody(expression2);
            this.generateInstructions(expression2.getBody());
            this.builder.jump(loopInfo.getEntryPoint(), expression2);
            this.builder.exitLoopBody(expression2);
            this.builder.bindLabel(loopInfo.getExitPoint());
            this.builder.loadUnit(expression2);
            this.builder.exitBlockScope(expression2);
        }

        private final void generateLoopConventionCall(KtExpression loopRange, ReadOnlySlice<KtExpression, ResolvedCall<FunctionDescriptor>> callSlice) {
            if (loopRange == null) {
                return;
            }
            ResolvedCall<FunctionDescriptor> resolvedCall2 = ControlFlowProcessor.this.trace.getBindingContext().get(callSlice, loopRange);
            if (resolvedCall2 == null) {
                return;
            }
            ResolvedCall<FunctionDescriptor> resolvedCall3 = resolvedCall2;
            this.generateCall(resolvedCall3);
        }

        private final void declareLoopParameter(KtForExpression expression2) {
            KtParameter loopParameter = expression2.getLoopParameter();
            if (loopParameter != null) {
                KtDestructuringDeclaration destructuringDeclaration = loopParameter.getDestructuringDeclaration();
                if (destructuringDeclaration != null) {
                    this.visitDestructuringDeclaration(destructuringDeclaration, false);
                } else {
                    this.builder.declareParameter(loopParameter);
                }
            }
        }

        private final void writeLoopParameterAssignment(KtForExpression expression2) {
            KtParameter loopParameter = expression2.getLoopParameter();
            KtExpression loopRange = expression2.getLoopRange();
            KtExpression ktExpression = loopRange;
            if (ktExpression == null) {
                ktExpression = expression2;
            }
            KtElement ktElement = ktExpression;
            List<PseudoValue> list = ContainerUtil.createMaybeSingletonList(this.builder.getBoundValue(loopRange));
            Intrinsics.checkNotNullExpressionValue(list, "createMaybeSingletonList(...)");
            PseudoValue value2 = this.builder.magic(ktElement, null, list, MagicKind.LOOP_RANGE_ITERATION).getOutputValue();
            if (loopParameter != null) {
                KtDestructuringDeclaration destructuringDeclaration = loopParameter.getDestructuringDeclaration();
                if (destructuringDeclaration != null) {
                    for (KtDestructuringDeclarationEntry entry : destructuringDeclaration.getEntries()) {
                        Intrinsics.checkNotNull(entry);
                        this.generateInitializer(entry, value2);
                    }
                } else {
                    this.generateInitializer(loopParameter, value2);
                }
            }
        }

        @Override
        public void visitBreakExpression(@NotNull KtBreakExpression expression2) {
            block3: {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                KtLoopExpression loop = this.getCorrespondingLoop(expression2);
                if (loop == null) break block3;
                if (this.jumpCrossesTryCatchBoundary(expression2, loop)) {
                    this.generateJumpsToCatchAndFinally();
                }
                if (this.jumpDoesNotCrossFunctionBoundary(expression2, loop)) {
                    Label label = this.builder.getLoopExitPoint(loop);
                    if (label != null) {
                        Label it = label;
                        boolean bl = false;
                        this.builder.jump(it, expression2);
                    }
                }
            }
        }

        @Override
        public void visitContinueExpression(@NotNull KtContinueExpression expression2) {
            block3: {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                KtLoopExpression loop = this.getCorrespondingLoop(expression2);
                if (loop == null) break block3;
                if (this.jumpCrossesTryCatchBoundary(expression2, loop)) {
                    this.generateJumpsToCatchAndFinally();
                }
                if (this.jumpDoesNotCrossFunctionBoundary(expression2, loop)) {
                    Label label = this.builder.getLoopConditionEntryPoint(loop);
                    if (label != null) {
                        Label it = label;
                        boolean bl = false;
                        this.builder.jump(it, expression2);
                    }
                }
            }
        }

        private final KtLoopExpression getNearestLoopExpression(KtExpression expression2) {
            PsiElement $this$getStrictParentOfType$iv = expression2;
            boolean $i$f$getStrictParentOfType = false;
            return PsiTreeUtil.getParentOfType($this$getStrictParentOfType$iv, KtLoopExpression.class, true);
        }

        private final KtLoopExpression getCorrespondingLoopWithoutLabel(KtExpression expression2) {
            KtLoopExpression ktLoopExpression = this.getNearestLoopExpression(expression2);
            if (ktLoopExpression == null) {
                return null;
            }
            KtLoopExpression parentLoop = ktLoopExpression;
            KtExpression parentBody = parentLoop.getBody();
            return parentBody != null && parentBody.getTextRange().contains(expression2.getTextRange()) ? parentLoop : this.getNearestLoopExpression(parentLoop);
        }

        private final KtLoopExpression getCorrespondingLoop(KtExpressionWithLabel expression2) {
            KtExpression ktExpression;
            Object object;
            String labelName = expression2.getLabelName();
            KtLoopExpression loop = null;
            if (labelName != null) {
                KtLoopExpression ktLoopExpression;
                KtSimpleNameExpression ktSimpleNameExpression = expression2.getTargetLabel();
                Intrinsics.checkNotNull(ktSimpleNameExpression);
                KtSimpleNameExpression targetLabel = ktSimpleNameExpression;
                PsiElement labeledElement = (PsiElement)ControlFlowProcessor.this.trace.get(BindingContext.LABEL_TARGET, targetLabel);
                if (labeledElement instanceof KtLoopExpression) {
                    ktLoopExpression = (KtLoopExpression)labeledElement;
                } else {
                    ControlFlowProcessor.this.trace.report(Errors.NOT_A_LOOP_LABEL.on((KtExpressionWithLabel)((PsiElement)expression2), targetLabel.getText()));
                    ktLoopExpression = null;
                }
                loop = ktLoopExpression;
            } else {
                KtWhenExpression whenExpression;
                loop = this.getCorrespondingLoopWithoutLabel(expression2);
                if (loop == null) {
                    ControlFlowProcessor.this.trace.report(Errors.BREAK_OR_CONTINUE_OUTSIDE_A_LOOP.on((KtExpressionWithLabel)((PsiElement)expression2)));
                } else if (!ControlFlowProcessor.this.languageVersionSettings.supportsFeature(LanguageFeature.AllowBreakAndContinueInsideWhen) && (whenExpression = PsiTreeUtil.getParentOfType((PsiElement)expression2, KtWhenExpression.class, true, object = new Class[]{KtLoopExpression.class})) != null) {
                    ControlFlowProcessor.this.trace.report(Errors.BREAK_OR_CONTINUE_IN_WHEN.on((KtExpressionWithLabel)((PsiElement)expression2)));
                }
            }
            if ((ktExpression = loop) != null && (ktExpression = ktExpression.getBody()) != null) {
                object = ktExpression;
                ControlFlowProcessor controlFlowProcessor = ControlFlowProcessor.this;
                Object it = object;
                boolean bl = false;
                if (!it.getTextRange().contains(expression2.getTextRange())) {
                    controlFlowProcessor.trace.report(Errors.BREAK_OR_CONTINUE_OUTSIDE_A_LOOP.on((KtExpressionWithLabel)((PsiElement)expression2)));
                    return null;
                }
            }
            return loop;
        }

        private final boolean returnCrossesTryCatchBoundary(KtReturnExpression returnExpression) {
            KtSimpleNameExpression ktSimpleNameExpression = returnExpression.getTargetLabel();
            if (ktSimpleNameExpression == null) {
                return true;
            }
            KtSimpleNameExpression targetLabel = ktSimpleNameExpression;
            PsiElement psiElement = (PsiElement)ControlFlowProcessor.this.trace.get(BindingContext.LABEL_TARGET, targetLabel);
            if (psiElement == null) {
                return true;
            }
            PsiElement labeledElement = psiElement;
            return this.jumpCrossesTryCatchBoundary(returnExpression, labeledElement);
        }

        private final boolean jumpCrossesTryCatchBoundary(KtExpressionWithLabel jumpExpression, PsiElement jumpTarget) {
            PsiElement current = jumpExpression.getParent();
            PsiElement psiElement;
            while (!Intrinsics.areEqual(psiElement = current, jumpTarget)) {
                if (psiElement instanceof KtTryExpression) {
                    return true;
                }
                current = current.getParent();
            }
            return false;
        }

        private final boolean jumpDoesNotCrossFunctionBoundary(KtExpressionWithLabel jumpExpression, KtLoopExpression jumpTarget) {
            boolean bl;
            block13: {
                block10: {
                    block12: {
                        boolean dependsOnInlineLambdas;
                        BindingContext bindingContext;
                        block11: {
                            boolean bl2;
                            BindingContext bindingContext2 = ControlFlowProcessor.this.trace.getBindingContext();
                            Intrinsics.checkNotNullExpressionValue(bindingContext2, "getBindingContext(...)");
                            bindingContext = bindingContext2;
                            FunctionDescriptor labelExprEnclosingFunc = BindingContextUtilsKt.getEnclosingFunctionDescriptor(bindingContext, jumpExpression, false);
                            FunctionDescriptor labelTargetEnclosingFunc = BindingContextUtilsKt.getEnclosingFunctionDescriptor(bindingContext, jumpTarget, false);
                            if (labelExprEnclosingFunc == labelTargetEnclosingFunc) break block10;
                            if (this.builder.getLoopExitPoint(jumpTarget) != null) break block11;
                            Object object = labelExprEnclosingFunc;
                            if (object != null && (object = DescriptorUtilsKt.getParentsWithSelf((DeclarationDescriptor)object)) != null) {
                                boolean bl3;
                                block9: {
                                    Object $this$any$iv = object;
                                    boolean $i$f$any = false;
                                    Iterator iterator2 = $this$any$iv.iterator();
                                    while (iterator2.hasNext()) {
                                        Object element$iv = iterator2.next();
                                        DeclarationDescriptor it = (DeclarationDescriptor)element$iv;
                                        boolean bl4 = false;
                                        if (!(it instanceof ConstructorDescriptor && !((ConstructorDescriptor)it).isPrimary())) continue;
                                        bl3 = true;
                                        break block9;
                                    }
                                    bl3 = false;
                                }
                                bl2 = bl3;
                            } else {
                                bl2 = false;
                            }
                            if (!bl2) break block12;
                        }
                        if (dependsOnInlineLambdas = Intrinsics.areEqual(BindingContextUtilsKt.getEnclosingFunctionDescriptor(bindingContext, jumpExpression, true), BindingContextUtilsKt.getEnclosingFunctionDescriptor(bindingContext, jumpTarget, true))) {
                            ControlFlowProcessor.this.trace.report(Errors.UNSUPPORTED_FEATURE.on(jumpExpression, TuplesKt.to(LanguageFeature.BreakContinueInInlineLambdas, ControlFlowProcessor.this.languageVersionSettings)));
                        } else {
                            ControlFlowProcessor.this.trace.report(Errors.BREAK_OR_CONTINUE_JUMPS_ACROSS_FUNCTION_BOUNDARY.on((KtExpressionWithLabel)((PsiElement)jumpExpression)));
                        }
                    }
                    bl = false;
                    break block13;
                }
                bl = true;
            }
            return bl;
        }

        @Override
        public void visitReturnExpression(@NotNull KtReturnExpression expression2) {
            KtElement ktElement;
            KtExpression returnedExpression;
            Intrinsics.checkNotNullParameter(expression2, "expression");
            if (this.returnCrossesTryCatchBoundary(expression2)) {
                this.generateJumpsToCatchAndFinally();
            }
            if ((returnedExpression = expression2.getReturnedExpression()) != null) {
                this.generateInstructions(returnedExpression);
            }
            KtSimpleNameExpression labelElement = expression2.getTargetLabel();
            KtElement subroutine = null;
            String labelName = expression2.getLabelName();
            if (labelElement != null && labelName != null) {
                PsiElement psiElement = (PsiElement)ControlFlowProcessor.this.trace.get(BindingContext.LABEL_TARGET, labelElement);
                if (psiElement != null) {
                    PsiElement labeledElement = psiElement;
                    boolean bl = false;
                    KtElement labeledKtElement = (KtElement)labeledElement;
                    this.checkReturnLabelTarget(expression2, labeledKtElement);
                    ktElement = labeledKtElement;
                } else {
                    ktElement = null;
                }
            } else {
                ktElement = subroutine = this.builder.getReturnSubroutine();
            }
            if (subroutine instanceof KtFunction || subroutine instanceof KtPropertyAccessor) {
                PseudoValue returnValue;
                PseudoValue pseudoValue = returnValue = returnedExpression != null ? this.builder.getBoundValue(returnedExpression) : null;
                if (returnValue == null) {
                    this.builder.returnNoValue(expression2, subroutine);
                } else {
                    this.builder.returnValue(expression2, returnValue, subroutine);
                }
            } else {
                KtElement[] ktElementArray = new KtElement[]{returnedExpression};
                this.createNonSyntheticValue((KtElement)expression2, MagicKind.UNSUPPORTED_ELEMENT, ktElementArray);
            }
        }

        private final void checkReturnLabelTarget(KtReturnExpression returnExpression, KtElement labeledElement) {
            if (!(labeledElement instanceof KtFunctionLiteral) && !(labeledElement instanceof KtNamedFunction)) {
                if (ControlFlowProcessor.this.languageVersionSettings.supportsFeature(LanguageFeature.RestrictReturnStatementTarget)) {
                    ControlFlowProcessor.this.trace.report(Errors.NOT_A_FUNCTION_LABEL.on((KtExpressionWithLabel)((PsiElement)returnExpression)));
                } else {
                    ControlFlowProcessor.this.trace.report(Errors.NOT_A_FUNCTION_LABEL_WARNING.on((KtExpressionWithLabel)((PsiElement)returnExpression)));
                }
            }
        }

        @Override
        public void visitParameter(@NotNull KtParameter parameter) {
            block2: {
                Intrinsics.checkNotNullParameter(parameter, "parameter");
                this.builder.declareParameter(parameter);
                KtExpression defaultValue = parameter.getDefaultValue();
                if (defaultValue != null) {
                    StringBuilder stringBuilder = new StringBuilder().append("after default value for parameter ");
                    String string2 = parameter.getName();
                    if (string2 == null) {
                        string2 = "<anonymous>";
                    }
                    Label skipDefaultValue = this.builder.createUnboundLabel(stringBuilder.append(string2).toString());
                    this.builder.nondeterministicJump(skipDefaultValue, defaultValue, null);
                    this.generateInstructions(defaultValue);
                    this.builder.bindLabel(skipDefaultValue);
                }
                this.generateInitializer(parameter, this.computePseudoValueForParameter(parameter));
                KtDestructuringDeclaration ktDestructuringDeclaration = parameter.getDestructuringDeclaration();
                if (ktDestructuringDeclaration == null) break block2;
                KtDestructuringDeclaration it = ktDestructuringDeclaration;
                boolean bl = false;
                this.visitDestructuringDeclaration(it, true);
            }
        }

        private final PseudoValue computePseudoValueForParameter(KtParameter parameter) {
            PseudoValue syntheticValue = this.createSyntheticValue(parameter, MagicKind.FAKE_INITIALIZER, new KtElement[0]);
            PseudoValue pseudoValue = this.builder.getBoundValue(parameter.getDefaultValue());
            if (pseudoValue == null) {
                return syntheticValue;
            }
            PseudoValue defaultValue = pseudoValue;
            PseudoValue[] pseudoValueArray = new PseudoValue[]{defaultValue, syntheticValue};
            return this.builder.merge(parameter, (List<? extends PseudoValue>)CollectionsKt.arrayListOf(pseudoValueArray)).getOutputValue();
        }

        @Override
        public void visitBlockExpression(@NotNull KtBlockExpression expression2) {
            boolean declareBlockScope;
            Intrinsics.checkNotNullParameter(expression2, "expression");
            boolean bl = declareBlockScope = !this.isBlockInDoWhile(expression2);
            if (declareBlockScope) {
                this.builder.enterBlockScope(expression2);
            }
            this.mark(expression2);
            List<KtExpression> list = expression2.getStatements();
            Intrinsics.checkNotNullExpressionValue(list, "getStatements(...)");
            List<KtExpression> statements = list;
            for (KtExpression statement : statements) {
                Label afterClassLabel;
                Label label;
                if ((statement instanceof KtClassOrObject ? (KtClassOrObject)statement : null) != null) {
                    KtClassOrObject it;
                    it = it;
                    boolean bl2 = false;
                    label = this.builder.createUnboundLabel("after local class");
                } else {
                    label = afterClassLabel = null;
                }
                if (afterClassLabel != null) {
                    this.builder.nondeterministicJump(afterClassLabel, statement, null);
                }
                this.generateInstructions(statement);
                if (afterClassLabel == null) continue;
                this.builder.bindLabel(afterClassLabel);
            }
            if (statements.isEmpty()) {
                this.builder.loadUnit(expression2);
            } else {
                this.copyValue(CollectionsKt.lastOrNull(statements), expression2);
            }
            if (declareBlockScope) {
                this.builder.exitBlockScope(expression2);
            }
        }

        private final boolean isBlockInDoWhile(KtBlockExpression expression2) {
            PsiElement parent2 = expression2.getParent();
            return parent2.getParent() instanceof KtDoWhileExpression;
        }

        private final void visitFunction(KtFunction function2, EventOccurrencesRange eventOccurrencesRange) {
            boolean isAnonymousFunction;
            if (eventOccurrencesRange == null) {
                ControlFlowProcessor.this.processLocalDeclaration(function2);
            } else {
                this.visitInlinedFunction(function2, eventOccurrencesRange);
            }
            boolean bl = isAnonymousFunction = function2 instanceof KtFunctionLiteral || function2.getName() == null;
            if (isAnonymousFunction || function2.isLocal() && !(function2.getParent() instanceof KtBlockExpression)) {
                this.builder.createLambda(function2);
            }
        }

        static /* synthetic */ void visitFunction$default(CFPVisitor cFPVisitor, KtFunction ktFunction, EventOccurrencesRange eventOccurrencesRange, int n, Object object) {
            if ((n & 2) != 0) {
                eventOccurrencesRange = null;
            }
            cFPVisitor.visitFunction(ktFunction, eventOccurrencesRange);
        }

        private final void visitInlinedFunction(KtFunction lambdaFunctionLiteral, EventOccurrencesRange eventOccurrencesRange) {
            this.deferredGeneratorsStack.peek().add(arg_0 -> CFPVisitor.visitInlinedFunction$lambda$18(eventOccurrencesRange, lambdaFunctionLiteral, ControlFlowProcessor.this, arg_0));
        }

        @Override
        public void visitNamedFunction(@NotNull KtNamedFunction function2) {
            Intrinsics.checkNotNullParameter(function2, "function");
            CFPVisitor.visitFunction$default(this, function2, null, 2, null);
        }

        @Override
        public void visitLambdaExpression(@NotNull KtLambdaExpression lambdaExpression) {
            Intrinsics.checkNotNullParameter(lambdaExpression, "lambdaExpression");
            this.mark(lambdaExpression);
            KtFunctionLiteral ktFunctionLiteral = lambdaExpression.getFunctionLiteral();
            Intrinsics.checkNotNullExpressionValue(ktFunctionLiteral, "getFunctionLiteral(...)");
            KtFunctionLiteral functionLiteral = ktFunctionLiteral;
            this.visitFunction(functionLiteral, (EventOccurrencesRange)((Object)ControlFlowProcessor.this.trace.get(BindingContext.LAMBDA_INVOCATIONS, lambdaExpression)));
            this.copyValue(functionLiteral, lambdaExpression);
        }

        @Override
        public void visitQualifiedExpression(@NotNull KtQualifiedExpression expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            this.mark(expression2);
            KtExpression selectorExpression = expression2.getSelectorExpression();
            KtExpression receiverExpression = expression2.getReceiverExpression();
            boolean safe = expression2 instanceof KtSafeQualifiedExpression;
            if (selectorExpression instanceof KtCallExpression || selectorExpression instanceof KtSimpleNameExpression) {
                if (!safe) {
                    this.generateInstructions(selectorExpression);
                } else {
                    Label resultLabel = this.builder.createUnboundLabel("result of call");
                    this.builder.jumpOnFalse(resultLabel, expression2, null);
                    this.generateInstructions(selectorExpression);
                    this.builder.bindLabel(resultLabel);
                }
                this.copyValue(selectorExpression, expression2);
            } else {
                this.generateInstructions(receiverExpression);
                KtElement[] ktElementArray = new KtElement[]{receiverExpression};
                this.createNonSyntheticValue((KtElement)expression2, MagicKind.UNSUPPORTED_ELEMENT, ktElementArray);
            }
        }

        @Override
        public void visitCallExpression(@NotNull KtCallExpression expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            if (!this.generateCall(expression2)) {
                ArrayList<KtExpression> inputExpressions = new ArrayList<KtExpression>();
                for (KtValueArgument argument : expression2.getValueArguments()) {
                    KtExpression argumentExpression = argument.getArgumentExpression();
                    if (argumentExpression == null) continue;
                    this.generateInstructions(argumentExpression);
                    inputExpressions.add(argumentExpression);
                }
                KtExpression calleeExpression = expression2.getCalleeExpression();
                this.generateInstructions(calleeExpression);
                if (calleeExpression != null) {
                    inputExpressions.add(calleeExpression);
                    KtExpression ktExpression = this.generateAndGetReceiverIfAny(expression2);
                    if (ktExpression != null) {
                        KtExpression it = ktExpression;
                        boolean bl = false;
                        inputExpressions.add(it);
                    }
                }
                this.mark(expression2);
                this.createNonSyntheticValue((KtElement)expression2, (List<? extends KtElement>)inputExpressions, MagicKind.UNRESOLVED_CALL);
            }
        }

        private final KtExpression generateAndGetReceiverIfAny(KtExpression expression2) {
            PsiElement psiElement = expression2.getParent();
            KtQualifiedExpression ktQualifiedExpression = psiElement instanceof KtQualifiedExpression ? (KtQualifiedExpression)psiElement : null;
            if (ktQualifiedExpression == null) {
                return null;
            }
            KtQualifiedExpression parent2 = ktQualifiedExpression;
            if (parent2.getSelectorExpression() != expression2) {
                return null;
            }
            KtExpression receiverExpression = parent2.getReceiverExpression();
            this.generateInstructions(receiverExpression);
            return receiverExpression;
        }

        @Override
        public void visitProperty(@NotNull KtProperty property2) {
            KtExpression delegate;
            Intrinsics.checkNotNullParameter(property2, "property");
            this.builder.declareVariable(property2);
            KtExpression initializer = property2.getInitializer();
            if (initializer != null) {
                this.visitAssignment(property2, this.getDeferredValue(initializer), property2);
            }
            if ((delegate = property2.getDelegateExpression()) != null) {
                this.visitAssignment(property2, this.getDeferredValue(null), property2);
                this.generateInstructions(delegate);
                if (property2.isLocal()) {
                    this.generateInitializer(property2, this.createSyntheticValue(property2, MagicKind.FAKE_INITIALIZER, new KtElement[0]));
                }
                if (this.builder.getBoundValue(delegate) != null) {
                    KtElement[] ktElementArray = new KtElement[]{delegate};
                    this.createSyntheticValue(property2, MagicKind.VALUE_CONSUMER, ktElementArray);
                }
            }
            if (KtPsiUtil.isLocal(property2)) {
                for (KtPropertyAccessor accessor : property2.getAccessors()) {
                    this.generateInstructions(accessor);
                }
            }
        }

        @Override
        public void visitDestructuringDeclaration(@NotNull KtDestructuringDeclaration declaration) {
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            this.visitDestructuringDeclaration(declaration, true);
        }

        @Override
        private final void visitDestructuringDeclaration(KtDestructuringDeclaration declaration, boolean generateWriteForEntries) {
            KtExpression initializer = declaration.getInitializer();
            this.generateInstructions(initializer);
            for (KtDestructuringDeclarationEntry entry : declaration.getEntries()) {
                PseudoValue writtenValue;
                PseudoValue pseudoValue;
                Intrinsics.checkNotNull(entry);
                this.builder.declareVariable(entry);
                ResolvedCall resolvedCall2 = (ResolvedCall)ControlFlowProcessor.this.trace.get(BindingContext.COMPONENT_RESOLVED_CALL, entry);
                if (resolvedCall2 != null) {
                    pseudoValue = this.builder.call(entry, resolvedCall2, this.getReceiverValues(resolvedCall2), MapsKt.emptyMap()).getOutputValue();
                } else if (initializer != null) {
                    KtExpression it;
                    boolean bl = false;
                    KtElement[] ktElementArray = new KtElement[]{it};
                    pseudoValue = this.createSyntheticValue(entry, MagicKind.UNRESOLVED_CALL, ktElementArray);
                } else {
                    pseudoValue = writtenValue = null;
                }
                if (!generateWriteForEntries) continue;
                KtDeclaration ktDeclaration = entry;
                PseudoValue pseudoValue2 = writtenValue;
                if (pseudoValue2 == null) {
                    pseudoValue2 = this.createSyntheticValue(entry, MagicKind.FAKE_INITIALIZER, new KtElement[0]);
                }
                this.generateInitializer(ktDeclaration, pseudoValue2);
            }
        }

        @Override
        public void visitPropertyAccessor(@NotNull KtPropertyAccessor accessor) {
            Intrinsics.checkNotNullParameter(accessor, "accessor");
            ControlFlowProcessor.this.processLocalDeclaration(accessor);
        }

        @Override
        public void visitBinaryWithTypeRHSExpression(@NotNull KtBinaryExpressionWithTypeRHS expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            this.mark(expression2);
            IElementType operationType = expression2.getOperationReference().getReferencedNameElementType();
            KtExpression ktExpression = expression2.getLeft();
            Intrinsics.checkNotNullExpressionValue(ktExpression, "getLeft(...)");
            KtExpression left = ktExpression;
            if (operationType == KtTokens.AS_KEYWORD || operationType == KtTokens.AS_SAFE) {
                this.generateInstructions(left);
                if (this.getBoundOrUnreachableValue(left) != null) {
                    KtElement[] ktElementArray = new KtElement[]{left};
                    this.createNonSyntheticValue((KtElement)expression2, MagicKind.CAST, ktElementArray);
                }
            } else {
                this.visitKtElement(expression2);
                KtElement[] ktElementArray = new KtElement[]{left};
                this.createNonSyntheticValue((KtElement)expression2, MagicKind.UNSUPPORTED_ELEMENT, ktElementArray);
            }
        }

        private final void generateJumpsToCatchAndFinally() {
            block3: {
                if (!(!((Collection)this.catchFinallyStack).isEmpty())) break block3;
                CatchFinallyLabels $this$generateJumpsToCatchAndFinally_u24lambda_u2423 = this.catchFinallyStack.peek();
                boolean bl = false;
                if ($this$generateJumpsToCatchAndFinally_u24lambda_u2423.getTryExpression() != null) {
                    Label it;
                    Label label = $this$generateJumpsToCatchAndFinally_u24lambda_u2423.getOnException();
                    if (label != null) {
                        it = label;
                        boolean bl2 = false;
                        this.builder.nondeterministicJump(it, $this$generateJumpsToCatchAndFinally_u24lambda_u2423.getTryExpression(), null);
                    }
                    Label label2 = $this$generateJumpsToCatchAndFinally_u24lambda_u2423.getToFinally();
                    if (label2 != null) {
                        it = label2;
                        boolean bl3 = false;
                        this.builder.nondeterministicJump(it, $this$generateJumpsToCatchAndFinally_u24lambda_u2423.getTryExpression(), null);
                    }
                }
            }
        }

        @Override
        public void visitThrowExpression(@NotNull KtThrowExpression expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            this.mark(expression2);
            this.generateJumpsToCatchAndFinally();
            KtExpression ktExpression = expression2.getThrownExpression();
            if (ktExpression == null) {
                return;
            }
            KtExpression thrownExpression = ktExpression;
            this.generateInstructions(thrownExpression);
            PseudoValue pseudoValue = this.builder.getBoundValue(thrownExpression);
            if (pseudoValue == null) {
                return;
            }
            PseudoValue thrownValue = pseudoValue;
            this.builder.throwException(expression2, thrownValue);
        }

        @Override
        public void visitArrayAccessExpression(@NotNull KtArrayAccessExpression expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            this.generateArrayAccess(expression2, (ResolvedCall)ControlFlowProcessor.this.trace.get(BindingContext.INDEXED_LVALUE_GET, expression2));
        }

        @Override
        public void visitIsExpression(@NotNull KtIsExpression expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            this.mark(expression2);
            KtExpression ktExpression = expression2.getLeftHandSide();
            Intrinsics.checkNotNullExpressionValue(ktExpression, "getLeftHandSide(...)");
            KtExpression left = ktExpression;
            this.generateInstructions(left);
            KtElement[] ktElementArray = new KtElement[]{left};
            this.createNonSyntheticValue((KtElement)expression2, MagicKind.IS, ktElementArray);
        }

        @Override
        public void visitWhenExpression(@NotNull KtWhenExpression expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            this.mark(expression2);
            KtExpression subjectExpression = expression2.getSubjectExpression();
            if (subjectExpression != null) {
                this.generateInstructions(subjectExpression);
            }
            ArrayList<KtExpression> branches = new ArrayList<KtExpression>();
            Label doneLabel = this.builder.createUnboundLabel("after 'when' expression");
            Label nextLabel = null;
            Iterator<KtWhenEntry> iterator2 = expression2.getEntries().iterator();
            while (iterator2.hasNext()) {
                KtWhenCondition[] conditions;
                KtWhenEntry whenEntry = iterator2.next();
                Intrinsics.checkNotNull(whenEntry);
                this.mark(whenEntry);
                boolean isElse = whenEntry.isElse();
                if (isElse && iterator2.hasNext()) {
                    ControlFlowProcessor.this.trace.report(Errors.ELSE_MISPLACED_IN_WHEN.on((KtWhenEntry)((PsiElement)whenEntry)));
                }
                Label bodyLabel = this.builder.createUnboundLabel("'when' entry body");
                Intrinsics.checkNotNullExpressionValue(whenEntry.getConditions(), "getConditions(...)");
                int n = conditions.length;
                for (int i = 0; i < n; ++i) {
                    KtWhenCondition condition = conditions[i];
                    condition.accept(this.conditionVisitor);
                    if (i + 1 >= conditions.length) continue;
                    this.builder.nondeterministicJump(bodyLabel, expression2, this.builder.getBoundValue(condition));
                }
                if (!isElse) {
                    nextLabel = this.builder.createUnboundLabel("next 'when' entry");
                    KtWhenCondition lastCondition = ArraysKt.lastOrNull(conditions);
                    this.builder.nondeterministicJump(nextLabel, expression2, this.builder.getBoundValue(lastCondition));
                }
                this.builder.bindLabel(bodyLabel);
                KtExpression whenEntryExpression = whenEntry.getExpression();
                if (whenEntryExpression != null) {
                    this.generateInstructions(whenEntryExpression);
                    branches.add(whenEntryExpression);
                }
                this.builder.jump(doneLabel, expression2);
                if (isElse || nextLabel == null) continue;
                this.builder.bindLabel(nextLabel);
                if (iterator2.hasNext() || !WhenChecker.isWhenExhaustive(expression2, ControlFlowProcessor.this.trace)) continue;
                this.builder.magic(expression2, null, CollectionsKt.emptyList(), MagicKind.EXHAUSTIVE_WHEN_ELSE);
            }
            this.builder.bindLabel(doneLabel);
            this.mergeValues((List<? extends KtExpression>)branches, expression2);
            WhenChecker.INSTANCE.checkDuplicatedLabels(expression2, ControlFlowProcessor.this.trace, ControlFlowProcessor.this.languageVersionSettings);
        }

        @Override
        public void visitObjectLiteralExpression(@NotNull KtObjectLiteralExpression expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            this.mark(expression2);
            KtObjectDeclaration ktObjectDeclaration = expression2.getObjectDeclaration();
            Intrinsics.checkNotNullExpressionValue(ktObjectDeclaration, "getObjectDeclaration(...)");
            KtObjectDeclaration declaration = ktObjectDeclaration;
            this.generateInstructions(declaration);
            this.builder.createAnonymousObject(expression2);
        }

        @Override
        public void visitObjectDeclaration(@NotNull KtObjectDeclaration objectDeclaration) {
            Intrinsics.checkNotNullParameter(objectDeclaration, "objectDeclaration");
            this.generateHeaderDelegationSpecifiers(objectDeclaration);
            this.generateInitializersForClassOrObject(objectDeclaration);
            this.generateDeclarationForLocalClassOrObjectIfNeeded(objectDeclaration);
        }

        @Override
        public void visitStringTemplateExpression(@NotNull KtStringTemplateExpression expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            this.mark(expression2);
            ArrayList<KtExpression> inputExpressions = new ArrayList<KtExpression>();
            for (KtStringTemplateEntry entry : expression2.getEntries()) {
                if (!(entry instanceof KtStringTemplateEntryWithExpression)) continue;
                KtExpression entryExpression = ((KtStringTemplateEntryWithExpression)entry).getExpression();
                this.generateInstructions(entryExpression);
                if (entryExpression == null) continue;
                inputExpressions.add(entryExpression);
            }
            this.builder.loadStringTemplate(expression2, this.elementsToValues((List<? extends KtElement>)inputExpressions));
        }

        @Override
        public void visitTypeProjection(@NotNull KtTypeProjection typeProjection) {
            Intrinsics.checkNotNullParameter(typeProjection, "typeProjection");
        }

        @Override
        public void visitAnonymousInitializer(@NotNull KtAnonymousInitializer classInitializer) {
            Intrinsics.checkNotNullParameter(classInitializer, "classInitializer");
            this.generateInstructions(classInitializer.getBody());
        }

        private final void generateHeaderDelegationSpecifiers(KtClassOrObject classOrObject) {
            for (KtSuperTypeListEntry specifier : classOrObject.getSuperTypeListEntries()) {
                this.generateInstructions(specifier);
            }
        }

        private final void generateInitializersForClassOrObject(KtDeclarationContainer classOrObject) {
            for (KtDeclaration declaration : classOrObject.getDeclarations()) {
                if (!(declaration instanceof KtProperty) && !(declaration instanceof KtAnonymousInitializer)) continue;
                this.generateInstructions(declaration);
            }
        }

        private final void processEntryOrObject(KtClassOrObject entryOrObject) {
            DeclarationDescriptor classDescriptor = ControlFlowProcessor.this.trace.get(BindingContext.DECLARATION_TO_DESCRIPTOR, entryOrObject);
            if (classDescriptor instanceof ClassDescriptor) {
                this.builder.declareEntryOrObject(entryOrObject);
                this.builder.write(entryOrObject, entryOrObject, this.createSyntheticValue(entryOrObject, MagicKind.FAKE_INITIALIZER, new KtElement[0]), new AccessTarget.Declaration(new FakeCallableDescriptorForObject((ClassDescriptor)classDescriptor)), MapsKt.emptyMap());
                this.generateInstructions(entryOrObject);
            }
        }

        @Override
        public void visitClass(@NotNull KtClass klass) {
            Intrinsics.checkNotNullParameter(klass, "klass");
            if (klass.hasPrimaryConstructor()) {
                this.processParameters(klass.getPrimaryConstructorParameters());
                this.generateHeaderDelegationSpecifiers(klass);
                this.generateInitializersForClassOrObject(klass);
            }
            this.generateDeclarationForLocalClassOrObjectIfNeeded(klass);
            if (klass.isEnum()) {
                Iterable $this$forEach$iv = klass.getDeclarations();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    KtDeclaration it = (KtDeclaration)element$iv;
                    boolean bl = false;
                    KtDeclaration ktDeclaration = it;
                    if (ktDeclaration instanceof KtEnumEntry) {
                        this.processEntryOrObject((KtClassOrObject)it);
                        continue;
                    }
                    if (!(ktDeclaration instanceof KtObjectDeclaration) || !((KtObjectDeclaration)it).isCompanion()) continue;
                    this.processEntryOrObject((KtClassOrObject)it);
                }
            }
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void visitScript(@NotNull KtScript script) {
            Intrinsics.checkNotNullParameter(script, "script");
            var4_2 = script;
            $i$f$getChildOfType = false;
            var3_8 = PsiTreeUtil.getChildOfType((PsiElement)$this$getChildOfType$iv, KtBlockExpression.class);
            if (var3_8 == null) ** GOTO lbl-1000
            $i$f$getChildOfType = var3_8;
            $i$f$getChildrenOfType = false;
            v0 = PsiTreeUtil.getChildrenOfType((PsiElement)$this$getChildrenOfType$iv, KtScriptInitializer.class);
            if (v0 == null) {
                v0 = new KtScriptInitializer[0];
            }
            if (($this$getChildOfType$iv = (KtScriptInitializer[])v0) != null) {
                v1 = ArraysKt.lastOrNull($this$getChildOfType$iv);
            } else lbl-1000:
            // 2 sources

            {
                v1 = null;
            }
            v2 = lastInitializer = v1;
            if (v2 != null) {
                $this$getChildOfType$iv = (KtScriptInitializer[])v2;
                $i$f$getChildOfType = false;
                v3 = PsiTreeUtil.getChildOfType((PsiElement)$this$getChildOfType$iv, KtExpression.class);
            } else {
                v3 = null;
            }
            v4 = resultExpression = v3;
            if (v4 != null) {
                $i$f$getChildOfType = v4;
                var6_10 = ControlFlowProcessor.this;
                it = $i$f$getChildOfType;
                $i$a$-let-ControlFlowProcessor$CFPVisitor$visitScript$resultType$1 = false;
                v5 = ControlFlowProcessor.access$getTrace$p(var6_10).getBindingContext().getType(it);
            } else {
                v5 = null;
            }
            resultType = v5;
            hasResultField = resultType != null && TypeUtilsKt.isUnit(resultType) == false && TypeUtilsKt.isNothing(resultType) == false;
            for (KtDeclaration declaration : script.getDeclarations()) {
                if (declaration instanceof KtAnonymousInitializer) {
                    this.generateInstructions(declaration);
                    if (!hasResultField || !Intrinsics.areEqual(declaration, lastInitializer)) continue;
                    v6 = resultExpression;
                    if (v6 != null) {
                        BindingContextUtilsKt.recordUsedAsExpression(v6, ControlFlowProcessor.access$getTrace$p(ControlFlowProcessor.this), true);
                    }
                    continue;
                }
                if (!(declaration instanceof KtProperty) && !(declaration instanceof KtDestructuringDeclaration)) continue;
                this.generateInstructions(declaration);
            }
        }

        private final void generateDeclarationForLocalClassOrObjectIfNeeded(KtClassOrObject classOrObject) {
            if (classOrObject.isLocal()) {
                for (KtDeclaration declaration : classOrObject.getDeclarations()) {
                    if (declaration instanceof KtSecondaryConstructor || declaration instanceof KtProperty || declaration instanceof KtAnonymousInitializer) continue;
                    this.generateInstructions(declaration);
                }
            }
        }

        private final void processParameters(List<? extends KtParameter> parameters) {
            for (KtParameter ktParameter : parameters) {
                this.generateInstructions(ktParameter);
            }
        }

        @Override
        public void visitSecondaryConstructor(@NotNull KtSecondaryConstructor constructor) {
            Intrinsics.checkNotNullParameter(constructor, "constructor");
            KtClassOrObject ktClassOrObject = PsiTreeUtil.getParentOfType((PsiElement)constructor, KtClassOrObject.class);
            if (ktClassOrObject == null) {
                throw new IllegalStateException("Guaranteed by parsing contract".toString());
            }
            KtClassOrObject classOrObject = ktClassOrObject;
            this.processParameters(constructor.getValueParameters());
            this.generateCallOrMarkUnresolved(constructor.getDelegationCall());
            if (!constructor.getDelegationCall().isCallToThis()) {
                this.generateInitializersForClassOrObject(classOrObject);
            }
            this.generateInstructions(constructor.getBodyExpression());
        }

        @Override
        public void visitSuperTypeCallEntry(@NotNull KtSuperTypeCallEntry call2) {
            Intrinsics.checkNotNullParameter(call2, "call");
            this.generateCallOrMarkUnresolved(call2);
        }

        @Override
        public void visitInitializerList(@NotNull KtInitializerList list) {
            Intrinsics.checkNotNullParameter(list, "list");
            list.acceptChildren(this);
        }

        /*
         * WARNING - void declaration
         */
        private final void generateCallOrMarkUnresolved(KtCallElement call2) {
            if (!this.generateCall(call2)) {
                void $this$mapNotNullTo$iv$iv;
                List<? extends ValueArgument> list = call2.getValueArguments();
                Intrinsics.checkNotNullExpressionValue(list, "getValueArguments(...)");
                Iterable $this$mapNotNull$iv = list;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    KtExpression it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl = false;
                    ValueArgument p0 = (ValueArgument)element$iv$iv;
                    boolean bl2 = false;
                    if (p0.getArgumentExpression() == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List arguments = (List)destination$iv$iv;
                for (KtExpression argument : arguments) {
                    this.generateInstructions(argument);
                }
                this.createNonSyntheticValue((KtElement)call2, arguments, MagicKind.UNRESOLVED_CALL);
            }
        }

        @Override
        public void visitDelegatedSuperTypeEntry(@NotNull KtDelegatedSuperTypeEntry specifier) {
            Intrinsics.checkNotNullParameter(specifier, "specifier");
            KtExpression delegateExpression = specifier.getDelegateExpression();
            this.generateInstructions(delegateExpression);
            if (delegateExpression != null) {
                KtElement[] ktElementArray = new KtElement[]{delegateExpression};
                this.createSyntheticValue(specifier, MagicKind.VALUE_CONSUMER, ktElementArray);
            }
        }

        @Override
        public void visitSuperTypeEntry(@NotNull KtSuperTypeEntry specifier) {
            Intrinsics.checkNotNullParameter(specifier, "specifier");
        }

        @Override
        public void visitSuperTypeList(@NotNull KtSuperTypeList list) {
            Intrinsics.checkNotNullParameter(list, "list");
            list.acceptChildren(this);
        }

        @Override
        public void visitKtFile(@NotNull KtFile file2) {
            Intrinsics.checkNotNullParameter(file2, "file");
            for (KtDeclaration declaration : file2.getDeclarations()) {
                if (!(declaration instanceof KtProperty)) continue;
                this.generateInstructions(declaration);
            }
        }

        @Override
        public void visitDoubleColonExpression(@NotNull KtDoubleColonExpression expression2) {
            PseudoValue pseudoValue;
            Intrinsics.checkNotNullParameter(expression2, "expression");
            this.mark(expression2);
            KtExpression receiverExpression = expression2.getReceiverExpression();
            if (receiverExpression != null && ControlFlowProcessor.this.trace.getBindingContext().get(BindingContext.DOUBLE_COLON_LHS, receiverExpression) instanceof DoubleColonLHS.Expression) {
                this.generateInstructions(receiverExpression);
                KtElement[] ktElementArray = new KtElement[]{receiverExpression};
                pseudoValue = this.createNonSyntheticValue((KtElement)expression2, MagicKind.BOUND_CALLABLE_REFERENCE, ktElementArray);
            } else {
                pseudoValue = this.createNonSyntheticValue((KtElement)expression2, MagicKind.UNBOUND_CALLABLE_REFERENCE, new KtElement[0]);
            }
        }

        @Override
        public void visitKtElement(@NotNull KtElement element) {
            Intrinsics.checkNotNullParameter(element, "element");
            this.createNonSyntheticValue(element, MagicKind.UNSUPPORTED_ELEMENT, new KtElement[0]);
        }

        private final boolean generateQualifier(KtExpression expression2, Qualifier qualifier) {
            FakeCallableDescriptorForObject fakeCallableDescriptorForObject;
            DeclarationDescriptor qualifierDescriptor = qualifier.getDescriptor();
            if (qualifierDescriptor instanceof ClassDescriptor && (fakeCallableDescriptorForObject = TowerLevelsKt.getFakeDescriptorForObject((ClassifierDescriptor)qualifierDescriptor)) != null) {
                FakeCallableDescriptorForObject it = fakeCallableDescriptorForObject;
                boolean bl = false;
                this.mark(expression2);
                this.builder.read(expression2, new AccessTarget.Declaration(it), MapsKt.emptyMap());
                return true;
            }
            return false;
        }

        private final boolean generateCall(KtElement callElement) {
            BindingContext bindingContext = ControlFlowProcessor.this.trace.getBindingContext();
            Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(callElement, bindingContext);
            ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
            if (resolvedCall3 == null || (resolvedCall3 = resolvedCall3.getCall()) == null || (resolvedCall3 = resolvedCall3.getCallElement()) == null) {
                return false;
            }
            ResolvedCall<? extends CallableDescriptor> callElementFromResolvedCall = resolvedCall3;
            if (PsiUtilsKt.isAncestor(callElement, (PsiElement)((Object)callElementFromResolvedCall), true)) {
                return false;
            }
            return this.checkAndGenerateCall(resolvedCall2);
        }

        private final boolean checkAndGenerateCall(ResolvedCall<?> resolvedCall2) {
            if (resolvedCall2 == null) {
                return false;
            }
            this.generateCall(resolvedCall2);
            return true;
        }

        private final InstructionWithValue generateCall(ResolvedCall<?> resolvedCall2) {
            Instruction instruction;
            KtElement ktElement = resolvedCall2.getCall().getCallElement();
            Intrinsics.checkNotNullExpressionValue(ktElement, "getCallElement(...)");
            KtElement callElement = ktElement;
            Map<PseudoValue, ReceiverValue> receivers = this.getReceiverValues(resolvedCall2);
            this.deferredGeneratorsStack.push(new ArrayList());
            SmartFMap<PseudoValue, ValueParameterDescriptor> smartFMap = SmartFMap.emptyMap();
            Intrinsics.checkNotNullExpressionValue(smartFMap, "emptyMap(...)");
            SmartFMap<PseudoValue, ValueParameterDescriptor> parameterValues = smartFMap;
            for (ValueArgument valueArgument : resolvedCall2.getCall().getValueArguments()) {
                ArgumentMapping argumentMapping2;
                Intrinsics.checkNotNullExpressionValue(resolvedCall2.getArgumentMapping(valueArgument), "getArgumentMapping(...)");
                KtExpression argumentExpression = valueArgument.getArgumentExpression();
                if (argumentMapping2 instanceof ArgumentMatch) {
                    Intrinsics.checkNotNull(valueArgument);
                    parameterValues = this.generateValueArgument(valueArgument, ((ArgumentMatch)argumentMapping2).getValueParameter(), parameterValues);
                    continue;
                }
                if (argumentExpression == null) continue;
                this.generateInstructions(argumentExpression);
                KtElement[] ktElementArray = new KtElement[]{argumentExpression};
                this.createSyntheticValue(argumentExpression, MagicKind.VALUE_CONSUMER, ktElementArray);
            }
            if (resolvedCall2.getResultingDescriptor() instanceof VariableDescriptor) {
                KtExpression ktExpression = callElement instanceof KtExpression ? (KtExpression)callElement : null;
                if (ktExpression == null) {
                    throw new IllegalStateException(("Variable-based call without callee expression: " + callElement.getText()).toString());
                }
                KtExpression ktExpression2 = ktExpression;
                boolean argumentMapping2 = parameterValues.isEmpty();
                if (_Assertions.ENABLED && !argumentMapping2) {
                    boolean bl = false;
                    String string2 = "Variable-based call with non-empty argument list: " + ((KtExpression)callElement).getText();
                    throw new AssertionError((Object)string2);
                }
                instruction = this.builder.readVariable(ktExpression2, resolvedCall2, receivers);
            } else {
                KtElement ktElement2 = resolvedCall2.getCall().getCallElement();
                Intrinsics.checkNotNullExpressionValue(ktElement2, "getCallElement(...)");
                this.mark(ktElement2);
                instruction = this.builder.call(callElement, resolvedCall2, receivers, (Map<PseudoValue, ? extends ValueParameterDescriptor>)parameterValues);
            }
            Instruction callInstruction = instruction;
            List<Function1<ControlFlowBuilder, Unit>> list = this.deferredGeneratorsStack.pop();
            Intrinsics.checkNotNullExpressionValue(list, "pop(...)");
            Iterable iterable = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : iterable) {
                Function1 it = (Function1)element$iv;
                boolean bl = false;
                it.invoke(this.builder);
            }
            return (InstructionWithValue)callInstruction;
        }

        private final Map<PseudoValue, ReceiverValue> getReceiverValues(ResolvedCall<?> resolvedCall2) {
            PseudoValue varCallResult = null;
            ReceiverValue explicitReceiver = null;
            if (resolvedCall2 instanceof VariableAsFunctionResolvedCall) {
                varCallResult = this.generateCall(((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getVariableCall()).getOutputValue();
                switch (WhenMappings.$EnumSwitchMapping$0[resolvedCall2.getExplicitReceiverKind().ordinal()]) {
                    case 1: {
                        explicitReceiver = resolvedCall2.getDispatchReceiver();
                        break;
                    }
                    case 2: 
                    case 3: {
                        explicitReceiver = resolvedCall2.getExtensionReceiver();
                        break;
                    }
                    case 4: {
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            SmartFMap<PseudoValue, ReceiverValue> smartFMap = SmartFMap.emptyMap();
            Intrinsics.checkNotNullExpressionValue(smartFMap, "emptyMap(...)");
            SmartFMap<PseudoValue, ReceiverValue> receiverValues = smartFMap;
            if (explicitReceiver != null && varCallResult != null) {
                receiverValues = receiverValues.plus(varCallResult, explicitReceiver);
            }
            KtElement ktElement = resolvedCall2.getCall().getCallElement();
            Intrinsics.checkNotNullExpressionValue(ktElement, "getCallElement(...)");
            KtElement callElement = ktElement;
            receiverValues = this.getReceiverValues(callElement, resolvedCall2.getDispatchReceiver(), receiverValues);
            receiverValues = this.getReceiverValues(callElement, resolvedCall2.getExtensionReceiver(), receiverValues);
            return receiverValues;
        }

        private final SmartFMap<PseudoValue, ReceiverValue> getReceiverValues(KtElement callElement, ReceiverValue receiver, SmartFMap<PseudoValue, ReceiverValue> receiverValuesArg) {
            SmartFMap<PseudoValue, ReceiverValue> receiverValues = receiverValuesArg;
            if (receiver == null || receiverValues.containsValue(receiver)) {
                return receiverValues;
            }
            ReceiverValue receiverValue = receiver;
            if (receiverValue instanceof ImplicitReceiver) {
                DeclarationDescriptor declaration;
                if (callElement instanceof KtCallExpression && (declaration = ((ImplicitReceiver)receiver).getDeclarationDescriptor()) instanceof ClassDescriptor) {
                    FakeCallableDescriptorForObject fakeDescriptor = TowerLevelsKt.getFakeDescriptorForObject((ClassifierDescriptor)declaration);
                    KtExpression calleeExpression = ((KtCallExpression)callElement).getCalleeExpression();
                    if (fakeDescriptor != null && calleeExpression != null) {
                        this.builder.read(calleeExpression, new AccessTarget.Declaration(fakeDescriptor), MapsKt.emptyMap());
                    }
                }
                receiverValues = receiverValues.plus(this.createSyntheticValue(callElement, MagicKind.IMPLICIT_RECEIVER, new KtElement[0]), receiver);
            } else if (receiverValue instanceof ExpressionReceiver) {
                PseudoValue receiverPseudoValue;
                KtExpression expression2 = ((ExpressionReceiver)receiver).getExpression();
                if (this.builder.getBoundValue(expression2) == null) {
                    this.generateInstructions(expression2);
                }
                if ((receiverPseudoValue = this.getBoundOrUnreachableValue(expression2)) != null) {
                    receiverValues = receiverValues.plus(receiverPseudoValue, receiver);
                }
            } else if (!(receiverValue instanceof TransientReceiver)) {
                throw new IllegalArgumentException("Unknown receiver kind: " + receiver);
            }
            return receiverValues;
        }

        private final SmartFMap<PseudoValue, ValueParameterDescriptor> generateValueArgument(ValueArgument valueArgument, ValueParameterDescriptor parameterDescriptor, SmartFMap<PseudoValue, ValueParameterDescriptor> parameterValuesArg) {
            SmartFMap<PseudoValue, ValueParameterDescriptor> parameterValues = parameterValuesArg;
            KtExpression expression2 = valueArgument.getArgumentExpression();
            if (expression2 != null) {
                PseudoValue argValue;
                if (!valueArgument.isExternal()) {
                    this.generateInstructions(expression2);
                }
                if ((argValue = this.getBoundOrUnreachableValue(expression2)) != null) {
                    parameterValues = parameterValues.plus(argValue, parameterDescriptor);
                }
            }
            return parameterValues;
        }

        private static final PseudoValue getValueAsFunction$lambda$3(PseudoValue $value) {
            return $value;
        }

        private static final PseudoValue getDeferredValue$lambda$4(CFPVisitor this$0, KtExpression $expression) {
            this$0.generateInstructions($expression);
            return this$0.getBoundOrUnreachableValue($expression);
        }

        private static final Unit visitInlinedFunction$lambda$18(EventOccurrencesRange $eventOccurrencesRange, KtFunction $lambdaFunctionLiteral, ControlFlowProcessor this$0, ControlFlowBuilder builder) {
            Intrinsics.checkNotNullParameter(builder, "builder");
            Label beforeDeclaration = builder.createUnboundLabel("before inlined declaration");
            Label afterDeclaration = builder.createUnboundLabel("after inlined declaration");
            builder.bindLabel(beforeDeclaration);
            if (!EventOccurrencesRangeKt.isDefinitelyVisited($eventOccurrencesRange)) {
                builder.nondeterministicJump(afterDeclaration, $lambdaFunctionLiteral, null);
            }
            this$0.generate($lambdaFunctionLiteral, $eventOccurrencesRange);
            if (EventOccurrencesRangeKt.canBeRevisited($eventOccurrencesRange)) {
                builder.nondeterministicJump(beforeDeclaration, $lambdaFunctionLiteral, null);
            }
            builder.bindLabel(afterDeclaration);
            return Unit.INSTANCE;
        }

        public static final /* synthetic */ boolean access$generateCall(CFPVisitor $this, KtElement callElement) {
            return $this.generateCall(callElement);
        }

        public static final /* synthetic */ PseudoValue access$createNonSyntheticValue(CFPVisitor $this, KtElement to, MagicKind kind, KtElement ... from2) {
            return $this.createNonSyntheticValue(to, kind, from2);
        }

        public static final /* synthetic */ void access$mark(CFPVisitor $this, KtElement element) {
            $this.mark(element);
        }

        public static final /* synthetic */ void access$copyValue(CFPVisitor $this, KtElement from2, KtElement to) {
            $this.copyValue(from2, to);
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\t\u001a\u00020\nR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor$FinallyBlockGenerator;", "", "finallyBlock", "Lorg/jetbrains/kotlin/psi/KtFinallySection;", "<init>", "(Lorg/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor;Lorg/jetbrains/kotlin/psi/KtFinallySection;)V", "startFinally", "Lorg/jetbrains/kotlin/cfg/Label;", "finishFinally", "generate", "", "cfg"})
        @SourceDebugExtension(value={"SMAP\nControlFlowProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ControlFlowProcessor.kt\norg/jetbrains/kotlin/cfg/ControlFlowProcessor$CFPVisitor$FinallyBlockGenerator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1701:1\n1#2:1702\n*E\n"})
        private final class FinallyBlockGenerator {
            @Nullable
            private final KtFinallySection finallyBlock;
            @Nullable
            private Label startFinally;
            @Nullable
            private Label finishFinally;

            public FinallyBlockGenerator(KtFinallySection finallyBlock) {
                this.finallyBlock = finallyBlock;
            }

            public final void generate() {
                ElementBase elementBase = this.finallyBlock;
                if (elementBase == null || (elementBase = elementBase.getFinalExpression()) == null) {
                    return;
                }
                ElementBase finalExpression = elementBase;
                CFPVisitor.this.catchFinallyStack.push(new CatchFinallyLabels(null, null, null));
                Label label = this.startFinally;
                if (label != null) {
                    boolean bl;
                    Label label2 = label;
                    CFPVisitor cFPVisitor = CFPVisitor.this;
                    Label it = label2;
                    boolean bl2 = false;
                    boolean bl3 = bl = this.finishFinally != null;
                    if (_Assertions.ENABLED && !bl) {
                        boolean bl4 = false;
                        String string2 = "startFinally label is set to " + this.startFinally + " but finishFinally label is not set";
                        throw new AssertionError((Object)string2);
                    }
                    ControlFlowBuilder controlFlowBuilder = cFPVisitor.builder;
                    Label label3 = this.finishFinally;
                    Intrinsics.checkNotNull(label3);
                    controlFlowBuilder.repeatPseudocode(it, label3);
                    cFPVisitor.catchFinallyStack.pop();
                    return;
                }
                label = CFPVisitor.this.builder.createUnboundLabel("start finally");
                CFPVisitor cFPVisitor = CFPVisitor.this;
                Label it = label;
                boolean bl = false;
                this.startFinally = it;
                cFPVisitor.builder.bindLabel(it);
                CFPVisitor.this.generateInstructions((KtElement)((Object)finalExpression));
                label = CFPVisitor.this.builder.createUnboundLabel("finish finally");
                cFPVisitor = CFPVisitor.this;
                it = label;
                boolean bl5 = false;
                this.finishFinally = it;
                cFPVisitor.builder.bindLabel(it);
                CFPVisitor.this.catchFinallyStack.pop();
            }
        }

        @Metadata(mv={2, 1, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ExplicitReceiverKind.values().length];
                try {
                    nArray[ExplicitReceiverKind.DISPATCH_RECEIVER.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ExplicitReceiverKind.EXTENSION_RECEIVER.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ExplicitReceiverKind.BOTH_RECEIVERS.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ExplicitReceiverKind.NO_EXPLICIT_RECEIVER.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B%\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/cfg/ControlFlowProcessor$CatchFinallyLabels;", "", "onException", "Lorg/jetbrains/kotlin/cfg/Label;", "toFinally", "tryExpression", "Lorg/jetbrains/kotlin/psi/KtTryExpression;", "<init>", "(Lorg/jetbrains/kotlin/cfg/Label;Lorg/jetbrains/kotlin/cfg/Label;Lorg/jetbrains/kotlin/psi/KtTryExpression;)V", "getOnException", "()Lorg/jetbrains/kotlin/cfg/Label;", "getToFinally", "getTryExpression", "()Lorg/jetbrains/kotlin/psi/KtTryExpression;", "cfg"})
    private static final class CatchFinallyLabels {
        @Nullable
        private final Label onException;
        @Nullable
        private final Label toFinally;
        @Nullable
        private final KtTryExpression tryExpression;

        public CatchFinallyLabels(@Nullable Label onException, @Nullable Label toFinally, @Nullable KtTryExpression tryExpression) {
            this.onException = onException;
            this.toFinally = toFinally;
            this.tryExpression = tryExpression;
        }

        @Nullable
        public final Label getOnException() {
            return this.onException;
        }

        @Nullable
        public final Label getToFinally() {
            return this.toFinally;
        }

        @Nullable
        public final KtTryExpression getTryExpression() {
            return this.tryExpression;
        }
    }
}

