/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirModifier;
import org.jetbrains.kotlin.fir.analysis.checkers.FirModifierList;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.resolve.Compatibility;
import org.jetbrains.kotlin.resolve.ModifierCheckerHelpersKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001aL\u0010\u0000\u001a\u00020\u00012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0010\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a:\u0010\r\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0010\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u001e\u0010\r\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0012"}, d2={"checkCompatibilityType", "", "firstModifier", "Lorg/jetbrains/kotlin/fir/analysis/checkers/FirModifier;", "secondModifier", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reportedNodes", "", "owner", "Lorg/jetbrains/kotlin/fir/FirElement;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "checkModifiersCompatibility", "modifierList", "Lorg/jetbrains/kotlin/fir/analysis/checkers/FirModifierList;", "typeArgument", "Lorg/jetbrains/kotlin/fir/types/FirTypeProjection;", "checkers"})
@SourceDebugExtension(value={"SMAP\nModifiersCompatibilityUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModifiersCompatibilityUtils.kt\norg/jetbrains/kotlin/fir/analysis/checkers/ModifiersCompatibilityUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,122:1\n1#2:123\n*E\n"})
public final class ModifiersCompatibilityUtilsKt {
    public static final void checkCompatibilityType(@NotNull FirModifier<?> firstModifier, @NotNull FirModifier<?> secondModifier, @NotNull DiagnosticReporter reporter, @NotNull Set<FirModifier<?>> reportedNodes, @Nullable FirElement owner, @NotNull CheckerContext context) {
        Intrinsics.checkNotNullParameter(firstModifier, "firstModifier");
        Intrinsics.checkNotNullParameter(secondModifier, "secondModifier");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(reportedNodes, "reportedNodes");
        Intrinsics.checkNotNullParameter(context, "context");
        KtModifierKeywordToken firstModifierToken = firstModifier.getToken();
        KtModifierKeywordToken secondModifierToken = secondModifier.getToken();
        Compatibility compatibilityType = ModifierCheckerHelpersKt.compatibility(firstModifierToken, secondModifierToken);
        switch (WhenMappings.$EnumSwitchMapping$0[compatibilityType.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                if (!reportedNodes.add(secondModifier)) break;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)secondModifier.getSource(), FirErrors.INSTANCE.getREPEATED_MODIFIER(), (Object)secondModifierToken, (DiagnosticContext)context, null, 16, null);
                break;
            }
            case 3: {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)secondModifier.getSource(), FirErrors.INSTANCE.getREDUNDANT_MODIFIER(), (Object)secondModifierToken, (Object)firstModifierToken, (DiagnosticContext)context, null, 32, null);
                break;
            }
            case 4: {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)firstModifier.getSource(), FirErrors.INSTANCE.getREDUNDANT_MODIFIER(), (Object)firstModifierToken, (Object)secondModifierToken, (DiagnosticContext)context, null, 32, null);
                break;
            }
            case 5: {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)firstModifier.getSource(), FirErrors.INSTANCE.getDEPRECATED_MODIFIER_PAIR(), (Object)firstModifierToken, (Object)secondModifierToken, (DiagnosticContext)context, null, 32, null);
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)secondModifier.getSource(), FirErrors.INSTANCE.getDEPRECATED_MODIFIER_PAIR(), (Object)secondModifierToken, (Object)firstModifierToken, (DiagnosticContext)context, null, 32, null);
                break;
            }
            case 6: 
            case 7: {
                if (compatibilityType == Compatibility.COMPATIBLE_FOR_CLASSES_ONLY && owner instanceof FirClass) {
                    return;
                }
                if (reportedNodes.add(firstModifier)) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)firstModifier.getSource(), FirErrors.INSTANCE.getINCOMPATIBLE_MODIFIERS(), (Object)firstModifierToken, (Object)secondModifierToken, (DiagnosticContext)context, null, 32, null);
                }
                if (!reportedNodes.add(secondModifier)) break;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)secondModifier.getSource(), FirErrors.INSTANCE.getINCOMPATIBLE_MODIFIERS(), (Object)secondModifierToken, (Object)firstModifierToken, (DiagnosticContext)context, null, 32, null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private static final void checkModifiersCompatibility(FirElement owner, FirModifierList modifierList2, DiagnosticReporter reporter, Set<FirModifier<?>> reportedNodes, CheckerContext context) {
        List<FirModifier<?>> modifiers = modifierList2.getModifiers();
        Iterator iterator2 = ((Iterable)modifiers).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int secondIndex = n++;
            FirModifier secondModifier = (FirModifier)iterator2.next();
            for (int firstIndex = 0; firstIndex < secondIndex; ++firstIndex) {
                ModifiersCompatibilityUtilsKt.checkCompatibilityType(modifiers.get(firstIndex), secondModifier, reporter, reportedNodes, owner, context);
            }
        }
    }

    public static final void checkModifiersCompatibility(@NotNull FirTypeProjection typeArgument, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        KtSourceElement ktSourceElement;
        block5: {
            block4: {
                KtSourceElement ktSourceElement2;
                Intrinsics.checkNotNullParameter(typeArgument, "typeArgument");
                Intrinsics.checkNotNullParameter(context, "context");
                Intrinsics.checkNotNullParameter(reporter, "reporter");
                ktSourceElement = typeArgument.getSource();
                if (ktSourceElement == null) break block4;
                KtSourceElement it = ktSourceElement2 = ktSourceElement;
                boolean bl = false;
                ktSourceElement = it.getKind() instanceof KtRealSourceElementKind ? ktSourceElement2 : null;
                if (ktSourceElement != null) break block5;
            }
            return;
        }
        KtSourceElement source = ktSourceElement;
        FirModifierList firModifierList = FirKeywordUtilsKt.getModifierList(source);
        if (firModifierList == null) {
            return;
        }
        FirModifierList modifierList2 = firModifierList;
        HashSet reportedNodes = new HashSet();
        ModifiersCompatibilityUtilsKt.checkModifiersCompatibility(typeArgument, modifierList2, reporter, reportedNodes, context);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Compatibility.values().length];
            try {
                nArray[Compatibility.COMPATIBLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Compatibility.REPEATED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Compatibility.REDUNDANT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Compatibility.REVERSE_REDUNDANT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Compatibility.DEPRECATED.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Compatibility.INCOMPATIBLE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Compatibility.COMPATIBLE_FOR_CLASSES_ONLY.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

