/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.library;

import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.konan.file.File;
import org.jetbrains.kotlin.konan.file.FileKt;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.library.KotlinLibraryKt;
import org.jetbrains.kotlin.library.KotlinLibrarySearchPathResolver;
import org.jetbrains.kotlin.library.LenientUnresolvedLibrary;
import org.jetbrains.kotlin.library.RequiredUnresolvedLibrary;
import org.jetbrains.kotlin.library.SearchPathResolver;
import org.jetbrains.kotlin.library.UnresolvedLibrary;
import org.jetbrains.kotlin.util.Logger;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001TBE\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ&\u00106\u001a\b\u0012\u0004\u0012\u00028\u00000\u00052\u0006\u00107\u001a\u00020\u000b2\u0006\u00108\u001a\u00020\u000b2\u0006\u00109\u001a\u00020\u000bH\u0016J\u0016\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00100;2\u0006\u0010<\u001a\u00020\u0006H\u0002J \u0010=\u001a\b\u0012\u0004\u0012\u00028\u00000;2\u0006\u0010>\u001a\u00020\u00102\b\b\u0002\u0010?\u001a\u00020\u0006H\u0002J\u001e\u0010@\u001a\b\u0012\u0004\u0012\u00028\u00000\u00052\u0006\u0010A\u001a\u00020\u00102\u0006\u0010B\u001a\u00020\u000bH&J\u001d\u0010C\u001a\u00020\u000b2\u0006\u0010D\u001a\u00028\u00002\u0006\u0010E\u001a\u00020*H\u0016\u00a2\u0006\u0002\u0010FJ\u0016\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00100;2\u0006\u0010H\u001a\u00020\u0006H\u0016J\u0015\u0010I\u001a\u00028\u00002\u0006\u0010H\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010JJ\u001f\u0010I\u001a\u0004\u0018\u00018\u00002\u0006\u0010E\u001a\u00020K2\u0006\u0010L\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010MJ\u001d\u0010I\u001a\u00028\u00002\u0006\u0010E\u001a\u00020N2\u0006\u0010L\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010OJ\u001f\u0010P\u001a\u0004\u0018\u00018\u00002\u0006\u0010E\u001a\u00020*2\u0006\u0010L\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010QJ\u0012\u0010R\u001a\u0004\u0018\u00010\u00102\u0006\u0010S\u001a\u00020\u0006H\u0002R\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R!\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u0017\u0010\u0015R\u0013\u0010\u001a\u001a\u0004\u0018\u00010\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0012R\u0016\u0010\u001c\u001a\u0004\u0018\u00010\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0012R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0013\u0010 \u001a\u0004\u0018\u00010\u00108F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0012R\u0013\u0010\t\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u001fR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R!\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00100\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010\u0019\u001a\u0004\b&\u0010\u0015R>\u0010(\u001a2\u0012\u0004\u0012\u00020*\u0012\u000e\u0012\f0+R\b\u0012\u0004\u0012\u00028\u00000\u00000)j\u0018\u0012\u0004\u0012\u00020*\u0012\u000e\u0012\f0+R\b\u0012\u0004\u0012\u00028\u00000\u0000`,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010-\u001a\b\u0012\u0004\u0012\u00020.0\u00058VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b0\u0010\u0019\u001a\u0004\b/\u0010\u0015R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u0018\u00103\u001a\u00020\u0010*\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00105\u00a8\u0006U"}, d2={"Lorg/jetbrains/kotlin/library/KotlinLibrarySearchPathResolver;", "L", "Lorg/jetbrains/kotlin/library/KotlinLibrary;", "Lorg/jetbrains/kotlin/library/SearchPathResolver;", "repositories", "", "", "directLibs", "distributionKlib", "localKotlinDir", "skipCurrentDir", "", "logger", "Lorg/jetbrains/kotlin/util/Logger;", "(Ljava/util/List;Ljava/util/List;Ljava/lang/String;Ljava/lang/String;ZLorg/jetbrains/kotlin/util/Logger;)V", "currentDirHead", "Lorg/jetbrains/kotlin/konan/file/File;", "getCurrentDirHead", "()Lorg/jetbrains/kotlin/konan/file/File;", "defaultRoots", "getDefaultRoots", "()Ljava/util/List;", "directLibraries", "getDirectLibraries", "directLibraries$delegate", "Lkotlin/Lazy;", "distHead", "getDistHead", "distPlatformHead", "getDistPlatformHead", "getDistributionKlib", "()Ljava/lang/String;", "localHead", "getLocalHead", "getLocalKotlinDir", "getLogger", "()Lorg/jetbrains/kotlin/util/Logger;", "repoRoots", "getRepoRoots", "repoRoots$delegate", "resolvedLibraries", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/library/UnresolvedLibrary;", "Lorg/jetbrains/kotlin/library/KotlinLibrarySearchPathResolver$ResolvedLibrary;", "Lkotlin/collections/HashMap;", "searchRoots", "Lorg/jetbrains/kotlin/library/SearchPathResolver$SearchRoot;", "getSearchRoots", "searchRoots$delegate", "getSkipCurrentDir", "()Z", "klib", "getKlib", "(Lorg/jetbrains/kotlin/konan/file/File;)Lorg/jetbrains/kotlin/konan/file/File;", "defaultLinks", "noStdLib", "noDefaultLibs", "noEndorsedLibs", "directLibsSequence", "Lkotlin/sequences/Sequence;", "givenName", "getDefaultLibrariesFromDir", "directory", "prefix", "libraryComponentBuilder", "file", "isDefault", "libraryMatch", "candidate", "unresolved", "(Lorg/jetbrains/kotlin/library/KotlinLibrary;Lorg/jetbrains/kotlin/library/UnresolvedLibrary;)Z", "resolutionSequence", "givenPath", "resolve", "(Ljava/lang/String;)Lorg/jetbrains/kotlin/library/KotlinLibrary;", "Lorg/jetbrains/kotlin/library/LenientUnresolvedLibrary;", "isDefaultLink", "(Lorg/jetbrains/kotlin/library/LenientUnresolvedLibrary;Z)Lorg/jetbrains/kotlin/library/KotlinLibrary;", "Lorg/jetbrains/kotlin/library/RequiredUnresolvedLibrary;", "(Lorg/jetbrains/kotlin/library/RequiredUnresolvedLibrary;Z)Lorg/jetbrains/kotlin/library/KotlinLibrary;", "resolveOrNull", "(Lorg/jetbrains/kotlin/library/UnresolvedLibrary;Z)Lorg/jetbrains/kotlin/library/KotlinLibrary;", "validFileOrNull", "path", "ResolvedLibrary", "kotlin-util-klib"})
@SourceDebugExtension(value={"SMAP\nSearchPathResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SearchPathResolver.kt\norg/jetbrains/kotlin/library/KotlinLibrarySearchPathResolver\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,404:1\n381#2,3:405\n384#2,4:409\n1#3:408\n1557#4:413\n1628#4,3:414\n774#4:417\n865#4,2:418\n*S KotlinDebug\n*F\n+ 1 SearchPathResolver.kt\norg/jetbrains/kotlin/library/KotlinLibrarySearchPathResolver\n*L\n239#1:405,3\n239#1:409,4\n271#1:413\n271#1:414,3\n284#1:417\n284#1:418,2\n*E\n"})
public abstract class KotlinLibrarySearchPathResolver<L extends KotlinLibrary>
implements SearchPathResolver<L> {
    @Nullable
    private final String distributionKlib;
    @Nullable
    private final String localKotlinDir;
    private final boolean skipCurrentDir;
    @NotNull
    private final Logger logger;
    @Nullable
    private final File distPlatformHead;
    @NotNull
    private final Lazy repoRoots$delegate;
    @NotNull
    private final Lazy directLibraries$delegate;
    @NotNull
    private final Lazy searchRoots$delegate;
    @NotNull
    private final HashMap<UnresolvedLibrary, ResolvedLibrary> resolvedLibraries;

    public KotlinLibrarySearchPathResolver(@NotNull List<String> repositories, @NotNull List<String> directLibs, @Nullable String distributionKlib, @Nullable String localKotlinDir, boolean skipCurrentDir, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter(repositories, "repositories");
        Intrinsics.checkNotNullParameter(directLibs, "directLibs");
        Intrinsics.checkNotNullParameter(logger, "logger");
        this.distributionKlib = distributionKlib;
        this.localKotlinDir = localKotlinDir;
        this.skipCurrentDir = skipCurrentDir;
        this.logger = logger;
        this.repoRoots$delegate = LazyKt.lazy((Function0)new Function0<List<? extends File>>(repositories){
            final /* synthetic */ List<String> $repositories;
            {
                this.$repositories = $repositories;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final List<File> invoke() {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = this.$repositories;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string2 = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(new File((String)it));
                }
                return (List)destination$iv$iv;
            }
        });
        this.directLibraries$delegate = LazyKt.lazy(new Function0<List<? extends L>>(directLibs, this){
            final /* synthetic */ List<String> $directLibs;
            final /* synthetic */ KotlinLibrarySearchPathResolver<L> this$0;
            {
                this.$directLibs = $directLibs;
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final List<L> invoke() {
                void $this$flatMapTo$iv$iv;
                void $this$flatMap$iv;
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv = this.$directLibs;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator<T> iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    File it$iv$iv;
                    T element$iv$iv$iv;
                    T element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl = false;
                    String it = (String)element$iv$iv;
                    boolean bl2 = false;
                    if (SearchPathResolver.SearchRoot.Companion.lookUpByAbsolutePath(new File(it)) == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                $this$mapNotNull$iv = (List)destination$iv$iv;
                KotlinLibrarySearchPathResolver<L> kotlinLibrarySearchPathResolver = this.this$0;
                boolean $i$f$flatMap = false;
                destination$iv$iv = $this$flatMap$iv;
                Collection destination$iv$iv2 = new ArrayList<E>();
                boolean $i$f$flatMapTo = false;
                for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                    File it = (File)element$iv$iv;
                    boolean bl = false;
                    Iterable list$iv$iv = kotlinLibrarySearchPathResolver.libraryComponentBuilder(it, false);
                    CollectionsKt.addAll(destination$iv$iv2, list$iv$iv);
                }
                return (List)destination$iv$iv2;
            }
        });
        this.searchRoots$delegate = LazyKt.lazy((Function0)new Function0<List<? extends SearchPathResolver.SearchRoot>>(this, repositories){
            final /* synthetic */ KotlinLibrarySearchPathResolver<L> this$0;
            final /* synthetic */ List<String> $repositories;
            {
                this.this$0 = $receiver;
                this.$repositories = $repositories;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final List<SearchPathResolver.SearchRoot> invoke() {
                SearchPathResolver.SearchRoot searchRoot;
                SearchPathResolver.SearchRoot searchRoot2;
                SearchPathResolver.SearchRoot searchRoot3;
                SearchPathResolver.SearchRoot searchRoot4;
                File it;
                List searchRoots2 = new ArrayList<E>();
                Collection collection = searchRoots2;
                File file2 = this.this$0.getCurrentDirHead();
                if (file2 != null) {
                    it = file2;
                    boolean bl = false;
                    searchRoot4 = new SearchPathResolver.SearchRoot(it, true, false, 4, null);
                } else {
                    searchRoot4 = null;
                }
                collection.add(searchRoot4);
                Iterable $this$mapTo$iv = this.$repositories;
                boolean $i$f$mapTo = false;
                for (T item$iv : $this$mapTo$iv) {
                    void it2;
                    String bl = (String)item$iv;
                    Collection collection2 = searchRoots2;
                    boolean bl2 = false;
                    collection2.add(new SearchPathResolver.SearchRoot(new File((String)it2), true, true));
                }
                Collection cfr_ignored_0 = (Collection)searchRoots2;
                collection = searchRoots2;
                File file3 = this.this$0.getLocalHead();
                if (file3 != null) {
                    it = file3;
                    boolean bl = false;
                    searchRoot3 = new SearchPathResolver.SearchRoot(it, true, true);
                } else {
                    searchRoot3 = null;
                }
                collection.add(searchRoot3);
                collection = searchRoots2;
                File file4 = this.this$0.getDistHead();
                if (file4 != null) {
                    it = file4;
                    boolean bl = false;
                    searchRoot2 = new SearchPathResolver.SearchRoot(it, false, false, 6, null);
                } else {
                    searchRoot2 = null;
                }
                collection.add(searchRoot2);
                collection = searchRoots2;
                File file5 = this.this$0.getDistPlatformHead();
                if (file5 != null) {
                    it = file5;
                    boolean bl = false;
                    searchRoot = new SearchPathResolver.SearchRoot(it, false, false, 6, null);
                } else {
                    searchRoot = null;
                }
                collection.add(searchRoot);
                return CollectionsKt.filterNotNull(searchRoots2);
            }
        });
        this.resolvedLibraries = new HashMap();
    }

    @Nullable
    public final String getDistributionKlib() {
        return this.distributionKlib;
    }

    @Nullable
    public final String getLocalKotlinDir() {
        return this.localKotlinDir;
    }

    public final boolean getSkipCurrentDir() {
        return this.skipCurrentDir;
    }

    @Override
    @NotNull
    public Logger getLogger() {
        return this.logger;
    }

    @Nullable
    public final File getLocalHead() {
        Object object = this.localKotlinDir;
        return object != null && (object = FileKt.File((String)object)) != null ? this.getKlib((File)object) : null;
    }

    @Nullable
    public final File getDistHead() {
        Object object = this.distributionKlib;
        return object != null && (object = FileKt.File((String)object)) != null ? ((File)object).child("common") : null;
    }

    @Nullable
    public File getDistPlatformHead() {
        return this.distPlatformHead;
    }

    @Nullable
    public final File getCurrentDirHead() {
        return !this.skipCurrentDir ? File.Companion.getUserDir() : null;
    }

    @NotNull
    public abstract List<L> libraryComponentBuilder(@NotNull File var1, boolean var2);

    private final List<KotlinLibrary> getDirectLibraries() {
        Lazy lazy = this.directLibraries$delegate;
        return (List)lazy.getValue();
    }

    @Override
    @NotNull
    public List<SearchPathResolver.SearchRoot> getSearchRoots() {
        Lazy lazy = this.searchRoots$delegate;
        return (List)lazy.getValue();
    }

    private final File validFileOrNull(String path) {
        File file2;
        try {
            Path path2 = Paths.get(path, new String[0]);
            Intrinsics.checkNotNullExpressionValue(path2, "get(path)");
            file2 = new File(path2);
        }
        catch (InvalidPathException _) {
            file2 = null;
        }
        return file2;
    }

    private final Sequence<File> directLibsSequence(String givenName) {
        return SequencesKt.map(SequencesKt.filter(CollectionsKt.asSequence((Iterable)this.getDirectLibraries()), (Function1)new Function1<KotlinLibrary, Boolean>(givenName){
            final /* synthetic */ String $givenName;
            {
                this.$givenName = $givenName;
                super(1);
            }

            public final Boolean invoke(KotlinLibrary it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return Intrinsics.areEqual(KotlinLibraryKt.getUniqueName(it), this.$givenName);
            }
        }), directLibsSequence.2.INSTANCE);
    }

    @Override
    @NotNull
    public Sequence<File> resolutionSequence(@NotNull String givenPath) {
        Sequence<File> sequence2;
        Intrinsics.checkNotNullParameter(givenPath, "givenPath");
        File given = this.validFileOrNull(givenPath);
        if (given == null) {
            sequence2 = this.directLibsSequence(givenPath);
        } else if (given.isAbsolute()) {
            File[] fileArray = new File[]{SearchPathResolver.SearchRoot.Companion.lookUpByAbsolutePath(given)};
            sequence2 = SequencesKt.sequenceOf(fileArray);
        } else {
            Sequence repoLibs2 = SequencesKt.map(CollectionsKt.asSequence((Iterable)this.getSearchRoots()), (Function1)new Function1<SearchPathResolver.SearchRoot, File>(given, this){
                final /* synthetic */ File $given;
                final /* synthetic */ KotlinLibrarySearchPathResolver<L> this$0;
                {
                    this.$given = $given;
                    this.this$0 = $receiver;
                    super(1);
                }

                public final File invoke(SearchPathResolver.SearchRoot searchRoot) {
                    File file2;
                    Intrinsics.checkNotNullParameter(searchRoot, "searchRoot");
                    SearchPathResolver.LookupResult lookupResult = searchRoot.lookUp(this.$given);
                    if (lookupResult instanceof SearchPathResolver.LookupResult.Found) {
                        file2 = ((SearchPathResolver.LookupResult.Found)lookupResult).getLibrary();
                    } else if (lookupResult instanceof SearchPathResolver.LookupResult.FoundWithWarning) {
                        this.this$0.getLogger().strongWarning(((SearchPathResolver.LookupResult.FoundWithWarning)lookupResult).getWarningText());
                        file2 = ((SearchPathResolver.LookupResult.FoundWithWarning)lookupResult).getLibrary();
                    } else if (Intrinsics.areEqual(lookupResult, SearchPathResolver.LookupResult.NotFound.INSTANCE)) {
                        file2 = null;
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    return file2;
                }
            });
            sequence2 = SequencesKt.plus(this.directLibsSequence(givenPath), repoLibs2);
        }
        Sequence<File> sequence3 = sequence2;
        return SequencesKt.filterNotNull(sequence3);
    }

    private final L resolveOrNull(UnresolvedLibrary unresolved, boolean isDefaultLink) {
        Object object;
        Map $this$getOrPut$iv = this.resolvedLibraries;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(unresolved);
        if (value$iv == null) {
            ResolvedLibrary resolvedLibrary;
            boolean bl = false;
            String givenPath = unresolved.getPath();
            try {
                KotlinLibrary p0 = (KotlinLibrary)SequencesKt.firstOrNull(SequencesKt.filterNotNull(SequencesKt.map(SequencesKt.flatMap(this.resolutionSequence(givenPath), new Function1<File, Sequence<? extends L>>(this, isDefaultLink){
                    final /* synthetic */ KotlinLibrarySearchPathResolver<L> this$0;
                    final /* synthetic */ boolean $isDefaultLink;
                    {
                        this.this$0 = $receiver;
                        this.$isDefaultLink = $isDefaultLink;
                        super(1);
                    }

                    public final Sequence<L> invoke(File it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        return CollectionsKt.asSequence((Iterable)this.this$0.libraryComponentBuilder(it, this.$isDefaultLink));
                    }
                }), new Function1<L, L>(this, unresolved){
                    final /* synthetic */ KotlinLibrarySearchPathResolver<L> this$0;
                    final /* synthetic */ UnresolvedLibrary $unresolved;
                    {
                        this.this$0 = $receiver;
                        this.$unresolved = $unresolved;
                        super(1);
                    }

                    public final L invoke(L it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        L l = it;
                        KotlinLibrarySearchPathResolver<L> kotlinLibrarySearchPathResolver = this.this$0;
                        UnresolvedLibrary unresolvedLibrary = this.$unresolved;
                        L it2 = l;
                        boolean bl = false;
                        return (L)(kotlinLibrarySearchPathResolver.libraryMatch(it2, unresolvedLibrary) ? l : null);
                    }
                })));
                boolean bl2 = false;
                resolvedLibrary = new ResolvedLibrary(this, p0);
            }
            catch (Throwable e) {
                this.getLogger().error("KLIB resolver: Failed to resolve Kotlin library: " + givenPath + ", due to " + e.getMessage());
                throw e;
            }
            ResolvedLibrary answer$iv = resolvedLibrary;
            $this$getOrPut$iv.put(unresolved, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return ((ResolvedLibrary)object).getLibrary();
    }

    @Override
    @Nullable
    public L resolve(@NotNull LenientUnresolvedLibrary unresolved, boolean isDefaultLink) {
        Intrinsics.checkNotNullParameter(unresolved, "unresolved");
        return this.resolveOrNull(unresolved, isDefaultLink);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public L resolve(@NotNull RequiredUnresolvedLibrary unresolved, boolean isDefaultLink) {
        Intrinsics.checkNotNullParameter(unresolved, "unresolved");
        L l = this.resolveOrNull(unresolved, isDefaultLink);
        if (l == null) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            KotlinLibrarySearchPathResolver $this$resolve_u24lambda_u242 = this;
            boolean bl = false;
            Iterable iterable = $this$resolve_u24lambda_u242.getSearchRoots();
            StringBuilder stringBuilder = new StringBuilder().append("KLIB resolver: Could not find \"").append(unresolved.getPath()).append("\" in ");
            Logger logger = $this$resolve_u24lambda_u242.getLogger();
            boolean $i$f$map = false;
            void var9_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                SearchPathResolver.SearchRoot searchRoot = (SearchPathResolver.SearchRoot)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.getSearchRootPath().getAbsolutePath());
            }
            collection = (List)destination$iv$iv;
            logger.fatal(stringBuilder.append(collection).toString());
            throw null;
        }
        return l;
    }

    @Override
    public boolean libraryMatch(@NotNull L candidate2, @NotNull UnresolvedLibrary unresolved) {
        Intrinsics.checkNotNullParameter(candidate2, "candidate");
        Intrinsics.checkNotNullParameter(unresolved, "unresolved");
        return true;
    }

    @Override
    @NotNull
    public L resolve(@NotNull String givenPath) {
        Intrinsics.checkNotNullParameter(givenPath, "givenPath");
        return this.resolve(new RequiredUnresolvedLibrary(givenPath), false);
    }

    private final File getKlib(File $this$klib) {
        return new File($this$klib, "klib");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<File> getDefaultRoots() {
        void $this$filterTo$iv$iv;
        File[] fileArray = new File[]{this.getDistHead(), this.getDistPlatformHead()};
        Iterable $this$filter$iv = CollectionsKt.listOfNotNull(fileArray);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            File it = (File)element$iv$iv;
            boolean bl = false;
            if (!it.getExists()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final Sequence<L> getDefaultLibrariesFromDir(File directory, String prefix) {
        return directory.getExists() ? SequencesKt.map(SequencesKt.map(SequencesKt.filterNot(SequencesKt.filterNot(SequencesKt.filter(CollectionsKt.asSequence((Iterable)directory.getListFiles()), (Function1)new Function1<File, Boolean>(prefix){
            final /* synthetic */ String $prefix;
            {
                this.$prefix = $prefix;
                super(1);
            }

            public final Boolean invoke(File it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return StringsKt.startsWith$default(it.getName(), this.$prefix, false, 2, null);
            }
        }), getDefaultLibrariesFromDir.2.INSTANCE), getDefaultLibrariesFromDir.3.INSTANCE), getDefaultLibrariesFromDir.4.INSTANCE), new Function1<RequiredUnresolvedLibrary, L>(this){
            final /* synthetic */ KotlinLibrarySearchPathResolver<L> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final L invoke(RequiredUnresolvedLibrary it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return this.this$0.resolve(it, true);
            }
        }) : SequencesKt.emptySequence();
    }

    static /* synthetic */ Sequence getDefaultLibrariesFromDir$default(KotlinLibrarySearchPathResolver kotlinLibrarySearchPathResolver, File file2, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getDefaultLibrariesFromDir");
        }
        if ((n & 2) != 0) {
            string2 = "org.jetbrains.kotlin";
        }
        return kotlinLibrarySearchPathResolver.getDefaultLibrariesFromDir(file2, string2);
    }

    @Override
    @NotNull
    public List<L> defaultLinks(boolean noStdLib, boolean noDefaultLibs, boolean noEndorsedLibs) {
        List result2;
        block4: {
            File it;
            result2 = new ArrayList();
            if (!noStdLib) {
                result2.add(this.resolve(new RequiredUnresolvedLibrary("stdlib"), true));
            }
            if (!noEndorsedLibs) {
                File file2 = this.getDistHead();
                if (file2 != null) {
                    it = file2;
                    boolean bl = false;
                    CollectionsKt.addAll((Collection)result2, KotlinLibrarySearchPathResolver.getDefaultLibrariesFromDir$default(this, it, null, 2, null));
                }
            }
            if (noDefaultLibs) break block4;
            File file3 = this.getDistPlatformHead();
            if (file3 != null) {
                it = file3;
                boolean bl = false;
                CollectionsKt.addAll((Collection)result2, KotlinLibrarySearchPathResolver.getDefaultLibrariesFromDir$default(this, it, null, 2, null));
            }
        }
        return result2;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u0003R\u0015\u0010\u0002\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\n\n\u0002\u0010\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/library/KotlinLibrarySearchPathResolver$ResolvedLibrary;", "", "library", "(Lorg/jetbrains/kotlin/library/KotlinLibrarySearchPathResolver;Lorg/jetbrains/kotlin/library/KotlinLibrary;)V", "getLibrary", "()Lorg/jetbrains/kotlin/library/KotlinLibrary;", "Lorg/jetbrains/kotlin/library/KotlinLibrary;", "kotlin-util-klib"})
    private static final class ResolvedLibrary {
        @Nullable
        private final L library;
        final /* synthetic */ KotlinLibrarySearchPathResolver<L> this$0;

        public ResolvedLibrary(L library) {
            this.this$0 = this$0;
            this.library = library;
        }

        @Nullable
        public final L getLibrary() {
            return this.library;
        }
    }
}

