/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.utils.FirScriptCustomizationKind;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirErrorExpression;
import org.jetbrains.kotlin.fir.expressions.FirLoop;
import org.jetbrains.kotlin.fir.expressions.FirReturnExpression;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirForLoopStatementAssignmentChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirLoop;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirLoopExpressionChecker;", "<init>", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirForLoopStatementAssignmentChecker
extends FirExpressionChecker<FirLoop> {
    @NotNull
    public static final FirForLoopStatementAssignmentChecker INSTANCE = new FirForLoopStatementAssignmentChecker();

    private FirForLoopStatementAssignmentChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirLoop expression2, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        block9: {
            block6: {
                FirElement grandParent;
                block8: {
                    block7: {
                        Intrinsics.checkNotNullParameter(expression2, "expression");
                        Intrinsics.checkNotNullParameter(context, "context");
                        Intrinsics.checkNotNullParameter(reporter, "reporter");
                        if (context.getContainingElements().size() < 2) {
                            return;
                        }
                        FirElement parent2 = context.getContainingElements().get(context.getContainingElements().size() - 2);
                        KtSourceElement ktSourceElement = parent2.getSource();
                        if (!Intrinsics.areEqual(ktSourceElement != null ? ktSourceElement.getKind() : null, KtFakeSourceElementKind.DesugaredForLoop.INSTANCE)) {
                            return;
                        }
                        if (context.getContainingElements().size() < 3) {
                            return;
                        }
                        grandParent = context.getContainingElements().get(context.getContainingElements().size() - 3);
                        if (grandParent instanceof FirBlock) break block6;
                        if (!(grandParent instanceof FirReturnExpression)) break block7;
                        KtSourceElement ktSourceElement2 = ((FirReturnExpression)grandParent).getSource();
                        if (Intrinsics.areEqual(ktSourceElement2 != null ? ktSourceElement2.getKind() : null, KtFakeSourceElementKind.ImplicitReturn.FromLastStatement.INSTANCE)) break block6;
                    }
                    if (!(grandParent instanceof FirProperty)) break block8;
                    FirDeclarationOrigin firDeclarationOrigin = ((FirProperty)grandParent).getOrigin();
                    FirDeclarationOrigin.ScriptCustomization scriptCustomization = firDeclarationOrigin instanceof FirDeclarationOrigin.ScriptCustomization ? (FirDeclarationOrigin.ScriptCustomization)firDeclarationOrigin : null;
                    if ((scriptCustomization != null ? scriptCustomization.getKind() : null) == FirScriptCustomizationKind.RESULT_PROPERTY) break block6;
                }
                if (!(grandParent instanceof FirErrorExpression)) break block9;
            }
            return;
        }
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getEXPRESSION_EXPECTED(), (DiagnosticContext)context, null, 8, null);
    }
}

