/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.common;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.optimization.common.UtilKt;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.TableSwitchInsnNode;
import org.jetbrains.org.objectweb.asm.tree.TryCatchBlockNode;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010!\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00132\u00020\u0001:\u0002\u0012\u0013B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\r2\u0006\u0010\u0010\u001a\u00020\tJ\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\r2\u0006\u0010\u0010\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u001c\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/common/ControlFlowGraph;", "", "insns", "Lorg/jetbrains/org/objectweb/asm/tree/InsnList;", "<init>", "(Lorg/jetbrains/org/objectweb/asm/tree/InsnList;)V", "successors", "", "", "", "[Ljava/util/List;", "predecessors", "getSuccessorsIndices", "", "insn", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "index", "getPredecessorsIndices", "Builder", "Companion", "backend"})
public final class ControlFlowGraph {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InsnList insns;
    @NotNull
    private final List<Integer>[] successors;
    @NotNull
    private final List<Integer>[] predecessors;

    private ControlFlowGraph(InsnList insns) {
        int n;
        this.insns = insns;
        int n2 = 0;
        int n3 = this.insns.size();
        List[] listArray = new List[n3];
        ControlFlowGraph controlFlowGraph = this;
        while (n2 < n3) {
            n = n2++;
            listArray[n] = new ArrayList(2);
        }
        controlFlowGraph.successors = listArray;
        n2 = 0;
        n3 = this.insns.size();
        listArray = new List[n3];
        controlFlowGraph = this;
        while (n2 < n3) {
            n = n2++;
            listArray[n] = new ArrayList(2);
        }
        controlFlowGraph.predecessors = listArray;
    }

    @NotNull
    public final List<Integer> getSuccessorsIndices(@NotNull AbstractInsnNode insn) {
        Intrinsics.checkNotNullParameter(insn, "insn");
        return this.getSuccessorsIndices(this.insns.indexOf(insn));
    }

    @NotNull
    public final List<Integer> getSuccessorsIndices(int index) {
        return this.successors[index];
    }

    @NotNull
    public final List<Integer> getPredecessorsIndices(@NotNull AbstractInsnNode insn) {
        Intrinsics.checkNotNullParameter(insn, "insn");
        return this.getPredecessorsIndices(this.insns.indexOf(insn));
    }

    @NotNull
    public final List<Integer> getPredecessorsIndices(int index) {
        return this.predecessors[index];
    }

    @JvmStatic
    @NotNull
    public static final ControlFlowGraph build(@NotNull MethodNode node, boolean followExceptions) {
        return Companion.build(node, followExceptions);
    }

    public /* synthetic */ ControlFlowGraph(InsnList insns, DefaultConstructorMarker $constructor_marker) {
        this(insns);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0018\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u001f\u001a\u00020 J\b\u0010!\u001a\u00020\"H\u0002J\b\u0010#\u001a\u00020\"H\u0002J\u0010\u0010$\u001a\u00020\"2\u0006\u0010%\u001a\u00020\rH\u0002J\u0018\u0010&\u001a\u00020\"2\u0006\u0010%\u001a\u00020\r2\u0006\u0010'\u001a\u00020(H\u0002J\u0018\u0010)\u001a\u00020\"2\u0006\u0010%\u001a\u00020\r2\u0006\u0010'\u001a\u00020*H\u0002J \u0010+\u001a\u00020\"2\u0006\u0010'\u001a\u00020,2\u0006\u0010%\u001a\u00020\r2\u0006\u0010-\u001a\u00020\rH\u0002J\b\u0010.\u001a\u00020\"H\u0002J\b\u0010/\u001a\u00020\"H\u0002J\u0018\u00100\u001a\u00020\"2\u0006\u00101\u001a\u00020\r2\u0006\u00102\u001a\u00020\rH\u0002J\u0018\u00103\u001a\u00020\"2\u0006\u00101\u001a\u00020\r2\u0006\u00102\u001a\u00020\rH\u0002J\u0010\u00104\u001a\u00020\"2\u0006\u0010%\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00100\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001aR\u0018\u0010\u001b\u001a\u00020\r*\u00020\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u00065"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/common/ControlFlowGraph$Builder;", "", "method", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "followExceptions", "", "<init>", "(Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;Z)V", "instructions", "Lorg/jetbrains/org/objectweb/asm/tree/InsnList;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/org/objectweb/asm/tree/InsnList;", "nInsns", "", "handlers", "", "", "Lorg/jetbrains/org/objectweb/asm/tree/TryCatchBlockNode;", "[Ljava/util/List;", "queued", "", "queue", "", "top", "predecessors", "Lit/unimi/dsi/fastutil/ints/IntOpenHashSet;", "[Lit/unimi/dsi/fastutil/ints/IntOpenHashSet;", "indexOf", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "getIndexOf", "(Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;)I", "build", "Lorg/jetbrains/kotlin/codegen/optimization/common/ControlFlowGraph;", "traverseCfg", "", "checkAssertions", "visitOpInsn", "insn", "visitTableSwitchInsnNode", "insnNode", "Lorg/jetbrains/org/objectweb/asm/tree/TableSwitchInsnNode;", "visitLookupSwitchInsnNode", "Lorg/jetbrains/org/objectweb/asm/tree/LookupSwitchInsnNode;", "visitJumpInsnNode", "Lorg/jetbrains/org/objectweb/asm/tree/JumpInsnNode;", "insnOpcode", "initControlFlowAnalysis", "computeExceptionHandlersForEachInsn", "visitExceptionEdge", "from", "to", "visitEdge", "enqueue", "backend"})
    @SourceDebugExtension(value={"SMAP\nControlFlowGraph.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ControlFlowGraph.kt\norg/jetbrains/kotlin/codegen/optimization/common/ControlFlowGraph$Builder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,164:1\n1863#2,2:165\n1755#2,3:167\n1#3:170\n*S KotlinDebug\n*F\n+ 1 ControlFlowGraph.kt\norg/jetbrains/kotlin/codegen/optimization/common/ControlFlowGraph$Builder\n*L\n79#1:165,2\n86#1:167,3\n*E\n"})
    private static final class Builder {
        @NotNull
        private final MethodNode method;
        private final boolean followExceptions;
        private final InsnList instructions;
        private final int nInsns;
        @NotNull
        private final List<TryCatchBlockNode>[] handlers;
        @NotNull
        private final boolean[] queued;
        @NotNull
        private final int[] queue;
        private int top;
        @NotNull
        private final IntOpenHashSet[] predecessors;

        public Builder(@NotNull MethodNode method, boolean followExceptions) {
            Intrinsics.checkNotNullParameter(method, "method");
            this.method = method;
            this.followExceptions = followExceptions;
            this.instructions = this.method.instructions;
            this.nInsns = this.instructions.size();
            this.handlers = new List[this.nInsns];
            this.queued = new boolean[this.nInsns];
            this.queue = new int[this.nInsns];
            int n = 0;
            int n2 = this.nInsns;
            IntOpenHashSet[] intOpenHashSetArray = new IntOpenHashSet[n2];
            Builder builder = this;
            while (n < n2) {
                int n3 = n++;
                intOpenHashSetArray[n3] = new IntOpenHashSet();
            }
            builder.predecessors = intOpenHashSetArray;
        }

        private final int getIndexOf(AbstractInsnNode $this$indexOf) {
            return this.instructions.indexOf($this$indexOf);
        }

        @NotNull
        public final ControlFlowGraph build() {
            InsnList insnList = this.method.instructions;
            Intrinsics.checkNotNullExpressionValue(insnList, "instructions");
            ControlFlowGraph graph2 = new ControlFlowGraph(insnList, null);
            if (this.nInsns == 0) {
                return graph2;
            }
            this.checkAssertions();
            this.computeExceptionHandlersForEachInsn();
            this.initControlFlowAnalysis();
            this.traverseCfg();
            IntOpenHashSet[] intOpenHashSetArray = this.predecessors;
            int n = intOpenHashSetArray.length;
            for (int i = 0; i < n; ++i) {
                int i2 = i;
                IntOpenHashSet preds = intOpenHashSetArray[i];
                for (int pred : preds.toIntArray()) {
                    graph2.predecessors[i2].add(pred);
                    graph2.successors[pred].add(i2);
                }
            }
            return graph2;
        }

        private final void traverseCfg() {
            while (this.top > 0) {
                this.top += -1;
                int insn = this.queue[this.top];
                AbstractInsnNode insnNode = this.method.instructions.get(insn);
                int insnOpcode = insnNode.getOpcode();
                Intrinsics.checkNotNull(insnNode);
                switch (UtilKt.getNodeType(insnNode)) {
                    case 8: 
                    case 14: 
                    case 15: {
                        this.visitOpInsn(insn);
                        break;
                    }
                    case 7: {
                        this.visitJumpInsnNode((JumpInsnNode)insnNode, insn, insnOpcode);
                        break;
                    }
                    case 12: {
                        this.visitLookupSwitchInsnNode(insn, (LookupSwitchInsnNode)insnNode);
                        break;
                    }
                    case 11: {
                        this.visitTableSwitchInsnNode(insn, (TableSwitchInsnNode)insnNode);
                        break;
                    }
                    default: {
                        if (insnOpcode == 191 || insnOpcode >= 172 && insnOpcode <= 177) break;
                        this.visitOpInsn(insn);
                    }
                }
                List<TryCatchBlockNode> list = this.handlers[insn];
                if (list == null) continue;
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    TryCatchBlockNode tcb = (TryCatchBlockNode)element$iv;
                    boolean bl = false;
                    LabelNode labelNode = tcb.handler;
                    Intrinsics.checkNotNullExpressionValue(labelNode, "handler");
                    this.visitExceptionEdge(insn, this.getIndexOf(labelNode));
                }
            }
        }

        private final void checkAssertions() {
            boolean bl;
            block4: {
                InsnList insnList = this.instructions;
                Intrinsics.checkNotNullExpressionValue(insnList, "instructions");
                Iterable $this$any$iv = insnList;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        AbstractInsnNode it = (AbstractInsnNode)element$iv;
                        boolean bl2 = false;
                        if (!(it.getOpcode() == 168 || it.getOpcode() == 169)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            if (bl) {
                throw new AssertionError((Object)"Subroutines are deprecated since Java 6");
            }
        }

        private final void visitOpInsn(int insn) {
            this.visitEdge(insn, insn + 1);
        }

        private final void visitTableSwitchInsnNode(int insn, TableSwitchInsnNode insnNode) {
            LabelNode labelNode = insnNode.dflt;
            Intrinsics.checkNotNullExpressionValue(labelNode, "dflt");
            int jump = this.getIndexOf(labelNode);
            this.visitEdge(insn, jump);
            for (LabelNode label : insnNode.labels) {
                Intrinsics.checkNotNull(label);
                jump = this.getIndexOf(label);
                this.visitEdge(insn, jump);
            }
        }

        private final void visitLookupSwitchInsnNode(int insn, LookupSwitchInsnNode insnNode) {
            LabelNode labelNode = insnNode.dflt;
            Intrinsics.checkNotNullExpressionValue(labelNode, "dflt");
            int jump = this.getIndexOf(labelNode);
            this.visitEdge(insn, jump);
            for (LabelNode label : insnNode.labels) {
                Intrinsics.checkNotNull(label);
                jump = this.getIndexOf(label);
                this.visitEdge(insn, jump);
            }
        }

        private final void visitJumpInsnNode(JumpInsnNode insnNode, int insn, int insnOpcode) {
            if (insnOpcode != 167 && insnOpcode != 168) {
                this.visitEdge(insn, insn + 1);
            }
            LabelNode labelNode = insnNode.label;
            Intrinsics.checkNotNullExpressionValue(labelNode, "label");
            int jump = this.getIndexOf(labelNode);
            this.visitEdge(insn, jump);
        }

        private final void initControlFlowAnalysis() {
            this.queued[0] = true;
            int n = this.top;
            this.top = n + 1;
            this.queue[n] = 0;
        }

        private final void computeExceptionHandlersForEachInsn() {
            for (TryCatchBlockNode tcb : this.method.tryCatchBlocks) {
                LabelNode labelNode = tcb.start;
                Intrinsics.checkNotNullExpressionValue(labelNode, "start");
                int begin = this.getIndexOf(labelNode);
                LabelNode labelNode2 = tcb.end;
                Intrinsics.checkNotNullExpressionValue(labelNode2, "end");
                int end = this.getIndexOf(labelNode2);
                for (int j = begin; j < end; ++j) {
                    List list = this.handlers[j];
                    if (list == null) {
                        ArrayList<TryCatchBlockNode> arrayList;
                        ArrayList<TryCatchBlockNode> it = arrayList = new ArrayList<TryCatchBlockNode>();
                        boolean bl = false;
                        this.handlers[j] = it;
                        list = arrayList;
                    }
                    List insnHandlers = list;
                    Intrinsics.checkNotNull(tcb);
                    insnHandlers.add((TryCatchBlockNode)tcb);
                }
            }
        }

        private final void visitExceptionEdge(int from2, int to) {
            if (this.followExceptions) {
                this.predecessors[to].add(from2);
            }
            this.enqueue(to);
        }

        private final void visitEdge(int from2, int to) {
            this.predecessors[to].add(from2);
            this.enqueue(to);
        }

        private final void enqueue(int insn) {
            if (!this.queued[insn]) {
                this.queued[insn] = true;
                int n = this.top;
                this.top = n + 1;
                this.queue[n] = insn;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/common/ControlFlowGraph$Companion;", "", "<init>", "()V", "build", "Lorg/jetbrains/kotlin/codegen/optimization/common/ControlFlowGraph;", "node", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "followExceptions", "", "backend"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ControlFlowGraph build(@NotNull MethodNode node, boolean followExceptions) {
            Intrinsics.checkNotNullParameter(node, "node");
            return new Builder(node, followExceptions).build();
        }

        public static /* synthetic */ ControlFlowGraph build$default(Companion companion, MethodNode methodNode, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = true;
            }
            return companion.build(methodNode, bl);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

