/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory3;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirVisibilityChecker;
import org.jetbrains.kotlin.fir.FirVisibilityCheckerKt;
import org.jetbrains.kotlin.fir.analysis.FirOverridesBackwardCompatibilityHelperKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirAbstractOverrideChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirDeprecationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirOptInUsageBaseChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.CallToPotentiallyHiddenSymbolResult;
import org.jetbrains.kotlin.fir.declarations.DeprecationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.DeprecationsPerUseSite;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.scopes.FirContainingNamesAwareScopeKt;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScopeKt;
import org.jetbrains.kotlin.fir.scopes.ProcessorAction;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirIntersectionOverrideFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirIntersectionOverridePropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertyAccessorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationInfo;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationLevelValue;
import org.jetbrains.kotlin.resolve.deprecation.SimpleDeprecationInfo;
import org.jetbrains.kotlin.types.TypeCheckerState;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002?@B\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J,\u0010\u000e\u001a\u00020\u000f*\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u001e\u0010\u0013\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u00142\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0002J*\u0010\u0016\u001a\u0018\u0012\u0004\u0012\u00020\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0010\u0012\u0004\u0012\u00020\u00190\u00172\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0002J*\u0010\u001a\u001a\u0018\u0012\u0004\u0012\u00020\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0010\u0012\u0004\u0012\u00020\u00190\u00172\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0002J \u0010\u001e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00102\u0010\u0010\u001f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100 H\u0002J$\u0010!\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0010*\u00020\"2\u0010\u0010\u001f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100 H\u0002J:\u0010#\u001a\u00020\u0007*\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010$\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0010\u0010\u001f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100 2\u0006\u0010\n\u001a\u00020\u000bH\u0002J:\u0010(\u001a\u00020\u0007*\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\f\u001a\u00020\r2\u0010\u0010\u001f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100 2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010)\u001a\u00020*H\u0002J \u0010+\u001a\u00020\u0007*\u0006\u0012\u0002\b\u00030,2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002J:\u0010-\u001a\u00020\u0007*\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\f\u001a\u00020\r2\u0010\u0010.\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100 2\u0006\u0010$\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J<\u0010/\u001a\u00020\u00072\n\u00100\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010$\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u00101\u001a\u0002022\u0006\u0010)\u001a\u00020*2\u0006\u0010\n\u001a\u00020\u000bH\u0002J6\u00103\u001a\u00020\u00072\n\u00104\u001a\u0006\u0012\u0002\b\u00030\u00102\u0010\u0010.\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100 2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J \u00105\u001a\u00020\u0007*\u00020\r2\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0002J,\u00106\u001a\u00020\u0007*\u00020\r2\n\u00107\u001a\u0006\u0012\u0002\b\u00030\u00102\n\u00108\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0002J,\u00109\u001a\u00020\u0007*\u00020\r2\n\u00107\u001a\u0006\u0012\u0002\b\u00030\u00102\n\u00108\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0002J,\u0010:\u001a\u00020\u0007*\u00020\r2\n\u00107\u001a\u0006\u0012\u0002\b\u00030\u00102\n\u00108\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0002J,\u0010;\u001a\u00020\u0007*\u00020\r2\n\u00107\u001a\u0006\u0012\u0002\b\u00030\u00102\n\u00108\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0002J,\u0010<\u001a\u00020\u0007*\u00020\r2\n\u00107\u001a\u0006\u0012\u0002\b\u00030\u00102\n\u00108\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0002J,\u0010=\u001a\u00020\u0007*\u00020\r2\n\u00107\u001a\u0006\u0012\u0002\b\u00030\u00102\n\u00108\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0002J,\u0010>\u001a\u00020\u0007*\u00020\r2\n\u00107\u001a\u0006\u0012\u0002\b\u00030\u00102\n\u00108\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u001c\u0010\u001b\u001a\u00020\u000f*\u0006\u0012\u0002\b\u00030\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0018\u0010%\u001a\u00020\u000f*\u00020\"8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'\u0082\u0001\u0002AB\u00a8\u0006C"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOverrideChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirAbstractOverrideChecker;", "mppKind", "Lorg/jetbrains/kotlin/fir/analysis/checkers/MppCheckerKind;", "<init>", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/MppCheckerKind;)V", "check", "", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "ensureKnownVisibility", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "chooseCannotInferVisibilityFor", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticFactory1;", "symbol", "chooseCannotChangeAccessPrivilegeFor", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticFactory3;", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "Lorg/jetbrains/kotlin/name/Name;", "chooseCannotWeakenAccessPrivilegeFor", "wouldMissDiagnosticInK1", "getWouldMissDiagnosticInK1", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;)Z", "checkModality", "overriddenSymbols", "", "checkMutability", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "checkVisibility", "containingClass", "canDelegateVisibilityConsistencyChecksToAccessors", "getCanDelegateVisibilityConsistencyChecksToAccessors", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;)Z", "checkDeprecation", "firTypeScope", "Lorg/jetbrains/kotlin/fir/scopes/FirTypeScope;", "checkDefaultValues", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;", "checkDataClassCopy", "overriddenMemberSymbols", "checkMember", "member", "typeCheckerState", "Lorg/jetbrains/kotlin/types/TypeCheckerState;", "checkOverriddenExperimentalities", "memberSymbol", "reportNothingToOverride", "reportOverridingFinalMember", "overriding", "overridden", "reportVarOverriddenByVal", "reportCannotWeakenAccessPrivilege", "reportCannotChangeAccessPrivilege", "reportReturnTypeMismatchOnFunction", "reportTypeMismatchOnProperty", "reportTypeMismatchOnVariable", "Regular", "ForExpectClass", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOverrideChecker$ForExpectClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOverrideChecker$Regular;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirOverrideChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirOverrideChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOverrideChecker\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 ClassMembers.kt\norg/jetbrains/kotlin/fir/ClassMembersKt\n+ 6 FirDeclarationUtil.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirDeclarationUtilKt\n*L\n1#1,573:1\n18#2:574\n18#2:576\n13#2:577\n18#2:581\n18#2:601\n25#2:605\n16#2:626\n18#2:633\n18#2:634\n1#3:575\n1#3:598\n1557#4:578\n1628#4,2:579\n1630#4:582\n1053#4:583\n1557#4:584\n1628#4,3:585\n1611#4,9:588\n1863#4:597\n1864#4:599\n1620#4:600\n1755#4,3:602\n295#4:606\n296#4:616\n1368#4:627\n1454#4,5:628\n114#5:607\n107#5,3:608\n98#5:611\n86#5:612\n92#5:614\n111#5:615\n114#5:617\n107#5,3:618\n98#5:621\n86#5:622\n92#5:624\n111#5:625\n39#6:613\n39#6:623\n*S KotlinDebug\n*F\n+ 1 FirOverrideChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOverrideChecker\n*L\n168#1:574\n188#1:576\n194#1:577\n220#1:581\n241#1:601\n356#1:605\n396#1:626\n526#1:633\n542#1:634\n236#1:598\n219#1:578\n219#1:579,2\n219#1:582\n221#1:583\n230#1:584\n230#1:585,3\n236#1:588,9\n236#1:597\n236#1:599\n236#1:600\n256#1:602,3\n373#1:606\n373#1:616\n479#1:627\n479#1:628,5\n376#1:607\n376#1:608,3\n376#1:611\n376#1:612\n376#1:614\n376#1:615\n383#1:617\n383#1:618,3\n383#1:621\n383#1:622\n383#1:624\n383#1:625\n376#1:613\n383#1:623\n*E\n"})
public abstract class FirOverrideChecker
extends FirAbstractOverrideChecker {
    private FirOverrideChecker(MppCheckerKind mppKind) {
        super(mppKind);
    }

    @Override
    public void check(@NotNull FirClass declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        TypeCheckerState typeCheckerState = TypeComponentsKt.getTypeContext(context2.getSession()).newTypeCheckerState(false, false);
        FirTypeScope firTypeScope = FirHelpersKt.unsubstitutedScope(declaration, context2);
        FirContainingNamesAwareScopeKt.processAllProperties(firTypeScope, new Function1<FirCallableSymbol<?>, Unit>(declaration, this, reporter, typeCheckerState, firTypeScope, context2){
            final /* synthetic */ FirClass $declaration;
            final /* synthetic */ FirOverrideChecker this$0;
            final /* synthetic */ DiagnosticReporter $reporter;
            final /* synthetic */ TypeCheckerState $typeCheckerState;
            final /* synthetic */ FirTypeScope $firTypeScope;
            final /* synthetic */ CheckerContext $context;
            {
                this.$declaration = $declaration;
                this.this$0 = $receiver;
                this.$reporter = $reporter;
                this.$typeCheckerState = $typeCheckerState;
                this.$firTypeScope = $firTypeScope;
                this.$context = $context;
                super(1);
            }

            public final void invoke(FirCallableSymbol<?> p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                FirOverrideChecker.access$check$checkMember(this.$declaration, this.this$0, this.$reporter, this.$typeCheckerState, this.$firTypeScope, this.$context, p0);
            }

            public final String getSignature() {
                return "check$checkMember(Lorg/jetbrains/kotlin/fir/declarations/FirClass;Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOverrideChecker;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/types/TypeCheckerState;Lorg/jetbrains/kotlin/fir/scopes/FirTypeScope;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;)V";
            }

            public final String getName() {
                return "checkMember";
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(Intrinsics.Kotlin.class);
            }
        });
        FirContainingNamesAwareScopeKt.processAllFunctions(firTypeScope, new Function1<FirCallableSymbol<?>, Unit>(declaration, this, reporter, typeCheckerState, firTypeScope, context2){
            final /* synthetic */ FirClass $declaration;
            final /* synthetic */ FirOverrideChecker this$0;
            final /* synthetic */ DiagnosticReporter $reporter;
            final /* synthetic */ TypeCheckerState $typeCheckerState;
            final /* synthetic */ FirTypeScope $firTypeScope;
            final /* synthetic */ CheckerContext $context;
            {
                this.$declaration = $declaration;
                this.this$0 = $receiver;
                this.$reporter = $reporter;
                this.$typeCheckerState = $typeCheckerState;
                this.$firTypeScope = $firTypeScope;
                this.$context = $context;
                super(1);
            }

            public final void invoke(FirCallableSymbol<?> p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                FirOverrideChecker.access$check$checkMember(this.$declaration, this.this$0, this.$reporter, this.$typeCheckerState, this.$firTypeScope, this.$context, p0);
            }

            public final String getSignature() {
                return "check$checkMember(Lorg/jetbrains/kotlin/fir/declarations/FirClass;Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOverrideChecker;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/types/TypeCheckerState;Lorg/jetbrains/kotlin/fir/scopes/FirTypeScope;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;)V";
            }

            public final String getName() {
                return "checkMember";
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(Intrinsics.Kotlin.class);
            }
        });
    }

    private final boolean ensureKnownVisibility(FirCallableSymbol<?> $this$ensureKnownVisibility, CheckerContext context2, DiagnosticReporter reporter, KtSourceElement source) {
        boolean bl;
        FirCallableSymbol<?> $this$visibility$iv = $this$ensureKnownVisibility;
        boolean $i$f$getVisibility = false;
        if (!Intrinsics.areEqual($this$visibility$iv.getResolvedStatus().getVisibility(), Visibilities.Unknown.INSTANCE)) {
            bl = true;
        } else {
            boolean bl2;
            boolean it = bl2 = false;
            boolean bl3 = false;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, this.chooseCannotInferVisibilityFor($this$ensureKnownVisibility), $this$ensureKnownVisibility, (DiagnosticContext)context2, null, 16, null);
            bl = bl2;
        }
        return bl;
    }

    static /* synthetic */ boolean ensureKnownVisibility$default(FirOverrideChecker firOverrideChecker, FirCallableSymbol firCallableSymbol, CheckerContext checkerContext, DiagnosticReporter diagnosticReporter, KtSourceElement ktSourceElement, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: ensureKnownVisibility");
        }
        if ((n & 4) != 0) {
            ktSourceElement = firCallableSymbol.getSource();
        }
        return firOverrideChecker.ensureKnownVisibility(firCallableSymbol, checkerContext, diagnosticReporter, ktSourceElement);
    }

    private final KtDiagnosticFactory1<FirCallableSymbol<?>> chooseCannotInferVisibilityFor(FirCallableSymbol<?> symbol) {
        return !this.getWouldMissDiagnosticInK1(symbol) ? FirErrors.INSTANCE.getCANNOT_INFER_VISIBILITY() : FirErrors.INSTANCE.getCANNOT_INFER_VISIBILITY_WARNING();
    }

    private final KtDiagnosticFactory3<Visibility, FirCallableSymbol<?>, Name> chooseCannotChangeAccessPrivilegeFor(FirCallableSymbol<?> symbol) {
        return !this.getWouldMissDiagnosticInK1(symbol) ? FirErrors.INSTANCE.getCANNOT_CHANGE_ACCESS_PRIVILEGE() : FirErrors.INSTANCE.getCANNOT_CHANGE_ACCESS_PRIVILEGE_WARNING();
    }

    private final KtDiagnosticFactory3<Visibility, FirCallableSymbol<?>, Name> chooseCannotWeakenAccessPrivilegeFor(FirCallableSymbol<?> symbol) {
        return !this.getWouldMissDiagnosticInK1(symbol) ? FirErrors.INSTANCE.getCANNOT_WEAKEN_ACCESS_PRIVILEGE() : FirErrors.INSTANCE.getCANNOT_WEAKEN_ACCESS_PRIVILEGE_WARNING();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean getWouldMissDiagnosticInK1(FirCallableSymbol<?> $this$wouldMissDiagnosticInK1) {
        if (!($this$wouldMissDiagnosticInK1 instanceof FirPropertyAccessorSymbol)) return false;
        if (!ClassMembersKt.isIntersectionOverride(((FirPropertyAccessorSymbol)$this$wouldMissDiagnosticInK1).getPropertySymbol())) return false;
        FirCallableSymbol $this$visibility$iv = $this$wouldMissDiagnosticInK1;
        boolean $i$f$getVisibility = false;
        Visibility visibility = $this$visibility$iv.getResolvedStatus().getVisibility();
        $this$visibility$iv = ((FirPropertyAccessorSymbol)$this$wouldMissDiagnosticInK1).getPropertySymbol();
        $i$f$getVisibility = false;
        if (Intrinsics.areEqual(visibility, $this$visibility$iv.getResolvedStatus().getVisibility())) return false;
        return true;
    }

    private final FirCallableSymbol<?> checkModality(List<? extends FirCallableSymbol<?>> overriddenSymbols) {
        Iterator<FirCallableSymbol<?>> iterator2 = overriddenSymbols.iterator();
        while (iterator2.hasNext()) {
            FirCallableSymbol<?> overridden;
            FirCallableSymbol<?> $this$modality$iv = overridden = iterator2.next();
            boolean $i$f$getModality = false;
            if ($this$modality$iv.getResolvedStatus().getModality() != Modality.FINAL) continue;
            return overridden;
        }
        return null;
    }

    private final FirCallableSymbol<?> checkMutability(FirPropertySymbol $this$checkMutability, List<? extends FirCallableSymbol<?>> overriddenSymbols) {
        Object v2;
        block2: {
            if ($this$checkMutability.isVar()) {
                return null;
            }
            Iterable iterable = overriddenSymbols;
            for (Object t : iterable) {
                FirCallableSymbol it = (FirCallableSymbol)t;
                boolean bl = false;
                FirPropertySymbol firPropertySymbol = it instanceof FirPropertySymbol ? (FirPropertySymbol)it : null;
                boolean bl2 = firPropertySymbol != null ? firPropertySymbol.isVar() : false;
                if (!bl2) continue;
                v2 = t;
                break block2;
            }
            v2 = null;
        }
        return v2;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkVisibility(FirCallableSymbol<?> $this$checkVisibility, FirClass containingClass, DiagnosticReporter reporter, List<? extends FirCallableSymbol<?>> overriddenSymbols, CheckerContext context2) {
        boolean hasVisibleBase;
        block14: {
            boolean bl;
            block16: {
                List<Pair> visibilities;
                block15: {
                    void $this$mapNotNullTo$iv$iv;
                    void $this$mapNotNull$iv;
                    Collection<FirCallableSymbol> collection;
                    void $this$mapTo$iv$iv;
                    FirCallableSymbol firCallableSymbol;
                    FirClass firClass;
                    DiagnosticReporter diagnosticReporter;
                    Iterator<Pair> $this$sortedBy$iv;
                    Object object;
                    void $this$mapTo$iv$iv2;
                    if (!FirOverrideChecker.ensureKnownVisibility$default(this, $this$checkVisibility, context2, reporter, null, 4, null)) {
                        return;
                    }
                    if (overriddenSymbols.isEmpty()) {
                        return;
                    }
                    Iterable $this$map$iv = overriddenSymbols;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                        void it;
                        FirCallableSymbol firCallableSymbol2 = (FirCallableSymbol)item$iv$iv;
                        object = destination$iv$iv;
                        boolean bl2 = false;
                        void $this$visibility$iv = it;
                        boolean $i$f$getVisibility = false;
                        object.add(TuplesKt.to(it, $this$visibility$iv.getResolvedStatus().getVisibility()));
                    }
                    $this$map$iv = (List)destination$iv$iv;
                    boolean $i$f$sortedBy22 = false;
                    visibilities = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator($this$checkVisibility){
                        final /* synthetic */ FirCallableSymbol $this_checkVisibility$inlined;
                        {
                            this.$this_checkVisibility$inlined = firCallableSymbol;
                        }

                        public final int compare(T a, T b) {
                            Pair pair = (Pair)a;
                            boolean bl = false;
                            FirCallableSymbol $this$visibility$iv = this.$this_checkVisibility$inlined;
                            boolean $i$f$getVisibility = false;
                            Integer n = Visibilities.INSTANCE.compare($this$visibility$iv.getResolvedStatus().getVisibility(), (Visibility)pair.getSecond());
                            pair = (Pair)b;
                            Comparable comparable = Integer.valueOf(n != null ? n : Integer.MIN_VALUE);
                            bl = false;
                            $this$visibility$iv = this.$this_checkVisibility$inlined;
                            $i$f$getVisibility = false;
                            Integer n2 = Visibilities.INSTANCE.compare($this$visibility$iv.getResolvedStatus().getVisibility(), (Visibility)pair.getSecond());
                            return ComparisonsKt.compareValues(comparable, n2 != null ? n2 : Integer.MIN_VALUE);
                        }
                    });
                    if (!($this$checkVisibility instanceof FirPropertySymbol) || !this.getCanDelegateVisibilityConsistencyChecksToAccessors((FirPropertySymbol)$this$checkVisibility)) break block15;
                    FirPropertyAccessorSymbol firPropertyAccessorSymbol = ((FirPropertySymbol)$this$checkVisibility).getGetterSymbol();
                    if (firPropertyAccessorSymbol != null) {
                        void $this$map$iv2;
                        Iterable $i$f$sortedBy22 = overriddenSymbols;
                        diagnosticReporter = reporter;
                        firClass = containingClass;
                        firCallableSymbol = firPropertyAccessorSymbol;
                        object = this;
                        boolean $i$f$map2 = false;
                        destination$iv$iv = $this$map$iv2;
                        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
                        boolean $i$f$mapTo2 = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            FirCallableSymbol bl2 = (FirCallableSymbol)item$iv$iv;
                            collection = destination$iv$iv2;
                            boolean bl3 = false;
                            Intrinsics.checkNotNull(it, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol");
                            FirPropertyAccessorSymbol firPropertyAccessorSymbol2 = ((FirPropertySymbol)it).getGetterSymbol();
                            collection.add((FirCallableSymbol)(firPropertyAccessorSymbol2 != null ? (FirCallableSymbol)firPropertyAccessorSymbol2 : it));
                        }
                        collection = (List)destination$iv$iv2;
                        super.checkVisibility(firCallableSymbol, firClass, diagnosticReporter, (List<? extends FirCallableSymbol<?>>)collection, context2);
                    }
                    FirPropertyAccessorSymbol firPropertyAccessorSymbol3 = ((FirPropertySymbol)$this$checkVisibility).getSetterSymbol();
                    if (firPropertyAccessorSymbol3 == null) break block16;
                    Iterable $this$map$iv2 = overriddenSymbols;
                    diagnosticReporter = reporter;
                    firClass = containingClass;
                    firCallableSymbol = firPropertyAccessorSymbol3;
                    object = this;
                    boolean $i$f$mapNotNull = false;
                    $this$mapTo$iv$iv = $this$mapNotNull$iv;
                    Collection destination$iv$iv3 = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator it = $this$forEach$iv$iv$iv.iterator();
                    while (it.hasNext()) {
                        FirPropertyAccessorSymbol it$iv$iv;
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = it.next();
                        boolean bl4 = false;
                        FirCallableSymbol it2 = (FirCallableSymbol)element$iv$iv;
                        boolean bl5 = false;
                        Intrinsics.checkNotNull(it2, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol");
                        if (((FirPropertySymbol)it2).getSetterSymbol() == null) continue;
                        boolean bl6 = false;
                        destination$iv$iv3.add(it$iv$iv);
                    }
                    collection = (List)destination$iv$iv3;
                    super.checkVisibility(firCallableSymbol, firClass, diagnosticReporter, (List<? extends FirCallableSymbol<?>>)collection, context2);
                    break block16;
                }
                for (Pair $this$mapNotNull$iv : visibilities) {
                    FirCallableSymbol overridden = (FirCallableSymbol)$this$mapNotNull$iv.component1();
                    Visibility overriddenVisibility = (Visibility)$this$mapNotNull$iv.component2();
                    FirCallableSymbol<?> $this$visibility$iv = $this$checkVisibility;
                    boolean $i$f$getVisibility = false;
                    Integer compare = Visibilities.INSTANCE.compare($this$visibility$iv.getResolvedStatus().getVisibility(), overriddenVisibility);
                    if (compare == null) {
                        this.reportCannotChangeAccessPrivilege(reporter, $this$checkVisibility, overridden, context2);
                        break;
                    }
                    if (compare >= 0) continue;
                    this.reportCannotWeakenAccessPrivilege(reporter, $this$checkVisibility, overridden, context2);
                    break;
                }
            }
            if ($this$checkVisibility instanceof FirPropertyAccessorSymbol) {
                return;
            }
            FirFile firFile = context2.getContainingFile();
            if (firFile == null) {
                return;
            }
            FirFile file2 = firFile;
            List<FirClass> containingDeclarations = CollectionsKt.plus((Collection)context2.getContainingDeclarations(), containingClass);
            FirVisibilityChecker visibilityChecker = FirVisibilityCheckerKt.getVisibilityChecker(context2.getSession());
            Iterable $this$any$iv = overriddenSymbols;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FirCallableSymbol it = (FirCallableSymbol)element$iv;
                    boolean bl7 = false;
                    FirLazyDeclarationResolverKt.lazyResolveToPhase(it, FirResolvePhase.STATUS);
                    FirCallableDeclaration fir = (FirCallableDeclaration)it.getFir();
                    if (!FirVisibilityChecker.isVisible$default(visibilityChecker, fir, context2.getSession(), file2, containingDeclarations, null, false, null, true, null, 352, null)) continue;
                    bl = true;
                    break block14;
                }
                bl = hasVisibleBase = false;
            }
        }
        if (!hasVisibleBase) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)$this$checkVisibility.getSource(), FirErrors.INSTANCE.getCANNOT_OVERRIDE_INVISIBLE_MEMBER(), $this$checkVisibility, CollectionsKt.first(overriddenSymbols), (DiagnosticContext)context2, null, 32, null);
        }
    }

    private final boolean getCanDelegateVisibilityConsistencyChecksToAccessors(FirPropertySymbol $this$canDelegateVisibilityConsistencyChecksToAccessors) {
        return $this$canDelegateVisibilityConsistencyChecksToAccessors.getGetterSymbol() != null || $this$canDelegateVisibilityConsistencyChecksToAccessors.getSetterSymbol() != null;
    }

    private final void checkDeprecation(FirCallableSymbol<?> $this$checkDeprecation, DiagnosticReporter reporter, List<? extends FirCallableSymbol<?>> overriddenSymbols, CheckerContext context2, FirTypeScope firTypeScope) {
        DeprecationsPerUseSite ownDeprecation = $this$checkDeprecation.getDeprecation(context2.getSession());
        if (ownDeprecation == null || ownDeprecation.isNotEmpty()) {
            return;
        }
        for (FirCallableSymbol<?> overriddenSymbol : overriddenSymbols) {
            Object object;
            DeprecationsPerUseSite deprecationInfoFromOverridden;
            DeprecationInfo deprecationInfo;
            if (overriddenSymbol.getDeprecation(context2.getSession()) == null || (deprecationInfo = deprecationInfoFromOverridden.getAll()) == null && ((object = deprecationInfoFromOverridden.getBySpecificSite()) != null && (object = object.values()) != null ? (DeprecationInfo)CollectionsKt.firstOrNull((Iterable)object) : (deprecationInfo = null)) == null) continue;
            DeprecationInfo deprecationFromOverriddenSymbol = deprecationInfo;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)$this$checkDeprecation.getSource(), FirErrors.INSTANCE.getOVERRIDE_DEPRECATION(), overriddenSymbol, (Object)deprecationFromOverriddenSymbol, (DiagnosticContext)context2, null, 32, null);
            return;
        }
        if ($this$checkDeprecation instanceof FirNamedFunctionSymbol) {
            String string2 = ((FirNamedFunctionSymbol)$this$checkDeprecation).getName().asString();
            Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
            String callableName = string2;
            if (FirDeprecationChecker.INSTANCE.getDeprecatedOverrideOfHiddenReplacements$checkers().containsKey(callableName)) {
                FirTypeScopeKt.processOverriddenFunctions(firTypeScope, (FirNamedFunctionSymbol)$this$checkDeprecation, arg_0 -> FirOverrideChecker.checkDeprecation$lambda$8(callableName, reporter, $this$checkDeprecation, context2, arg_0));
            }
        }
    }

    private final void checkDefaultValues(FirFunctionSymbol<?> $this$checkDefaultValues, DiagnosticReporter reporter, CheckerContext context2) {
        for (FirValueParameterSymbol valueParameterSymbol : $this$checkDefaultValues.getValueParameterSymbols()) {
            if (!valueParameterSymbol.getHasDefaultValue()) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)valueParameterSymbol.getDefaultValueSource(), FirErrors.INSTANCE.getDEFAULT_VALUE_NOT_ALLOWED_IN_OVERRIDE(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    private final void checkDataClassCopy(FirCallableSymbol<?> $this$checkDataClassCopy, DiagnosticReporter reporter, List<? extends FirCallableSymbol<?>> overriddenMemberSymbols, FirClass containingClass, CheckerContext context2) {
        FirCallableSymbol<?> firCallableSymbol = CollectionsKt.firstOrNull(overriddenMemberSymbols);
        if (firCallableSymbol == null) {
            return;
        }
        FirCallableSymbol<?> overridden = firCallableSymbol;
        FirClassLikeSymbol<?> firClassLikeSymbol = FirHelpersKt.getContainingClassSymbol((FirBasedSymbol)overridden, context2.getSession());
        FirClassSymbol firClassSymbol = firClassLikeSymbol instanceof FirClassSymbol ? (FirClassSymbol)firClassLikeSymbol : null;
        if (firClassSymbol == null) {
            return;
        }
        FirClassSymbol overriddenClass = firClassSymbol;
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)containingClass.getSource(), FirErrors.INSTANCE.getDATA_CLASS_OVERRIDE_DEFAULT_VALUES(), $this$checkDataClassCopy, (Object)overriddenClass, (DiagnosticContext)context2, null, 32, null);
    }

    /*
     * Unable to fully structure code
     */
    private final void checkMember(FirCallableSymbol<?> member, FirClass containingClass, DiagnosticReporter reporter, TypeCheckerState typeCheckerState, FirTypeScope firTypeScope, CheckerContext context) {
        block40: {
            block42: {
                block41: {
                    block38: {
                        overriddenMemberSymbols = FirTypeScopeKt.retrieveDirectOverriddenOf(firTypeScope, member);
                        v0 = member;
                        v1 = KtTokens.OVERRIDE_KEYWORD;
                        Intrinsics.checkNotNullExpressionValue(v1, "OVERRIDE_KEYWORD");
                        hasOverrideKeyword = FirKeywordUtilsKt.hasModifier(v0, v1);
                        $this$isOverride$iv = member;
                        $i$f$isOverride = false;
                        v2 = isOverride = $this$isOverride$iv.getRawStatus().isOverride() != false && (Intrinsics.areEqual(member.getOrigin(), FirDeclarationOrigin.Source.INSTANCE) == false || hasOverrideKeyword != false);
                        if (isOverride) break block40;
                        if (overriddenMemberSymbols.isEmpty() || FirOverridesBackwardCompatibilityHelperKt.getOverridesBackwardCompatibilityHelper(context.getSession()).overrideCanBeOmitted(overriddenMemberSymbols, context)) {
                            return;
                        }
                        v3 = member.getSource();
                        v4 = kind = v3 != null ? v3.getKind() : null;
                        if (!(kind instanceof KtRealSourceElementKind) && !(kind instanceof KtFakeSourceElementKind.PropertyFromParameter)) {
                            return;
                        }
                        visibilityChecker = FirVisibilityCheckerKt.getVisibilityChecker(context.getSession());
                        v5 = context.getContainingFile();
                        if (v5 == null) {
                            return;
                        }
                        file = v5;
                        containingDeclarations = CollectionsKt.plus((Collection)context.getContainingDeclarations(), containingClass);
                        $this$firstOrNull$iv = overriddenMemberSymbols;
                        $i$f$firstOrNull = false;
                        var18_26 = $this$firstOrNull$iv.iterator();
                        while (var18_26.hasNext()) {
                            element$iv = var18_26.next();
                            it = (FirCallableSymbol)element$iv;
                            $i$a$-firstOrNull-FirOverrideChecker$checkMember$overridden$1 = false;
                            FirLazyDeclarationResolverKt.lazyResolveToPhase(it, FirResolvePhase.STATUS);
                            var22_34 = it;
                            var23_35 = visibilityChecker;
                            $i$f$originalOrSelf = false;
                            $this$originalOrSelf$iv$iv = (FirCallableDeclaration)$this$originalOrSelf$iv.getFir();
                            $i$f$originalOrSelf = false;
                            result$iv$iv = $this$originalOrSelf$iv$iv;
                            while (ClassMembersKt.isSubstitutionOrIntersectionOverride(result$iv$iv)) {
                                $this$originalIfFakeOverride$iv$iv$iv = result$iv$iv;
                                $i$f$originalIfFakeOverride = false;
                                $this$originalForSubstitutionOverride$iv$iv$iv$iv = $this$originalIfFakeOverride$iv$iv$iv;
                                $i$f$getOriginalForSubstitutionOverride = false;
                                if (ClassMembersKt.isSubstitutionOverride($this$originalForSubstitutionOverride$iv$iv$iv$iv)) ** GOTO lbl-1000
                                $this$isSynthetic$iv$iv$iv$iv$iv = $this$originalForSubstitutionOverride$iv$iv$iv$iv;
                                $i$f$isSynthetic = false;
                                if ($this$isSynthetic$iv$iv$iv$iv$iv.getOrigin() instanceof FirDeclarationOrigin.Synthetic) lbl-1000:
                                // 2 sources

                                {
                                    v6 = ClassMembersKt.getOriginalForSubstitutionOverrideAttr($this$originalForSubstitutionOverride$iv$iv$iv$iv);
                                } else {
                                    v6 = v7 = null;
                                }
                                if (v6 == null) {
                                    $this$baseForIntersectionOverride$iv$iv$iv$iv = $this$originalIfFakeOverride$iv$iv$iv;
                                    $i$f$getBaseForIntersectionOverride = false;
                                    v7 = ClassMembersKt.isIntersectionOverride($this$baseForIntersectionOverride$iv$iv$iv$iv) ? ClassMembersKt.getOriginalForIntersectionOverrideAttr($this$baseForIntersectionOverride$iv$iv$iv$iv) : null;
                                }
                                if (v7 == null) break;
                                result$iv$iv = v7;
                            }
                            v8 = result$iv$iv.getSymbol();
                            if (v8 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol<*>");
                            }
                            if (!FirVisibilityChecker.isVisible$default(var23_35, (FirMemberDeclaration)v8.getFir(), context.getSession(), file, containingDeclarations, null, false, null, true, null, 352, null)) continue;
                            v9 = element$iv;
                            break block38;
                        }
                        v9 = null;
                    }
                    var15_51 = v9;
                    if (var15_51 == null) break block41;
                    $i$f$firstOrNull = var15_51;
                    $i$f$originalOrSelf = false;
                    $this$originalOrSelf$iv$iv = (FirCallableDeclaration)$this$originalOrSelf$iv.getFir();
                    $i$f$originalOrSelf = false;
                    result$iv$iv = $this$originalOrSelf$iv$iv;
                    while (ClassMembersKt.isSubstitutionOrIntersectionOverride(result$iv$iv)) {
                        $this$originalIfFakeOverride$iv$iv$iv = result$iv$iv;
                        $i$f$originalIfFakeOverride = false;
                        $this$originalForSubstitutionOverride$iv$iv$iv$iv = $this$originalIfFakeOverride$iv$iv$iv;
                        $i$f$getOriginalForSubstitutionOverride = false;
                        if (ClassMembersKt.isSubstitutionOverride($this$originalForSubstitutionOverride$iv$iv$iv$iv)) ** GOTO lbl-1000
                        $this$isSynthetic$iv$iv$iv$iv$iv = $this$originalForSubstitutionOverride$iv$iv$iv$iv;
                        $i$f$isSynthetic = false;
                        if ($this$isSynthetic$iv$iv$iv$iv$iv.getOrigin() instanceof FirDeclarationOrigin.Synthetic) lbl-1000:
                        // 2 sources

                        {
                            v10 = ClassMembersKt.getOriginalForSubstitutionOverrideAttr($this$originalForSubstitutionOverride$iv$iv$iv$iv);
                        } else {
                            v10 = v11 = null;
                        }
                        if (v10 == null) {
                            $this$baseForIntersectionOverride$iv$iv$iv$iv = $this$originalIfFakeOverride$iv$iv$iv;
                            $i$f$getBaseForIntersectionOverride = false;
                            v11 = ClassMembersKt.isIntersectionOverride($this$baseForIntersectionOverride$iv$iv$iv$iv) ? ClassMembersKt.getOriginalForIntersectionOverrideAttr($this$baseForIntersectionOverride$iv$iv$iv$iv) : null;
                        }
                        if (v11 == null) break;
                        result$iv$iv = v11;
                    }
                    v12 = result$iv$iv.getSymbol();
                    if (v12 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol<*>");
                    }
                    $this$firstOrNull$iv = v12;
                    if ($this$firstOrNull$iv != null) break block42;
                }
                return;
            }
            overridden = $this$firstOrNull$iv;
            v13 = ClassMembersKt.containingClassLookupTag(overridden);
            $this$originalOrSelf$iv = v13 != null ? LookupTagUtilsKt.toSymbol(v13, context.getSession()) : null;
            v14 = $this$originalOrSelf$iv instanceof FirRegularClassSymbol != false ? (FirRegularClassSymbol)$this$originalOrSelf$iv : null;
            if (v14 == null) {
                return;
            }
            originalContainingClassSymbol = v14;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)member.getSource(), FirErrors.INSTANCE.getVIRTUAL_MEMBER_HIDDEN(), member, (Object)originalContainingClassSymbol, (DiagnosticContext)context, null, 32, null);
            return;
        }
        v15 = member.getSource();
        if ((v15 != null ? v15.getKind() : null) instanceof KtFakeSourceElementKind.DataClassGeneratedMembers) {
            block39: {
                file = overriddenMemberSymbols;
                for (T var14_54 : file) {
                    it = (FirCallableSymbol)var14_54;
                    $i$a$-find-FirOverrideChecker$checkMember$1 = false;
                    $this$isFinal$iv = it;
                    $i$f$isFinal = false;
                    v16 = $this$isFinal$iv.getResolvedStatus().getModality() == Modality.FINAL;
                    if (!v16) continue;
                    v17 = var14_54;
                    break block39;
                }
                v17 = null;
            }
            v18 = v17;
            if (v18 != null) {
                base = v18;
                $i$a$-let-FirOverrideChecker$checkMember$2 = false;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)containingClass.getSource(), FirErrors.INSTANCE.getDATA_CLASS_OVERRIDE_CONFLICT(), member, (Object)base, (DiagnosticContext)context, null, 32, null);
            }
            if (Intrinsics.areEqual(member.getName(), StandardNames.DATA_CLASS_COPY)) {
                this.checkDataClassCopy(member, reporter, overriddenMemberSymbols, containingClass, context);
            }
            return;
        }
        if (overriddenMemberSymbols.isEmpty()) {
            this.reportNothingToOverride(reporter, member, context);
            return;
        }
        this.checkOverriddenExperimentalities(member, overriddenMemberSymbols, context, reporter);
        if (!ClassMembersKt.isIntersectionOverride(member) && !ClassMembersKt.isDelegated(member)) {
            v19 = this.checkModality(overriddenMemberSymbols);
            if (v19 != null) {
                it = v19;
                $i$a$-let-FirOverrideChecker$checkMember$3 = false;
                this.reportOverridingFinalMember(reporter, member, it, context);
            }
        }
        if (member instanceof FirPropertySymbol && !ClassMembersKt.isDelegated(member)) {
            v20 = this.checkMutability((FirPropertySymbol)member, overriddenMemberSymbols);
            if (v20 != null) {
                it = v20;
                $i$a$-let-FirOverrideChecker$checkMember$4 = false;
                this.reportVarOverriddenByVal(reporter, member, it, context);
            }
        }
        this.checkVisibility(member, containingClass, reporter, overriddenMemberSymbols, context);
        if (Intrinsics.areEqual(member.getOrigin(), FirDeclarationOrigin.Source.INSTANCE)) {
            this.checkDeprecation(member, reporter, overriddenMemberSymbols, context, firTypeScope);
        }
        if (member instanceof FirFunctionSymbol && !Intrinsics.areEqual(((FirFunctionSymbol)member).getOrigin(), FirDeclarationOrigin.Synthetic.DataClassMember.INSTANCE)) {
            this.checkDefaultValues((FirFunctionSymbol)member, reporter, context);
        }
        if (ClassMembersKt.isIntersectionOverride(member) || ClassMembersKt.isDelegated(member)) {
            return;
        }
        v21 = this.checkReturnType(member, overriddenMemberSymbols, typeCheckerState, context);
        if (v21 == null) {
            return;
        }
        restriction = v21;
        var11_12 = member;
        if (var11_12 instanceof FirNamedFunctionSymbol) {
            this.reportReturnTypeMismatchOnFunction(reporter, member, restriction, context);
        } else if (var11_12 instanceof FirPropertySymbol) {
            if (((FirPropertySymbol)member).isVar()) {
                this.reportTypeMismatchOnVariable(reporter, member, restriction, context);
            } else {
                this.reportTypeMismatchOnProperty(reporter, member, restriction, context);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkOverriddenExperimentalities(FirCallableSymbol<?> memberSymbol, List<? extends FirCallableSymbol<?>> overriddenMemberSymbols, CheckerContext context2, DiagnosticReporter reporter) {
        void $this$flatMapTo$iv$iv;
        FirOptInUsageBaseChecker $this$checkOverriddenExperimentalities_u24lambda_u2415 = FirOptInUsageBaseChecker.INSTANCE;
        boolean bl = false;
        Set overriddenExperimentalities = new LinkedHashSet();
        FirSession session2 = context2.getSession();
        Iterable $this$flatMap$iv = overriddenMemberSymbols;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            FirCallableSymbol it = (FirCallableSymbol)element$iv$iv;
            boolean bl2 = false;
            FirCallableSymbol firCallableSymbol = it;
            Iterable list$iv$iv = firCallableSymbol instanceof FirIntersectionOverridePropertySymbol ? ((FirIntersectionOverridePropertySymbol)it).getIntersections() : (firCallableSymbol instanceof FirIntersectionOverrideFunctionSymbol ? ((FirIntersectionOverrideFunctionSymbol)it).getIntersections() : (Collection<FirCallableSymbol<Object>>)CollectionsKt.listOf(it));
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        List overriddenSymbolsWithUnwrappedIntersectionOverrides = (List)destination$iv$iv;
        for (FirCallableSymbol overriddenMemberSymbol : overriddenSymbolsWithUnwrappedIntersectionOverrides) {
            $this$checkOverriddenExperimentalities_u24lambda_u2415.loadExperimentalitiesFromAnnotationTo(overriddenMemberSymbol, session2, overriddenExperimentalities);
        }
        $this$checkOverriddenExperimentalities_u24lambda_u2415.reportNotAcceptedOverrideExperimentalities(overriddenExperimentalities, memberSymbol, context2, reporter);
    }

    private final void reportNothingToOverride(DiagnosticReporter $this$reportNothingToOverride, FirCallableSymbol<?> declaration, CheckerContext context2) {
        KtDiagnosticReportHelpersKt.reportOn$default($this$reportNothingToOverride, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getNOTHING_TO_OVERRIDE(), declaration, (DiagnosticContext)context2, null, 16, null);
    }

    private final void reportOverridingFinalMember(DiagnosticReporter $this$reportOverridingFinalMember, FirCallableSymbol<?> overriding, FirCallableSymbol<?> overridden, CheckerContext context2) {
        block0: {
            ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClassLookupTag(overridden);
            if (coneClassLikeLookupTag == null) break block0;
            ConeClassLikeLookupTag containingClass = coneClassLikeLookupTag;
            boolean bl = false;
            KtDiagnosticReportHelpersKt.reportOn$default($this$reportOverridingFinalMember, (AbstractKtSourceElement)overriding.getSource(), FirErrors.INSTANCE.getOVERRIDING_FINAL_MEMBER(), overridden, (Object)containingClass.getName(), (DiagnosticContext)context2, null, 32, null);
        }
    }

    private final void reportVarOverriddenByVal(DiagnosticReporter $this$reportVarOverriddenByVal, FirCallableSymbol<?> overriding, FirCallableSymbol<?> overridden, CheckerContext context2) {
        KtDiagnosticReportHelpersKt.reportOn$default($this$reportVarOverriddenByVal, (AbstractKtSourceElement)overriding.getSource(), FirErrors.INSTANCE.getVAR_OVERRIDDEN_BY_VAL(), overriding, overridden, (DiagnosticContext)context2, null, 32, null);
    }

    private final void reportCannotWeakenAccessPrivilege(DiagnosticReporter $this$reportCannotWeakenAccessPrivilege, FirCallableSymbol<?> overriding, FirCallableSymbol<?> overridden, CheckerContext context2) {
        ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClassLookupTag(overridden);
        if (coneClassLikeLookupTag == null) {
            return;
        }
        ConeClassLikeLookupTag containingClass = coneClassLikeLookupTag;
        FirCallableSymbol<?> $this$visibility$iv = overriding;
        boolean $i$f$getVisibility = false;
        KtDiagnosticReportHelpersKt.reportOn$default($this$reportCannotWeakenAccessPrivilege, (AbstractKtSourceElement)overriding.getSource(), this.chooseCannotWeakenAccessPrivilegeFor(overriding), (Object)$this$visibility$iv.getResolvedStatus().getVisibility(), overridden, (Object)containingClass.getName(), (DiagnosticContext)context2, null, 64, null);
    }

    private final void reportCannotChangeAccessPrivilege(DiagnosticReporter $this$reportCannotChangeAccessPrivilege, FirCallableSymbol<?> overriding, FirCallableSymbol<?> overridden, CheckerContext context2) {
        ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClassLookupTag(overridden);
        if (coneClassLikeLookupTag == null) {
            return;
        }
        ConeClassLikeLookupTag containingClass = coneClassLikeLookupTag;
        FirCallableSymbol<?> $this$visibility$iv = overriding;
        boolean $i$f$getVisibility = false;
        KtDiagnosticReportHelpersKt.reportOn$default($this$reportCannotChangeAccessPrivilege, (AbstractKtSourceElement)overriding.getSource(), this.chooseCannotChangeAccessPrivilegeFor(overriding), (Object)$this$visibility$iv.getResolvedStatus().getVisibility(), overridden, (Object)containingClass.getName(), (DiagnosticContext)context2, null, 64, null);
    }

    private final void reportReturnTypeMismatchOnFunction(DiagnosticReporter $this$reportReturnTypeMismatchOnFunction, FirCallableSymbol<?> overriding, FirCallableSymbol<?> overridden, CheckerContext context2) {
        KtDiagnosticReportHelpersKt.reportOn$default($this$reportReturnTypeMismatchOnFunction, (AbstractKtSourceElement)overriding.getSource(), FirErrors.INSTANCE.getRETURN_TYPE_MISMATCH_ON_OVERRIDE(), overriding, overridden, (DiagnosticContext)context2, null, 32, null);
    }

    private final void reportTypeMismatchOnProperty(DiagnosticReporter $this$reportTypeMismatchOnProperty, FirCallableSymbol<?> overriding, FirCallableSymbol<?> overridden, CheckerContext context2) {
        KtDiagnosticReportHelpersKt.reportOn$default($this$reportTypeMismatchOnProperty, (AbstractKtSourceElement)overriding.getSource(), FirErrors.INSTANCE.getPROPERTY_TYPE_MISMATCH_ON_OVERRIDE(), overriding, overridden, (DiagnosticContext)context2, null, 32, null);
    }

    private final void reportTypeMismatchOnVariable(DiagnosticReporter $this$reportTypeMismatchOnVariable, FirCallableSymbol<?> overriding, FirCallableSymbol<?> overridden, CheckerContext context2) {
        KtDiagnosticReportHelpersKt.reportOn$default($this$reportTypeMismatchOnVariable, (AbstractKtSourceElement)overriding.getSource(), FirErrors.INSTANCE.getVAR_TYPE_MISMATCH_ON_OVERRIDE(), overriding, overridden, (DiagnosticContext)context2, null, 32, null);
    }

    private static final void check$checkMember(FirClass $declaration, FirOverrideChecker this$0, DiagnosticReporter $reporter, TypeCheckerState typeCheckerState, FirTypeScope firTypeScope, CheckerContext $context, FirCallableSymbol<?> it) {
        block3: {
            KtSourceElement ktSourceElement;
            block5: {
                block4: {
                    KtSourceElement ktSourceElement2;
                    boolean isFromThis;
                    block2: {
                        isFromThis = Intrinsics.areEqual(ClassMembersKt.containingClassLookupTag(it), $declaration.getSymbol().toLookupTag());
                        if (!isFromThis || ClassMembersKt.isSubstitutionOverride(it)) break block2;
                        this$0.checkMember(it, $declaration, $reporter, typeCheckerState, firTypeScope, $context);
                        break block3;
                    }
                    ktSourceElement = it.getSource();
                    if (ktSourceElement == null) break block4;
                    KtSourceElement it2 = ktSourceElement2 = ktSourceElement;
                    boolean bl = false;
                    ktSourceElement = isFromThis ? ktSourceElement2 : null;
                    if (ktSourceElement != null) break block5;
                }
                ktSourceElement = $declaration.getSource();
            }
            KtSourceElement source = ktSourceElement;
            this$0.ensureKnownVisibility(it, $context, $reporter, source);
        }
    }

    private static final ProcessorAction checkDeprecation$lambda$8(String $callableName, DiagnosticReporter $reporter, FirCallableSymbol $this_checkDeprecation, CheckerContext $context, FirNamedFunctionSymbol it) {
        Intrinsics.checkNotNullParameter($callableName, "$callableName");
        Intrinsics.checkNotNullParameter($reporter, "$reporter");
        Intrinsics.checkNotNullParameter($this_checkDeprecation, "$this_checkDeprecation");
        Intrinsics.checkNotNullParameter($context, "$context");
        Intrinsics.checkNotNullParameter(it, "it");
        if (DeprecationUtilsKt.hiddenStatusOfCall(it, false, true) == CallToPotentiallyHiddenSymbolResult.VisibleWithDeprecation) {
            String message = FirDeprecationChecker.INSTANCE.getDeprecatedOverrideOfHiddenMessage$checkers($callableName);
            SimpleDeprecationInfo deprecationInfo = new SimpleDeprecationInfo(DeprecationLevelValue.WARNING, false, message);
            KtDiagnosticReportHelpersKt.reportOn$default($reporter, (AbstractKtSourceElement)((FirNamedFunctionSymbol)$this_checkDeprecation).getSource(), FirErrors.INSTANCE.getOVERRIDE_DEPRECATION(), (Object)it, (Object)deprecationInfo, (DiagnosticContext)$context, null, 32, null);
            return ProcessorAction.STOP;
        }
        return ProcessorAction.NEXT;
    }

    public /* synthetic */ FirOverrideChecker(MppCheckerKind mppKind, DefaultConstructorMarker $constructor_marker) {
        this(mppKind);
    }

    public static final /* synthetic */ void access$check$checkMember(FirClass $declaration, FirOverrideChecker this$0, DiagnosticReporter $reporter, TypeCheckerState typeCheckerState, FirTypeScope firTypeScope, CheckerContext $context, FirCallableSymbol it) {
        FirOverrideChecker.check$checkMember($declaration, this$0, $reporter, typeCheckerState, firTypeScope, $context, it);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOverrideChecker$ForExpectClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOverrideChecker;", "<init>", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
    @SourceDebugExtension(value={"SMAP\nFirOverrideChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirOverrideChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOverrideChecker$ForExpectClass\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,573:1\n37#2:574\n*S KotlinDebug\n*F\n+ 1 FirOverrideChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOverrideChecker$ForExpectClass\n*L\n123#1:574\n*E\n"})
    public static final class ForExpectClass
    extends FirOverrideChecker {
        @NotNull
        public static final ForExpectClass INSTANCE = new ForExpectClass();

        private ForExpectClass() {
            super(MppCheckerKind.Common, null);
        }

        @Override
        public void check(@NotNull FirClass declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            Intrinsics.checkNotNullParameter(context2, "context");
            Intrinsics.checkNotNullParameter(reporter, "reporter");
            FirMemberDeclaration $this$isExpect$iv = declaration;
            boolean $i$f$isExpect = false;
            if (!$this$isExpect$iv.getStatus().isExpect()) {
                return;
            }
            super.check(declaration, context2, reporter);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOverrideChecker$Regular;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOverrideChecker;", "<init>", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
    @SourceDebugExtension(value={"SMAP\nFirOverrideChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirOverrideChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOverrideChecker$Regular\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,573:1\n37#2:574\n*S KotlinDebug\n*F\n+ 1 FirOverrideChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOverrideChecker$Regular\n*L\n116#1:574\n*E\n"})
    public static final class Regular
    extends FirOverrideChecker {
        @NotNull
        public static final Regular INSTANCE = new Regular();

        private Regular() {
            super(MppCheckerKind.Platform, null);
        }

        @Override
        public void check(@NotNull FirClass declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            Intrinsics.checkNotNullParameter(context2, "context");
            Intrinsics.checkNotNullParameter(reporter, "reporter");
            FirMemberDeclaration $this$isExpect$iv = declaration;
            boolean $i$f$isExpect = false;
            if ($this$isExpect$iv.getStatus().isExpect()) {
                return;
            }
            super.check(declaration, context2, reporter);
        }
    }
}

