/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers;

import com.intellij.lang.LighterASTNode;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtLightSourceElement;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKind;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.diagnostics.LightTreePositioningStrategiesKt;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002\u001a\f\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u0005\u00a8\u0006\u0006"}, d2={"toVisibilityOrNull", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "findContextReceiverListSource", "Lorg/jetbrains/kotlin/KtLightSourceElement;", "Lorg/jetbrains/kotlin/KtSourceElement;", "checkers"})
@SourceDebugExtension(value={"SMAP\nSourceHelpers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SourceHelpers.kt\norg/jetbrains/kotlin/fir/analysis/checkers/SourceHelpersKt\n+ 2 KtSourceElement.kt\norg/jetbrains/kotlin/KtSourceElementKt\n*L\n1#1,49:1\n650#2,7:50\n650#2,7:57\n*S KotlinDebug\n*F\n+ 1 SourceHelpers.kt\norg/jetbrains/kotlin/fir/analysis/checkers/SourceHelpersKt\n*L\n41#1:50,7\n47#1:57,7\n*E\n"})
public final class SourceHelpersKt {
    @Nullable
    public static final Visibility toVisibilityOrNull(@NotNull KtModifierKeywordToken $this$toVisibilityOrNull) {
        Intrinsics.checkNotNullParameter($this$toVisibilityOrNull, "<this>");
        KtModifierKeywordToken ktModifierKeywordToken = $this$toVisibilityOrNull;
        return Intrinsics.areEqual(ktModifierKeywordToken, KtTokens.PUBLIC_KEYWORD) ? (Visibility)Visibilities.Public.INSTANCE : (Intrinsics.areEqual(ktModifierKeywordToken, KtTokens.PRIVATE_KEYWORD) ? (Visibility)Visibilities.Private.INSTANCE : (Intrinsics.areEqual(ktModifierKeywordToken, KtTokens.PROTECTED_KEYWORD) ? (Visibility)Visibilities.Protected.INSTANCE : (Intrinsics.areEqual(ktModifierKeywordToken, KtTokens.INTERNAL_KEYWORD) ? (Visibility)Visibilities.Internal.INSTANCE : null)));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final KtLightSourceElement findContextReceiverListSource(@NotNull KtSourceElement $this$findContextReceiverListSource) {
        KtLightSourceElement ktLightSourceElement;
        Intrinsics.checkNotNullParameter($this$findContextReceiverListSource, "<this>");
        if (Intrinsics.areEqual($this$findContextReceiverListSource.getLighterASTNode().getTokenType(), KtNodeTypes.CONTEXT_RECEIVER_LIST)) {
            void $this$toKtLightSourceElement_u24default$iv;
            LighterASTNode lighterASTNode = $this$findContextReceiverListSource.getLighterASTNode();
            FlyweightCapableTreeStructure<LighterASTNode> tree$iv = $this$findContextReceiverListSource.getTreeStructure();
            KtSourceElementKind kind$iv = KtRealSourceElementKind.INSTANCE;
            int startOffset$iv = $this$toKtLightSourceElement_u24default$iv.getStartOffset();
            int endOffset$iv = $this$toKtLightSourceElement_u24default$iv.getEndOffset();
            boolean $i$f$toKtLightSourceElement = false;
            return new KtLightSourceElement((LighterASTNode)$this$toKtLightSourceElement_u24default$iv, startOffset$iv, endOffset$iv, tree$iv, kind$iv);
        }
        FlyweightCapableTreeStructure<LighterASTNode> flyweightCapableTreeStructure = $this$findContextReceiverListSource.getTreeStructure();
        LighterASTNode lighterASTNode = $this$findContextReceiverListSource.getLighterASTNode();
        IElementType iElementType = KtNodeTypes.CONTEXT_RECEIVER_LIST;
        Intrinsics.checkNotNullExpressionValue(iElementType, "CONTEXT_RECEIVER_LIST");
        LighterASTNode lighterASTNode2 = LightTreePositioningStrategiesKt.findDescendantByType(flyweightCapableTreeStructure, lighterASTNode, iElementType, false);
        if (lighterASTNode2 != null) {
            void $this$toKtLightSourceElement_u24default$iv;
            LighterASTNode tree$iv = lighterASTNode2;
            FlyweightCapableTreeStructure<LighterASTNode> tree$iv2 = $this$findContextReceiverListSource.getTreeStructure();
            KtSourceElementKind kind$iv = KtRealSourceElementKind.INSTANCE;
            int startOffset$iv = $this$toKtLightSourceElement_u24default$iv.getStartOffset();
            int endOffset$iv = $this$toKtLightSourceElement_u24default$iv.getEndOffset();
            boolean $i$f$toKtLightSourceElement = false;
            ktLightSourceElement = new KtLightSourceElement((LighterASTNode)$this$toKtLightSourceElement_u24default$iv, startOffset$iv, endOffset$iv, tree$iv2, kind$iv);
        } else {
            ktLightSourceElement = null;
        }
        return ktLightSourceElement;
    }
}

