/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.util.text.Strings;
import it.unimi.dsi.fastutil.Hash;

final class FastUtilCharSequenceHashingStrategy
implements Hash.Strategy<CharSequence> {
    private final boolean isCaseSensitive;

    FastUtilCharSequenceHashingStrategy(boolean caseSensitive) {
        this.isCaseSensitive = caseSensitive;
    }

    @Override
    public int hashCode(CharSequence o) {
        if (o == null) {
            return 0;
        }
        return this.isCaseSensitive ? Strings.stringHashCode(o) : Strings.stringHashCodeInsensitive(o);
    }

    @Override
    public boolean equals(CharSequence s1, CharSequence s2) {
        return StringUtilRt.equal(s1, s2, this.isCaseSensitive);
    }
}

