/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.deserialization;

import java.io.InputStream;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.builtins.BuiltInsBinaryVersion;
import org.jetbrains.kotlin.metadata.deserialization.NameResolverImpl;
import org.jetbrains.kotlin.serialization.deserialization.builtins.BuiltInSerializerProtocol;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00012\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"readProto", "Lkotlin/Triple;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$PackageFragment;", "Lorg/jetbrains/kotlin/metadata/deserialization/NameResolverImpl;", "Lorg/jetbrains/kotlin/metadata/builtins/BuiltInsBinaryVersion;", "stream", "Ljava/io/InputStream;", "deserialization.common"})
public final class MetadataUtilKt {
    @NotNull
    public static final Triple<ProtoBuf.PackageFragment, NameResolverImpl, BuiltInsBinaryVersion> readProto(@NotNull InputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        BuiltInsBinaryVersion version2 = BuiltInsBinaryVersion.Companion.readFrom(stream);
        if (!version2.isCompatibleWithCurrentCompilerVersion()) {
            throw new UnsupportedOperationException("Kotlin metadata definition format version is not supported: expected " + BuiltInsBinaryVersion.INSTANCE + ", actual " + version2 + ". Please update Kotlin");
        }
        ProtoBuf.PackageFragment message2 = ProtoBuf.PackageFragment.parseFrom(stream, BuiltInSerializerProtocol.INSTANCE.getExtensionRegistry());
        ProtoBuf.StringTable stringTable2 = message2.getStrings();
        Intrinsics.checkNotNullExpressionValue(stringTable2, "message.strings");
        ProtoBuf.QualifiedNameTable qualifiedNameTable = message2.getQualifiedNames();
        Intrinsics.checkNotNullExpressionValue(qualifiedNameTable, "message.qualifiedNames");
        NameResolverImpl nameResolver2 = new NameResolverImpl(stringTable2, qualifiedNameTable);
        return new Triple<ProtoBuf.PackageFragment, NameResolverImpl, BuiltInsBinaryVersion>(message2, nameResolver2, version2);
    }
}

