/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BindingTraceFilter;
import org.jetbrains.kotlin.resolve.DelegatingBindingTrace;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J=\u0010\u0007\u001a\u00020\b\"\u0004\b\u0000\u0010\t\"\u0004\b\u0001\u0010\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u0002H\n0\f2\u0006\u0010\r\u001a\u0002H\t2\u0006\u0010\u000e\u001a\u0002H\nH\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J5\u0010\u0013\u001a\u00020\u0014\"\u0004\b\u0000\u0010\t\"\u0004\b\u0001\u0010\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u0002H\n0\f2\u0006\u0010\r\u001a\u0002H\tH$\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0016\u001a\u00020\u0014H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/resolve/AbstractFilteringTrace;", "Lorg/jetbrains/kotlin/resolve/DelegatingBindingTrace;", "parentTrace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "name", "", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;Ljava/lang/String;)V", "record", "", "K", "V", "slice", "Lorg/jetbrains/kotlin/util/slicedMap/WritableSlice;", "key", "value", "(Lorg/jetbrains/kotlin/util/slicedMap/WritableSlice;Ljava/lang/Object;Ljava/lang/Object;)V", "report", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "shouldBeHiddenFromParent", "", "(Lorg/jetbrains/kotlin/util/slicedMap/WritableSlice;Ljava/lang/Object;)Z", "wantsDiagnostics", "frontend"})
public abstract class AbstractFilteringTrace
extends DelegatingBindingTrace {
    @NotNull
    private final BindingTrace parentTrace;

    public AbstractFilteringTrace(@NotNull BindingTrace parentTrace, @NotNull String name2) {
        Intrinsics.checkNotNullParameter(parentTrace, "parentTrace");
        Intrinsics.checkNotNullParameter(name2, "name");
        BindingContext bindingContext = parentTrace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue(bindingContext, "parentTrace.bindingContext");
        super(bindingContext, name2, true, BindingTraceFilter.Companion.getACCEPT_ALL(), false, null, 32, null);
        this.parentTrace = parentTrace;
    }

    protected abstract <K, V> boolean shouldBeHiddenFromParent(@NotNull WritableSlice<K, V> var1, K var2);

    @Override
    public <K, V> void record(@NotNull WritableSlice<K, V> slice, K key, V value2) {
        Intrinsics.checkNotNullParameter(slice, "slice");
        if (this.shouldBeHiddenFromParent(slice, key)) {
            super.record(slice, key, value2);
        } else {
            this.parentTrace.record(slice, key, value2);
        }
    }

    @Override
    public void report(@NotNull Diagnostic diagnostic) {
        Intrinsics.checkNotNullParameter(diagnostic, "diagnostic");
        DiagnosticSink.DiagnosticsCallback diagnosticsCallback = this.getDiagnosticsCallback();
        if (diagnosticsCallback != null) {
            diagnosticsCallback.callback(diagnostic);
        }
        this.parentTrace.report(diagnostic);
    }

    @Override
    public boolean wantsDiagnostics() {
        return this.parentTrace.wantsDiagnostics();
    }
}

