/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.types;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionOut;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeTypeVariableType;
import org.jetbrains.kotlin.fir.types.TypeConstructionUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\f\u0010\u0004\u001a\u0004\u0018\u00010\u0002*\u00020\u0002\u001a\u001e\u0010\u0005\u001a\u00020\u0006*\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00012\b\b\u0002\u0010\t\u001a\u00020\u0001\u001a\u001e\u0010\n\u001a\u00020\u0002*\u00020\u00022\b\b\u0002\u0010\b\u001a\u00020\u00012\b\b\u0002\u0010\u000b\u001a\u00020\u0001\u001a\f\u0010\f\u001a\u00020\u0001*\u0004\u0018\u00010\u0002\u001a\n\u0010\r\u001a\u00020\u0002*\u00020\u0002\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\u00a8\u0006\u000e"}, d2={"isArrayOrPrimitiveArray", "", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "(Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)Z", "arrayElementType", "createArrayType", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;", "nullable", "createPrimitiveArrayTypeIfPossible", "createOutArrayType", "createPrimitiveArrayType", "isPotentiallyArray", "varargElementType", "providers"})
@SourceDebugExtension(value={"SMAP\nArrayUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArrayUtils.kt\norg/jetbrains/kotlin/fir/types/ArrayUtilsKt\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n*L\n1#1,53:1\n26#2:54\n26#2:55\n*S KotlinDebug\n*F\n+ 1 ArrayUtils.kt\norg/jetbrains/kotlin/fir/types/ArrayUtilsKt\n*L\n25#1:54\n41#1:55\n*E\n"})
public final class ArrayUtilsKt {
    public static final boolean isArrayOrPrimitiveArray(@NotNull ConeKotlinType $this$isArrayOrPrimitiveArray) {
        Intrinsics.checkNotNullParameter($this$isArrayOrPrimitiveArray, "<this>");
        return ArrayUtilsKt.arrayElementType($this$isArrayOrPrimitiveArray) != null;
    }

    @NotNull
    public static final ConeKotlinType createOutArrayType(@NotNull ConeKotlinType $this$createOutArrayType, boolean nullable, boolean createPrimitiveArrayType) {
        Intrinsics.checkNotNullParameter($this$createOutArrayType, "<this>");
        return ArrayUtilsKt.createArrayType(new ConeKotlinTypeProjectionOut($this$createOutArrayType), nullable, createPrimitiveArrayType);
    }

    public static /* synthetic */ ConeKotlinType createOutArrayType$default(ConeKotlinType coneKotlinType, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = true;
        }
        return ArrayUtilsKt.createOutArrayType(coneKotlinType, bl, bl2);
    }

    @NotNull
    public static final ConeClassLikeType createArrayType(@NotNull ConeTypeProjection $this$createArrayType, boolean nullable, boolean createPrimitiveArrayTypeIfPossible) {
        ConeSimpleKotlinType type2;
        Intrinsics.checkNotNullParameter($this$createArrayType, "<this>");
        if ($this$createArrayType instanceof ConeKotlinTypeProjection && createPrimitiveArrayTypeIfPossible && (type2 = ConeTypeUtilsKt.lowerBoundIfFlexible(((ConeKotlinTypeProjection)$this$createArrayType).getType())) instanceof ConeClassLikeType && type2.getNullability() != ConeNullability.NULLABLE) {
            ClassId primitiveArrayId;
            ClassId classId = ((ConeClassLikeType)type2).getLookupTag().getClassId();
            ClassId classId2 = StandardClassIds.INSTANCE.getPrimitiveArrayTypeByElementType().get(classId);
            if (classId2 == null) {
                classId2 = StandardClassIds.INSTANCE.getUnsignedArrayTypeByElementType().get(classId);
            }
            if ((primitiveArrayId = classId2) != null) {
                boolean $i$f$emptyArray = false;
                return TypeConstructionUtilsKt.constructClassLikeType$default(primitiveArrayId, new ConeTypeProjection[0], nullable, null, 4, null);
            }
        }
        ConeTypeProjection[] coneTypeProjectionArray = new ConeTypeProjection[]{$this$createArrayType};
        return TypeConstructionUtilsKt.constructClassLikeType$default(StandardClassIds.INSTANCE.getArray(), coneTypeProjectionArray, nullable, null, 4, null);
    }

    public static /* synthetic */ ConeClassLikeType createArrayType$default(ConeTypeProjection coneTypeProjection, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = true;
        }
        return ArrayUtilsKt.createArrayType(coneTypeProjection, bl, bl2);
    }

    @Nullable
    public static final ConeKotlinType arrayElementType(@NotNull ConeKotlinType $this$arrayElementType) {
        ClassId elementType;
        Intrinsics.checkNotNullParameter($this$arrayElementType, "<this>");
        ConeSimpleKotlinType type2 = ConeTypeUtilsKt.lowerBoundIfFlexible($this$arrayElementType);
        if (!(type2 instanceof ConeClassLikeType)) {
            return null;
        }
        ClassId classId = ((ConeClassLikeType)type2).getLookupTag().getClassId();
        if (Intrinsics.areEqual(classId, StandardClassIds.INSTANCE.getArray())) {
            ConeTypeProjection coneTypeProjection = ArraysKt.first(type2.getTypeArguments());
            Intrinsics.checkNotNull(coneTypeProjection, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection");
            return ((ConeKotlinTypeProjection)coneTypeProjection).getType();
        }
        ClassId classId2 = StandardClassIds.INSTANCE.getElementTypeByPrimitiveArrayType().get(classId);
        if (classId2 == null) {
            classId2 = StandardClassIds.INSTANCE.getElementTypeByUnsignedArrayType().get(classId);
        }
        if ((elementType = classId2) != null) {
            boolean $i$f$emptyArray = false;
            return TypeConstructionUtilsKt.constructClassLikeType$default(elementType, new ConeTypeProjection[0], false, null, 4, null);
        }
        return null;
    }

    @NotNull
    public static final ConeKotlinType varargElementType(@NotNull ConeKotlinType $this$varargElementType) {
        Intrinsics.checkNotNullParameter($this$varargElementType, "<this>");
        ConeKotlinType coneKotlinType = ArrayUtilsKt.arrayElementType($this$varargElementType);
        if (coneKotlinType == null) {
            coneKotlinType = $this$varargElementType;
        }
        return coneKotlinType;
    }

    public static final boolean isPotentiallyArray(@Nullable ConeKotlinType $this$isPotentiallyArray) {
        return $this$isPotentiallyArray != null && (ArrayUtilsKt.arrayElementType($this$isPotentiallyArray) != null || $this$isPotentiallyArray instanceof ConeTypeVariableType);
    }
}

