/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.actualizer;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a*\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006\u001a\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u001a\u000e\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010\u00a8\u0006\u0011"}, d2={"checkParameters", "", "expectFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "actualFunction", "expectActualTypesMap", "", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "reportManyInterfacesMembersNotImplemented", "", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "actualMember", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "reportMissingActual", "irElement", "Lorg/jetbrains/kotlin/ir/IrElement;", "ir.backend.common"})
public final class IrActualizerUtilsKt {
    public static final boolean checkParameters(@NotNull IrFunction expectFunction, @NotNull IrFunction actualFunction, @NotNull Map<IrSymbol, ? extends IrSymbol> expectActualTypesMap) {
        Intrinsics.checkNotNullParameter(expectFunction, "expectFunction");
        Intrinsics.checkNotNullParameter(actualFunction, "actualFunction");
        Intrinsics.checkNotNullParameter(expectActualTypesMap, "expectActualTypesMap");
        if (expectFunction.getValueParameters().size() != actualFunction.getValueParameters().size()) {
            return false;
        }
        for (Pair pair : CollectionsKt.zip((Iterable)expectFunction.getValueParameters(), (Iterable)actualFunction.getValueParameters())) {
            IrSymbol actualizedParameterTypeSymbol;
            IrValueParameter expectParameter = (IrValueParameter)pair.component1();
            IrValueParameter actualParameter = (IrValueParameter)pair.component2();
            IrClassifierSymbol expectParameterTypeSymbol = IrTypesKt.getClassifierOrFail(expectParameter.getType());
            IrSymbol irSymbol2 = expectActualTypesMap.get(expectParameterTypeSymbol);
            if (irSymbol2 == null) {
                irSymbol2 = expectParameterTypeSymbol;
            }
            if (Intrinsics.areEqual(actualizedParameterTypeSymbol = irSymbol2, IrTypesKt.getClassifierOrFail(actualParameter.getType()))) continue;
            return false;
        }
        return true;
    }

    public static final void reportMissingActual(@NotNull IrElement irElement) {
        Intrinsics.checkNotNullParameter(irElement, "irElement");
        throw new AssertionError((Object)("Missing actual for " + RenderIrElementKt.render(irElement)));
    }

    public static final void reportManyInterfacesMembersNotImplemented(@NotNull IrClass declaration, @NotNull IrDeclarationWithName actualMember) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(actualMember, "actualMember");
        throw new AssertionError((Object)(declaration.getName() + " must override " + actualMember.getName() + " because it inherits multiple interface methods of it"));
    }
}

