/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions.impl;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.DefaultPluginDescriptor;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.extensions.impl.BeanExtensionPoint;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.extensions.impl.InterfaceExtensionPoint;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public final class ExtensionsAreaImpl
implements ExtensionsArea {
    private static final Logger LOG = Logger.getInstance(ExtensionsAreaImpl.class);
    private final ComponentManager componentManager;
    private final Map<String, ExtensionPointImpl<?>> extensionPoints;
    private final Map<String, Throwable> epTraces;

    public ExtensionsAreaImpl(@NotNull ComponentManager componentManager) {
        if (componentManager == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(0);
        }
        this.extensionPoints = new ConcurrentHashMap();
        this.epTraces = null;
        this.componentManager = componentManager;
    }

    @TestOnly
    public final void notifyAreaReplaced(@Nullable ExtensionsAreaImpl newArea) {
        HashSet<String> processedEPs = new HashSet<String>(this.extensionPoints.size());
        for (ExtensionPointImpl<?> point : this.extensionPoints.values()) {
            point.notifyAreaReplaced(this);
            processedEPs.add(point.getName());
        }
        if (newArea == null) {
            return;
        }
        for (ExtensionPointImpl<?> point : newArea.extensionPoints.values()) {
            if (processedEPs.contains(point.getName())) continue;
            point.notifyAreaReplaced(this);
        }
    }

    @NotNull
    public static String extractPointName(@NotNull Element extensionElement, @Nullable String ns) {
        String epName;
        if (extensionElement == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(20);
        }
        if ((epName = extensionElement.getAttributeValue("point")) == null) {
            if (ns == null) {
                Namespace namespace = extensionElement.getNamespace();
                epName = namespace.getURI() + '.' + extensionElement.getName();
            } else {
                epName = ns + '.' + extensionElement.getName();
            }
        }
        String string2 = epName;
        if (string2 == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(21);
        }
        return string2;
    }

    @Override
    @TestOnly
    public void registerExtensionPoint(@NotNull @NonNls String extensionPointName, @NotNull String extensionPointBeanClass, @NotNull ExtensionPoint.Kind kind) {
        if (extensionPointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(22);
        }
        if (extensionPointBeanClass == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(23);
        }
        if (kind == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(24);
        }
        this.doRegisterExtensionPoint(extensionPointName, extensionPointBeanClass, kind);
    }

    @Override
    @TestOnly
    public void registerDynamicExtensionPoint(@NonNls @NotNull String extensionPointName, @NotNull String extensionPointBeanClass, @NotNull ExtensionPoint.Kind kind) {
        if (extensionPointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(25);
        }
        if (extensionPointBeanClass == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(26);
        }
        if (kind == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(27);
        }
        this.doRegisterExtensionPoint(extensionPointName, extensionPointBeanClass, kind, true);
    }

    @TestOnly
    void doRegisterExtensionPoint(@NotNull String extensionPointName, @NotNull String extensionPointBeanClass, @NotNull ExtensionPoint.Kind kind) {
        if (extensionPointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(32);
        }
        if (extensionPointBeanClass == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(33);
        }
        if (kind == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(34);
        }
        this.doRegisterExtensionPoint(extensionPointName, extensionPointBeanClass, kind, false);
    }

    @TestOnly
    void doRegisterExtensionPoint(@NotNull String extensionPointName, @NotNull String extensionPointBeanClass, @NotNull ExtensionPoint.Kind kind, boolean dynamic) {
        if (extensionPointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(35);
        }
        if (extensionPointBeanClass == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(36);
        }
        if (kind == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(37);
        }
        DefaultPluginDescriptor pluginDescriptor = new DefaultPluginDescriptor(PluginId.getId("FakeIdForTests"));
        this.doRegisterExtensionPoint(extensionPointName, extensionPointBeanClass, pluginDescriptor, kind == ExtensionPoint.Kind.INTERFACE, dynamic);
    }

    @NotNull
    private <T> ExtensionPointImpl<T> doRegisterExtensionPoint(@NotNull String name, @NotNull String extensionClass, @NotNull PluginDescriptor pluginDescriptor, boolean isInterface, boolean dynamic) {
        if (name == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(41);
        }
        if (extensionClass == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(42);
        }
        if (pluginDescriptor == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(43);
        }
        ExtensionPointImpl point = isInterface ? new InterfaceExtensionPoint(name, extensionClass, pluginDescriptor, null, dynamic) : new BeanExtensionPoint(name, extensionClass, pluginDescriptor, dynamic);
        point.setComponentManager(this.componentManager);
        this.registerExtensionPoint(point);
        ExtensionPointImpl extensionPointImpl = point;
        if (extensionPointImpl == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(44);
        }
        return extensionPointImpl;
    }

    private void checkThatPointNotDuplicated(@NotNull String pointName, @NotNull PluginDescriptor pluginDescriptor) {
        if (pointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(47);
        }
        if (pluginDescriptor == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(48);
        }
        if (!this.hasExtensionPoint(pointName)) {
            return;
        }
        PluginId id1 = ((ExtensionPointImpl)this.getExtensionPoint(pointName)).getPluginDescriptor().getPluginId();
        PluginId id2 = pluginDescriptor.getPluginId();
        @NonNls String message = "Duplicate registration for EP '" + pointName + "': first in " + id1 + ", second in " + id2;
        throw this.componentManager.createError(message, pluginDescriptor.getPluginId());
    }

    private void registerExtensionPoint(@NotNull ExtensionPointImpl<?> point) {
        if (point == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(49);
        }
        String name = point.getName();
        this.checkThatPointNotDuplicated(name, point.getPluginDescriptor());
        this.extensionPoints.put(name, point);
    }

    @ApiStatus.Internal
    public void registerExtensionPoints(@NotNull List<? extends ExtensionPointImpl<?>> points, boolean clonePoint) {
        if (points == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(50);
        }
        ComponentManager componentManager = this.componentManager;
        Map<String, ExtensionPointImpl<?>> map = this.extensionPoints;
        for (ExtensionPointImpl<?> point : points) {
            ExtensionPointImpl<?> old;
            if (clonePoint) {
                point = point.cloneFor(componentManager);
            } else {
                point.setComponentManager(componentManager);
            }
            if ((old = map.put(point.getName(), point)) == null) continue;
            map.put(point.getName(), old);
            throw componentManager.createError("Duplicate registration for EP '" + point.getName() + "': first in " + old.getPluginDescriptor() + ", second in " + point.getPluginDescriptor(), point.getPluginDescriptor().getPluginId());
        }
    }

    @NotNull
    public <T> ExtensionPointImpl<T> getExtensionPoint(@NotNull String extensionPointName) {
        ExtensionPointImpl<?> extensionPoint;
        if (extensionPointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(51);
        }
        if ((extensionPoint = this.extensionPoints.get(extensionPointName)) == null) {
            throw new IllegalArgumentException("Missing extension point: " + extensionPointName + " in container " + this.componentManager);
        }
        ExtensionPointImpl<?> extensionPointImpl = extensionPoint;
        if (extensionPointImpl == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(52);
        }
        return extensionPointImpl;
    }

    public void registerExtensions(@NotNull Map<String, List<Element>> extensions, @NotNull PluginDescriptor pluginDescriptor, @Nullable List<? super Runnable> listenerCallbacks) {
        if (extensions == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(53);
        }
        if (pluginDescriptor == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(54);
        }
        extensions.forEach((name, list2) -> {
            ExtensionPointImpl<?> point = this.extensionPoints.get(name);
            if (point != null) {
                point.registerExtensions((List<Element>)list2, pluginDescriptor, this.componentManager, (List<Runnable>)listenerCallbacks);
            }
        });
    }

    public boolean registerExtensions(@NotNull String pointName, @NotNull List<? extends Element> extensions, @NotNull PluginDescriptor pluginDescriptor, @Nullable List<? super Runnable> listenerCallbacks) {
        ExtensionPointImpl<?> point;
        if (pointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(55);
        }
        if (extensions == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(56);
        }
        if (pluginDescriptor == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(57);
        }
        if ((point = this.extensionPoints.get(pointName)) == null) {
            return false;
        }
        point.registerExtensions(extensions, pluginDescriptor, this.componentManager, listenerCallbacks);
        return true;
    }

    @Nullable
    public <T> ExtensionPointImpl<T> getExtensionPointIfRegistered(@NotNull String extensionPointName) {
        if (extensionPointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(58);
        }
        return this.extensionPoints.get(extensionPointName);
    }

    @Override
    @NotNull
    public <T> ExtensionPoint<T> getExtensionPoint(@NotNull ExtensionPointName<T> extensionPointName) {
        if (extensionPointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(59);
        }
        ExtensionPoint extensionPoint = this.getExtensionPoint(extensionPointName.getName());
        if (extensionPoint == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(60);
        }
        return extensionPoint;
    }

    @Override
    public boolean hasExtensionPoint(@NotNull String extensionPointName) {
        if (extensionPointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(65);
        }
        return this.extensionPoints.containsKey(extensionPointName);
    }

    @Override
    public boolean hasExtensionPoint(@NotNull ExtensionPointName<?> extensionPointName) {
        if (extensionPointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(66);
        }
        return this.hasExtensionPoint(extensionPointName.getName());
    }

    public String toString() {
        return this.componentManager.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 21: 
            case 44: 
            case 52: 
            case 60: 
            case 62: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 21: 
            case 44: 
            case 52: 
            case 60: 
            case 62: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentManager";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 11: 
            case 14: 
            case 40: 
            case 43: 
            case 46: 
            case 48: 
            case 54: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPointElements";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPointElement";
                break;
            }
            case 7: 
            case 21: 
            case 44: 
            case 52: 
            case 60: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/extensions/impl/ExtensionsAreaImpl";
                break;
            }
            case 9: 
            case 12: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionElement";
                break;
            }
            case 10: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPoint";
                break;
            }
            case 13: 
            case 22: 
            case 25: 
            case 32: 
            case 35: 
            case 51: 
            case 58: 
            case 59: 
            case 64: 
            case 65: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPointName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "priorityListenerCallbacks";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listenerCallbacks";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawExtensionPoints";
                break;
            }
            case 23: 
            case 26: 
            case 29: 
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPointBeanClass";
                break;
            }
            case 24: 
            case 27: 
            case 30: 
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 38: 
            case 41: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 39: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionClass";
                break;
            }
            case 47: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointName";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "points";
                break;
            }
            case 53: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensions";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/extensions/impl/ExtensionsAreaImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionPointName";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "extractPointName";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "doRegisterExtensionPoint";
                break;
            }
            case 52: 
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionPoint";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionPoints";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "registerExtensionPoints";
                break;
            }
            case 3: 
            case 4: 
            case 22: 
            case 23: 
            case 24: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "registerExtensionPoint";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getExtensionPointName";
                break;
            }
            case 7: 
            case 21: 
            case 44: 
            case 52: 
            case 60: 
            case 62: {
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "registerExtension";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "unregisterExtensions";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "resetExtensionPoints";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "unregisterExtensionPoints";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "extractPointName";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "registerDynamicExtensionPoint";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "doRegisterExtensionPoint";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "registerPoint";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "registerFakeBeanPoint";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "checkThatPointNotDuplicated";
                break;
            }
            case 51: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getExtensionPoint";
                break;
            }
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "registerExtensions";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getExtensionPointIfRegistered";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "processExtensionPoints";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "findExtensionByClass";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "unregisterExtensionPoint";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "hasExtensionPoint";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 7: 
            case 21: 
            case 44: 
            case 52: 
            case 60: 
            case 62: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

