/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.inference;

import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.resolve.calls.inference.TypeVariable;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPosition;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\bf\u0018\u00002\u00020\u0001:\u0002\u0011\u0012R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\u0004\u0018\u00010\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0018\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0006\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0013\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/inference/TypeBounds;", "", "bounds", "", "Lorg/jetbrains/kotlin/resolve/calls/inference/TypeBounds$Bound;", "getBounds", "()Ljava/util/Collection;", "typeVariable", "Lorg/jetbrains/kotlin/resolve/calls/inference/TypeVariable;", "getTypeVariable", "()Lorg/jetbrains/kotlin/resolve/calls/inference/TypeVariable;", "value", "Lorg/jetbrains/kotlin/types/KotlinType;", "getValue", "()Lorg/jetbrains/kotlin/types/KotlinType;", "values", "getValues", "Bound", "BoundKind", "frontend"})
public interface TypeBounds {
    @NotNull
    public TypeVariable getTypeVariable();

    @NotNull
    public Collection<Bound> getBounds();

    @Nullable
    default public KotlinType getValue() {
        return this.getValues().size() == 1 ? (KotlinType)CollectionsKt.first((Iterable)this.getValues()) : null;
    }

    @NotNull
    public Collection<KotlinType> getValues();

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\b\u000f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\r\u00a2\u0006\u0002\u0010\u000eJ\u0013\u0010\u001a\u001a\u00020\u000b2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/resolve/calls/inference/TypeBounds$Bound;", "", "typeVariable", "Lorg/jetbrains/kotlin/resolve/calls/inference/TypeVariable;", "constrainingType", "Lorg/jetbrains/kotlin/types/KotlinType;", "kind", "Lorg/jetbrains/kotlin/resolve/calls/inference/TypeBounds$BoundKind;", "position", "Lorg/jetbrains/kotlin/resolve/calls/inference/constraintPosition/ConstraintPosition;", "isProper", "", "derivedFrom", "", "(Lorg/jetbrains/kotlin/resolve/calls/inference/TypeVariable;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/resolve/calls/inference/TypeBounds$BoundKind;Lorg/jetbrains/kotlin/resolve/calls/inference/constraintPosition/ConstraintPosition;ZLjava/util/Set;)V", "getConstrainingType", "()Lorg/jetbrains/kotlin/types/KotlinType;", "getDerivedFrom", "()Ljava/util/Set;", "()Z", "getKind", "()Lorg/jetbrains/kotlin/resolve/calls/inference/TypeBounds$BoundKind;", "getPosition", "()Lorg/jetbrains/kotlin/resolve/calls/inference/constraintPosition/ConstraintPosition;", "getTypeVariable", "()Lorg/jetbrains/kotlin/resolve/calls/inference/TypeVariable;", "equals", "other", "hashCode", "", "toString", "", "frontend"})
    public static final class Bound {
        @NotNull
        private final TypeVariable typeVariable;
        @NotNull
        private final KotlinType constrainingType;
        @NotNull
        private final BoundKind kind;
        @NotNull
        private final ConstraintPosition position;
        private final boolean isProper;
        @NotNull
        private final Set<TypeVariable> derivedFrom;

        public Bound(@NotNull TypeVariable typeVariable2, @NotNull KotlinType constrainingType, @NotNull BoundKind kind, @NotNull ConstraintPosition position, boolean isProper2, @NotNull Set<TypeVariable> derivedFrom) {
            Intrinsics.checkNotNullParameter(typeVariable2, "typeVariable");
            Intrinsics.checkNotNullParameter(constrainingType, "constrainingType");
            Intrinsics.checkNotNullParameter((Object)kind, "kind");
            Intrinsics.checkNotNullParameter(position, "position");
            Intrinsics.checkNotNullParameter(derivedFrom, "derivedFrom");
            this.typeVariable = typeVariable2;
            this.constrainingType = constrainingType;
            this.kind = kind;
            this.position = position;
            this.isProper = isProper2;
            this.derivedFrom = derivedFrom;
        }

        @NotNull
        public final TypeVariable getTypeVariable() {
            return this.typeVariable;
        }

        @NotNull
        public final KotlinType getConstrainingType() {
            return this.constrainingType;
        }

        @NotNull
        public final BoundKind getKind() {
            return this.kind;
        }

        @NotNull
        public final ConstraintPosition getPosition() {
            return this.position;
        }

        public final boolean isProper() {
            return this.isProper;
        }

        @NotNull
        public final Set<TypeVariable> getDerivedFrom() {
            return this.derivedFrom;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || !Intrinsics.areEqual(this.getClass(), other.getClass())) {
                return false;
            }
            Bound bound2 = (Bound)other;
            if (!Intrinsics.areEqual(this.typeVariable, bound2.typeVariable)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.constrainingType, bound2.constrainingType)) {
                return false;
            }
            if (this.kind != bound2.kind) {
                return false;
            }
            return this.position.isStrong() == bound2.position.isStrong();
        }

        public int hashCode() {
            int result2 = this.typeVariable.hashCode();
            result2 = 31 * result2 + this.constrainingType.hashCode();
            result2 = 31 * result2 + this.kind.hashCode();
            result2 = 31 * result2 + (this.position.isStrong() ? 1 : 0);
            return result2;
        }

        @NotNull
        public String toString() {
            return "Bound(" + this.constrainingType + ", " + (Object)((Object)this.kind) + ", " + this.position + ", isProper = " + this.isProper + ')';
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/inference/TypeBounds$BoundKind;", "", "(Ljava/lang/String;I)V", "LOWER_BOUND", "EXACT_BOUND", "UPPER_BOUND", "frontend"})
    public static final class BoundKind
    extends Enum<BoundKind> {
        public static final /* enum */ BoundKind LOWER_BOUND = new BoundKind();
        public static final /* enum */ BoundKind EXACT_BOUND = new BoundKind();
        public static final /* enum */ BoundKind UPPER_BOUND = new BoundKind();
        private static final /* synthetic */ BoundKind[] $VALUES;

        public static BoundKind[] values() {
            return (BoundKind[])$VALUES.clone();
        }

        public static BoundKind valueOf(String value2) {
            return Enum.valueOf(BoundKind.class, value2);
        }

        static {
            $VALUES = boundKindArray = new BoundKind[]{BoundKind.LOWER_BOUND, BoundKind.EXACT_BOUND, BoundKind.UPPER_BOUND};
        }
    }
}

