/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.utils;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.backend.js.utils.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.JsGenerationContext;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrPossiblyExternalDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrScriptSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrDynamicType;
import org.jetbrains.kotlin.ir.types.IrErrorType;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrStarProjection;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.types.SimpleTypeNullability;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0013\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0086\u0010\u001a\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0006H\u0002\u001a\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0003\u001a\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0007H\u0002\u001a\u0012\u0010\b\u001a\u00020\t*\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"erase", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "asString", "", "Lorg/jetbrains/kotlin/ir/symbols/IrClassifierSymbol;", "Lorg/jetbrains/kotlin/ir/types/IrTypeArgument;", "getClassRef", "Lorg/jetbrains/kotlin/js/backend/ast/JsNameRef;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/utils/JsGenerationContext;", "backend.js"})
public final class IrTypeUtilsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String asString(@NotNull IrType $this$asString) {
        String string2;
        Intrinsics.checkNotNullParameter($this$asString, "<this>");
        IrType irType = $this$asString;
        if (irType instanceof IrErrorType) {
            string2 = "$ErrorType$";
        } else if (irType instanceof IrDynamicType) {
            string2 = "dynamic";
        } else if (irType instanceof IrSimpleType) {
            String string3;
            String string4;
            String string5;
            StringBuilder stringBuilder2 = new StringBuilder().append(IrTypeUtilsKt.asString(((IrSimpleType)$this$asString).getClassifier()));
            switch (WhenMappings.$EnumSwitchMapping$0[((IrSimpleType)$this$asString).getNullability().ordinal()]) {
                case 1: {
                    string5 = "?";
                    break;
                }
                case 2: {
                    string5 = "";
                    break;
                }
                case 3: {
                    if (((IrSimpleType)$this$asString).getClassifier() instanceof IrTypeParameterSymbol) {
                        string5 = " & Any";
                        break;
                    }
                    string5 = "";
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            StringBuilder stringBuilder3 = stringBuilder2.append(string5);
            Collection $this$ifNotEmpty$iv = ((IrSimpleType)$this$asString).getArguments();
            boolean $i$f$ifNotEmpty = false;
            if (!$this$ifNotEmpty$iv.isEmpty()) {
                void $this$asString_u24lambda_u240;
                List list2 = (List)$this$ifNotEmpty$iv;
                StringBuilder stringBuilder4 = stringBuilder3;
                boolean bl = false;
                string4 = CollectionsKt.joinToString$default((Iterable)$this$asString_u24lambda_u240, ",", "<", ">", 0, null, asString.1.1.INSTANCE, 24, null);
                stringBuilder3 = stringBuilder4;
            } else {
                string4 = string3 = null;
            }
            if (string4 == null) {
                string3 = "";
            }
            string2 = stringBuilder3.append(string3).toString();
        } else {
            throw new IllegalStateException(("Unexpected kind of IrType: " + $this$asString.getClass().getTypeName()).toString());
        }
        return string2;
    }

    private static final String asString(IrTypeArgument $this$asString) {
        String string2;
        IrTypeArgument irTypeArgument = $this$asString;
        if (irTypeArgument instanceof IrStarProjection) {
            string2 = "*";
        } else if (irTypeArgument instanceof IrTypeProjection) {
            string2 = ((IrTypeProjection)$this$asString).getVariance().getLabel() + (((IrTypeProjection)$this$asString).getVariance() != Variance.INVARIANT ? " " : "") + IrTypeUtilsKt.asString(((IrTypeProjection)$this$asString).getType());
        } else {
            throw new IllegalStateException(("Unexpected kind of IrTypeArgument: " + $this$asString.getClass().getSimpleName()).toString());
        }
        return string2;
    }

    private static final String asString(IrClassifierSymbol $this$asString) {
        String string2;
        IrClassifierSymbol irClassifierSymbol = $this$asString;
        if (irClassifierSymbol instanceof IrTypeParameterSymbol) {
            string2 = ((IrTypeParameter)((IrTypeParameterSymbol)$this$asString).getOwner()).getName().asString();
        } else if (irClassifierSymbol instanceof IrClassSymbol) {
            FqName fqName2 = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrClassSymbol)$this$asString).getOwner());
            Intrinsics.checkNotNull(fqName2);
            string2 = fqName2.asString();
        } else {
            throw new IllegalStateException(("Unexpected kind of IrClassifierSymbol: " + $this$asString.getClass().getTypeName()).toString());
        }
        String string3 = string2;
        Intrinsics.checkNotNullExpressionValue(string3, "when (this) {\n    is IrT\u2026\" + javaClass.typeName)\n}");
        return string3;
    }

    @Nullable
    public static final IrClass erase(@NotNull IrType type2) {
        IrClass irClass2;
        block4: {
            IrClassifierSymbol classifier2;
            IrClassifierSymbol irClassifierSymbol;
            Intrinsics.checkNotNullParameter(type2, "type");
            while (true) {
                if ((irClassifierSymbol = (classifier2 = IrTypesKt.getClassifierOrFail(type2))) instanceof IrClassSymbol) {
                    irClass2 = (IrClass)((IrClassSymbol)classifier2).getOwner();
                    break block4;
                }
                if (!(irClassifierSymbol instanceof IrTypeParameterSymbol)) break;
                type2 = CollectionsKt.first(((IrTypeParameter)((IrTypeParameterSymbol)classifier2).getOwner()).getSuperTypes());
            }
            if (irClassifierSymbol instanceof IrScriptSymbol) {
                irClass2 = null;
            } else {
                throw new IllegalStateException(classifier2.toString());
            }
        }
        return irClass2;
    }

    @NotNull
    public static final JsNameRef getClassRef(@NotNull IrType $this$getClassRef, @NotNull JsGenerationContext context) {
        JsNameRef jsNameRef;
        Intrinsics.checkNotNullParameter($this$getClassRef, "<this>");
        Intrinsics.checkNotNullParameter(context, "context");
        IrSymbolOwner klass = IrTypesKt.getClassifierOrFail($this$getClassRef).getOwner();
        if (klass instanceof IrClass) {
            if (IrUtilsKt.isEffectivelyExternal((IrPossiblyExternalDeclaration)klass)) {
                jsNameRef = context.getRefForExternalClass((IrClass)klass);
            } else {
                JsNameRef jsNameRef2 = context.getNameForClass((IrClass)klass).makeRef();
                jsNameRef = jsNameRef2;
                Intrinsics.checkNotNullExpressionValue(jsNameRef2, "context.getNameForClass(klass).makeRef()");
            }
        } else {
            Intrinsics.checkNotNull(klass, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName");
            JsNameRef jsNameRef3 = context.getNameForStaticDeclaration((IrDeclarationWithName)klass).makeRef();
            jsNameRef = jsNameRef3;
            Intrinsics.checkNotNullExpressionValue(jsNameRef3, "context.getNameForStatic\u2026rationWithName).makeRef()");
        }
        return jsNameRef;
    }

    public static final /* synthetic */ String access$asString(IrTypeArgument $receiver) {
        return IrTypeUtilsKt.asString($receiver);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SimpleTypeNullability.values().length];
            try {
                nArray[SimpleTypeNullability.MARKED_NULLABLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SimpleTypeNullability.NOT_SPECIFIED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SimpleTypeNullability.DEFINITELY_NOT_NULL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

