/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.expressions.builder;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.fir.builder.FirAnnotationContainerBuilder;
import org.jetbrains.kotlin.fir.builder.FirBuilderDsl;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirCatch;
import org.jetbrains.kotlin.fir.expressions.FirTryExpression;
import org.jetbrains.kotlin.fir.expressions.builder.FirExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.impl.FirTryExpressionImpl;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.impl.FirStubReference;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitTypeRefImpl;

@FirBuilderDsl
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010'\u001a\u00020(H\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\bR\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u0013X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0015\"\u0004\b \u0010\u0017R\u001a\u0010!\u001a\u00020\"X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/fir/expressions/builder/FirTryExpressionBuilder;", "Lorg/jetbrains/kotlin/fir/builder/FirAnnotationContainerBuilder;", "Lorg/jetbrains/kotlin/fir/expressions/builder/FirExpressionBuilder;", "()V", "annotations", "", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "getAnnotations", "()Ljava/util/List;", "calleeReference", "Lorg/jetbrains/kotlin/fir/references/FirReference;", "getCalleeReference", "()Lorg/jetbrains/kotlin/fir/references/FirReference;", "setCalleeReference", "(Lorg/jetbrains/kotlin/fir/references/FirReference;)V", "catches", "Lorg/jetbrains/kotlin/fir/expressions/FirCatch;", "getCatches", "finallyBlock", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "getFinallyBlock", "()Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "setFinallyBlock", "(Lorg/jetbrains/kotlin/fir/expressions/FirBlock;)V", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "getSource", "()Lorg/jetbrains/kotlin/KtSourceElement;", "setSource", "(Lorg/jetbrains/kotlin/KtSourceElement;)V", "tryBlock", "getTryBlock", "setTryBlock", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "getTypeRef", "()Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "setTypeRef", "(Lorg/jetbrains/kotlin/fir/types/FirTypeRef;)V", "build", "Lorg/jetbrains/kotlin/fir/expressions/FirTryExpression;", "tree"})
public final class FirTryExpressionBuilder
implements FirAnnotationContainerBuilder,
FirExpressionBuilder {
    @Nullable
    private KtSourceElement source;
    @NotNull
    private FirTypeRef typeRef = new FirImplicitTypeRefImpl(null);
    @NotNull
    private final List<FirAnnotation> annotations = new ArrayList();
    @NotNull
    private FirReference calleeReference = FirStubReference.INSTANCE;
    public FirBlock tryBlock;
    @NotNull
    private final List<FirCatch> catches = new ArrayList();
    @Nullable
    private FirBlock finallyBlock;

    @Override
    @Nullable
    public KtSourceElement getSource() {
        return this.source;
    }

    @Override
    public void setSource(@Nullable KtSourceElement ktSourceElement) {
        this.source = ktSourceElement;
    }

    @Override
    @NotNull
    public FirTypeRef getTypeRef() {
        return this.typeRef;
    }

    @Override
    public void setTypeRef(@NotNull FirTypeRef firTypeRef) {
        Intrinsics.checkNotNullParameter(firTypeRef, "<set-?>");
        this.typeRef = firTypeRef;
    }

    @Override
    @NotNull
    public List<FirAnnotation> getAnnotations() {
        return this.annotations;
    }

    @NotNull
    public final FirReference getCalleeReference() {
        return this.calleeReference;
    }

    public final void setCalleeReference(@NotNull FirReference firReference) {
        Intrinsics.checkNotNullParameter(firReference, "<set-?>");
        this.calleeReference = firReference;
    }

    @NotNull
    public final FirBlock getTryBlock() {
        FirBlock firBlock = this.tryBlock;
        if (firBlock != null) {
            return firBlock;
        }
        Intrinsics.throwUninitializedPropertyAccessException("tryBlock");
        return null;
    }

    public final void setTryBlock(@NotNull FirBlock firBlock) {
        Intrinsics.checkNotNullParameter(firBlock, "<set-?>");
        this.tryBlock = firBlock;
    }

    @NotNull
    public final List<FirCatch> getCatches() {
        return this.catches;
    }

    @Nullable
    public final FirBlock getFinallyBlock() {
        return this.finallyBlock;
    }

    public final void setFinallyBlock(@Nullable FirBlock firBlock) {
        this.finallyBlock = firBlock;
    }

    @Override
    @NotNull
    public FirTryExpression build() {
        return new FirTryExpressionImpl(this.getSource(), this.getTypeRef(), this.getAnnotations(), this.calleeReference, this.getTryBlock(), this.catches, this.finallyBlock);
    }
}

