/*
 * Decompiled with CFR 0.152.
 */
package kotlin.script.experimental.host;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.script.experimental.api.ExternalSourceCode;
import kotlin.script.experimental.api.ScriptCompilationConfiguration;
import kotlin.script.experimental.api.ScriptCompilationKt;
import kotlin.script.experimental.api.ScriptSourceNamedFragment;
import kotlin.script.experimental.api.SourceCode;
import kotlin.script.experimental.host.FileScriptSource;
import kotlin.script.experimental.host.StringScriptSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t\u001a&\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b*\u00020\u00012\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u000eH\u0002\u001a\n\u0010\u0010\u001a\u00020\u0007*\u00020\u0011\u001a\u0016\u0010\u0010\u001a\u00020\u0007*\u00020\u00012\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0001\"\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0013"}, d2={"textSafe", "", "Lkotlin/script/experimental/api/ExternalSourceCode;", "getTextSafe", "(Lkotlin/script/experimental/api/ExternalSourceCode;)Ljava/lang/String;", "getMergedScriptText", "script", "Lkotlin/script/experimental/api/SourceCode;", "configuration", "Lkotlin/script/experimental/api/ScriptCompilationConfiguration;", "cleanContentPreservingLinesLayout", "", "", "start", "", "end", "toScriptSource", "Ljava/io/File;", "name", "kotlin-scripting-common"})
public final class ScriptHostUtilKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String getMergedScriptText(@NotNull SourceCode script, @Nullable ScriptCompilationConfiguration configuration) {
        String string;
        List<ScriptSourceNamedFragment> sourceFragments;
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        String originalScriptText = script.getText();
        ScriptCompilationConfiguration scriptCompilationConfiguration = configuration;
        List<ScriptSourceNamedFragment> list = sourceFragments = scriptCompilationConfiguration != null ? scriptCompilationConfiguration.get(ScriptCompilationKt.getSourceFragments(ScriptCompilationConfiguration.Companion)) : null;
        if (sourceFragments == null || sourceFragments.isEmpty()) {
            string = originalScriptText;
        } else {
            Integer positionOfLastAppended;
            StringBuilder sb = new StringBuilder(originalScriptText.length());
            ScriptSourceNamedFragment prevFragment = null;
            for (ScriptSourceNamedFragment scriptSourceNamedFragment : sourceFragments) {
                int curPos;
                int n;
                Integer fragmentStartPos = scriptSourceNamedFragment.getRange().getStart().getAbsolutePos();
                Integer fragmentEndPos = scriptSourceNamedFragment.getRange().getEnd().getAbsolutePos();
                if (fragmentStartPos == null || fragmentEndPos == null) {
                    throw new RuntimeException("Script fragments require absolute positions (received: " + scriptSourceNamedFragment + ')');
                }
                ScriptSourceNamedFragment scriptSourceNamedFragment2 = prevFragment;
                if (scriptSourceNamedFragment2 == null) {
                    n = 0;
                } else {
                    Integer n2 = scriptSourceNamedFragment2.getRange().getEnd().getAbsolutePos();
                    Intrinsics.checkNotNull((Object)n2);
                    n = curPos = n2.intValue();
                }
                if (prevFragment != null) {
                    Integer n3 = prevFragment.getRange().getEnd().getAbsolutePos();
                    Intrinsics.checkNotNull((Object)n3);
                    if (n3 > fragmentStartPos) {
                        throw new RuntimeException("Unsorted or overlapping fragments: previous: " + prevFragment + ", current: " + scriptSourceNamedFragment);
                    }
                }
                if (curPos < fragmentStartPos) {
                    void $this$forEach$iv;
                    Iterable iterable = ScriptHostUtilKt.cleanContentPreservingLinesLayout(originalScriptText, curPos, fragmentStartPos);
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        char p0 = ((Character)element$iv).charValue();
                        boolean bl = false;
                        sb.append(p0);
                    }
                }
                sb.append(originalScriptText.subSequence(fragmentStartPos, fragmentEndPos));
                prevFragment = scriptSourceNamedFragment;
            }
            Serializable serializable = prevFragment;
            Integer n = serializable != null && (serializable = ((ScriptSourceNamedFragment)serializable).getRange()) != null && (serializable = ((SourceCode.Range)serializable).getEnd()) != null ? ((SourceCode.Position)serializable).getAbsolutePos() : (positionOfLastAppended = null);
            if (positionOfLastAppended != null && positionOfLastAppended < originalScriptText.length()) {
                Iterable iterable = ScriptHostUtilKt.cleanContentPreservingLinesLayout$default(originalScriptText, positionOfLastAppended, 0, 2, null);
                boolean $i$f$forEach = false;
                for (Object element$iv : iterable) {
                    char p0 = ((Character)element$iv).charValue();
                    boolean bl = false;
                    sb.append(p0);
                }
            }
            String string2 = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n        val sb = Strin\u2026      sb.toString()\n    }");
            string = string2;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<Character> cleanContentPreservingLinesLayout(String $this$cleanContentPreservingLinesLayout, int start, int end) {
        void $this$mapTo$iv$iv;
        CharSequence $this$map$iv = $this$cleanContentPreservingLinesLayout.subSequence(start, end);
        boolean $i$f$map = false;
        CharSequence charSequence = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length());
        boolean $i$f$mapTo = false;
        for (int i = 0; i < $this$mapTo$iv$iv.length(); ++i) {
            int it;
            char item$iv$iv;
            char c = item$iv$iv = $this$mapTo$iv$iv.charAt(i);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Character.valueOf((char)(it == 13 || it == 10 ? it : 32)));
        }
        return (List)destination$iv$iv;
    }

    static /* synthetic */ List cleanContentPreservingLinesLayout$default(String string, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = string.length();
        }
        return ScriptHostUtilKt.cleanContentPreservingLinesLayout(string, n, n2);
    }

    @NotNull
    public static final SourceCode toScriptSource(@NotNull File $this$toScriptSource) {
        Intrinsics.checkNotNullParameter((Object)$this$toScriptSource, (String)"<this>");
        return new FileScriptSource($this$toScriptSource, null, 2, null);
    }

    @NotNull
    public static final SourceCode toScriptSource(@NotNull String $this$toScriptSource, @Nullable String name) {
        Intrinsics.checkNotNullParameter((Object)$this$toScriptSource, (String)"<this>");
        return new StringScriptSource($this$toScriptSource, name);
    }

    public static /* synthetic */ SourceCode toScriptSource$default(String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = null;
        }
        return ScriptHostUtilKt.toScriptSource(string, string2);
    }

    private static final String getTextSafe(ExternalSourceCode $this$textSafe) {
        String string;
        try {
            string = $this$textSafe.getText();
        }
        catch (Throwable e) {
            string = null;
        }
        return string;
    }

    public static final /* synthetic */ String access$getTextSafe(ExternalSourceCode $receiver) {
        return ScriptHostUtilKt.getTextSafe($receiver);
    }
}

